
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;
import common.*;

public class Example4 extends DefaultHandler {


	// Local Customer object to collect 
	// customer XML data.
	private  Customer cust = new Customer();

	// Local list of order items...
	private Vector orderItems = new Vector();

	// Local current order item reference...
	private OrderItem currentOrderItem;

	// Buffer for collecting data from
	// the "characters" SAX event.
	private CharArrayWriter contents = new CharArrayWriter();



	// Override methods of the DefaultHandler class
	// to gain notification of SAX Events.
	//
        // See org.xml.sax.ContentHandler for all available events.
	//

	public void startElement( String namespaceURI,
			 	  String localName,
				  String qName,
				  Attributes attr ) throws SAXException {

		contents.reset();

		// New twist...
		if ( localName.equals( "OrderItem" ) ) {
                	currentOrderItem = new OrderItem();
			orderItems.addElement( currentOrderItem );
		}

	} 
	
	public void endElement( String namespaceURI,
			 	  String localName,
				  String qName ) throws SAXException {

		if ( localName.equals( "FirstName" ) ) {
			cust.firstName = contents.toString();
		}		

		if ( localName.equals( "LastName" ) ) {
			cust.lastName = contents.toString();
		}		

		if ( localName.equals( "CustId" ) ) {
			cust.custId = contents.toString();
		}		

		if ( localName.equals( "Quantity" ) ) {
			currentOrderItem.quantity = Integer.valueOf(contents.toString().trim()).intValue();
		}		

		if ( localName.equals( "ProductCode" ) ) {
			currentOrderItem.productCode = contents.toString();
		}		

		if ( localName.equals( "Description" ) ) {
			currentOrderItem.description = contents.toString();
		}		

		if ( localName.equals( "Price" ) ) {
			currentOrderItem.price = Double.valueOf(contents.toString().trim()).doubleValue();
		}		


	} 
	
	public void characters( char[] ch, int start, int length ) 
						throws SAXException {

			contents.write( ch, start, length );  
        	
	}


	public Customer getCustomer()  {
        	return cust;
	}

	public Vector getOrderItems() {
        	return orderItems;
	}

	public static void main( String[] argv ){
	
		System.out.println( "Example4:" );		
		try {
		
			// Create SAX 2 parser...
			XMLReader xr = XMLReaderFactory.createXMLReader();
			
			// Set the ContentHandler...
			Example4 ex4 = new Example4();
			xr.setContentHandler( ex4 );
						
			// Parse the file...
			xr.parse( new InputSource( 
					new FileReader( "Example4.xml" )) );
					
			// Display customer to stdout...
			Customer cust = ex4.getCustomer();
			cust.print( System.out );

			// Display all order items to stdout...
			OrderItem i;
			Vector items = ex4.getOrderItems();
			Enumeration e = items.elements();
			while( e.hasMoreElements()){
                        	i = (OrderItem) e.nextElement();
				i.print( System.out );	
			}

			
		}catch ( Exception e )  {
			e.printStackTrace();
		}
			
		

		
	}

}
