
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import common.*;

public class Example3 extends DefaultHandler {


	// Local Customer object to collect 
	// customer XML data.
	private  Customer cust = new Customer();

	// Buffer for collecting data from
	// the "characters" SAX event.
	private CharArrayWriter contents = new CharArrayWriter();



	// Override methods of the DefaultHandler class
	// to gain notification of SAX Events.
	//
        // See org.xml.sax.ContentHandler for all available events.
	//

	public void startElement( String namespaceURI,
			 	  String localName,
				  String qName,
				  Attributes attr ) throws SAXException {


		contents.reset();

	} 
	

	public void endElement( String namespaceURI,
			 	  String localName,
				  String qName ) throws SAXException {

		if ( localName.equals( "FirstName" ) ) {
			cust.firstName = contents.toString();
		}		

		if ( localName.equals( "LastName" ) ) {
			cust.lastName = contents.toString();
		}		

		if ( localName.equals( "CustId" ) ) {
			cust.custId = contents.toString();
		}		


	} 
	
	public void characters( char[] ch, int start, int length ) 
						throws SAXException {

		contents.write( ch, start, length );  
        	
	}


	public Customer getCustomer()  {
        	return cust;
	}



	public static void main( String[] argv ){
	
		System.out.println( "Example3:" );		
		try {
		
			// Create SAX 2 parser...
			XMLReader xr = XMLReaderFactory.createXMLReader();
			
			// Set the ContentHandler...
			Example3 ex3 = new Example3();
			xr.setContentHandler( ex3 );
						
			// Parse the file...
			xr.parse( new InputSource( 
					new FileReader( "Example3.xml" )) );
					
			// Display customer to stdout...
			Customer cust = ex3.getCustomer();
			cust.print( System.out );
			
		}catch ( Exception e )  {
			e.printStackTrace();
		}
			
		

		
	}

}
