/*
 * Decompiled with CFR 0.152.
 */
package amber.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ProtocolException;

public class Packet
implements Serializable {
    public static final int PacketHeaderLength = 12;
    public static final byte PacketMagicMarker = -86;
    public static final int CommandNone = 0;
    public static final short ServerId = -1;
    public static final int MagicMarker = 0;
    public static final int Version = 1;
    public static final int Flags = 2;
    public static final int Command = 3;
    public static final int DestinationIdHigh = 4;
    public static final int DestinationIdLow = 5;
    public static final int SourceIdHigh = 6;
    public static final int SourceIdLow = 7;
    public static final int DataLengthStart = 8;
    public static final int EventFlag = 1;
    public static final int IncompleteFlag = 2;
    protected byte[] header = new byte[12];
    protected byte[] data;

    public byte getVersion() {
        return this.header[1];
    }

    public byte getFlags() {
        return this.header[2];
    }

    public byte getCommand() {
        return this.header[3];
    }

    public short getDestinationId() {
        return Packet.bytesToShort(this.header, 4);
    }

    public short getSourceId() {
        return Packet.bytesToShort(this.header, 6);
    }

    public int getDataLength() {
        return Packet.bytesToInt(this.header, 8);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setVersion(byte by) {
        this.header[1] = by;
    }

    public void setFlags(byte by) {
        this.header[2] = by;
    }

    public void setCommand(byte by) {
        this.header[3] = by;
    }

    public void setDestinationId(short s) {
        Packet.shortToBytes(s, this.header, 4);
    }

    public void setSourceId(short s) {
        Packet.shortToBytes(s, this.header, 6);
    }

    public void setDataLength(int n) {
        Packet.intToBytes(n, this.header, 8);
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
        this.setDataLength(byArray.length);
    }

    public void readPacket(InputStream inputStream) throws IOException, ProtocolException {
        this.m1(inputStream, this.header, this.header.length);
        if (this.header[0] != -86) {
            throw new ProtocolException("Invalid Packet Header");
        }
        if (this.getDataLength() > 0) {
            this.data = new byte[this.getDataLength()];
            this.m1(inputStream, this.data, this.data.length);
        }
    }

    private final void m1(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 < 0) {
                StringBuffer stringBuffer = new StringBuffer("Insufficient bytes in stream for data. Offset: ");
                stringBuffer.append(n2);
                stringBuffer.append(", Length: ");
                stringBuffer.append(n);
                throw new IOException(stringBuffer.toString());
            }
            n2 += n3;
        }
    }

    public void sendPacket(OutputStream outputStream) throws IOException, ProtocolException {
        if (this.data == null && this.getDataLength() > 0) {
            throw new ProtocolException("Invalid, data length not zero but no data");
        }
        if (this.data != null && this.getDataLength() != this.data.length) {
            throw new ProtocolException("Invalid, data does not match data length");
        }
        outputStream.write(this.header);
        if (this.getDataLength() > 0 && this.data != null) {
            outputStream.write(this.data);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Packet\n");
        stringBuffer.append("Version: ");
        stringBuffer.append(Integer.toString(this.header[1]));
        stringBuffer.append("\nFlags: ");
        stringBuffer.append(Integer.toString(this.header[2]));
        stringBuffer.append("\nCommand: ");
        stringBuffer.append(Integer.toString(this.header[3]));
        stringBuffer.append("\nDest ID: ");
        stringBuffer.append(Integer.toString(this.getDestinationId()));
        stringBuffer.append("\nSource ID: ");
        stringBuffer.append(Integer.toString(this.getSourceId()));
        stringBuffer.append("\nData: ");
        stringBuffer.append(Integer.toString(this.getDataLength()));
        stringBuffer.append(" bytes: ");
        if (this.data != null) {
            int n = 0;
            while (n < this.data.length) {
                stringBuffer.append(Integer.toString(this.data[n], 16));
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)((n & 0xFF000000) >> 24);
        byArray[n2 + 1] = (byte)((n & 0xFF0000) >> 16);
        byArray[n2 + 2] = (byte)((n & 0xFF00) >> 8);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    public static int bytesToInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static short bytesToShort(byte[] byArray, int n) {
        return (short)((short)(((short)byArray[n] & 0xFF) << 8) + (short)((short)byArray[n + 1] & 0xFF));
    }

    public static void shortToBytes(short s, byte[] byArray, int n) {
        byArray[n] = (byte)((s & 0xFF00) >> 8);
        byArray[n + 1] = (byte)(s & 0xFF);
    }

    public static byte[] shortToBytes(short s) {
        byte[] byArray = new byte[2];
        Packet.shortToBytes(s, byArray, 0);
        return byArray;
    }

    public void setEvent(boolean bl) {
        if (bl) {
            this.header[2] = (byte)(this.header[2] | 1);
            return;
        }
        this.header[2] = (byte)(this.header[2] & 1);
    }

    public boolean isEvent() {
        return (this.header[2] & 1) == 1;
    }

    public void setIncomplete(boolean bl) {
        if (bl) {
            this.header[2] = (byte)(this.header[2] | 2);
            return;
        }
        this.header[2] = (byte)(this.header[2] & 2);
    }

    public boolean isIncomplete() {
        return (this.header[2] & 2) == 2;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public boolean compareTo(byte[] byArray) {
        boolean bl = true;
        if (byArray.length == this.header.length) {
            int n = 0;
            while (n < this.header.length) {
                if (this.header[n] != byArray[n]) {
                    bl = false;
                    break;
                }
                ++n;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean headerOnlyComparesTo(byte[] byArray) {
        boolean bl = true;
        if (byArray.length == this.header.length) {
            int n = 0;
            while (n < 8) {
                if (this.header[n] != byArray[n]) {
                    bl = false;
                    break;
                }
                ++n;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public Packet() {
        this(0, 0, 0, -1, -1, 0, null, false);
    }

    public Packet(byte by, short s, short s2, boolean bl) {
        this(0, 0, by, s, s2, 0, null, bl);
    }

    public Packet(byte by, short s, short s2, int n, byte[] byArray, boolean bl) {
        this(0, 0, by, s, s2, n, byArray, bl);
    }

    public Packet(byte by, byte by2, byte by3, short s, short s2, int n, byte[] byArray, boolean bl) {
        this.header[0] = -86;
        this.header[1] = by;
        this.header[2] = by2;
        this.header[2] = bl ? (byte)(this.header[2] | 1) : (byte)(this.header[2] & 0xFFFFFFFE);
        this.header[3] = by3;
        Packet.shortToBytes(s, this.header, 4);
        Packet.shortToBytes(s2, this.header, 6);
        Packet.intToBytes(n, this.header, 8);
        this.data = byArray;
    }

    public Packet(InputStream inputStream) throws IOException, ProtocolException {
        this();
        this.readPacket(inputStream);
    }
}

