/*
 * Decompiled with CFR 0.152.
 */
package amber.client.panel;

import amber.awt.WrapTextArea;
import amber.client.BaseComponent;
import amber.client.RContainer;
import amber.client.panel.BaseControl;
import amber.type.Packet;

public class PWrapArea
extends BaseControl {
    public void init(RContainer rContainer, int[] nArray, String string) {
        this.visualObject = new WrapTextArea();
        super.init(rContainer, nArray, string);
    }

    public void parseParameters(String string) {
        if (string != null) {
            String string2 = this.parseString(string);
            ((WrapTextArea)this.visualObject).setText(string2);
        }
    }

    public void addListeners(BaseComponent baseComponent) {
        super.addListeners(baseComponent);
        ((WrapTextArea)this.visualObject).removeTextListener(this);
        if (this.eventEnabled[1]) {
            ((WrapTextArea)this.visualObject).addTextListener(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processPacket(Packet packet) {
        super.processPacket(packet);
        try {
            switch (packet.getCommand()) {
                case 80: {
                    if (this.dataDecoder.available() > 0) {
                        ((WrapTextArea)this.visualObject).setText(this.dataDecoder.readLongUTF());
                        return;
                    }
                    ((WrapTextArea)this.visualObject).setText("");
                    return;
                }
                case 93: {
                    if (this.dataDecoder.available() <= 0) return;
                    ((WrapTextArea)this.visualObject).append(this.dataDecoder.readLongUTF());
                    return;
                }
                case 94: {
                    if (this.dataDecoder.available() <= 0) return;
                    int n = this.dataDecoder.readInt();
                    String string = this.dataDecoder.readLongUTF();
                    ((WrapTextArea)this.visualObject).insert(string, n);
                    return;
                }
                case 95: {
                    if (this.dataDecoder.available() <= 0) return;
                    int n = this.dataDecoder.readInt();
                    int n2 = this.dataDecoder.readInt();
                    String string = this.dataDecoder.readLongUTF();
                    ((WrapTextArea)this.visualObject).replaceRange(string, n, n2);
                    return;
                }
                case 81: {
                    this.encoderBytes.reset();
                    Packet packet2 = new Packet(82, -1, this.getId(), false);
                    this.dataEncoder.writeLongUTF(((WrapTextArea)this.visualObject).getGenericText());
                    packet2.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet2);
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String parseString(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        do {
            if ((n = string.indexOf(92, n2)) != -1) {
                stringBuffer.append(string.substring(n2, n - 1));
                switch (string.charAt(n + 1)) {
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                    }
                }
                n2 = n + 2;
                continue;
            }
            stringBuffer.append(string.substring(n2, string.length()));
        } while (n != -1);
        return stringBuffer.toString();
    }
}

