/*
 * Decompiled with CFR 0.152.
 */
package amber.client.panel;

import amber.awt.ListItem;
import amber.awt.TreeList;
import amber.client.BaseComponent;
import amber.client.RContainer;
import amber.client.panel.BaseControl;
import amber.type.AmberInputStream;
import amber.type.Packet;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;

public class PTreeList
extends BaseControl {
    public void init(RContainer rContainer, int[] nArray, String string) {
        this.visualObject = new TreeList();
        super.init(rContainer, nArray, string);
    }

    public void parseParameters(String string) {
    }

    public void addListeners(BaseComponent baseComponent) {
        super.addListeners(baseComponent);
        ((TreeList)this.visualObject).removeActionListener(this);
        ((TreeList)this.visualObject).removeItemListener(this);
        if (this.eventEnabled[0]) {
            ((TreeList)this.visualObject).addActionListener(this);
        }
        if (this.eventEnabled[10]) {
            ((TreeList)this.visualObject).addItemListener(this);
        }
    }

    public void processPacket(Packet packet) {
        super.processPacket(packet);
        try {
            switch (packet.getCommand()) {
                case 80: {
                    ((TreeList)this.visualObject).removeAll();
                    return;
                }
                case 85: {
                    int n = this.dataDecoder.readInt();
                    PTreeList pTreeList = this;
                    ListItem listItem = pTreeList.m1(pTreeList.dataDecoder);
                    ((TreeList)this.visualObject).add(listItem, n);
                    return;
                }
                case 81: {
                    this.encoderBytes.reset();
                    Packet packet2 = new Packet(82, -1, this.getId(), false);
                    this.dataEncoder.writeInt(((TreeList)this.visualObject).getSelectedIndex());
                    packet2.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet2);
                    return;
                }
                case 83: {
                    this.encoderBytes.reset();
                    Packet packet3 = new Packet(84, -1, this.getId(), false);
                    int[] nArray = ((TreeList)this.visualObject).getSelectedIndexes();
                    int n = 0;
                    while (n < nArray.length) {
                        this.dataEncoder.writeInt(nArray[n]);
                        ++n;
                    }
                    packet3.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet3);
                    return;
                }
                case 94: {
                    ((TreeList)this.visualObject).setMultipleMode(this.dataDecoder.readBoolean());
                    return;
                }
                case 90: {
                    int n = this.dataDecoder.readInt();
                    int n2 = this.dataDecoder.readInt();
                    Packet packet4 = new Packet(91, -1, this.getId(), false);
                    this.encoderBytes.reset();
                    this.dataEncoder.writeInt(((TreeList)this.visualObject).locationToIndex(new Point(n, n2)));
                    packet4.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet4);
                    return;
                }
                case 86: {
                    int n = this.dataDecoder.readInt();
                    int n3 = this.dataDecoder.readInt();
                    PTreeList pTreeList = this;
                    ListItem listItem = pTreeList.m1(pTreeList.dataDecoder);
                    ((TreeList)this.visualObject).insert(listItem, n, n3);
                    return;
                }
                case 87: {
                    ((TreeList)this.visualObject).remove(this.dataDecoder.readInt());
                    return;
                }
                case 88: {
                    int n = this.dataDecoder.readInt();
                    if (this.dataDecoder.readBoolean()) {
                        ((TreeList)this.visualObject).select(n);
                        return;
                    }
                    ((TreeList)this.visualObject).deselect(n);
                    return;
                }
                case 89: {
                    int n = this.dataDecoder.readInt();
                    int n4 = this.dataDecoder.readInt();
                    PTreeList pTreeList = this;
                    ListItem listItem = pTreeList.m1(pTreeList.dataDecoder);
                    ((TreeList)this.visualObject).replaceItem(listItem, n, n4);
                    return;
                }
                case 92: {
                    int n = this.dataDecoder.readInt();
                    ((TreeList)this.visualObject).toggleOpenState(n);
                    return;
                }
                case 93: {
                    int n = this.dataDecoder.readInt();
                    boolean bl = this.dataDecoder.readBoolean();
                    ((TreeList)this.visualObject).setOpenState(n, bl);
                    return;
                }
                case 95: {
                    boolean bl = this.dataDecoder.readBoolean();
                    ((TreeList)this.visualObject).setDefaultOpen(bl);
                    return;
                }
                case 96: {
                    ((TreeList)this.visualObject).setAllowDeselect(this.dataDecoder.readBoolean());
                    return;
                }
                case 97: {
                    ((TreeList)this.visualObject).setModifierRequired(this.dataDecoder.readBoolean());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private final ListItem m1(AmberInputStream amberInputStream) throws IOException {
        ListItem listItem = new ListItem();
        new ListItem().item = amberInputStream.readLongUTF();
        listItem.textAttr = amberInputStream.readInt();
        byte by = amberInputStream.readByte();
        int n = 0;
        while (n < 4) {
            int n2 = 1 << n;
            if ((by & n2) == n2) {
                listItem.colour[n] = new Color(amberInputStream.readInt());
            }
            ++n;
        }
        if (amberInputStream.available() > 0) {
            listItem.image = this.getImage(amberInputStream);
        }
        return listItem;
    }
}

