/*
 * Decompiled with CFR 0.152.
 */
package amber.client.panel;

import amber.client.BaseComponent;
import amber.client.panel.BaseControl;
import amber.type.Packet;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.TextEvent;

public class PTextComponent
extends BaseControl {
    protected String oldValue;
    protected int limit = -1;

    public void parseParameters(String string) {
        if (string != null) {
            String string2 = this.parseString(string);
            ((TextComponent)this.visualObject).setText(string2);
        }
    }

    public void addListeners(BaseComponent baseComponent) {
        super.addListeners(baseComponent);
        ((TextComponent)this.visualObject).removeTextListener(this);
        ((TextComponent)this.visualObject).addTextListener(this);
    }

    public void processPacket(Packet packet) {
        super.processPacket(packet);
        try {
            switch (packet.getCommand()) {
                case 80: {
                    if (this.dataDecoder.available() > 0) {
                        PTextComponent pTextComponent = this;
                        pTextComponent.m1(pTextComponent.dataDecoder.readLongUTF());
                        return;
                    }
                    this.m1("");
                    return;
                }
                case 81: {
                    this.encoderBytes.reset();
                    Packet packet2 = new Packet(82, -1, this.getId(), false);
                    this.dataEncoder.writeLongUTF(((TextComponent)this.visualObject).getText());
                    packet2.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet2);
                    return;
                }
                case 83: {
                    this.encoderBytes.reset();
                    Packet packet3 = new Packet(84, -1, this.getId(), false);
                    this.dataEncoder.writeInt(((TextComponent)this.visualObject).getCaretPosition());
                    packet3.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet3);
                    return;
                }
                case 85: {
                    this.encoderBytes.reset();
                    Packet packet4 = new Packet(86, -1, this.getId(), false);
                    this.dataEncoder.writeLongUTF(((TextComponent)this.visualObject).getSelectedText());
                    packet4.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet4);
                    return;
                }
                case 87: {
                    this.encoderBytes.reset();
                    Packet packet5 = new Packet(88, -1, this.getId(), false);
                    this.dataEncoder.writeInt(((TextComponent)this.visualObject).getSelectionStart());
                    this.dataEncoder.writeInt(((TextComponent)this.visualObject).getSelectionEnd());
                    packet5.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet5);
                    return;
                }
                case 91: {
                    ((TextComponent)this.visualObject).setEditable(this.dataDecoder.readBoolean());
                    return;
                }
                case 89: {
                    switch (this.dataDecoder.readInt()) {
                        case 0: {
                            ((TextComponent)this.visualObject).setSelectionStart(this.dataDecoder.readInt());
                            return;
                        }
                        case 1: {
                            ((TextComponent)this.visualObject).setSelectionEnd(this.dataDecoder.readInt());
                            return;
                        }
                        case 2: {
                            ((TextComponent)this.visualObject).setSelectionStart(this.dataDecoder.readInt());
                            ((TextComponent)this.visualObject).setSelectionEnd(this.dataDecoder.readInt());
                            return;
                        }
                        case 3: {
                            ((TextComponent)this.visualObject).selectAll();
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 90: {
                    ((TextComponent)this.visualObject).setCaretPosition(this.dataDecoder.readInt());
                    return;
                }
                case 92: {
                    this.limit = this.dataDecoder.readInt();
                    PTextComponent pTextComponent = this;
                    pTextComponent.m1(((TextComponent)pTextComponent.visualObject).getText());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private final void m1(String string) {
        if (string != null && this.limit > 0 && string.length() > this.limit) {
            string = string.substring(0, this.limit);
        }
        ((TextComponent)this.visualObject).setText(string);
        this.oldValue = string;
    }

    protected String parseString(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        do {
            if ((n = string.indexOf(92, n2)) != -1) {
                stringBuffer.append(string.substring(n2, n - 1));
                switch (string.charAt(n + 1)) {
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                    }
                }
                n2 = n + 2;
                continue;
            }
            stringBuffer.append(string.substring(n2, string.length()));
        } while (n != -1);
        return stringBuffer.toString();
    }

    public void textValueChanged(TextEvent textEvent) {
        boolean bl = true;
        if (this.limit > 0) {
            String string = ((TextComponent)this.visualObject).getText();
            int n = ((TextComponent)this.visualObject).getCaretPosition();
            if (string != null && string.length() > this.limit) {
                Toolkit.getDefaultToolkit().beep();
                if (this.oldValue == null || this.oldValue.length() < this.limit) {
                    ((TextComponent)this.visualObject).setText(string.substring(0, this.limit));
                } else {
                    ((TextComponent)this.visualObject).setText(this.oldValue);
                    bl = false;
                }
                ((TextComponent)this.visualObject).setCaretPosition(n - 1);
            } else {
                this.oldValue = string;
            }
        }
        if (bl && this.eventEnabled[1]) {
            super.textValueChanged(textEvent);
        }
    }
}

