/*
 * Decompiled with CFR 0.152.
 */
package amber.client.panel;

import amber.client.AmberException;
import amber.client.BaseComponent;
import amber.client.RContainer;
import amber.client.panel.BaseControl;
import amber.type.AmberInputStream;
import amber.type.Packet;
import java.awt.List;
import java.io.IOException;
import java.util.StringTokenizer;

public class PList
extends BaseControl {
    public void init(RContainer rContainer, int[] nArray, String string) {
        this.visualObject = new List();
        super.init(rContainer, nArray, string);
    }

    public void parseParameters(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                ((List)this.visualObject).add(stringTokenizer.nextToken());
            }
        }
    }

    public void addListeners(BaseComponent baseComponent) {
        super.addListeners(baseComponent);
        ((List)this.visualObject).removeActionListener(this);
        ((List)this.visualObject).removeItemListener(this);
        if (this.eventEnabled[0]) {
            ((List)this.visualObject).addActionListener(this);
        }
        if (this.eventEnabled[10]) {
            ((List)this.visualObject).addItemListener(this);
        }
    }

    public void processPacket(Packet packet) {
        super.processPacket(packet);
        try {
            switch (packet.getCommand()) {
                case 80: {
                    ((List)this.visualObject).removeAll();
                    return;
                }
                case 81: {
                    PList pList = this;
                    pList.m1(pList.dataDecoder);
                    return;
                }
                case 82: {
                    ((List)this.visualObject).removeAll();
                    PList pList = this;
                    pList.m1(pList.dataDecoder);
                    return;
                }
                case 83: {
                    Packet packet2 = new Packet(84, -1, this.getId(), false);
                    this.encoderBytes.reset();
                    this.dataEncoder.writeInt(((List)this.visualObject).getSelectedIndex());
                    packet2.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet2);
                    return;
                }
                case 85: {
                    Packet packet3 = new Packet(86, -1, this.getId(), false);
                    this.encoderBytes.reset();
                    this.dataEncoder.writeLongUTF(((List)this.visualObject).getSelectedItem());
                    packet3.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet3);
                    return;
                }
                case 87: {
                    int n = this.dataDecoder.readInt();
                    String string = this.dataDecoder.readLongUTF();
                    ((List)this.visualObject).add(string, n);
                    return;
                }
                case 88: {
                    ((List)this.visualObject).remove(this.dataDecoder.readInt());
                    return;
                }
                case 93: {
                    int n = this.dataDecoder.readInt();
                    String string = this.dataDecoder.readLongUTF();
                    ((List)this.visualObject).replaceItem(string, n);
                    return;
                }
                case 89: {
                    int n = this.dataDecoder.readInt();
                    if (this.dataDecoder.readBoolean()) {
                        ((List)this.visualObject).select(n);
                        return;
                    }
                    ((List)this.visualObject).deselect(n);
                    return;
                }
                case 90: {
                    ((List)this.visualObject).setMultipleMode(this.dataDecoder.readBoolean());
                    return;
                }
                case 91: {
                    this.getIndexes();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private final void m1(AmberInputStream amberInputStream) throws IOException {
        while (amberInputStream.available() > 0) {
            ((List)this.visualObject).add(amberInputStream.readLongUTF());
        }
    }

    protected void getIndexes() throws AmberException, IOException {
        Packet packet = new Packet(92, -1, this.getId(), false);
        int[] nArray = ((List)this.visualObject).getSelectedIndexes();
        this.encoderBytes.reset();
        if (nArray.length > 0) {
            int n = 0;
            while (n < nArray.length) {
                this.dataEncoder.writeInt(nArray[n]);
                ++n;
            }
            packet.setData(this.encoderBytes.toByteArray());
        }
        this.forwardPacket(packet);
    }
}

