/*
 * Decompiled with CFR 0.152.
 */
package amber.client.panel;

import amber.awt.FloatButton;
import amber.client.BaseComponent;
import amber.client.RContainer;
import amber.client.panel.BaseControl;
import amber.type.AmberInputStream;
import amber.type.Packet;
import java.awt.Color;
import java.awt.Image;
import java.util.StringTokenizer;

public class PFloatButton
extends BaseControl {
    public void init(RContainer rContainer, int[] nArray, String string) {
        this.visualObject = new FloatButton();
        super.init(rContainer, nArray, string);
    }

    public void parseParameters(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            if (stringTokenizer.hasMoreTokens()) {
                ((FloatButton)this.visualObject).setLabel(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.setImage(stringTokenizer.nextToken(), true);
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.setImage(stringTokenizer.nextToken(), false);
            }
        }
    }

    public void addListeners(BaseComponent baseComponent) {
        super.addListeners(baseComponent);
        ((FloatButton)this.visualObject).removeActionListener(this);
        if (this.eventEnabled[0]) {
            ((FloatButton)this.visualObject).addActionListener(this);
        }
    }

    public void processPacket(Packet packet) {
        super.processPacket(packet);
        try {
            switch (packet.getCommand()) {
                case 80: {
                    ((FloatButton)this.visualObject).setLabel(this.dataDecoder.readLongUTF());
                    return;
                }
                case 81: {
                    this.encoderBytes.reset();
                    Packet packet2 = new Packet(82, -1, this.getId(), false);
                    this.dataEncoder.writeLongUTF(((FloatButton)this.visualObject).getLabel());
                    packet2.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet2);
                    return;
                }
                case 83: {
                    PFloatButton pFloatButton = this;
                    pFloatButton.setImage(pFloatButton.dataDecoder, true);
                    return;
                }
                case 84: {
                    PFloatButton pFloatButton = this;
                    pFloatButton.setImage(pFloatButton.dataDecoder, false);
                    return;
                }
                case 85: {
                    ((FloatButton)this.getVisualObject()).setButtonType(this.dataDecoder.readInt());
                    return;
                }
                case 86: {
                    boolean bl = this.dataDecoder.readBoolean();
                    ((FloatButton)this.getVisualObject()).setButtonState(bl);
                    return;
                }
                case 87: {
                    int n = this.dataDecoder.readInt();
                    Color color = new Color(n);
                    n = this.dataDecoder.readInt();
                    Color color2 = new Color(n);
                    ((FloatButton)this.getVisualObject()).setBackground(color);
                    ((FloatButton)this.getVisualObject()).setForeground(color2);
                    return;
                }
                case 88: {
                    ((FloatButton)this.getVisualObject()).setOrientation(this.dataDecoder.readInt());
                    return;
                }
                case 89: {
                    ((FloatButton)this.visualObject).setAlignment(this.dataDecoder.readInt());
                    return;
                }
                case 90: {
                    ((FloatButton)this.visualObject).setMargin(this.dataDecoder.readInt());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void setImage(AmberInputStream amberInputStream, boolean bl) {
        Image image = this.getImage(amberInputStream);
        if (bl) {
            ((FloatButton)this.visualObject).setEnabledImage(image);
        } else {
            ((FloatButton)this.visualObject).setDisabledImage(image);
        }
        ((FloatButton)this.visualObject).repaint();
    }

    protected void setImage(String string, boolean bl) {
        Image image = this.getImage(string);
        if (bl) {
            ((FloatButton)this.visualObject).setEnabledImage(image);
        } else {
            ((FloatButton)this.visualObject).setDisabledImage(image);
        }
        ((FloatButton)this.visualObject).repaint();
    }
}

