/*
 * Decompiled with CFR 0.152.
 */
package amber.client.panel;

import amber.awt.Calendar;
import amber.client.AmberException;
import amber.client.BaseComponent;
import amber.client.RContainer;
import amber.client.panel.BaseControl;
import amber.type.Packet;
import java.io.IOException;
import java.util.StringTokenizer;

public class PCalendar
extends BaseControl {
    public void init(RContainer rContainer, int[] nArray, String string) {
        this.visualObject = new Calendar();
        super.init(rContainer, nArray, string);
    }

    public void parseParameters(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            if (stringTokenizer.hasMoreTokens()) {
                ((Calendar)this.visualObject).setStartingDay(Integer.parseInt(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                ((Calendar)this.visualObject).setMonthLength(Integer.parseInt(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                ((Calendar)this.visualObject).setPriorMonthLength(Integer.parseInt(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                ((Calendar)this.visualObject).setCurrentDay(Integer.parseInt(stringTokenizer.nextToken()));
            }
        }
    }

    public void addListeners(BaseComponent baseComponent) {
        super.addListeners(baseComponent);
        ((Calendar)this.visualObject).removeActionListener(this);
        ((Calendar)this.visualObject).removeItemListener(this);
        if (this.eventEnabled[0]) {
            ((Calendar)this.visualObject).addActionListener(this);
        }
        if (this.eventEnabled[10]) {
            ((Calendar)this.visualObject).addItemListener(this);
        }
    }

    public void processPacket(Packet packet) {
        super.processPacket(packet);
        try {
            switch (packet.getCommand()) {
                case 80: {
                    int n = this.dataDecoder.readInt();
                    int n2 = this.dataDecoder.readInt();
                    int n3 = this.dataDecoder.readInt();
                    ((Calendar)this.visualObject).setMonthConfiguration(n, n2, n3);
                    return;
                }
                case 81: {
                    ((Calendar)this.visualObject).setCurrentDay(this.dataDecoder.readInt());
                    return;
                }
                case 82: {
                    this.encoderBytes.reset();
                    this.dataEncoder.writeInt(((Calendar)this.visualObject).getSelectedIndex());
                    Packet packet2 = new Packet(83, -1, this.getId(), false);
                    packet2.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet2);
                    return;
                }
                case 84: {
                    int n = this.dataDecoder.readInt();
                    boolean bl = this.dataDecoder.readBoolean();
                    if (n == -1) {
                        ((Calendar)this.visualObject).deselectAll();
                        return;
                    }
                    if (bl) {
                        ((Calendar)this.visualObject).select(n);
                        return;
                    }
                    ((Calendar)this.visualObject).deselect(n);
                    return;
                }
                case 86: {
                    ((Calendar)this.visualObject).setMultipleMode(this.dataDecoder.readBoolean());
                    return;
                }
                case 87: {
                    this.getIndexes(packet);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void getIndexes(Packet packet) throws AmberException, IOException {
        this.encoderBytes.reset();
        Packet packet2 = new Packet(87, -1, this.getId(), false);
        int[] nArray = ((Calendar)this.visualObject).getSelectedIndexes();
        if (nArray.length > 0) {
            int n = 0;
            while (n < nArray.length) {
                this.dataEncoder.writeInt(nArray[n]);
                ++n;
            }
            packet2.setData(this.encoderBytes.toByteArray());
        }
        this.forwardPacket(packet2);
    }
}

