/*
 * Decompiled with CFR 0.152.
 */
package amber.client.panel;

import amber.awt.DrawPanel;
import amber.awt.XYLayout;
import amber.client.AmberException;
import amber.client.BaseComponent;
import amber.client.RContainer;
import amber.client.panel.BaseControl;
import amber.type.Packet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Vector;

public class BasePanel
extends BaseControl
implements RContainer {
    protected DrawPanel panel = new DrawPanel();
    protected XYLayout xyLayout = new XYLayout();
    protected Vector components = new Vector();
    protected int[] coordinates = new int[6];
    private short f1;
    private Image f2 = null;
    private String f3 = null;
    private boolean f4 = false;
    private boolean f5 = true;
    private boolean f6 = false;
    private int f7 = 0;
    private Vector f8 = new Vector();

    public void init(RContainer rContainer, int[] nArray, String string) {
        if (this.visualObject == null && this.nonVisualObject == null) {
            this.visualObject = this.panel;
            this.panel.setLayout(this.xyLayout);
        }
        super.init(rContainer, nArray, string);
    }

    public void parseParameters(String string) {
    }

    public void addListeners(BaseComponent baseComponent) {
        super.addListeners(baseComponent);
    }

    protected BaseControl createAndAddComponent(String string, int[] nArray, String string2, boolean bl) {
        BaseControl baseControl = null;
        try {
            baseControl = (BaseControl)Class.forName(string).newInstance();
            baseControl.init(this, nArray, string2);
            baseControl.addListeners(this.findBaseComponent());
            this.components.addElement(baseControl);
            this.addComponentToPanel(baseControl, nArray, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return baseControl;
    }

    protected void addComponentToPanel(BaseControl baseControl, int[] nArray, boolean bl) {
        Component component = baseControl.getVisualObject();
        if (component != null) {
            if (baseControl.canAdd()) {
                this.getContainer().add(component, BasePanel.coordToString(2, nArray));
            }
        } else {
            Object object = baseControl.getNonVisualObject();
            if (object instanceof PopupMenu && baseControl.canAdd()) {
                this.getContainer().add((PopupMenu)object);
            }
        }
        if (bl && this.visualObject != null && this.f5) {
            if (this.visualObject != null) {
                this.visualObject.validate();
            }
            this.getContainer().validate();
        }
    }

    public static String coordToString(int n, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < nArray.length - n) {
            stringBuffer.append(Integer.toString(nArray[n + n2]));
            if (n2 < 3) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void processPacket(Packet packet) {
        short s = packet.getDestinationId();
        if (s == this.getId()) {
            this.internalProcessPacket(packet);
            return;
        }
        int n = 0;
        while (n < this.components.size()) {
            BaseControl baseControl = (BaseControl)this.components.elementAt(n);
            if (baseControl.isMyId(s)) {
                baseControl.createDataInput(packet);
                baseControl.processPacket(packet);
                return;
            }
            ++n;
        }
    }

    public void internalProcessPacket(Packet packet) {
        try {
            switch (packet.getCommand()) {
                default: {
                    super.processPacket(packet);
                    return;
                }
                case 80: {
                    this.addComponent(packet);
                    return;
                }
                case 81: {
                    this.removeComponent(packet);
                    return;
                }
                case 82: {
                    this.removeAllComponents();
                    return;
                }
                case 83: {
                    this.setComponentBounds(packet);
                    return;
                }
                case 84: {
                    this.f5 = this.dataDecoder.readBoolean();
                    return;
                }
                case 85: {
                    if (this.visualObject != null) {
                        this.visualObject.validate();
                        this.visualObject.doLayout();
                    }
                    this.getContainer().validate();
                    if (this.getContainer().getParent() != null) {
                        this.getContainer().getParent().validate();
                        return;
                    }
                    break;
                }
                case 86: {
                    Insets insets = ((Container)this.visualObject).getInsets();
                    this.encoderBytes.reset();
                    this.dataEncoder.writeInt(insets.top);
                    this.dataEncoder.writeInt(insets.left);
                    this.dataEncoder.writeInt(insets.bottom);
                    this.dataEncoder.writeInt(insets.right);
                    Packet packet2 = new Packet(87, -1, this.getId(), false);
                    packet2.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet2);
                    return;
                }
                case 88: {
                    if (this.visualObject instanceof DrawPanel) {
                        ((DrawPanel)this.visualObject).setBorder(this.dataDecoder.readInt());
                        return;
                    }
                    this.panel.setBorder(this.dataDecoder.readInt());
                    return;
                }
                case 89: {
                    int[] nArray = this.createArray();
                    if (this.visualObject instanceof DrawPanel) {
                        ((DrawPanel)this.visualObject).addOperation(this.createObject(nArray), nArray);
                        return;
                    }
                    this.panel.addOperation(this.createObject(nArray), nArray);
                    return;
                }
                case 90: {
                    int n = this.dataDecoder.readInt();
                    int[] nArray = this.createArray();
                    if (this.visualObject instanceof DrawPanel) {
                        ((DrawPanel)this.visualObject).insertOperation(this.createObject(nArray), nArray, n);
                        return;
                    }
                    this.panel.insertOperation(this.createObject(nArray), nArray, n);
                    return;
                }
                case 91: {
                    int n = this.dataDecoder.readInt();
                    int[] nArray = this.createArray();
                    if (this.visualObject instanceof DrawPanel) {
                        ((DrawPanel)this.visualObject).replaceOperation(this.createObject(nArray), nArray, n);
                        return;
                    }
                    this.panel.replaceOperation(this.createObject(nArray), nArray, n);
                    return;
                }
                case 92: {
                    if (this.visualObject instanceof DrawPanel) {
                        ((DrawPanel)this.visualObject).removeOperation(this.dataDecoder.readInt());
                        return;
                    }
                    this.panel.removeOperation(this.dataDecoder.readInt());
                    return;
                }
                case 93: {
                    if (this.visualObject instanceof DrawPanel) {
                        ((DrawPanel)this.visualObject).removeAllOperations();
                        return;
                    }
                    this.panel.removeAllOperations();
                    return;
                }
                case 94: {
                    if (this.visualObject instanceof DrawPanel) {
                        ((DrawPanel)this.visualObject).setAutoRepaint(this.dataDecoder.readBoolean());
                        return;
                    }
                    this.panel.setAutoRepaint(this.dataDecoder.readBoolean());
                    return;
                }
                case 95: {
                    if (this.visualObject instanceof DrawPanel) {
                        ((DrawPanel)this.visualObject).repaint();
                        return;
                    }
                    this.panel.repaint();
                    return;
                }
                case 96: {
                    this.m1();
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void m1() throws IOException {
        if (!this.dataDecoder.readBoolean()) {
            this.f7 = this.dataDecoder.readInt();
            while (this.dataDecoder.available() > 0) {
                this.f8.addElement(new Integer(this.dataDecoder.readInt()));
            }
            return;
        }
        boolean bl = this.dataDecoder.readBoolean();
        if (!this.f6 && bl) {
            this.m2(true, this.getContainer());
            if (!(this.isEventEnabled(2) || this.isEventEnabled(3) || this.isEventEnabled(4))) {
                this.visualObject.addKeyListener(this);
            }
            this.f6 = true;
            return;
        }
        if (this.f6 && !bl) {
            this.m2(true, this.getContainer());
            if (!(this.isEventEnabled(2) || this.isEventEnabled(3) || this.isEventEnabled(4))) {
                this.visualObject.removeKeyListener(this);
            }
            this.f6 = false;
        }
    }

    private final void m2(boolean bl, Container container) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (bl) {
                componentArray[n].addKeyListener(this);
            } else {
                componentArray[n].removeKeyListener(this);
            }
            if (componentArray[n] instanceof Container) {
                this.m2(bl, (Container)componentArray[n]);
            }
            ++n;
        }
    }

    protected int[] createArray() throws IOException, AmberException {
        int[] nArray;
        int n = this.dataDecoder.readInt();
        if (n > 0) {
            nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.dataDecoder.readInt();
                ++n2;
            }
        } else {
            throw new AmberException("Drawing data array length invalid: " + n);
        }
        return nArray;
    }

    protected Object createObject(int[] nArray) throws IOException {
        Object object;
        switch (nArray[0]) {
            case 0: {
                object = this.findBaseComponent().getImage(this.dataDecoder);
                break;
            }
            case 2: 
            case 11: {
                object = new Color(nArray[2]);
                this.dataDecoder.readLongUTF();
                break;
            }
            case 12: {
                object = new Font(this.dataDecoder.readLongUTF(), nArray[2], nArray[3]);
                break;
            }
            default: {
                object = this.dataDecoder.readLongUTF();
            }
        }
        return object;
    }

    public boolean isMyId(int n) {
        int n2 = 0;
        while (n2 < this.components.size()) {
            if (((BaseControl)this.components.elementAt(n2)).isMyId(n)) {
                return true;
            }
            ++n2;
        }
        return super.isMyId(n);
    }

    public BaseControl findById(int n) {
        int n2 = 0;
        while (n2 < this.components.size()) {
            BaseControl baseControl = (BaseControl)this.components.elementAt(n2);
            if (baseControl.isMyId(n)) {
                return baseControl;
            }
            ++n2;
        }
        return null;
    }

    public void addComponent(Packet packet) {
        try {
            this.createDataInput(packet);
            boolean bl = this.dataDecoder.readBoolean();
            this.coordinates[0] = this.dataDecoder.readInt();
            this.coordinates[1] = this.dataDecoder.readInt();
            this.coordinates[2] = this.dataDecoder.readInt();
            this.coordinates[3] = this.dataDecoder.readInt();
            this.coordinates[4] = this.dataDecoder.readInt();
            this.coordinates[5] = this.dataDecoder.readInt();
            String string = this.dataDecoder.readLongUTF();
            String string2 = null;
            if (this.dataDecoder.available() > 0) {
                string2 = this.dataDecoder.readLongUTF();
            }
            this.createAndAddComponent(string, this.coordinates, string2, bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setComponentBounds(Packet packet) {
        try {
            this.createDataInput(packet);
            Container container = this.getContainer();
            int n = this.dataDecoder.readInt();
            BaseControl baseControl = this.findById(n);
            if (this.getId() != n) {
                Component component;
                if (baseControl instanceof RContainer && baseControl.getId() != n) {
                    ((RContainer)((Object)baseControl)).setComponentBounds(packet);
                } else if (baseControl.canAdd() && (component = baseControl.getVisualObject()) != null) {
                    int n2 = this.dataDecoder.readInt();
                    int[] nArray = XYLayout.getCoordinates(this.xyLayout.getComponentLayout(component));
                    int n3 = this.dataDecoder.readInt();
                    int n4 = this.dataDecoder.readInt();
                    switch (n2) {
                        case 0: {
                            nArray[2] = this.dataDecoder.readInt();
                            nArray[3] = this.dataDecoder.readInt();
                        }
                        case 1: {
                            nArray[0] = n3;
                            nArray[1] = n4;
                            break;
                        }
                        case 2: {
                            nArray[2] = n3;
                            nArray[3] = n4;
                        }
                    }
                    if (container != null) {
                        container.remove(component);
                    }
                    component.invalidate();
                    String string = XYLayout.valuesToString(nArray);
                    if (container != null) {
                        container.add(component, string);
                        if (this.f5) {
                            container.validate();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.visualObject != null && this.f5) {
            this.visualObject.validate();
        }
    }

    public void removeComponent(Packet packet) {
        try {
            this.createDataInput(packet);
            int n = this.dataDecoder.readInt();
            BaseControl baseControl = this.findById(n);
            if (n == this.getId()) {
                this.removeAllComponents();
                throw new AmberException("This object cannot be removed from within itself");
            }
            if (baseControl instanceof RContainer) {
                if (n == baseControl.getId()) {
                    ((RContainer)((Object)baseControl)).removeAllComponents();
                    this.removeControl(baseControl);
                    int n2 = this.components.indexOf(baseControl);
                    if (n2 >= 0) {
                        this.components.removeElementAt(n2);
                    }
                } else {
                    ((RContainer)((Object)baseControl)).removeComponent(packet);
                }
            } else {
                this.removeControl(baseControl);
                int n3 = this.components.indexOf(baseControl);
                if (n3 >= 0) {
                    this.components.removeElementAt(n3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.visualObject != null && this.f5) {
            this.visualObject.doLayout();
        }
    }

    protected void removeControl(BaseControl baseControl) {
        Object object;
        baseControl.enableSpecifiedEvents(0);
        baseControl.addListeners(null);
        Component component = baseControl.getVisualObject();
        Container container = this.getContainer();
        if (component != null) {
            if (baseControl.canAdd()) {
                container.remove(component);
            }
            if (component instanceof Window) {
                ((Window)component).dispose();
            }
            this.findBaseComponent().getToolTipManager().removeTip(component);
        }
        if ((object = baseControl.getNonVisualObject()) != null) {
            if (object instanceof MenuBar) {
                ((Frame)this.visualObject).setMenuBar(null);
                return;
            }
            if (object instanceof MenuComponent) {
                container.remove((MenuComponent)object);
            }
        }
    }

    public void removeAllComponents() {
        int n = this.components.size() - 1;
        while (n >= 0) {
            BaseControl baseControl = (BaseControl)this.components.elementAt(n);
            if (baseControl instanceof RContainer) {
                ((RContainer)((Object)baseControl)).removeAllComponents();
            }
            this.removeControl(baseControl);
            this.components.removeElementAt(n);
            --n;
        }
        if (this.visualObject != null && this.f5) {
            this.visualObject.doLayout();
        }
    }

    public short getIdFromInternalObject(Object object) {
        if (object == this.visualObject || object == this.nonVisualObject) {
            return this.getId();
        }
        int n = 0;
        while (n < this.components.size()) {
            BaseControl baseControl = (BaseControl)this.components.elementAt(n);
            this.f1 = baseControl.getIdFromInternalObject(object);
            if (this.f1 != -1) {
                return this.f1;
            }
            ++n;
        }
        return -1;
    }

    public Container getContainer() {
        return this.panel;
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.visualObject) {
            super.keyReleased(keyEvent);
        }
        if (this.f6) {
            boolean bl = false;
            if ((keyEvent.getModifiers() & this.f7) != 0) {
                bl = true;
            } else {
                int n = 0;
                while (n < this.f8.size()) {
                    if (keyEvent.getKeyCode() == ((Integer)this.f8.elementAt(n)).intValue()) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (bl) {
                try {
                    this.encoderBytes.reset();
                    this.dataEncoder.writeInt(keyEvent.getModifiers());
                    this.dataEncoder.writeInt(keyEvent.getKeyCode());
                    this.dataEncoder.writeChar(keyEvent.getKeyChar());
                    Packet packet = new Packet(97, -1, this.getId(), true);
                    packet.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

