/*
 * Decompiled with CFR 0.152.
 */
package amber.client.panel;

import amber.awt.TipMgr;
import amber.awt.ToolTip;
import amber.client.AmberException;
import amber.client.BaseComponent;
import amber.client.MbInterface;
import amber.client.RContainer;
import amber.client.RMessageBox;
import amber.type.AmberInputStream;
import amber.type.AmberOutputStream;
import amber.type.Mutex;
import amber.type.Packet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class BaseControl
implements MbInterface,
ActionListener,
ItemListener,
KeyListener,
MouseListener,
TextListener,
FocusListener,
MouseMotionListener,
WindowListener,
ComponentListener {
    protected boolean[] eventEnabled = new boolean[20];
    private short f1 = (short)-1;
    protected RContainer panelParent = null;
    protected Component visualObject = null;
    protected Object nonVisualObject = null;
    protected AmberInputStream dataDecoder = null;
    protected ByteArrayOutputStream encoderBytes = new ByteArrayOutputStream();
    protected AmberOutputStream dataEncoder = new AmberOutputStream(this.encoderBytes);
    protected BaseComponent mainEventHandler = null;
    private Mutex f2 = new Mutex();
    private int f3;

    public void init(RContainer rContainer, int[] nArray, String string) {
        this.setParent(rContainer);
        this.setId((short)nArray[0]);
        this.enableSpecifiedEvents(nArray[1]);
        this.parseParameters(string);
    }

    public abstract void parseParameters(String var1);

    public void addListeners(BaseComponent baseComponent) {
        this.mainEventHandler = baseComponent;
        if (this.visualObject != null) {
            this.visualObject.removeFocusListener(this);
            this.visualObject.removeKeyListener(this);
            this.visualObject.removeMouseListener(this);
            this.visualObject.removeMouseMotionListener(this);
            this.visualObject.removeComponentListener(this);
            if (this.eventEnabled[15] || this.eventEnabled[14]) {
                this.visualObject.addFocusListener(this);
            }
            if (this.isEventEnabled(2) || this.isEventEnabled(3) || this.isEventEnabled(4)) {
                this.visualObject.addKeyListener(this);
            }
            if (this.isEventEnabled(5) || this.isEventEnabled(6) || this.isEventEnabled(7) || this.isEventEnabled(8) || this.isEventEnabled(9)) {
                this.visualObject.addMouseListener(this);
            }
            if (this.isEventEnabled(12) || this.isEventEnabled(13)) {
                this.visualObject.addMouseMotionListener(this);
            }
            if (this.isEventEnabled(16) || this.isEventEnabled(17) || this.isEventEnabled(18) || this.isEventEnabled(19)) {
                this.visualObject.addComponentListener(this);
            }
        }
    }

    public short getIdFromInternalObject(Object object) {
        if (object == this.visualObject || object == this.nonVisualObject) {
            return this.getId();
        }
        return -1;
    }

    public Component getVisualObject() {
        return this.visualObject;
    }

    public Object getNonVisualObject() {
        return this.nonVisualObject;
    }

    public void setParent(RContainer rContainer) {
        this.panelParent = rContainer;
    }

    public RContainer getParent() {
        return this.panelParent;
    }

    public Image getImage(String string) {
        Image image;
        try {
            BaseComponent baseComponent = this.findBaseComponent();
            image = baseComponent.getImage(new URL(baseComponent.getCodeBase(), string));
            baseComponent.waitForImage(image);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + string);
            image = null;
        }
        return image;
    }

    public Image getImage(AmberInputStream amberInputStream) {
        return this.findBaseComponent().getImage(amberInputStream);
    }

    public boolean isEventEnabled(int n) {
        return this.eventEnabled[n];
    }

    void enableSpecifiedEvents(int n) {
        int n2 = 0;
        while (n2 < 20) {
            int n3 = 1 << n2;
            this.eventEnabled[n2] = (n & n3) == n3;
            ++n2;
        }
    }

    public short getId() {
        return this.f1;
    }

    public void setId(short s) {
        this.f1 = s;
    }

    public boolean isMyId(int n) {
        return n == this.f1;
    }

    public void processPacket(Packet packet) {
        try {
            switch (packet.getCommand()) {
                case 4: {
                    BaseComponent baseComponent = this.findBaseComponent();
                    String string = this.dataDecoder.readLongUTF();
                    String string2 = null;
                    if (this.dataDecoder.available() > 0) {
                        string2 = this.dataDecoder.readLongUTF();
                    }
                    baseComponent.displayUrl(string, string2);
                }
                case 0: {
                    return;
                }
                case 5: {
                    BaseControl baseControl = this;
                    baseControl.setEnabled(baseControl.dataDecoder.readBoolean());
                    return;
                }
                case 6: {
                    BaseControl baseControl = this;
                    baseControl.setVisible(baseControl.dataDecoder.readBoolean());
                    return;
                }
                case 10: {
                    int n = this.dataDecoder.readInt();
                    Cursor cursor = new Cursor(n);
                    this.visualObject.setCursor(cursor);
                    return;
                }
                case 8: {
                    int n = this.dataDecoder.readInt();
                    int n2 = this.dataDecoder.readInt();
                    switch (n) {
                        case 0: {
                            int n3 = this.dataDecoder.readInt();
                            this.visualObject.setForeground(new Color(n2));
                            this.visualObject.setBackground(new Color(n3));
                            break;
                        }
                        case 1: {
                            this.visualObject.setForeground(new Color(n2));
                            break;
                        }
                        case 2: {
                            this.visualObject.setBackground(new Color(n2));
                        }
                    }
                    this.visualObject.invalidate();
                    if (this.visualObject.getParent() != null) {
                        this.visualObject.getParent().invalidate();
                        this.visualObject.getParent().validate();
                        return;
                    }
                    this.visualObject.repaint();
                    return;
                }
                case 9: {
                    int n = this.dataDecoder.readInt();
                    Font font = this.visualObject.getFont();
                    if (font == null && this.visualObject.getParent() != null) {
                        font = this.visualObject.getParent().getFont();
                    }
                    int n4 = this.dataDecoder.available() > 0 ? this.dataDecoder.readInt() : (font != null ? font.getSize() : 12);
                    String string = this.dataDecoder.available() > 0 ? this.dataDecoder.readLongUTF() : (font != null ? this.visualObject.getFont().getName() : "Dialog");
                    this.visualObject.setFont(new Font(string, n, n4));
                    this.visualObject.invalidate();
                    if (this.visualObject.getParent() != null) {
                        this.visualObject.getParent().invalidate();
                        return;
                    }
                    break;
                }
                case 13: {
                    int n = this.dataDecoder.readInt();
                    this.enableSpecifiedEvents(n);
                    BaseControl baseControl = this;
                    baseControl.addListeners(baseControl.mainEventHandler);
                    return;
                }
                case 14: {
                    this.visualObject.requestFocus();
                    return;
                }
                case 7: {
                    BaseControl baseControl = this;
                    baseControl.displayMessage(baseControl.dataDecoder.readLongUTF(), this.dataDecoder.readLongUTF(), 0, false);
                    return;
                }
                case 11: {
                    int n = this.dataDecoder.readInt();
                    BaseControl baseControl = this;
                    int n5 = baseControl.displayMessage(baseControl.dataDecoder.readLongUTF(), this.dataDecoder.readLongUTF(), n, true);
                    this.encoderBytes.reset();
                    this.dataEncoder.writeInt(n5);
                    Packet packet2 = new Packet(12, -1, this.getId(), false);
                    packet2.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet2);
                    return;
                }
                case 18: {
                    Serializable serializable;
                    this.encoderBytes.reset();
                    Component component = this.getVisualObject();
                    if (component != null) {
                        serializable = component.getBounds();
                        this.dataEncoder.writeInt(serializable.x);
                        this.dataEncoder.writeInt(serializable.y);
                        this.dataEncoder.writeInt(serializable.width);
                        this.dataEncoder.writeInt(serializable.height);
                    } else {
                        this.dataEncoder.writeInt(0);
                        this.dataEncoder.writeInt(0);
                        this.dataEncoder.writeInt(0);
                        this.dataEncoder.writeInt(0);
                    }
                    serializable = new Packet(19, -1, this.getId(), false);
                    ((Packet)serializable).setData(this.encoderBytes.toByteArray());
                    this.forwardPacket((Packet)serializable);
                    return;
                }
                case 23: {
                    Serializable serializable;
                    this.encoderBytes.reset();
                    if (this.visualObject != null) {
                        serializable = this.visualObject.getMinimumSize();
                        this.dataEncoder.writeInt(serializable.width);
                        this.dataEncoder.writeInt(serializable.height);
                        serializable = this.visualObject.getMaximumSize();
                        this.dataEncoder.writeInt(serializable.width);
                        this.dataEncoder.writeInt(serializable.height);
                        serializable = this.visualObject.getPreferredSize();
                        this.dataEncoder.writeInt(serializable.width);
                        this.dataEncoder.writeInt(serializable.height);
                    }
                    serializable = new Packet(24, -1, this.getId(), false);
                    ((Packet)serializable).setData(this.encoderBytes.toByteArray());
                    this.forwardPacket((Packet)serializable);
                    return;
                }
                case 20: {
                    Serializable serializable;
                    Font font;
                    this.encoderBytes.reset();
                    String string = null;
                    Font font2 = font = this.visualObject != null ? this.visualObject.getFont() : null;
                    if (this.dataDecoder.available() > 0) {
                        string = this.dataDecoder.readLongUTF();
                    }
                    if (this.dataDecoder.available() > 0) {
                        int n = this.dataDecoder.readInt();
                        int n6 = this.dataDecoder.readInt();
                        String string3 = this.dataDecoder.available() > 0 ? this.dataDecoder.readLongUTF() : this.visualObject.getFont().getName();
                        font = new Font(string3, n6, n);
                    }
                    if (font != null && this.visualObject != null) {
                        serializable = this.visualObject.getFontMetrics(font);
                        this.dataEncoder.writeInt(((FontMetrics)serializable).getMaxAscent());
                        this.dataEncoder.writeInt(((FontMetrics)serializable).getMaxDescent());
                        this.dataEncoder.writeInt(((FontMetrics)serializable).getLeading());
                        this.dataEncoder.writeInt(((FontMetrics)serializable).getMaxAdvance());
                        if (string != null) {
                            this.dataEncoder.writeInt(((FontMetrics)serializable).stringWidth(string));
                        }
                    }
                    serializable = new Packet(21, -1, this.getId(), false);
                    ((Packet)serializable).setData(this.encoderBytes.toByteArray());
                    this.forwardPacket((Packet)serializable);
                    return;
                }
                case 25: {
                    TipMgr tipMgr = this.findBaseComponent().getToolTipManager();
                    if (this.dataDecoder.readBoolean()) {
                        tipMgr.addTip(new ToolTip(this.getVisualObject(), this.dataDecoder.readLongUTF()));
                        return;
                    }
                    tipMgr.removeTip(this.getVisualObject());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void forwardPacket(Packet packet) throws AmberException {
        this.findBaseComponent().forwardPacket(packet);
    }

    public void setVisible(boolean bl) {
        if (this.visualObject != null) {
            this.visualObject.setVisible(bl);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.visualObject != null) {
            this.visualObject.setEnabled(bl);
        }
    }

    public AmberInputStream createDataInput(Packet packet) {
        ByteArrayInputStream byteArrayInputStream = packet.getData() == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(packet.getData());
        this.dataDecoder = new AmberInputStream(byteArrayInputStream);
        return this.dataDecoder;
    }

    public boolean canAdd() {
        return true;
    }

    protected AmberInputStream getDataInput() {
        return this.dataDecoder;
    }

    public BaseComponent findBaseComponent() {
        if (this.panelParent instanceof BaseComponent) {
            return (BaseComponent)((Object)this.panelParent);
        }
        if (this.panelParent != null) {
            return this.panelParent.findBaseComponent();
        }
        return null;
    }

    public int displayMessage(String string, String string2, int n, boolean bl) {
        int n2 = 0;
        if (string != null && string2 != null) {
            ((Component)new RMessageBox(this, string, string2, n)).setVisible(true);
            this.f3 = 0;
            if (bl) {
                this.f2.block(200000L);
                n2 = this.f3;
            }
        }
        return n2;
    }

    public void setMessageBoxReturn(int n) {
        this.f3 = n;
        this.f2.unlock();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.eventEnabled[0]) {
            this.mainEventHandler.sendEvent(actionEvent, this.getIdFromInternalObject(actionEvent.getSource()));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.eventEnabled[10]) {
            this.mainEventHandler.sendEvent(itemEvent, this.getIdFromInternalObject(itemEvent.getSource()));
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.eventEnabled[2]) {
            this.mainEventHandler.sendEvent(keyEvent, this.getIdFromInternalObject(keyEvent.getSource()));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.eventEnabled[3]) {
            this.mainEventHandler.sendEvent(keyEvent, this.getIdFromInternalObject(keyEvent.getSource()));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.eventEnabled[4]) {
            this.mainEventHandler.sendEvent(keyEvent, this.getIdFromInternalObject(keyEvent.getSource()));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.eventEnabled[5]) {
            this.mainEventHandler.sendEvent(mouseEvent, this.getIdFromInternalObject(mouseEvent.getSource()));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.eventEnabled[6]) {
            this.mainEventHandler.sendEvent(mouseEvent, this.getIdFromInternalObject(mouseEvent.getSource()));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.eventEnabled[7]) {
            this.mainEventHandler.sendEvent(mouseEvent, this.getIdFromInternalObject(mouseEvent.getSource()));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.eventEnabled[8]) {
            this.mainEventHandler.sendEvent(mouseEvent, this.getIdFromInternalObject(mouseEvent.getSource()));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.eventEnabled[9]) {
            this.mainEventHandler.sendEvent(mouseEvent, this.getIdFromInternalObject(mouseEvent.getSource()));
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.eventEnabled[1]) {
            this.mainEventHandler.sendEvent(textEvent, this.getIdFromInternalObject(textEvent.getSource()));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.eventEnabled[12]) {
            this.mainEventHandler.sendEvent(mouseEvent, this.getIdFromInternalObject(mouseEvent.getSource()));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.eventEnabled[13]) {
            this.mainEventHandler.sendEvent(mouseEvent, this.getIdFromInternalObject(mouseEvent.getSource()));
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.eventEnabled[15]) {
            this.mainEventHandler.sendEvent(focusEvent, this.getIdFromInternalObject(focusEvent.getSource()));
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.eventEnabled[14]) {
            this.mainEventHandler.sendEvent(focusEvent, this.getIdFromInternalObject(focusEvent.getSource()));
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
        if (this.eventEnabled[11]) {
            this.mainEventHandler.sendEvent(windowEvent, this.getIdFromInternalObject(windowEvent.getSource()));
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.eventEnabled[11]) {
            this.mainEventHandler.sendEvent(windowEvent, this.getIdFromInternalObject(windowEvent.getSource()));
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.eventEnabled[11]) {
            this.mainEventHandler.sendEvent(windowEvent, this.getIdFromInternalObject(windowEvent.getSource()));
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        if (this.eventEnabled[11]) {
            this.mainEventHandler.sendEvent(windowEvent, this.getIdFromInternalObject(windowEvent.getSource()));
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.eventEnabled[11]) {
            this.mainEventHandler.sendEvent(windowEvent, this.getIdFromInternalObject(windowEvent.getSource()));
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (this.eventEnabled[11]) {
            this.mainEventHandler.sendEvent(windowEvent, this.getIdFromInternalObject(windowEvent.getSource()));
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        if (this.eventEnabled[11]) {
            this.mainEventHandler.sendEvent(windowEvent, this.getIdFromInternalObject(windowEvent.getSource()));
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.eventEnabled[18]) {
            this.mainEventHandler.sendEvent(componentEvent, this.getIdFromInternalObject(componentEvent.getSource()));
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (this.eventEnabled[17]) {
            this.mainEventHandler.sendEvent(componentEvent, this.getIdFromInternalObject(componentEvent.getSource()));
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.eventEnabled[19]) {
            this.mainEventHandler.sendEvent(componentEvent, this.getIdFromInternalObject(componentEvent.getSource()));
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (this.eventEnabled[16]) {
            this.mainEventHandler.sendEvent(componentEvent, this.getIdFromInternalObject(componentEvent.getSource()));
        }
    }
}

