/*
 * Decompiled with CFR 0.152.
 */
package amber.client;

import amber.awt.TipMgr;
import amber.client.AmberException;
import amber.client.BaseComponent;
import amber.client.ConnectionModule;
import amber.client.RMessageBox;
import amber.type.AmberInputStream;
import amber.type.AmberOutputStream;
import amber.type.Mutex;
import amber.type.Packet;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class RComponent
extends Applet
implements BaseComponent,
ActionListener,
TextListener,
KeyListener,
MouseListener,
ItemListener,
WindowListener,
MouseMotionListener,
FocusListener,
ComponentListener {
    public static final int InvalidPageSubId = -1;
    private static int f1 = 0;
    protected boolean[] eventEnabled = new boolean[20];
    private short f2;
    private int f3 = 0;
    private int f4 = 0;
    private String f5 = null;
    protected ConnectionModule connectionModule;
    private Mutex f6 = new Mutex();
    private int f7;
    protected Font defaultFont = this.getFont();
    protected AmberInputStream dataDecoder = null;
    protected ByteArrayOutputStream encoderBytes = new ByteArrayOutputStream();
    protected AmberOutputStream dataEncoder = new AmberOutputStream(this.encoderBytes);
    public int num;
    protected Component visualObject = this;
    protected TipMgr toolTipManager = null;

    public String getParameter(String string, String string2) {
        if (this.getParameter(string) != null) {
            return this.getParameter(string);
        }
        return string2;
    }

    public void init() {
        super.init();
        this.defaultFont = this.getFont();
        try {
            this.f2 = (short)Integer.parseInt(this.getParameter("ID", Integer.toString(0)));
            this.f3 = Integer.parseInt(this.getParameter("PAGEID", "0"));
            this.f4 = Integer.parseInt(this.getParameter("PAGESUBID", "-1"));
            String string = this.getParameter("EVENTMASK");
            if (string != null) {
                this.enableSpecifiedEvents(Integer.parseInt(string, 16));
            }
            if (this.m4()) {
                this.waitForRegistration();
                boolean bl = true;
                int n = 0;
                while (bl) {
                    String string2 = this.getParameter("CONNECTIONMODULE" + Integer.toString(n), null);
                    if (string2 == null && n == 0) {
                        string2 = "amber.client.SocketConnection";
                        bl = false;
                    }
                    if (string2 != null) {
                        try {
                            Class<?> clazz = Class.forName(string2);
                            this.connectionModule = (ConnectionModule)clazz.newInstance();
                            RComponent rComponent = this;
                            this.connectionModule.init(rComponent, rComponent.m2(), 0, null);
                            bl = false;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            this.connectionModule = null;
                        }
                    } else {
                        bl = false;
                    }
                    ++n;
                }
                if (this.connectionModule == null) {
                    this.displayMessage("Comms Error", "Connection to server could not be established", 0, false);
                    return;
                }
                this.toolTipManager = new TipMgr();
                this.toolTipManager.start();
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void m1() {
        Enumeration<Applet> enumeration = this.getAppletContext().getApplets();
        while (enumeration.hasMoreElements()) {
            Applet applet = enumeration.nextElement();
            if (!(applet instanceof BaseComponent) || applet == this || ((BaseComponent)((Object)applet)).getSessionId() != null) continue;
            ((BaseComponent)((Object)applet)).setSessionId(this.getSessionId());
        }
    }

    public void destroy() {
        if (this.m4()) {
            System.out.println(System.currentTimeMillis() + " " + this.getSessionId() + " Destroyed");
            if (this.connectionModule != null) {
                this.connectionModule.close(true);
            }
            if (this.toolTipManager != null) {
                this.toolTipManager.terminate();
            }
        }
        super.destroy();
    }

    public String getSessionId() {
        return this.f5;
    }

    public void setSessionId(String string) {
        this.f5 = string;
    }

    private final Packet m2() throws IOException {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Packet packet = new Packet(1, -1, this.getId(), false);
        this.encoderBytes.reset();
        this.dataEncoder.writeInt(12);
        this.dataEncoder.writeInt(0);
        this.dataEncoder.writeInt(this.f3);
        this.dataEncoder.writeInt(this.f4);
        this.dataEncoder.writeInt(dimension.width);
        this.dataEncoder.writeInt(dimension.height);
        this.dataEncoder.writeLongUTF("java.vendor");
        this.dataEncoder.writeLongUTF(System.getProperty("java.vendor"));
        this.dataEncoder.writeLongUTF("java.version");
        this.dataEncoder.writeLongUTF(System.getProperty("java.version"));
        this.dataEncoder.writeLongUTF("os.version");
        this.dataEncoder.writeLongUTF(System.getProperty("os.version"));
        this.dataEncoder.writeLongUTF("os.name");
        this.dataEncoder.writeLongUTF(System.getProperty("os.name"));
        this.dataEncoder.writeLongUTF("os.arch");
        this.dataEncoder.writeLongUTF(System.getProperty("os.arch"));
        try {
            int n = 0;
            while (n < 100) {
                String string = this.getParameter("Extension" + n);
                if (string != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    this.dataEncoder.writeLongUTF(string2);
                    this.dataEncoder.writeLongUTF(string3);
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("Extension parameters invalid, continuing");
        }
        packet.setData(this.encoderBytes.toByteArray());
        return packet;
    }

    protected void waitForRegistration() {
        String string = this.getParameter("RegisteredIds", null);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = 10;
                boolean bl = false;
                while (!bl && n3 >= 0) {
                    try {
                        if (this.findApplet(n2) != null) break;
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    --n3;
                }
                ++n;
            }
            return;
        }
        System.out.println("No registered sub components, continuing");
    }

    protected void enableSpecifiedEvents(int n) {
        int n2 = 0;
        while (n2 < 20) {
            int n3 = 1 << n2;
            this.eventEnabled[n2] = (n & n3) == n3;
            ++n2;
        }
    }

    public void addBaseListeners(Component component) {
        component.removeFocusListener(this);
        component.removeKeyListener(this);
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeComponentListener(this);
        if (this.eventEnabled[15] || this.eventEnabled[14]) {
            component.addFocusListener(this);
        }
        if (this.eventEnabled[2] || this.eventEnabled[3] || this.eventEnabled[4]) {
            component.addKeyListener(this);
        }
        if (this.eventEnabled[5] || this.eventEnabled[6] || this.eventEnabled[7] || this.eventEnabled[8] || this.eventEnabled[9]) {
            component.addMouseListener(this);
        }
        if (this.eventEnabled[12] || this.eventEnabled[13]) {
            component.addMouseMotionListener(this);
        }
        if (this.eventEnabled[16] || this.eventEnabled[17] || this.eventEnabled[18] || this.eventEnabled[19]) {
            component.addComponentListener(this);
        }
    }

    public String getAppletInfo() {
        return "Amber Component Applet";
    }

    public final short getId() {
        return this.f2;
    }

    public void setId(short s) {
        this.f2 = s;
    }

    public BaseComponent findApplet(int n) {
        Applet applet;
        this.getAppletContext().getApplets();
        Enumeration<Applet> enumeration = this.getAppletContext().getApplets();
        while (enumeration.hasMoreElements()) {
            applet = enumeration.nextElement();
            if (!(applet instanceof BaseComponent) || !((BaseComponent)((Object)applet)).isMyId(n) || !this.getSessionId().equals(((BaseComponent)((Object)applet)).getSessionId())) continue;
            return (BaseComponent)((Object)applet);
        }
        enumeration = this.getAppletContext().getApplets();
        while (enumeration.hasMoreElements()) {
            applet = enumeration.nextElement();
            if (!(applet instanceof BaseComponent) || !((BaseComponent)((Object)applet)).isMyId(n) || ((BaseComponent)((Object)applet)).getSessionId() != null) continue;
            ((BaseComponent)((Object)applet)).setSessionId(this.getSessionId());
            return (BaseComponent)((Object)applet);
        }
        return null;
    }

    public boolean isMyId(int n) {
        return n == this.f2;
    }

    public void forwardPacket(Packet packet) throws AmberException {
        short s = packet.getDestinationId();
        if (this.isMyId(s)) {
            this.createDataInput(packet);
            this.processPacket(packet);
            return;
        }
        if (s == -1) {
            if (this.m4()) {
                this.m3(packet);
                return;
            }
            BaseComponent baseComponent = this.findApplet(0);
            if (baseComponent != null) {
                baseComponent.forwardPacket(packet);
                return;
            }
            throw new AmberException("Could not forward packet to master applet - master not found");
        }
        BaseComponent baseComponent = this.findApplet(s);
        if (baseComponent != null) {
            baseComponent.forwardPacket(packet);
            return;
        }
        throw new AmberException("Packet addressed to non-existent component (ID " + s + "), " + packet.getCommand());
    }

    public void processPacket(Packet packet) {
        try {
            switch (packet.getCommand()) {
                case 0: 
                case 2: {
                    return;
                }
                case 4: {
                    String string = this.dataDecoder.readLongUTF();
                    String string2 = null;
                    if (this.dataDecoder.available() > 0) {
                        string2 = this.dataDecoder.readLongUTF();
                    }
                    this.displayUrl(string, string2);
                    return;
                }
                case 5: {
                    RComponent rComponent = this;
                    rComponent.setEnabled(rComponent.dataDecoder.readBoolean());
                    return;
                }
                case 6: {
                    RComponent rComponent = this;
                    rComponent.setVisible(rComponent.dataDecoder.readBoolean());
                    return;
                }
                case 7: {
                    RComponent rComponent = this;
                    rComponent.displayMessage(rComponent.dataDecoder.readLongUTF(), this.dataDecoder.readLongUTF(), 0, false);
                    return;
                }
                case 11: {
                    int n = this.dataDecoder.readInt();
                    RComponent rComponent = this;
                    int n2 = rComponent.displayMessage(rComponent.dataDecoder.readLongUTF(), this.dataDecoder.readLongUTF(), n, true);
                    this.encoderBytes.reset();
                    this.dataEncoder.writeInt(n2);
                    Packet packet2 = new Packet(12, -1, this.getId(), false);
                    packet2.setData(this.encoderBytes.toByteArray());
                    try {
                        this.forwardPacket(packet2);
                        return;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
                case 8: {
                    int n = this.dataDecoder.readInt();
                    int n3 = this.dataDecoder.readInt();
                    switch (n) {
                        case 0: {
                            this.dataDecoder.readInt();
                            this.visualObject.setForeground(new Color(n3));
                            this.visualObject.setBackground(new Color(n3));
                            break;
                        }
                        case 1: {
                            this.visualObject.setForeground(new Color(n3));
                            break;
                        }
                        case 2: {
                            this.visualObject.setBackground(new Color(n3));
                        }
                    }
                    this.visualObject.repaint();
                    this.repaint();
                    return;
                }
                case 9: {
                    int n = this.dataDecoder.readInt();
                    int n4 = this.dataDecoder.available() > 0 ? this.dataDecoder.readInt() : this.defaultFont.getSize();
                    String string = this.dataDecoder.available() > 0 ? this.dataDecoder.readLongUTF() : this.defaultFont.getName();
                    this.defaultFont = new Font(string, n, n4);
                    this.visualObject.setFont(this.defaultFont);
                    this.visualObject.repaint();
                    this.repaint();
                    return;
                }
                case 10: {
                    int n = this.dataDecoder.readInt();
                    Cursor cursor = new Cursor(n);
                    this.visualObject.setCursor(cursor);
                    return;
                }
                case 14: {
                    this.requestFocus();
                    return;
                }
                case 13: {
                    int n = this.dataDecoder.readInt();
                    this.enableSpecifiedEvents(n);
                    RComponent rComponent = this;
                    rComponent.addBaseListeners(rComponent.visualObject);
                    return;
                }
                case 15: {
                    this.f5 = this.dataDecoder.readLongUTF();
                    this.connectionModule.setSessionId(this.f5);
                    System.out.println("Session Started: " + this.f5);
                    this.m1();
                    return;
                }
                case 17: {
                    Object object;
                    System.out.println(System.currentTimeMillis() + " " + this.getSessionId() + " Shut down");
                    if (this.dataDecoder.available() > 0 && (object = this.dataDecoder.readLongUTF()) != null) {
                        this.displayMessage("Shut Down", (String)object, 0, false);
                    }
                    object = new Packet(17, -1, this.getId(), false);
                    this.forwardPacket((Packet)object);
                    Thread.yield();
                    this.connectionModule.close(false);
                    if (this.toolTipManager != null) {
                        this.toolTipManager.terminate();
                        return;
                    }
                    break;
                }
                case 18: {
                    this.encoderBytes.reset();
                    Rectangle rectangle = this.visualObject.getBounds();
                    this.dataEncoder.writeInt(rectangle.x);
                    this.dataEncoder.writeInt(rectangle.y);
                    this.dataEncoder.writeInt(rectangle.width);
                    this.dataEncoder.writeInt(rectangle.height);
                    Packet packet3 = new Packet(19, -1, this.getId(), false);
                    packet3.setData(this.encoderBytes.toByteArray());
                    this.forwardPacket(packet3);
                    return;
                }
                case 23: {
                    Serializable serializable;
                    this.encoderBytes.reset();
                    if (this.visualObject != null) {
                        serializable = this.visualObject.getMinimumSize();
                        this.dataEncoder.writeInt(serializable.width);
                        this.dataEncoder.writeInt(serializable.height);
                        serializable = this.visualObject.getMaximumSize();
                        this.dataEncoder.writeInt(serializable.width);
                        this.dataEncoder.writeInt(serializable.height);
                        serializable = this.visualObject.getPreferredSize();
                        this.dataEncoder.writeInt(serializable.width);
                        this.dataEncoder.writeInt(serializable.height);
                    }
                    serializable = new Packet(24, -1, this.getId(), false);
                    ((Packet)serializable).setData(this.encoderBytes.toByteArray());
                    this.forwardPacket((Packet)serializable);
                    return;
                }
                case 20: {
                    Serializable serializable;
                    this.encoderBytes.reset();
                    String string = null;
                    Font font = this.getFont();
                    if (this.dataDecoder.available() > 0) {
                        string = this.dataDecoder.readLongUTF();
                    }
                    if (this.dataDecoder.available() > 0) {
                        int n = this.dataDecoder.readInt();
                        int n5 = this.dataDecoder.readInt();
                        String string3 = this.dataDecoder.available() > 0 ? this.dataDecoder.readLongUTF() : this.getFont().getName();
                        font = new Font(string3, n5, n);
                    }
                    if (font != null) {
                        serializable = this.visualObject.getFontMetrics(font);
                        this.dataEncoder.writeInt(((FontMetrics)serializable).getMaxAscent());
                        this.dataEncoder.writeInt(((FontMetrics)serializable).getMaxDescent());
                        this.dataEncoder.writeInt(((FontMetrics)serializable).getLeading());
                        this.dataEncoder.writeInt(((FontMetrics)serializable).getMaxAdvance());
                        if (string != null) {
                            this.dataEncoder.writeInt(((FontMetrics)serializable).stringWidth(string));
                        }
                    }
                    serializable = new Packet(21, -1, this.getId(), false);
                    ((Packet)serializable).setData(this.encoderBytes.toByteArray());
                    this.forwardPacket((Packet)serializable);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void displayUrl(String string, String string2) {
        try {
            if (string2 != null) {
                this.getAppletContext().showDocument(new URL(this.getCodeBase(), string), string2);
                return;
            }
            this.getAppletContext().showDocument(new URL(this.getCodeBase(), string));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL Exception: " + string + ", location: " + string2);
            return;
        }
    }

    private final void m3(Packet packet) throws AmberException {
        if (this.connectionModule != null) {
            this.connectionModule.sendPacket(packet);
            return;
        }
        throw new AmberException("Attempting to transmit packet with no connection module");
    }

    private final boolean m4() {
        return this.f2 == 0;
    }

    public int displayMessage(String string, String string2, int n, boolean bl) {
        int n2 = 0;
        if (string != null && string2 != null) {
            ((Component)new RMessageBox(this, string, string2, n)).setVisible(true);
            this.f7 = 0;
            if (bl) {
                this.f6.block(200000L);
                n2 = this.f7;
            }
        }
        return n2;
    }

    public Image getImage(AmberInputStream amberInputStream) {
        Image image = null;
        try {
            int n = amberInputStream.readInt();
            if (n == 1) {
                String string = amberInputStream.readLongUTF();
                image = this.getImage(new URL(this.getCodeBase(), string));
                this.waitForImage(image);
            } else if (n == 2) {
                byte[] byArray = new byte[amberInputStream.readInt()];
                amberInputStream.read(byArray);
                image = Toolkit.getDefaultToolkit().createImage(byArray);
            } else if (n == 3) {
                int n2 = amberInputStream.readInt();
                int n3 = amberInputStream.readInt();
                int[] nArray = new int[n2 * n3];
                int n4 = 0;
                while (n4 < n2 * n3) {
                    nArray[n4] = amberInputStream.readInt();
                    ++n4;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
            } else if (n != 0) {
                System.out.println("Unknown image type error: " + n);
            }
        }
        catch (Exception exception) {
            System.out.println("Error fetching image");
            exception.printStackTrace();
        }
        return image;
    }

    public void waitForImage(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void setMessageBoxReturn(int n) {
        this.f7 = n;
        this.f6.unlock();
    }

    public AmberInputStream createDataInput(Packet packet) {
        ByteArrayInputStream byteArrayInputStream = packet.getData() == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(packet.getData());
        this.dataDecoder = new AmberInputStream(byteArrayInputStream);
        return this.dataDecoder;
    }

    public AmberInputStream getDataInput() {
        return this.dataDecoder;
    }

    public TipMgr getToolTipManager() {
        TipMgr tipMgr = null;
        if (this.toolTipManager != null) {
            tipMgr = this.toolTipManager;
        } else {
            BaseComponent baseComponent = this.findApplet(0);
            if (baseComponent != null) {
                tipMgr = baseComponent.getToolTipManager();
            } else {
                System.out.println("Could not get master applet - master not found");
            }
        }
        return tipMgr;
    }

    public void sendEvent(EventObject eventObject, int n) {
        if (eventObject instanceof ActionEvent) {
            this.m10((ActionEvent)eventObject, n);
            return;
        }
        if (eventObject instanceof FocusEvent) {
            if (((FocusEvent)eventObject).getID() == 1004) {
                this.m12((byte)55, ((FocusEvent)eventObject).isTemporary() ? 1 : 0, n);
                return;
            }
            this.m12((byte)54, ((FocusEvent)eventObject).isTemporary() ? 1 : 0, n);
            return;
        }
        if (eventObject instanceof ItemEvent) {
            this.m6((ItemEvent)eventObject, n);
            return;
        }
        if (eventObject instanceof KeyEvent) {
            this.m7((KeyEvent)eventObject, n);
            return;
        }
        if (eventObject instanceof MouseEvent) {
            this.m11((MouseEvent)eventObject, n);
            return;
        }
        if (eventObject instanceof TextEvent) {
            this.m14((byte)41, n);
            return;
        }
        if (eventObject instanceof WindowEvent) {
            this.m13((WindowEvent)eventObject, n);
            return;
        }
        if (eventObject instanceof ComponentEvent) {
            switch (((ComponentEvent)eventObject).getID()) {
                case 103: {
                    this.m14((byte)56, n);
                    return;
                }
                case 100: {
                    this.m14((byte)57, n);
                    return;
                }
                case 101: {
                    this.m14((byte)58, n);
                    return;
                }
                case 102: {
                    this.m14((byte)59, n);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.eventEnabled[0]) {
            this.sendEvent(actionEvent, this.getId());
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.eventEnabled[1]) {
            this.sendEvent(textEvent, this.getId());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.eventEnabled[2]) {
            this.sendEvent(keyEvent, this.getId());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.eventEnabled[3]) {
            this.sendEvent(keyEvent, this.getId());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.eventEnabled[4]) {
            this.sendEvent(keyEvent, this.getId());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.eventEnabled[5]) {
            this.sendEvent(mouseEvent, this.getId());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.eventEnabled[6]) {
            this.sendEvent(mouseEvent, this.getId());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.eventEnabled[7]) {
            this.sendEvent(mouseEvent, this.getId());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.eventEnabled[8]) {
            this.sendEvent(mouseEvent, this.getId());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.eventEnabled[9]) {
            this.sendEvent(mouseEvent, this.getId());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.eventEnabled[10]) {
            this.sendEvent(itemEvent, this.getId());
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.m5(windowEvent);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.m5(windowEvent);
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.m5(windowEvent);
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.m5(windowEvent);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.m5(windowEvent);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.m5(windowEvent);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.m5(windowEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.eventEnabled[12]) {
            this.sendEvent(mouseEvent, this.getId());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.eventEnabled[13]) {
            this.sendEvent(mouseEvent, this.getId());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.eventEnabled[15]) {
            this.sendEvent(focusEvent, this.getId());
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.eventEnabled[14]) {
            this.sendEvent(focusEvent, this.getId());
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.eventEnabled[18]) {
            this.sendEvent(componentEvent, this.getId());
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (this.eventEnabled[17]) {
            this.sendEvent(componentEvent, this.getId());
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.eventEnabled[19]) {
            this.sendEvent(componentEvent, this.getId());
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (this.eventEnabled[16]) {
            this.sendEvent(componentEvent, this.getId());
        }
    }

    private final void m5(WindowEvent windowEvent) {
        if (this.eventEnabled[11]) {
            this.sendEvent(windowEvent, this.getId());
        }
    }

    private final void m6(ItemEvent itemEvent, int n) {
        try {
            Object object = itemEvent.getItem();
            Packet packet = new Packet(50, -1, (short)n, true);
            this.encoderBytes.reset();
            this.dataEncoder.writeInt(itemEvent.getStateChange());
            if (object instanceof Integer) {
                this.dataEncoder.writeInt(0);
                this.dataEncoder.writeInt((Integer)object);
            } else if (object instanceof String) {
                this.dataEncoder.writeInt(1);
                this.dataEncoder.writeLongUTF((String)object);
            }
            packet.setData(this.encoderBytes.toByteArray());
            this.forwardPacket(packet);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private final void m7(KeyEvent keyEvent, int n) {
        try {
            this.encoderBytes.reset();
            this.dataEncoder.writeInt(keyEvent.getModifiers());
            this.dataEncoder.writeInt(keyEvent.getKeyCode());
            this.dataEncoder.writeChar(keyEvent.getKeyChar());
            Packet packet = new Packet(this.m8(keyEvent.getID()), -1, (short)n, true);
            packet.setData(this.encoderBytes.toByteArray());
            this.forwardPacket(packet);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private final byte m8(int n) {
        byte by;
        switch (n) {
            case 401: {
                by = 43;
                break;
            }
            case 402: {
                by = 44;
                break;
            }
            default: {
                by = 42;
            }
        }
        return by;
    }

    private final byte m9(int n) {
        byte by;
        switch (n) {
            default: {
                by = 45;
                break;
            }
            case 506: {
                by = 52;
                break;
            }
            case 504: {
                by = 48;
                break;
            }
            case 505: {
                by = 49;
                break;
            }
            case 503: {
                by = 53;
                break;
            }
            case 501: {
                by = 46;
                break;
            }
            case 502: {
                by = 47;
            }
        }
        return by;
    }

    private final void m10(ActionEvent actionEvent, int n) {
        try {
            this.encoderBytes.reset();
            this.dataEncoder.writeInt(actionEvent.getModifiers());
            this.dataEncoder.writeLongUTF(actionEvent.getActionCommand());
            Packet packet = new Packet(40, -1, (short)n, true);
            packet.setData(this.encoderBytes.toByteArray());
            this.forwardPacket(packet);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private final void m11(MouseEvent mouseEvent, int n) {
        try {
            this.encoderBytes.reset();
            this.dataEncoder.writeInt(mouseEvent.getX());
            this.dataEncoder.writeInt(mouseEvent.getY());
            this.dataEncoder.writeInt(mouseEvent.getClickCount());
            this.dataEncoder.writeInt(mouseEvent.getModifiers());
            this.dataEncoder.writeBoolean(mouseEvent.isPopupTrigger());
            Packet packet = new Packet(this.m9(mouseEvent.getID()), -1, (short)n, true);
            packet.setData(this.encoderBytes.toByteArray());
            this.forwardPacket(packet);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private final void m12(byte by, int n, int n2) {
        try {
            this.encoderBytes.reset();
            this.dataEncoder.writeInt(n);
            byte[] byArray = this.encoderBytes.toByteArray();
            Packet packet = new Packet(by, -1, (short)n2, byArray.length, byArray, true);
            this.forwardPacket(packet);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private final void m13(WindowEvent windowEvent, int n) {
        this.m12((byte)51, windowEvent.getID(), n);
    }

    private final void m14(byte by, int n) {
        try {
            Packet packet = new Packet(by, -1, (short)n, true);
            this.forwardPacket(packet);
            return;
        }
        catch (AmberException amberException) {
            amberException.printStackTrace();
            return;
        }
    }

    public RComponent() {
        this.num = f1++;
    }
}

