/*
 * Decompiled with CFR 0.152.
 */
package amber.client;

import amber.awt.XYLayout;
import amber.client.BaseComponent;
import amber.client.RComponent;
import amber.client.RContainer;
import amber.client.panel.BaseControl;
import amber.type.Packet;
import java.awt.Component;
import java.awt.Container;
import java.awt.PopupMenu;

public class RBase
extends RComponent
implements RContainer {
    protected XYLayout xyL = new XYLayout();
    private BaseControl f1;
    protected int[] coordinates = new int[]{0, 0, 0, 0, -1, -1};

    public void init() {
        try {
            RBase rBase = this;
            rBase.setLayout(rBase.xyL);
            this.processParameters();
            if (this.f1.getVisualObject() != null) {
                this.visualObject = this.f1.getVisualObject();
            }
            super.init();
            RBase rBase2 = this;
            rBase2.addBaseListeners(rBase2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void processParameters() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Object object;
        this.coordinates[0] = (short)Integer.parseInt(this.getParameter("ID", Integer.toString(0)));
        String string = this.getParameter("Component", "");
        this.coordinates[1] = Integer.parseInt(this.getParameter("EVENTMASK", "0"), 16);
        String string2 = this.getParameter("Coordinates", null);
        if (string2 != null) {
            System.arraycopy(object, 0, this.coordinates, 2, ((int[])(object = XYLayout.getCoordinates(string2))).length > 4 ? 4 : ((int[])object).length);
        }
        object = this.getParameter("Parameters", "");
        this.createAndAddComponent(string, this.coordinates, (String)object);
    }

    protected void createAndAddComponent(String string, int[] nArray, String string2) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        BaseControl baseControl = (BaseControl)Class.forName(string).newInstance();
        baseControl.init(this, nArray, string2);
        baseControl.addListeners(this);
        this.f1 = baseControl;
        this.addComponentToPanel(baseControl, nArray);
    }

    protected void addComponentToPanel(BaseControl baseControl, int[] nArray) {
        Component component = baseControl.getVisualObject();
        if (component != null) {
            if (baseControl.canAdd()) {
                this.add(component, RBase.coordToString(2, nArray));
            }
            this.visualObject = component;
        } else {
            Object object = baseControl.getNonVisualObject();
            if (object instanceof PopupMenu && baseControl.canAdd()) {
                this.add((PopupMenu)object);
            }
        }
        this.validate();
    }

    public static String coordToString(int n, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < nArray.length - n) {
            stringBuffer.append(Integer.toString(nArray[n + n2]));
            if (n2 < 3) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean isMyId(int n) {
        boolean bl = super.isMyId(n);
        if (this.f1 != null) {
            bl |= this.f1.isMyId(n);
        }
        return bl;
    }

    protected boolean isSpecial(byte by) {
        return by == 15 || by == 17;
    }

    public void processPacket(Packet packet) {
        short s = packet.getDestinationId();
        if (this.isMyId(s)) {
            if (this.isSpecial(packet.getCommand()) && s == this.getId()) {
                super.processPacket(packet);
                return;
            }
            this.f1.createDataInput(packet);
            this.f1.processPacket(packet);
            return;
        }
        System.out.println("Received packet for another component. ID: " + s + " our ID: " + this.getId());
    }

    public BaseComponent findBaseComponent() {
        return this;
    }

    public Component getVisualObject() {
        return this;
    }

    public Container getContainer() {
        return this;
    }

    public Object getNonVisualObject() {
        return null;
    }

    public void removeAllComponents() {
    }

    public void setComponentBounds(Packet packet) {
    }

    public void removeComponent(Packet packet) {
    }

    public void addComponent(Packet packet) {
    }

    public void internalProcessPacket(Packet packet) {
    }
}

