/*
 * Decompiled with CFR 0.152.
 */
package amber.awt;

import amber.awt.ListItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class TreeList
extends Panel
implements AdjustmentListener,
ItemSelectable {
    private BorderLayout f1 = new BorderLayout();
    private Scrollbar f2 = new Scrollbar();
    private Scrollbar f3 = new Scrollbar();
    private transient Vector f4;
    private transient Vector f5;
    private int f6 = 18;
    private int f7 = -1;
    private int f8 = -1;
    private Vector f9 = new Vector();
    private Vector f10 = new Vector();
    private Vector f11 = new Vector();
    private int[] f12 = new int[0];
    private int[] f13 = new int[0];
    private int f14 = 0;
    private int f15 = 0;
    private int f16 = 0;
    private boolean f17 = false;
    private boolean f18 = false;
    private boolean f19 = true;
    private boolean f20 = true;
    private int f21 = 0;
    private int f22 = -1;
    private int f23 = -1;
    private boolean f24 = true;
    Image buffer = null;
    Dimension oldSize = new Dimension();

    void componentSetUp() throws Exception {
        TreeList treeList = this;
        treeList.setLayout(treeList.f1);
        this.f2.setOrientation(0);
        TreeList treeList2 = this;
        treeList2.add((Component)treeList2.f2, "South");
        TreeList treeList3 = this;
        treeList3.add((Component)treeList3.f3, "East");
        this.f2.setVisible(false);
        this.f2.addAdjustmentListener(this);
        this.f3.setVisible(false);
        this.f3.addAdjustmentListener(this);
    }

    public void add(ListItem listItem, int n) {
        this.f9.addElement(listItem);
        this.f10.addElement(new Integer(n));
        TreeList treeList = this;
        treeList.m1(treeList.f10.size() - 1);
        this.updateCanvas();
    }

    public void insert(ListItem listItem, int n, int n2) {
        this.f9.insertElementAt(listItem, n);
        this.f10.insertElementAt(new Integer(n2), n);
        this.m1(n);
        this.updateCanvas();
    }

    public void remove(int n) {
        if (this.isIndexSelected(n)) {
            this.deselect(n);
        }
        this.f9.removeElementAt(n);
        this.f10.removeElementAt(n);
        int n2 = 0;
        while (n2 < this.f13.length) {
            if (this.f13[n2] >= n) {
                int n3 = n2;
                this.f13[n3] = this.f13[n3] - 1;
            }
            ++n2;
        }
        this.updateCanvas();
    }

    public void removeAll() {
        this.f13 = new int[0];
        this.f15 = 0;
        this.f14 = 0;
        this.f9.removeAllElements();
        this.f10.removeAllElements();
        this.updateCanvas();
    }

    public void replaceItem(ListItem listItem, int n, int n2) {
        this.f9.setElementAt(listItem, n);
        this.f10.setElementAt(new Integer(n2), n);
        this.m1(n);
        this.updateCanvas();
    }

    public void setDefaultOpen(boolean bl) {
        this.f20 = bl;
    }

    public int getItemCount() {
        return this.f9.size();
    }

    public int getLineType(int n) {
        return (Integer)this.f10.elementAt(n);
    }

    public int getParentLine(int n) {
        if (n < 1) {
            return -1;
        }
        int n2 = (Integer)this.f10.elementAt(n);
        int n3 = n - 1;
        while (n3 >= 0) {
            if ((Integer)this.f10.elementAt(n3) < n2) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public void setLineType(int n, int n2) {
        this.f10.setElementAt(new Integer(n2), n);
    }

    public int getSelectedIndex() {
        if (this.f13.length > 0) {
            return this.f13[0];
        }
        return -1;
    }

    public int[] getSelectedIndexes() {
        if (this.f13.length >= 0) {
            return this.f13;
        }
        return new int[0];
    }

    public Object[] getSelectedObjects() {
        return new Object[0];
    }

    protected void updateCanvas() {
        this.generateVisibleLines();
        this.createVScrollIfRequired();
        this.createHScrollIfRequired();
        this.repaint();
    }

    protected void createVScrollIfRequired() {
        int n = this.getSize().height;
        if (n >= 1) {
            if (this.f2.isVisible()) {
                n -= this.f2.getSize().height;
            }
            if (this.f11.size() * this.f6 > n || this.f15 > 0) {
                int n2 = n / this.f6;
                this.f3.setVisible(true);
                this.f3.setValues(this.f15, n2, 0, this.f9.size());
                this.f3.setBlockIncrement(n2);
            } else {
                this.f3.setVisible(false);
                this.f15 = 0;
            }
            this.doLayout();
        }
    }

    private final void m1(int n) {
        if (this.f20) {
            int n2;
            int n3 = n;
            do {
                if ((n2 = this.getParentLine(n3)) >= 0) {
                    this.setOpenState(n2, true);
                }
                n3 = n2;
            } while (n2 >= 0);
        }
    }

    protected void createHScrollIfRequired() {
        int n = this.getSize().width;
        if (n >= 1) {
            if (this.f3.isVisible()) {
                n -= this.f3.getSize().width;
            }
            if (this.f21 > n) {
                this.f2.setVisible(true);
                if (n > 0) {
                    this.f2.setValues(this.f14, n, 0, this.f21 + 1);
                    this.f2.setBlockIncrement(n);
                    this.f2.setUnitIncrement(8);
                } else {
                    this.f2.setValues(0, 1, 0, 1);
                }
            } else {
                this.f14 = 0;
                this.f2.setVisible(false);
            }
            this.doLayout();
        }
    }

    protected void processHScroll(AdjustmentEvent adjustmentEvent) {
        this.f14 = adjustmentEvent.getValue();
        this.repaint();
    }

    protected void processVScroll(AdjustmentEvent adjustmentEvent) {
        this.f15 = adjustmentEvent.getValue();
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.f2) {
            this.processHScroll(adjustmentEvent);
            return;
        }
        this.processVScroll(adjustmentEvent);
    }

    public void select(int n) {
        this.m2(n, false);
    }

    private final void m2(int n, boolean bl) {
        if (n > this.f9.size()) {
            throw new IndexOutOfBoundsException("No such item");
        }
        if (n < 0) {
            if (bl) {
                int n2 = 0;
                while (n2 < this.f13.length) {
                    ItemEvent itemEvent = new ItemEvent(this, 701, new Integer(this.f13[n2]), 2);
                    this.fireItemStateChanged(itemEvent);
                    ++n2;
                }
            }
            this.f13 = new int[0];
            this.repaint();
        } else if (!this.isIndexSelected(n)) {
            if (this.isMultipleMode()) {
                int[] nArray = new int[this.f13.length + 1];
                System.arraycopy(this.f13, 0, nArray, 0, this.f13.length);
                nArray[nArray.length - 1] = n;
                this.f13 = nArray;
            } else {
                this.f13 = new int[1];
                this.f13[0] = n;
            }
            this.repaint();
        }
        if (bl) {
            ItemEvent itemEvent = new ItemEvent(this, 701, new Integer(this.f8), 1);
            this.fireItemStateChanged(itemEvent);
        }
    }

    public void toggleOpenState(int n) {
        if (n > this.f9.size() || n < 0) {
            throw new IndexOutOfBoundsException("No such item");
        }
        int n2 = (Integer)this.f10.elementAt(n);
        if (this.m5(n, n2)) {
            if (this.isIndexOpen(n)) {
                int[] nArray = new int[this.f12.length - 1];
                int n3 = 0;
                while (n3 < this.f12.length) {
                    if (this.f12[n3] == n) {
                        System.arraycopy(this.f12, 0, nArray, 0, n3);
                        System.arraycopy(this.f12, n3 + 1, nArray, n3, this.f12.length - (n3 + 1));
                        this.f12 = nArray;
                        break;
                    }
                    ++n3;
                }
            } else {
                int[] nArray = new int[this.f12.length + 1];
                System.arraycopy(this.f12, 0, nArray, 0, this.f12.length);
                nArray[this.f12.length] = n;
                this.f12 = nArray;
            }
            this.repaint();
        }
    }

    public void setOpenState(int n, boolean bl) {
        if (this.isIndexOpen(n) && !bl || !this.isIndexOpen(n) && bl) {
            this.toggleOpenState(n);
        }
    }

    public void deselect(int n) {
        this.m3(n, false);
    }

    private final void m3(int n, boolean bl) {
        if (n > this.f9.size()) {
            throw new IndexOutOfBoundsException("No such item");
        }
        if (n < 0) {
            if (bl) {
                int n2 = 0;
                while (n2 < this.f13.length) {
                    ItemEvent itemEvent = new ItemEvent(this, 701, new Integer(this.f13[n2]), 2);
                    this.fireItemStateChanged(itemEvent);
                    ++n2;
                }
            }
            this.f13 = new int[0];
            this.repaint();
            return;
        }
        if (this.isMultipleMode()) {
            int n3 = 0;
            while (n3 < this.f13.length) {
                if (this.f13[n3] == n) {
                    int[] nArray = new int[this.f13.length - 1];
                    System.arraycopy(this.f13, 0, nArray, 0, n3);
                    System.arraycopy(this.f13, n3 + 1, nArray, n3, this.f13.length - (n3 + 1));
                    this.f13 = nArray;
                    break;
                }
                ++n3;
            }
        } else {
            this.f13 = new int[0];
        }
        if (bl) {
            ItemEvent itemEvent = new ItemEvent(this, 701, new Integer(this.f8), 2);
            this.fireItemStateChanged(itemEvent);
        }
        this.repaint();
    }

    public boolean isIndexSelected(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.f13.length) {
            if (this.f13[n2] == n) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isIndexOpen(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.f12.length) {
            if (n == this.f12[n2]) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addNotify() {
        super.addNotify();
        this.updateCanvas();
    }

    public void paint(Graphics graphics) {
        if (this.f24) {
            this.updateCanvas();
            this.f24 = false;
            return;
        }
        Font font = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.f6 = fontMetrics.getHeight() + fontMetrics.getDescent();
        int n = fontMetrics.getHeight();
        Dimension dimension = this.getSize();
        if (this.f2.isVisible()) {
            dimension.height -= this.f2.getSize().height;
        }
        if (this.f3.isVisible()) {
            dimension.width -= this.f3.getSize().width;
        }
        if (this.oldSize == null || this.buffer == null || dimension.height != this.oldSize.height || dimension.width != this.oldSize.width) {
            this.buffer = this.createImage(dimension.width, dimension.height);
        }
        Graphics graphics2 = this.buffer.getGraphics();
        this.oldSize.width = dimension.width;
        this.oldSize.height = dimension.height;
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(this.getForeground());
        int n2 = 1;
        int n3 = this.f15;
        while (n3 < this.f11.size()) {
            int n4 = (Integer)this.f11.elementAt(n3);
            ListItem listItem = (ListItem)this.f9.elementAt(n4);
            int n5 = (Integer)this.f10.elementAt(n4);
            n2 += this.m8(graphics2, listItem, this.f6, dimension, n4, this.f14, n2, n5, this.m5(n4, n5));
            graphics2.setFont(font);
            if (n2 + n > dimension.height) {
                this.f16 = n3 + 1;
                break;
            }
            ++n3;
        }
        graphics2.setColor(SystemColor.controlDkShadow);
        graphics2.drawLine(0, 0, 0, dimension.height);
        graphics2.drawLine(0, 0, dimension.width, 0);
        graphics2.setColor(SystemColor.controlHighlight);
        graphics2.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height);
        graphics2.drawLine(0, dimension.height, dimension.width - 1, dimension.height);
        graphics.drawImage(this.buffer, 0, 0, dimension.width, dimension.height, this);
    }

    protected void generateVisibleLines() {
        Font font = this.getFont();
        FontMetrics fontMetrics = null;
        if (font != null) {
            fontMetrics = this.getFontMetrics(font);
        }
        this.f21 = 0;
        this.f11.removeAllElements();
        int n = 0;
        while (n < this.f9.size()) {
            int n2 = (Integer)this.f10.elementAt(n);
            if (this.m4(n, n2)) {
                this.f11.addElement(new Integer(n));
                ListItem listItem = (ListItem)this.f9.elementAt(n);
                int n3 = this.m6(n2, listItem.image);
                int n4 = fontMetrics != null ? fontMetrics.stringWidth((String)listItem.item) : 0;
                if (n4 + n3 > this.f21) {
                    this.f21 = n4 + n3;
                }
            }
            ++n;
        }
    }

    private final boolean m4(int n, int n2) {
        boolean bl = true;
        int n3 = n2;
        int n4 = n - 1;
        while (n4 >= 0) {
            int n5 = (Integer)this.f10.elementAt(n4);
            if (n5 < n3) {
                if (!this.isIndexOpen(n4)) {
                    bl = false;
                    break;
                }
                if (n2 == 0) break;
                n3 = n5;
            }
            --n4;
        }
        return bl;
    }

    private final boolean m5(int n, int n2) {
        boolean bl = false;
        if (n + 1 < this.f10.size() && (Integer)this.f10.elementAt(n + 1) > n2) {
            bl = true;
        }
        return bl;
    }

    private final int m6(int n, Image image) {
        int n2 = this.m7(n) + 15 + 1;
        if (image != null) {
            n2 += image.getWidth(null) + 2;
        }
        return n2;
    }

    private final int m7(int n) {
        return n * 15 + 1;
    }

    private final int m8(Graphics graphics, ListItem listItem, int n, Dimension dimension, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        Font font = graphics.getFont();
        if (listItem.textAttr >= 0) {
            font = new Font(font.getName(), listItem.textAttr, font.getSize());
            graphics.setFont(font);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n7 = this.m7(n5) - n3;
        if (bl) {
            graphics.setColor(SystemColor.textText);
            n6 = n - 8 >> 1;
            graphics.drawRect(n7 + 3, n4 + n6, 8, 8);
            graphics.drawLine(n7 + 3, n4 + n6 + 4, n7 + 3 + 8, n4 + n6 + 4);
            if (!this.isIndexOpen(n2)) {
                graphics.drawLine(n7 + 3 + 4, n4 + n6, n7 + 3 + 4, n4 + n6 + 8);
            }
        }
        n7 += 15;
        if (listItem.image != null) {
            int n8 = listItem.image.getHeight(null) <= n ? listItem.image.getHeight(null) : n;
            graphics.drawImage(listItem.image, n7 + 1, n4, listItem.image.getWidth(null), n8, null);
            n7 += listItem.image.getWidth(null) + 2;
        }
        String string = this.m9((String)listItem.item, dimension.width - n7, fontMetrics);
        n6 = fontMetrics.stringWidth(string);
        if (this.isIndexSelected(n2)) {
            graphics.setColor(listItem.colour[3]);
            graphics.fillRect(n7, n4, n6, n);
            graphics.setColor(listItem.colour[2]);
        } else {
            graphics.setColor(listItem.colour[1]);
            graphics.fillRect(n7, n4, n6, n);
            graphics.setColor(listItem.colour[0]);
        }
        graphics.drawString(string, n7, n4 + fontMetrics.getHeight());
        return n;
    }

    private final String m9(String string, int n, FontMetrics fontMetrics) {
        if (string.length() < 1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        while (n2 >= 0) {
            if (fontMetrics.charsWidth(cArray, 0, n2) <= n) break;
            --n2;
        }
        return new String(cArray, 0, n2 + 1);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                break;
            }
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    private final int m10(Point point) {
        int n = point.y;
        int n2 = -1;
        if (n < this.f11.size() * this.f6 && n >= 0) {
            this.f7 = (n - 1) / this.f6 + this.f15;
            int n3 = (Integer)this.f11.elementAt(this.f7);
            int n4 = (Integer)this.f10.elementAt(n3);
            int n5 = this.m7(n4);
            if (point.x + this.f14 > n5 && point.x + this.f14 < n5 + 15) {
                n2 = n3;
            }
        }
        return n2;
    }

    public int locationToIndex(Point point) {
        int n = point.y;
        int n2 = -1;
        if (this.f11.size() > 0 && n < this.f11.size() * this.f6 && n >= 0) {
            this.f7 = (n - 1) / this.f6 + this.f15;
            int n3 = (Integer)this.f11.elementAt(this.f7);
            int n4 = (Integer)this.f10.elementAt(n3);
            int n5 = this.m7(n4) + 15 + 1;
            if (point.x + this.f14 > n5) {
                n2 = n3;
            }
        }
        return n2;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.f22 = this.locationToIndex(mouseEvent.getPoint());
        this.f23 = this.m10(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.locationToIndex(mouseEvent.getPoint());
        int n2 = this.m10(mouseEvent.getPoint());
        if (n != -1 && this.f22 == n) {
            this.f8 = n;
            if (this.isMultipleMode() && this.isModifierRequired()) {
                if (mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
                    TreeList treeList = this;
                    if (treeList.isIndexSelected(treeList.f8)) {
                        if (mouseEvent.getClickCount() < 2) {
                            TreeList treeList2 = this;
                            treeList2.m3(treeList2.f8, true);
                        }
                    } else {
                        TreeList treeList3 = this;
                        treeList3.m2(treeList3.f8, true);
                    }
                } else {
                    this.m2(-1, true);
                    TreeList treeList = this;
                    treeList.m2(treeList.f8, true);
                }
            } else {
                TreeList treeList = this;
                if (treeList.isIndexSelected(treeList.f8)) {
                    if (mouseEvent.getClickCount() < 2 && (this.isMultipleMode() || this.f19)) {
                        TreeList treeList4 = this;
                        treeList4.m3(treeList4.f8, true);
                    }
                } else {
                    TreeList treeList5 = this;
                    treeList5.m2(treeList5.f8, true);
                }
            }
            if (mouseEvent.getClickCount() > 1) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, Integer.toString(this.f8));
                this.fireActionPerformed(actionEvent);
            }
        } else if (n2 != -1 && this.f23 == n2) {
            this.toggleOpenState(n2);
            this.updateCanvas();
        }
        this.repaint();
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.f4 != null && this.f4.contains(actionListener)) {
            Vector vector = (Vector)this.f4.clone();
            vector.removeElement(actionListener);
            this.f4 = vector;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        Vector vector = this.f4 == null ? new Vector(2) : (Vector)this.f4.clone();
        if (!vector.contains(actionListener)) {
            vector.addElement(actionListener);
            this.f4 = vector;
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.f4 != null) {
            Vector vector = this.f4;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ActionListener)vector.elementAt(n2)).actionPerformed(actionEvent);
                ++n2;
            }
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (this.f5 != null && this.f5.contains(itemListener)) {
            Vector vector = (Vector)this.f5.clone();
            vector.removeElement(itemListener);
            this.f5 = vector;
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        Vector vector = this.f5 == null ? new Vector(2) : (Vector)this.f5.clone();
        if (!vector.contains(itemListener)) {
            vector.addElement(itemListener);
            this.f5 = vector;
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (this.f5 != null) {
            Vector vector = this.f5;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ItemListener)vector.elementAt(n2)).itemStateChanged(itemEvent);
                ++n2;
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        componentEvent.getID();
        if (componentEvent.getID() == 101) {
            this.updateCanvas();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isMultipleMode() {
        return this.f17;
    }

    public void setMultipleMode(boolean bl) {
        this.f17 = bl;
    }

    public boolean isModifierRequired() {
        return this.f18;
    }

    public void setModifierRequired(boolean bl) {
        this.f18 = bl;
    }

    public void setAllowDeselect(boolean bl) {
        this.f19 = bl;
    }

    public void validate() {
        super.validate();
        this.updateCanvas();
    }

    public TreeList() {
        try {
            this.componentSetUp();
            this.f6 = 14;
            this.setBackground(Color.white);
            this.enableEvents(17L);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

