/*
 * Decompiled with CFR 0.152.
 */
package amber.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;

public class TimePlot
extends Canvas
implements MouseMotionListener,
MouseListener {
    public static final int SeriesCountDefault = 1;
    public static final int XSampleCountDefault = 10;
    public static float yMaxDefault = 1.0f;
    public static float yMinDefault = 0.0f;
    public static float yIncrementDefault = 0.2f;
    public static boolean mouseOversDefault = true;
    public static boolean autosizeDefault = true;
    private String f1 = null;
    private String f2 = null;
    private String f3 = null;
    private float f4 = yMaxDefault;
    private float f5 = yMinDefault;
    private float f6 = yIncrementDefault;
    private boolean f7 = autosizeDefault;
    private boolean f8 = mouseOversDefault;
    private int f9 = 2;
    private int f10 = 10;
    private int f11 = 1;
    private float[][] f12 = null;
    private int f13 = 0;
    private Color[] f14 = new Color[]{Color.red, Color.blue, Color.green, Color.magenta, Color.orange, Color.pink, Color.darkGray, Color.cyan, Color.white, Color.gray};
    private boolean f15 = false;
    private int f16 = -1;
    private int f17 = -1;

    public void setCaption(String string) {
        this.f1 = string;
        this.repaint();
    }

    public String getCaption() {
        return this.f1;
    }

    public void setXLabel(String string) {
        this.f2 = string;
        this.repaint();
    }

    public String getXLabel() {
        return this.f2;
    }

    public void setYLabel(String string) {
        this.f3 = string;
        this.repaint();
    }

    public String getYLabel() {
        return this.f3;
    }

    public void setYMax(float f) {
        this.f4 = f;
        this.repaint();
    }

    public float getYMax() {
        return this.f4;
    }

    public void setYMin(float f) {
        this.f5 = f;
        this.repaint();
    }

    public float getYMin() {
        return this.f5;
    }

    public void setYIncrement(float f) {
        this.f6 = f;
        this.repaint();
    }

    public float getYIncrement() {
        return this.f6;
    }

    public void setXEventCount(int n) {
        this.f10 = n;
        this.f12 = TimePlot.constructSeriesPointsArray(this.getXEventCount(), this.getSeriesCount());
        this.f13 = 0;
        this.repaint();
    }

    public int getXEventCount() {
        return this.f10;
    }

    public void setSeriesCount(int n) {
        this.f11 = n;
        this.f12 = TimePlot.constructSeriesPointsArray(this.getXEventCount(), this.getSeriesCount());
        this.f13 = 0;
        this.repaint();
    }

    public int getSeriesCount() {
        return this.f11;
    }

    public void setAutosize(boolean bl) {
        this.f7 = bl;
        this.repaint();
    }

    public boolean getAutosize() {
        return this.f7;
    }

    public void setMouseOvers(boolean bl) {
        this.f8 = bl;
        this.repaint();
    }

    public boolean getMouseOvers() {
        return this.f8;
    }

    public void addSampleValues(float[] fArray) {
        TimePlot.shiftSampleValues(this.f12, fArray, this.getXEventCount(), this.getSeriesCount());
        if (this.getAutosize()) {
            int n = 0;
            while (n < this.f11) {
                if (this.f12[this.getXEventCount() - 1][n] > this.getYMax()) {
                    TimePlot timePlot = this;
                    timePlot.setYMax(timePlot.f12[this.getXEventCount() - 1][n]);
                }
                if (this.f12[this.getXEventCount() - 1][n] < this.getYMin()) {
                    TimePlot timePlot = this;
                    timePlot.setYMin(timePlot.f12[this.getXEventCount() - 1][n]);
                }
                ++n;
            }
        }
        ++this.f13;
        this.repaint();
    }

    public static void shiftSampleValues(float[][] fArray, float[] fArray2, int n, int n2) {
        int n3 = 1;
        while (n3 <= n) {
            int n4 = 0;
            while (n4 < n2) {
                fArray[n3 - 1][n4] = fArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            fArray[fArray.length - 1][n3] = fArray2[n3];
            ++n3;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Dimension dimension = this.getSize();
        Image image = this.createImage(dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n5 = this.f9;
        int n6 = this.f9;
        rectangle2.grow(-(n5 + n5), -(n6 + n6));
        rectangle2.height -= graphics2.getFontMetrics().getAscent();
        if (this.getCaption() != null) {
            Font font = graphics2.getFont();
            Font font2 = new Font(font.getName(), 1, font.getSize());
            graphics2.setFont(font2);
            n4 = graphics2.getFontMetrics().stringWidth(this.getCaption());
            n3 = graphics2.getFontMetrics().getAscent();
            graphics2.drawString(this.getCaption(), (rectangle2.width >> 1) - (n4 >> 1) + rectangle2.x, rectangle2.y + n3);
            graphics2.setFont(font);
        }
        n4 = this.getYLabel() == null ? 0 : graphics2.getFontMetrics().stringWidth(this.getYLabel());
        n3 = graphics2.getFontMetrics().stringWidth("" + this.getYMin());
        int n7 = graphics2.getFontMetrics().stringWidth("" + this.getYMax());
        String string = this.getYLabel();
        if (n3 > n4) {
            string = "" + this.getYMin();
        }
        if (n7 > n3) {
            string = "" + this.getYMax();
        }
        int n8 = graphics2.getFontMetrics().stringWidth(string);
        int n9 = graphics2.getFontMetrics().getDescent();
        int n10 = rectangle2.x + rectangle2.width - n8;
        graphics2.drawLine(n10, rectangle2.y, n10, rectangle2.y + rectangle2.height);
        int n11 = rectangle2.height;
        float f = (this.getYMax() - this.getYMin()) / this.getYIncrement();
        float f2 = (float)n11 / f;
        int n12 = (int)((float)rectangle2.x + f2 * (this.getYMax() / this.getYIncrement()));
        graphics2.drawLine(rectangle2.x, n12, n10, n12);
        int n13 = 0;
        while (n13 <= (int)f) {
            int n14 = (int)((float)rectangle2.y + f2 * (float)n13);
            graphics2.drawLine(n10 - 2, n14, n10 + 2, n14);
            ++n13;
        }
        Font font = graphics2.getFont();
        Font font3 = new Font(font.getName(), 0, 9);
        graphics2.setFont(font3);
        int n15 = graphics2.getFontMetrics().getHeight();
        graphics2.drawString("" + this.getYMax(), n10 + 4, rectangle2.y + n15);
        graphics2.drawString("" + this.getYMin(), n10 + 4, rectangle2.y + rectangle2.height);
        new SimpleDateFormat("HH:mm:ss");
        graphics2.setFont(font);
        if (this.getYLabel() != null) {
            int n16 = this.f9;
            graphics2.drawString(this.getYLabel(), n10 + (n16 + n16), rectangle2.x + n9 + n15 + n15);
        }
        float f3 = (float)(n10 - rectangle2.x) / (float)this.getXEventCount();
        int n17 = 0;
        while (n17 < this.getXEventCount()) {
            n2 = (int)((float)rectangle2.x + f3 * (float)n17);
            graphics2.drawLine(n2, n12 - 2, n2, n12 + 2);
            ++n17;
        }
        if (this.getXLabel() != null) {
            graphics2.getFontMetrics().stringWidth(this.getXLabel());
            n9 = graphics2.getFontMetrics().getAscent();
            graphics2.drawString(this.getXLabel(), rectangle2.x + (rectangle2.width >> 1) - (graphics2.getFontMetrics().stringWidth(this.getXLabel()) >> 1), n12 + n9 + this.f9);
        }
        float f4 = (float)(n12 - rectangle2.x) / this.getYMax();
        if (this.f12 != null) {
            n2 = 0;
            while (n2 < this.f11) {
                graphics2.setColor(this.f14[n2]);
                n = -1;
                int n18 = -1;
                boolean bl = true;
                int n19 = this.getXEventCount() - this.f13;
                if (n19 < 0) {
                    n19 = -1;
                }
                int n20 = 0;
                while (n20 <= this.f10) {
                    int n21 = rectangle2.x + (int)(f3 * (float)n20);
                    int n22 = n12 - (int)(this.f12[n20][n2] * f4);
                    if (!bl && n20 > n19 + 1) {
                        graphics2.drawLine(n, n18, n21, n22);
                    }
                    bl = false;
                    n = n21;
                    n18 = n22;
                    ++n20;
                }
                ++n2;
            }
        }
        if (this.f15 && this.f8) {
            n2 = this.m1(rectangle2.x, n10, this.getXEventCount(), f3);
            n = rectangle2.x + (int)((float)n2 * f3);
            graphics2.setColor(Color.gray);
            graphics2.drawLine(n, 0, n, dimension.height);
            this.m2(graphics2, this.f16, this.f17, n2);
        }
        graphics.drawImage(image, 0, 0, null);
    }

    public static float[][] constructSeriesPointsArray(int n, int n2) {
        return new float[n + 1][n2];
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.f15 = true;
        this.f16 = mouseEvent.getX();
        this.f17 = mouseEvent.getY();
        if (this.f8) {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.f15 = false;
        this.f16 = -1;
        this.f17 = -1;
        if (this.f8) {
            this.repaint();
        }
    }

    private final int m1(int n, int n2, int n3, float f) {
        int n4 = this.f16 - n;
        if (n4 <= 0) {
            return 0;
        }
        int n5 = (int)((float)n4 / f);
        int n6 = (int)f;
        if (n4 - n5 * n6 > n6 >> 1) {
            ++n5;
        }
        if (n5 > n3) {
            n5 = n3;
        }
        return n5;
    }

    private final void m2(Graphics graphics, int n, int n2, int n3) {
        float[] fArray = new float[this.f11];
        int n4 = graphics.getFontMetrics().getHeight();
        int n5 = graphics.getFontMetrics().stringWidth("xx");
        int n6 = graphics.getFontMetrics().getAscent();
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.f11) {
            fArray[n8] = this.f12[n3][n8];
            int n9 = graphics.getFontMetrics().stringWidth(" " + fArray[n8]) + n5;
            if (n9 > n7) {
                n7 = n9;
            }
            ++n8;
        }
        n8 = n2 - this.f11 * n4 + n6;
        Color color = graphics.getColor();
        int n10 = 0;
        while (n10 < this.f11) {
            graphics.setColor(color);
            graphics.drawString("" + fArray[n10], n + n5, n8 + n10 * n4);
            graphics.setColor(this.f14[n10]);
            graphics.fillRect(n + 2, n8 + n10 * n4 - (n4 >> 1), (n4 >> 1) - 1, (n4 >> 1) - 1);
            ++n10;
        }
    }

    public TimePlot() {
        this.f12 = TimePlot.constructSeriesPointsArray(this.getXEventCount(), this.getSeriesCount());
        TimePlot timePlot = this;
        timePlot.addMouseListener(timePlot);
        TimePlot timePlot2 = this;
        timePlot2.addMouseMotionListener(timePlot2);
    }
}

