/*
 * Decompiled with CFR 0.152.
 */
package amber.awt;

import amber.awt.ListItem;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class TabPanel
extends Panel
implements ItemSelectable {
    public static final int Top = 0;
    public static final int Bottom = 1;
    private Polygon f1 = null;
    private boolean f2 = false;
    private Polygon f3 = null;
    private boolean f4 = false;
    private BorderLayout f5 = new BorderLayout();
    private int f6 = 0;
    private int f7 = -1;
    private int f8 = -1;
    private int f9 = 0;
    private int f10 = -1;
    private Vector f11 = new Vector();
    private Vector f12 = new Vector();
    private Vector f13 = new Vector();
    private ItemListener f14 = null;
    private boolean f15 = true;
    private int f16 = 0;

    public void first() {
        if (this.f11.size() <= 0) {
            throw new IndexOutOfBoundsException("No panels exist to display");
        }
        this.show(0);
    }

    public void last() {
        if (this.f11.size() <= 0) {
            throw new IndexOutOfBoundsException("No panels exist to display");
        }
        TabPanel tabPanel = this;
        tabPanel.show(tabPanel.f11.size() - 1);
    }

    public void next() {
        if (this.f11.size() <= 0) {
            throw new IndexOutOfBoundsException("No panels exist to display");
        }
        if (this.f7 < this.f11.size() - 1) {
            TabPanel tabPanel = this;
            tabPanel.show(tabPanel.f7 + 1);
        }
    }

    public void previous() {
        if (this.f11.size() <= 0) {
            throw new IndexOutOfBoundsException("No panels exist to display");
        }
        if (this.f7 > 0) {
            TabPanel tabPanel = this;
            tabPanel.show(tabPanel.f7 - 1);
        }
    }

    public Container getPanel(int n) {
        return (Container)this.f12.elementAt(n);
    }

    public int getPanelCount() {
        return this.f12.size();
    }

    public void addTab(ListItem listItem, Container container) {
        this.f11.addElement(listItem);
        this.f12.addElement(container);
        container.setVisible(false);
        this.add(container);
        if (this.f11.size() == 1) {
            this.f7 = 0;
            TabPanel tabPanel = this;
            tabPanel.show(tabPanel.f7);
            return;
        }
        TabPanel tabPanel = this;
        tabPanel.show(tabPanel.f7);
    }

    public void addTab(ListItem listItem, Container container, int n) {
        this.f11.insertElementAt(listItem, n);
        this.f12.insertElementAt(container, n);
        container.setVisible(false);
        this.add(container);
        if (this.f11.size() == 1) {
            this.f7 = 0;
            TabPanel tabPanel = this;
            tabPanel.show(tabPanel.f7);
            return;
        }
        TabPanel tabPanel = this;
        tabPanel.show(tabPanel.f7);
    }

    public void renameTab(ListItem listItem, int n) {
        this.f11.setElementAt(listItem, n);
        this.repaint();
    }

    public void removeTab(ListItem listItem) {
        int n = this.f11.indexOf(listItem);
        this.removeTab(n);
    }

    public void removeTab(int n) {
        this.f11.removeElementAt(n);
        Container container = (Container)this.f12.elementAt(n);
        container.removeAll();
        this.remove(container);
        this.f12.removeElementAt(n);
        if (n == this.f7 && this.f11.size() > 0) {
            this.f7 = -1;
            this.show(0);
            return;
        }
        this.repaint();
    }

    public void removeAllTabs() {
        this.f11.removeAllElements();
        this.f12.removeAllElements();
        this.removeAll();
        this.repaint();
    }

    public void show(String string) {
        int n = this.f11.indexOf(string);
        this.show(n);
    }

    public void show(int n) {
        if (n < 0 || n >= this.f11.size()) {
            throw new IllegalArgumentException("Tab index outside of bounds");
        }
        if (this.f7 >= 0) {
            ((Container)this.f12.elementAt(this.f7)).setVisible(false);
        }
        this.f7 = n;
        Container container = (Container)this.f12.elementAt(this.f7);
        container.setVisible(false);
        this.doLayout();
        container.setVisible(true);
        this.repaint();
    }

    public void setTabChangeEnabled(boolean bl) {
        this.f15 = bl;
    }

    public boolean isTabChangeEnabled() {
        return this.f15;
    }

    public int getSelectedIndex() {
        return this.f7;
    }

    public void doLayout() {
        if (this.f7 >= 0) {
            Container container = (Container)this.f12.elementAt(this.f7);
            if (this.f16 == 0) {
                container.setBounds(1, this.f9, this.getSize().width - 2, this.getSize().height - this.f9 - 1);
            } else {
                container.setBounds(1, 1, this.getSize().width - 2, this.getSize().height - this.f9 - 1);
            }
            container.doLayout();
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        super.paint(graphics);
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.f9 < fontMetrics.getHeight() + fontMetrics.getDescent() + 7) {
            this.f9 = fontMetrics.getHeight() + fontMetrics.getDescent() + 7;
        }
        graphics.setColor(Color.white);
        if (this.f16 == 0) {
            n2 = this.f9 - 1;
            n = dimension.height - 1;
        } else {
            n2 = 0;
            n = dimension.height - this.f9;
        }
        graphics.drawLine(0, n2, dimension.width - 1, n2);
        graphics.setColor(Color.white);
        if (this.f16 == 0) {
            graphics.drawLine(0, this.f9 - 1, 0, dimension.height - 1);
        } else {
            graphics.drawLine(0, 0, 0, dimension.height - this.f9 - 1);
        }
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, n, dimension.width - 1, n);
        this.m1(graphics, n2, n);
    }

    private final void m1(Graphics graphics, int n, int n2) {
        int n3 = 0;
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.f13.removeAllElements();
        int n4 = dimension.width - 23;
        int n5 = 0;
        int n6 = this.f6;
        while (n6 < this.f11.size() && n3 < n4) {
            ListItem listItem = (ListItem)this.f11.elementAt(n6);
            int n7 = fontMetrics.stringWidth(listItem.item.toString());
            int n8 = 0;
            int n9 = 0;
            if (listItem.image != null) {
                n8 = listItem.image.getWidth(this);
                n9 = listItem.image.getHeight(this);
                n7 += n8 + 1;
                if (this.f9 < n9 + 7) {
                    this.f9 = n9 + 7;
                    this.doLayout();
                }
            }
            if (n3 + n7 + 10 > n4) break;
            this.f13.addElement(new Integer(n7 + 10));
            Container container = (Container)this.f12.elementAt(n6);
            graphics.setColor(container.getBackground());
            if (n6 == this.f7) {
                if (this.f16 == 0) {
                    graphics.fill3DRect(n3, 0, n7 + 10, this.f9, true);
                    graphics.drawLine(n3 + 1, this.f9 - 1, n3 + n7 + 8, this.f9 - 1);
                } else {
                    graphics.fill3DRect(n3, n2, n7 + 10, this.f9, true);
                    graphics.drawLine(n3 + 1, n2, n3 + n7 + 8, n2);
                }
            } else if (this.f16 == 0) {
                graphics.fill3DRect(n3, 2, n7 + 10, this.f9 - 2, true);
                graphics.setColor(Color.white);
                graphics.drawLine(n3, this.f9 - 1, n3 + n7 + 10, this.f9 - 1);
            } else {
                graphics.fill3DRect(n3, n2, n7 + 10, this.f9 - 2, true);
                graphics.setColor(Color.darkGray);
                graphics.drawLine(n3, n2, n3 + n7 + 10, n2);
            }
            int n10 = this.f9 - 4 - n9 >> 1;
            if (n10 < 0) {
                n10 = 0;
            }
            graphics.setColor(listItem.colour[0]);
            if (this.f16 == 0) {
                if (listItem.image != null) {
                    graphics.drawImage(listItem.image, n3 + 2, n10 + 3, this);
                }
                graphics.drawString(listItem.item.toString(), n3 + n8 + 6, fontMetrics.getAscent() + 4);
            } else {
                if (listItem.image != null) {
                    graphics.drawImage(listItem.image, n3 + 2, n2 + n10, this);
                }
                graphics.drawString(listItem.item.toString(), n3 + n8 + 6, n2 + fontMetrics.getAscent() + 4);
            }
            n3 += n7 + 10;
            ++n5;
            ++n6;
        }
        this.m2(graphics, n, n2, n5);
    }

    private final void m2(Graphics graphics, int n, int n2, int n3) {
        Dimension dimension = this.getSize();
        int[] nArray = new int[]{dimension.width - 19, dimension.width - 13, dimension.width - 13};
        int[] nArray2 = new int[]{8, 2, 14};
        if (this.f16 == 1) {
            int n4 = 0;
            while (n4 < nArray2.length) {
                int n5 = n4++;
                nArray2[n5] = nArray2[n5] + n2;
            }
        }
        this.f1 = new Polygon(nArray, nArray2, nArray.length);
        if (this.f6 <= 0) {
            graphics.setColor(Color.darkGray);
            graphics.drawPolygon(this.f1);
            this.f2 = false;
        } else {
            graphics.setColor(Color.black);
            graphics.fillPolygon(this.f1);
            this.f2 = true;
        }
        nArray = new int[]{dimension.width - 1, dimension.width - 7, dimension.width - 7};
        this.f3 = new Polygon(nArray, nArray2, nArray.length);
        if (this.f6 + n3 >= this.f11.size()) {
            graphics.setColor(Color.darkGray);
            graphics.drawPolygon(this.f3);
            this.f4 = false;
            return;
        }
        graphics.setColor(Color.black);
        graphics.fillPolygon(this.f3);
        this.f4 = true;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.f8 = -1;
            this.f10 = this.identifyTab(mouseEvent);
            if (this.f10 < 0) {
                this.f8 = this.m3(mouseEvent);
            }
        } else if (mouseEvent.getID() == 502) {
            int n;
            if (this.f10 >= 0) {
                if (this.f10 == this.identifyTab(mouseEvent)) {
                    if (this.isTabChangeEnabled()) {
                        TabPanel tabPanel = this;
                        tabPanel.show(tabPanel.f10);
                        this.repaint();
                    }
                    this.fireItemStateChanged(new ItemEvent(this, 701, new Integer(this.f10), 1));
                }
            } else if (this.f8 >= 0 && this.f8 == (n = this.m3(mouseEvent))) {
                if (this.f8 == 0) {
                    if (this.f6 > 0) {
                        --this.f6;
                    }
                } else if (this.f6 < this.f11.size() - 1) {
                    ++this.f6;
                }
                this.repaint();
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    private final int m3(MouseEvent mouseEvent) {
        int n = -1;
        if (this.f1 != null && this.f1.contains(mouseEvent.getX(), mouseEvent.getY()) && this.f2) {
            n = 0;
        } else if (this.f3 != null && this.f3.contains(mouseEvent.getX(), mouseEvent.getY()) && this.f4) {
            n = 1;
        }
        return n;
    }

    protected int identifyTab(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        if (mouseEvent.getY() > this.f9 && this.f16 == 0) {
            return -1;
        }
        if (mouseEvent.getY() < dimension.height - this.f9 && this.f16 == 1) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.f13.size()) {
            Integer n3 = (Integer)this.f13.elementAt(n2);
            if ((n += n3.intValue()) > mouseEvent.getX()) {
                return n2 + this.f6;
            }
            ++n2;
        }
        return -1;
    }

    public void addNotify() {
        super.addNotify();
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.f9 = fontMetrics.getHeight() + fontMetrics.getDescent() + 7;
            return;
        }
        this.f9 = 25;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.f14 = AWTEventMulticaster.remove(this.f14, itemListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.f14 = AWTEventMulticaster.add(this.f14, itemListener);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (this.f14 != null) {
            this.f14.itemStateChanged(itemEvent);
        }
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public int getTabLocation() {
        return this.f16;
    }

    public void setTabLocation(int n) {
        this.f16 = n;
    }

    public TabPanel() {
        try {
            TabPanel tabPanel = this;
            tabPanel.setLayout(tabPanel.f5);
            this.setBackground(Color.lightGray);
            this.enableEvents(16L);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

