/*
 * Decompiled with CFR 0.152.
 */
package amber.awt;

import amber.awt.DrawPanel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class ImageNode
extends Component {
    protected Vector operations = new Vector();
    protected Vector objects = new Vector();
    protected Rectangle bounds = new Rectangle(0, 0, 0, 0);
    protected boolean selected = false;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected boolean mobile = true;
    protected Container parentContainer = null;
    private String f1 = null;

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.bounds.contains(n, n2);
    }

    public void render(Graphics graphics, Dimension dimension, DrawPanel drawPanel, Color color) {
        if (this.isVisible()) {
            int n = this.operations.size();
            int n2 = 0;
            while (n2 < n) {
                int[] nArray = (int[])this.operations.elementAt(n2);
                int[] cfr_ignored_0 = new int[nArray.length];
                Object e = this.objects.elementAt(n2);
                Dimension dimension2 = this.getSize();
                dimension2.width += this.bounds.x;
                dimension2.height += this.bounds.y;
                drawPanel.renderOperation(graphics, dimension2, nArray, e, this.bounds.x, this.bounds.y);
                ++n2;
            }
            if (this.isSelected() && color != null) {
                Color color2 = graphics.getColor();
                graphics.setColor(color);
                graphics.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                graphics.setColor(color2);
            }
        }
    }

    public void addOperation(Object object, int[] nArray) {
        this.objects.addElement(object);
        this.operations.addElement(nArray);
    }

    public void insertOperation(Object object, int[] nArray, int n) {
        this.objects.insertElementAt(object, n);
        this.operations.insertElementAt(nArray, n);
    }

    public void replaceOperation(Object object, int[] nArray, int n) {
        this.objects.setElementAt(object, n);
        this.operations.setElementAt(nArray, n);
    }

    public void removeOperation(int n) {
        this.objects.removeElementAt(n);
        this.operations.removeElementAt(n);
    }

    public void removeAllOperations() {
        this.objects.removeAllElements();
        this.operations.removeAllElements();
    }

    public Vector getOperations() {
        return this.operations;
    }

    public Vector getObjects() {
        return this.objects;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public Dimension getSize() {
        return new Dimension(this.bounds.width, this.bounds.height);
    }

    public Point getLocation() {
        return new Point(this.bounds.x, this.bounds.y);
    }

    public int getX() {
        return this.bounds.x;
    }

    public int getY() {
        return this.bounds.y;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public void setOperations(Vector vector) {
        this.operations = vector;
    }

    public void setObjects(Vector vector) {
        this.objects = vector;
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds = rectangle;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setMobile(boolean bl) {
        this.mobile = bl;
    }

    public void setSize(Dimension dimension) {
        this.bounds.width = dimension.width;
        this.bounds.height = dimension.height;
    }

    public void setLocation(Point point) {
        this.bounds.x = point.x;
        this.bounds.y = point.y;
    }

    public void setX(int n) {
        this.bounds.x = n;
    }

    public void setY(int n) {
        this.bounds.y = n;
    }

    public void setWidth(int n) {
        this.bounds.width = n;
    }

    public void setHeight(int n) {
        this.bounds.height = n;
    }

    public String toString() {
        return new String("ImageNode object, values: operations: " + this.operations + "objects: " + this.objects + ", bounds: " + this.bounds + ", tool tip: " + this.f1);
    }

    public void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    public Container getParent() {
        return this.parentContainer;
    }

    public void setParent(Container container) {
        this.parentContainer = container;
    }

    public String getToolTip() {
        return this.f1;
    }

    public void setToolTip(String string) {
        this.f1 = string;
    }
}

