/*
 * Decompiled with CFR 0.152.
 */
package amber.awt;

import amber.awt.DrawPanel;
import amber.awt.ImageNode;
import amber.awt.TipMgr;
import amber.awt.ToolTip;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class ExtDrawPanel
extends DrawPanel
implements ItemSelectable {
    private Vector f1 = new Vector();
    private ActionListener f2;
    private ItemListener f3;
    private int[] f4 = new int[0];
    private int f5 = -1;
    protected boolean multipleMode = false;
    protected Color highlightColour = null;
    private TipMgr f6 = null;
    private int f7 = -1;
    private int f8 = -1;
    private int f9 = -1;
    private int f10 = -1;
    private int f11 = -1;
    private int f12 = -1;
    private int f13 = -1;
    private boolean f14 = false;
    private int f15 = -1;
    private int f16 = -1;
    private int f17 = -1;

    public void addNode(ImageNode imageNode) {
        this.f1.addElement(imageNode);
        imageNode.setParent(this);
        if (this.f6 != null && imageNode.getToolTip() != null) {
            ImageNode imageNode2 = imageNode;
            this.f6.addTip(new ToolTip(imageNode2, imageNode2.getToolTip()));
        }
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void insertNode(ImageNode imageNode, int n) {
        this.f1.insertElementAt(imageNode, n);
        imageNode.setParent(this);
        if (this.f6 != null && imageNode.getToolTip() != null) {
            ImageNode imageNode2 = imageNode;
            this.f6.addTip(new ToolTip(imageNode2, imageNode2.getToolTip()));
        }
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void replaceNode(ImageNode imageNode, int n) {
        ImageNode imageNode2 = (ImageNode)this.f1.elementAt(n);
        imageNode2.setParent(null);
        if (this.f6 != null && imageNode2.getToolTip() != null) {
            this.f6.removeTip(imageNode2);
        }
        this.f1.setElementAt(imageNode, n);
        imageNode.setParent(this);
        if (this.f6 != null && imageNode.getToolTip() != null) {
            ImageNode imageNode3 = imageNode;
            this.f6.addTip(new ToolTip(imageNode3, imageNode3.getToolTip()));
        }
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void removeNode(int n) {
        if (n < 0 || n >= this.f1.size()) {
            throw new IndexOutOfBoundsException("No such node");
        }
        ImageNode imageNode = (ImageNode)this.f1.elementAt(n);
        if (imageNode.isSelected()) {
            this.deselect(n);
        }
        imageNode.setParent(null);
        this.f1.removeElementAt(n);
        if (this.f6 != null && imageNode.getToolTip() != null) {
            this.f6.removeTip(imageNode);
        }
        int n2 = 0;
        while (n2 < this.f4.length) {
            if (this.f4[n2] >= n) {
                int n3 = n2;
                this.f4[n3] = this.f4[n3] - 1;
            }
            ++n2;
        }
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void removeAllNodes() {
        int n = this.f1.size();
        int n2 = 0;
        while (n2 < n) {
            ImageNode imageNode = (ImageNode)this.f1.elementAt(n2);
            imageNode.setParent(null);
            if (this.f6 != null && imageNode.getToolTip() != null) {
                this.f6.removeTip(imageNode);
            }
            ++n2;
        }
        this.f1.removeAllElements();
        if (this.redrawState) {
            this.repaint();
        }
    }

    public Vector getNodes() {
        return this.f1;
    }

    public ImageNode getNode(int n) {
        return (ImageNode)this.f1.elementAt(n);
    }

    public Color getHighlightColour() {
        return this.highlightColour;
    }

    public void setHighlightColour(Color color) {
        this.highlightColour = color;
    }

    protected void render(Graphics graphics, Dimension dimension) {
        super.render(graphics, dimension);
        int n = this.f1.size();
        int n2 = 0;
        while (n2 < n) {
            ExtDrawPanel extDrawPanel = this;
            ((ImageNode)this.f1.elementAt(n2)).render(graphics, dimension, extDrawPanel, extDrawPanel.highlightColour);
            ++n2;
        }
    }

    private final void m1(MouseEvent mouseEvent) {
        if (this.f5 >= 0) {
            ImageNode imageNode = (ImageNode)this.f1.elementAt(this.f5);
            imageNode.processEvent(new MouseEvent(imageNode, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
        this.f5 = -1;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 505: {
                this.m1(mouseEvent);
                return;
            }
            case 501: {
                this.m1(mouseEvent);
                int n = this.getSelectedNode(mouseEvent.getX(), mouseEvent.getY());
                if (n >= 0) {
                    ImageNode imageNode = (ImageNode)this.f1.elementAt(n);
                    if (!imageNode.isEnabled()) {
                        this.f7 = -1;
                        return;
                    }
                    this.f14 = false;
                    this.f15 = -1;
                    this.f8 = mouseEvent.getX();
                    this.f9 = mouseEvent.getY();
                    this.f12 = mouseEvent.getX() - imageNode.getX();
                    this.f13 = mouseEvent.getY() - imageNode.getY();
                    this.f10 = mouseEvent.getX();
                    this.f11 = mouseEvent.getY();
                    if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                        if (!imageNode.isSelected()) {
                            this.select(n, true, true, mouseEvent);
                        } else {
                            this.deselect(n, true, mouseEvent);
                            this.f15 = n;
                            this.f16 = mouseEvent.getX() - imageNode.getX();
                            this.f17 = mouseEvent.getY() - imageNode.getY();
                        }
                    } else {
                        this.select(n, false, true, mouseEvent);
                    }
                    this.f7 = n;
                    this.repaint();
                    return;
                }
                this.deselect(-1, true, mouseEvent);
                this.f7 = n;
                return;
            }
            case 502: {
                if (this.f7 >= 0) {
                    if (this.f14) {
                        int n = 0;
                        while (n < this.f4.length) {
                            ImageNode imageNode = (ImageNode)this.f1.elementAt(this.f4[n]);
                            if (imageNode.isEnabled() && imageNode.isMobile()) {
                                this.fireItemStateChanged(new ItemEvent(this, 701, new Rectangle(mouseEvent.getX() - this.f12, mouseEvent.getY() - this.f13, this.f4[n], 1), 1));
                            }
                            ++n;
                        }
                    }
                    if (mouseEvent.getClickCount() > 1) {
                        this.fireActionPerformed(new ActionEvent(this, 1001, Integer.toString(this.f7), mouseEvent.getModifiers()));
                    }
                }
                this.f15 = -1;
                this.repaint();
            }
        }
    }

    public int getSelectedNode(int n, int n2) {
        int n3 = this.f1.size() - 1;
        while (n3 >= 0) {
            ImageNode imageNode = (ImageNode)this.f1.elementAt(n3);
            if (imageNode.isVisible() && imageNode.contains(n, n2)) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 503: {
                int n = this.getSelectedNode(mouseEvent.getX(), mouseEvent.getY());
                if (n >= 0) {
                    if (n == this.f5) break;
                    this.m1(mouseEvent);
                    this.f5 = n;
                    ImageNode imageNode = (ImageNode)this.f1.elementAt(this.f5);
                    imageNode.processEvent(new MouseEvent(imageNode, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    return;
                }
                this.m1(mouseEvent);
                return;
            }
            case 506: {
                if (this.f4.length < 0) break;
                int n = 0;
                while (n < this.f4.length) {
                    ImageNode imageNode = (ImageNode)this.f1.elementAt(this.f4[n]);
                    if (imageNode.isEnabled() && imageNode.isMobile()) {
                        this.f12 = this.f10 - imageNode.getX();
                        this.f13 = this.f11 - imageNode.getY();
                        imageNode.setLocation(new Point(mouseEvent.getX() - this.f12, mouseEvent.getY() - this.f13));
                    }
                    ++n;
                }
                this.f10 = mouseEvent.getX();
                this.f11 = mouseEvent.getY();
                if (!this.f14 && Math.abs(this.f10 - this.f8) > 2 || Math.abs(this.f11 - this.f9) > 2) {
                    this.f14 = true;
                    if (this.f15 >= 0) {
                        ImageNode imageNode = (ImageNode)this.f1.elementAt(this.f15);
                        if (imageNode.isEnabled() && imageNode.isMobile()) {
                            ExtDrawPanel extDrawPanel = this;
                            extDrawPanel.select(extDrawPanel.f15, true, true, mouseEvent);
                            imageNode.setLocation(new Point(mouseEvent.getX() - this.f16, mouseEvent.getY() - this.f17));
                        }
                        this.f15 = -1;
                    }
                }
                this.repaint();
            }
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.f2 = AWTEventMulticaster.remove(this.f2, actionListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.f2 = AWTEventMulticaster.add(this.f2, actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.f2 != null) {
            this.f2.actionPerformed(actionEvent);
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.f3 = AWTEventMulticaster.remove(this.f3, itemListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.f3 = AWTEventMulticaster.add(this.f3, itemListener);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (this.f3 != null) {
            this.f3.itemStateChanged(itemEvent);
        }
    }

    public ImageNode getSelected() {
        if (this.f4.length < 1) {
            return null;
        }
        return (ImageNode)this.f1.elementAt(this.f4[0]);
    }

    public int getSelectedIndex() {
        if (this.f4.length < 1) {
            return -1;
        }
        return this.f4[0];
    }

    public int[] getSelectedIndexes() {
        return this.f4;
    }

    public void select(int n) {
        this.select(n, false);
    }

    public void select(int n, boolean bl) {
        this.select(n, bl, false, null);
    }

    public void select(int n, boolean bl, boolean bl2, MouseEvent mouseEvent) {
        if (n > this.f1.size()) {
            throw new IndexOutOfBoundsException("No such node");
        }
        if (n < 0) {
            this.deselect(-1, bl2, mouseEvent);
            return;
        }
        ImageNode imageNode = (ImageNode)this.f1.elementAt(n);
        if (this.isMultipleMode() && bl) {
            if (!imageNode.isSelected()) {
                int[] nArray = new int[this.f4.length + 1];
                System.arraycopy(this.f4, 0, nArray, 0, this.f4.length);
                imageNode.setSelected(true);
                nArray[nArray.length - 1] = n;
                this.f4 = nArray;
                if (bl2) {
                    this.fireItemStateChanged(new ItemEvent(this, 701, new Rectangle(mouseEvent.getX(), mouseEvent.getY(), n, 0), 1));
                }
            }
        } else {
            this.deselect(-1, bl2, mouseEvent);
            this.f4 = new int[1];
            imageNode.setSelected(true);
            this.f4[0] = n;
            if (bl2) {
                this.fireItemStateChanged(new ItemEvent(this, 701, new Rectangle(mouseEvent.getX(), mouseEvent.getY(), n, 0), 1));
            }
        }
        this.repaint();
    }

    public void deselect(int n) {
        this.deselect(n, false, null);
    }

    public void deselect(int n, boolean bl, MouseEvent mouseEvent) {
        if (n > this.f1.size()) {
            throw new IndexOutOfBoundsException("No such node");
        }
        if (n < 0) {
            int n2 = 0;
            while (n2 < this.f4.length) {
                ((ImageNode)this.f1.elementAt(this.f4[n2])).setSelected(false);
                if (bl) {
                    this.fireItemStateChanged(new ItemEvent(this, 701, new Rectangle(mouseEvent.getX(), mouseEvent.getY(), this.f4[n2], 0), 2));
                }
                ++n2;
            }
            this.f4 = new int[0];
            this.repaint();
            return;
        }
        if (this.isMultipleMode()) {
            ((ImageNode)this.f1.elementAt(n)).setSelected(false);
            int n3 = 0;
            while (n3 < this.f4.length) {
                if (this.f4[n3] == n) {
                    int[] nArray = new int[this.f4.length - 1];
                    System.arraycopy(this.f4, 0, nArray, 0, n3);
                    System.arraycopy(this.f4, n3 + 1, nArray, n3, this.f4.length - (n3 + 1));
                    this.f4 = nArray;
                    if (bl) {
                        this.fireItemStateChanged(new ItemEvent(this, 701, new Rectangle(mouseEvent.getX(), mouseEvent.getY(), n, 0), 2));
                    }
                    break;
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.f4.length) {
                ((ImageNode)this.f1.elementAt(this.f4[n4])).setSelected(false);
                if (bl) {
                    this.fireItemStateChanged(new ItemEvent(this, 701, new Rectangle(mouseEvent.getX(), mouseEvent.getY(), this.f4[n4], 0), 2));
                }
                ++n4;
            }
            this.f4 = new int[0];
        }
        this.repaint();
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[this.f4.length];
        int n = 0;
        while (n < this.f4.length) {
            objectArray[n] = (ImageNode)this.f1.elementAt(this.f4[n]);
            ++n;
        }
        return objectArray;
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean bl) {
        this.multipleMode = bl;
    }

    public TipMgr getToolTipManager() {
        return this.f6;
    }

    public void setToolTipManager(TipMgr tipMgr) {
        this.f6 = tipMgr;
    }

    public ExtDrawPanel() {
        this.enableEvents(48L);
    }
}

