/*
 * Decompiled with CFR 0.152.
 */
package amber.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.util.Vector;

public class DrawPanel
extends Panel {
    public static final int BorderNone = 0;
    public static final int BorderUp = 1;
    public static final int BorderDown = 2;
    public static final int BorderBevel = 3;
    public static final int DrawImage = 0;
    public static final int DrawString = 1;
    public static final int SetColour = 2;
    public static final int DrawLine = 3;
    public static final int DrawRect = 4;
    public static final int DrawOval = 5;
    public static final int DrawArc = 6;
    public static final int DrawPolygon = 7;
    public static final int DrawPolyline = 8;
    public static final int SetClip = 9;
    public static final int SetPaintMode = 10;
    public static final int SetXorMode = 11;
    public static final int SetFont = 12;
    public static final int None = 0;
    public static final int Filled = 1;
    public static final int None3D = 2;
    public static final int Filled3D = 3;
    public static final int Round = 4;
    public static final int RoundFilled = 5;
    public static final int RectUp = 128;
    public static final int RectDown = 0;
    public static final int Default = 0;
    public static final int Left = 0;
    public static final int Centre = 1;
    public static final int Right = 2;
    public static final int TopAligned = 16;
    public static final int CentreAligned = 32;
    public static final int BottomAligned = 0;
    private Vector f1 = new Vector();
    private Vector f2 = new Vector();
    int borderType = 0;
    protected boolean redrawState = true;
    private Image f3 = null;
    private Dimension f4 = new Dimension();

    public void setAutoRepaint(boolean bl) {
        this.redrawState = bl;
    }

    public void addOperation(Object object, int[] nArray) {
        this.f1.addElement(object);
        this.f2.addElement(nArray);
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void insertOperation(Object object, int[] nArray, int n) {
        this.f1.insertElementAt(object, n);
        this.f2.insertElementAt(nArray, n);
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void replaceOperation(Object object, int[] nArray, int n) {
        this.f1.setElementAt(object, n);
        this.f2.setElementAt(nArray, n);
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void removeOperation(int n) {
        this.f1.removeElementAt(n);
        this.f2.removeElementAt(n);
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void removeAllOperations() {
        this.f1.removeAllElements();
        this.f2.removeAllElements();
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void setBorder(int n) {
        this.borderType = n;
        if (this.redrawState) {
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.f4 == null || this.f3 == null || dimension.height != this.f4.height || dimension.width != this.f4.width) {
            this.f3 = this.createImage(dimension.width, dimension.height);
        }
        Graphics graphics2 = this.f3.getGraphics();
        this.f4.width = dimension.width;
        this.f4.height = dimension.height;
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(this.getForeground());
        this.render(graphics2, dimension);
        graphics.drawImage(this.f3, 0, 0, dimension.width, dimension.height, this);
        super.paint(graphics);
    }

    protected void render(Graphics graphics, Dimension dimension) {
        graphics.setPaintMode();
        int n = 0;
        while (n < this.f2.size()) {
            int[] nArray = (int[])this.f2.elementAt(n);
            Object e = this.f1.elementAt(n);
            this.renderOperation(graphics, dimension, nArray, e, 0, 0);
            ++n;
        }
        graphics.setPaintMode();
        DrawPanel drawPanel = this;
        drawPanel.drawBorder(drawPanel.borderType, dimension, graphics);
    }

    public void renderOperation(Graphics graphics, Dimension dimension, int[] nArray, Object object, int n, int n2) {
        switch (nArray[0]) {
            case 0: {
                this.drawImage((Image)object, dimension, nArray, graphics, n, n2);
                return;
            }
            case 1: {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n3 = nArray[2];
                int n4 = nArray[3];
                if ((nArray[1] & 0xF) == 1) {
                    n3 -= fontMetrics.stringWidth((String)object) >> 1;
                } else if ((nArray[1] & 0x3F) == 2) {
                    n3 -= fontMetrics.stringWidth((String)object);
                }
                if ((nArray[1] & 0xF0) == 16) {
                    n4 += fontMetrics.getAscent() + fontMetrics.getLeading();
                } else if ((nArray[1] & 0xF0) == 32) {
                    n4 += fontMetrics.getAscent() + fontMetrics.getLeading() - fontMetrics.getDescent() >> 1;
                }
                graphics.drawString((String)object, n3 + n, n4 + n2);
                return;
            }
            case 2: {
                graphics.setColor((Color)object);
                return;
            }
            case 3: {
                graphics.drawLine(nArray[2] + n, nArray[3] + n2, nArray[4] + n, nArray[5] + n2);
                return;
            }
            case 4: {
                switch (nArray[1] & 0x7F) {
                    case 0: {
                        graphics.drawRect(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5]);
                        return;
                    }
                    case 1: {
                        graphics.fillRect(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5]);
                        return;
                    }
                    case 2: {
                        graphics.draw3DRect(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5], (nArray[1] & 0x80) == 128);
                        return;
                    }
                    case 3: {
                        graphics.fill3DRect(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5], (nArray[1] & 0x80) == 128);
                        return;
                    }
                    case 4: {
                        graphics.drawRoundRect(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5], nArray[6], nArray[7]);
                        return;
                    }
                    case 5: {
                        graphics.fillRoundRect(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5], nArray[6], nArray[7]);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 5: {
                if (nArray[1] == 0) {
                    graphics.drawOval(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5]);
                    return;
                }
                graphics.fillOval(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5]);
                return;
            }
            case 6: {
                if (nArray[1] == 0) {
                    graphics.drawArc(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5], nArray[6], nArray[7]);
                    return;
                }
                graphics.fillArc(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5], nArray[6], nArray[7]);
                return;
            }
            case 7: {
                int n5 = nArray.length - 2 >> 1;
                int[] nArray2 = new int[n5];
                int[] nArray3 = new int[n5];
                int n6 = 0;
                while (n6 < n5) {
                    nArray2[n6] = nArray[2 + n6] + n;
                    ++n6;
                }
                n6 = 0;
                while (n6 < n5) {
                    nArray3[n6] = nArray[2 + n6 + n5] + n2;
                    ++n6;
                }
                if (nArray[1] == 0) {
                    graphics.drawPolygon(nArray2, nArray3, n5);
                    return;
                }
                graphics.fillPolygon(nArray2, nArray3, n5);
                return;
            }
            case 8: {
                int n7 = nArray.length - 2 >> 1;
                int[] nArray4 = new int[n7];
                int[] nArray5 = new int[n7];
                int n8 = 0;
                while (n8 < n7) {
                    nArray4[n8] = nArray[2 + n8] + n;
                    ++n8;
                }
                n8 = 0;
                while (n8 < n7) {
                    nArray5[n8] = nArray[2 + n8 + n7] + n2;
                    ++n8;
                }
                graphics.drawPolyline(nArray4, nArray5, n7);
                return;
            }
            case 9: {
                graphics.setClip(nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5]);
                return;
            }
            case 10: {
                graphics.setPaintMode();
                return;
            }
            case 11: {
                graphics.setXORMode((Color)object);
                return;
            }
            case 12: {
                graphics.setFont((Font)object);
            }
        }
    }

    protected void drawImage(Image image, Dimension dimension, int[] nArray, Graphics graphics, int n, int n2) {
        if (image != null) {
            if (nArray[1] > 0) {
                int n3 = image.getHeight(this);
                int n4 = image.getWidth(this);
                int n5 = n;
                int n6 = 0;
                while (n6 < (dimension.width - n) / n4 + 1) {
                    int n7 = n2;
                    int n8 = 0;
                    while (n8 < (dimension.height - n2) / n3 + 1) {
                        graphics.drawImage(image, n5, n7, this);
                        n7 += n3;
                        ++n8;
                    }
                    n5 += n4;
                    ++n6;
                }
                return;
            }
            if (nArray[4] < 0 || nArray[5] < 0) {
                graphics.drawImage(image, nArray[2] + n, nArray[3] + n2, this);
                return;
            }
            graphics.drawImage(image, nArray[2] + n, nArray[3] + n2, nArray[4], nArray[5], this);
        }
    }

    protected void drawBorder(int n, Dimension dimension, Graphics graphics) {
        if (n != 0) {
            if (n == 3) {
                graphics.setColor(this.getBackground().darker().darker());
                graphics.drawRect(0, 0, dimension.width - 2, dimension.height - 2);
                graphics.setColor(Color.white);
                graphics.drawLine(1, 1, dimension.width - 3, 1);
                graphics.drawLine(1, 1, 1, dimension.height - 3);
                graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
                return;
            }
            if (n == 2) {
                graphics.setColor(Color.darkGray);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.drawLine(0, 0, dimension.width, 0);
            graphics.drawLine(1, 1, dimension.width - 2, 1);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.drawLine(1, 1, 1, dimension.height - 3);
            if (n == 2) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.darkGray);
            }
            graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(2, dimension.height - 2, dimension.width - 1, dimension.height - 2);
            graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height - 2);
        }
    }

    public void addNotify() {
        super.addNotify();
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].removeNotify();
            componentArray[n].addNotify();
            ++n;
        }
    }
}

