/*
 * Decompiled with CFR 0.152.
 */
package amber.awt;

import amber.awt.ListItem;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;

public class ComplexList
extends Panel
implements AdjustmentListener,
ItemSelectable,
KeyListener,
ActionListener {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int ArrowNone = 0;
    public static final int ArrowDown = 1;
    public static final int ArrowUp = 2;
    public static final int EditNone = 0;
    public static final int EditDoubleClick = 1;
    private Scrollbar f1 = new Scrollbar();
    private Scrollbar f2 = new Scrollbar();
    private Vector f3 = new Vector();
    private int f4 = 0;
    private int f5 = 0;
    private int f6 = -1;
    private Vector f7 = new Vector();
    private Vector f8 = new Vector();
    private Vector f9 = new Vector();
    private Vector f10 = new Vector();
    private int[] f11 = new int[0];
    private int f12 = 0;
    private int f13 = 0;
    private int f14 = 0;
    private int f15 = 0;
    private boolean f16 = false;
    private boolean f17 = false;
    private int f18 = -1;
    private int f19 = -1;
    private int f20 = -1;
    private int f21 = 0;
    private int f22 = -1;
    private int f23 = -1;
    private int f24 = -1;
    private boolean f25 = true;
    private transient Vector f26;
    private transient Vector f27;
    private boolean f28 = true;
    private boolean f29 = true;
    private int f30 = -1;
    private TextField f31 = new TextField();
    private Checkbox f32 = new Checkbox();
    private int f33 = -1;
    private int f34 = -1;
    private boolean f35 = false;
    private int f36 = 0;
    private boolean f37 = false;
    private Image f38 = null;
    private Dimension f39 = null;

    public void setColumnAlignments(Vector vector) {
        this.f9.removeAllElements();
        this.f9 = vector;
        this.doLayout();
        this.updateCanvas();
    }

    public void setColumnSizes(Vector vector) {
        this.f8.removeAllElements();
        this.f8 = vector;
        this.createHScrollIfRequired();
        this.doLayout();
        this.updateCanvas();
    }

    public void setColumnHeaders(Vector vector) {
        this.f7.removeAllElements();
        this.f7 = vector;
        this.doLayout();
        this.updateCanvas();
    }

    public void add(Vector vector) {
        this.add(vector, 0);
    }

    public void add(Vector vector, int n) {
        this.f3.addElement(vector);
        this.f10.addElement(new Integer(n));
        this.updateCanvas();
    }

    public void insert(Vector vector, int n) {
        this.insert(vector, n, 0);
    }

    public void insert(Vector vector, int n, int n2) {
        this.f3.insertElementAt(vector, n);
        this.f10.addElement(new Integer(n2));
        this.updateCanvas();
    }

    public void remove(int n) {
        if (this.isIndexSelected(n)) {
            this.deselect(n);
        }
        this.f3.removeElementAt(n);
        this.f10.removeElementAt(n);
        int n2 = 0;
        while (n2 < this.f11.length) {
            if (this.f11[n2] >= n) {
                int n3 = n2;
                this.f11[n3] = this.f11[n3] - 1;
            }
            ++n2;
        }
        if (this.f30 >= this.f3.size()) {
            --this.f30;
        }
        this.updateCanvas();
    }

    public void removeAll() {
        this.f11 = new int[0];
        this.f14 = 0;
        this.f12 = 0;
        this.f30 = -1;
        this.f3.removeAllElements();
        this.f10.removeAllElements();
        this.updateCanvas();
    }

    public void replaceItem(Vector vector, int n) {
        this.f3.setElementAt(vector, n);
        this.updateCanvas();
    }

    public void replaceItem(Vector vector, int n, int n2) {
        this.f3.setElementAt(vector, n);
        this.f10.setElementAt(new Integer(n2), n);
        this.updateCanvas();
    }

    public void addSubItem(Object object, int n) {
        ((Vector)this.f3.elementAt(n)).addElement(object);
        this.updateCanvas();
    }

    public void insertSubItem(Object object, int n, int n2) {
        ((Vector)this.f3.elementAt(n)).insertElementAt(object, n2);
        this.updateCanvas();
    }

    public void setSubItem(Object object, int n, int n2) {
        ((Vector)this.f3.elementAt(n)).setElementAt(object, n2);
        this.updateCanvas();
    }

    public void removeSubItem(int n, int n2) {
        ((Vector)this.f3.elementAt(n)).removeElementAt(n2);
        this.updateCanvas();
    }

    public void setDrawHeaders(boolean bl) {
        this.f25 = bl;
        this.doLayout();
        this.updateCanvas();
    }

    public void setItemHeight(int n) {
        this.f23 = n;
        if (n > 0) {
            this.f4 = n;
        }
        this.doLayout();
        this.updateCanvas();
    }

    public void setHeaderHeight(int n) {
        this.f24 = n;
        this.doLayout();
        this.updateCanvas();
    }

    public int getItemCount() {
        return this.f3.size();
    }

    public int getLineType(int n) {
        return (Integer)this.f10.elementAt(n);
    }

    public void setLineType(int n, int n2) {
        this.f10.setElementAt(new Integer(n2), n);
    }

    public void setColumnAlignment(int n, int n2) {
        this.f9.setElementAt(new Integer(n2), n);
    }

    public int getSelectedIndex() {
        if (this.f11.length > 0) {
            return this.f11[0];
        }
        return -1;
    }

    public int getSelectedColumn() {
        return this.f20;
    }

    public int getSelectedColumnState() {
        return this.f21;
    }

    public Vector getSelectedItem() {
        if (this.f11.length > 0) {
            return (Vector)this.f3.elementAt(this.f11[0]);
        }
        return null;
    }

    public int[] getSelectedIndexes() {
        return this.f11;
    }

    public Vector[] getSelectedItems() {
        Vector[] vectorArray = new Vector[this.f11.length];
        int n = 0;
        while (n < this.f11.length) {
            vectorArray[n] = (Vector)this.f3.elementAt(this.f11[n]);
            ++n;
        }
        return vectorArray;
    }

    public boolean isMultipleMode() {
        return this.f16;
    }

    public void setMultipleMode(boolean bl) {
        this.f16 = bl;
    }

    public boolean isModifierRequired() {
        return this.f17;
    }

    public void setModifierRequired(boolean bl) {
        this.f17 = bl;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setSelectedColumn(int n, int n2) {
        this.f20 = n;
        this.f21 = n2;
        this.updateCanvas();
    }

    public void select(int n) {
        this.m1(n, false);
    }

    private final void m1(int n, boolean bl) {
        block12: {
            if (n > this.f3.size()) {
                throw new IndexOutOfBoundsException("No such item");
            }
            if (n < 0) {
                if (bl) {
                    int n2 = 0;
                    while (n2 < this.f11.length) {
                        ItemEvent itemEvent = new ItemEvent(this, 701, new Integer(this.f11[n2]), 2);
                        this.fireItemStateChanged(itemEvent);
                        ++n2;
                    }
                }
                this.f11 = new int[0];
                this.repaint();
                return;
            }
            int n3 = this.f16 ? this.f11.length : (this.f11.length == 0 ? 0 : 1);
            int n4 = 0;
            while (n4 < n3) {
                if (this.f11[n4] != n) {
                    ++n4;
                    continue;
                }
                break block12;
            }
            if (this.f16) {
                int[] nArray = new int[this.f11.length + 1];
                System.arraycopy(this.f11, 0, nArray, 0, this.f11.length);
                nArray[this.f11.length] = n;
                this.f11 = nArray;
            } else {
                if (this.f11.length < 1) {
                    this.f11 = new int[1];
                }
                this.f11[0] = n;
            }
            if (n >= this.f14 && n < this.f14 + this.f15) {
                this.repaint();
            } else {
                this.showLine(n);
            }
            if (bl) {
                ItemEvent itemEvent = new ItemEvent(this, 701, new Integer(n), 1);
                this.fireItemStateChanged(itemEvent);
            }
        }
    }

    public void deselect(int n) {
        this.m2(n, false);
    }

    private final void m2(int n, boolean bl) {
        if (n > this.f3.size() || n < 0) {
            throw new IndexOutOfBoundsException("No such item");
        }
        int n2 = this.f16 ? this.f11.length : (this.f11.length == 0 ? 0 : 1);
        int n3 = 0;
        while (n3 < n2) {
            if (this.f11[n3] == n) {
                int[] nArray = new int[this.f11.length - 1];
                System.arraycopy(this.f11, 0, nArray, 0, n3);
                System.arraycopy(this.f11, n3 + 1, nArray, n3, this.f11.length - (n3 + 1));
                this.f11 = nArray;
                break;
            }
            ++n3;
        }
        if (n >= this.f14 && n < this.f14 + this.f15) {
            this.repaint();
        } else {
            this.showLine(n);
        }
        if (bl) {
            ItemEvent itemEvent = new ItemEvent(this, 701, new Integer(n), 2);
            this.fireItemStateChanged(itemEvent);
        }
    }

    public void showLine(int n) {
        if (n > this.f3.size() || n < 0) {
            throw new IndexOutOfBoundsException("No such item");
        }
        int n2 = 0;
        if (this.f2.isVisible()) {
            n2 = n - this.f15 + 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.f2.setValue(n2);
        this.f14 = n2;
        this.repaint();
    }

    public void showColumn(int n) {
        if (n > this.f8.size() || n < 0) {
            throw new IndexOutOfBoundsException("No such item");
        }
        this.f1.setValue(n);
        this.f12 = n;
        this.repaint();
    }

    public boolean isIndexSelected(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.f11.length) {
            if (n == this.f11[n2]) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public Vector getModifiedItems() {
        Vector vector = new Vector();
        int n = this.f3.size();
        int n2 = 0;
        while (n2 < n) {
            Vector vector2 = (Vector)this.f3.elementAt(n2);
            int n3 = vector2.size();
            int n4 = 0;
            while (n4 < n3) {
                ListItem listItem = (ListItem)vector2.elementAt(n4);
                if (listItem.modified) {
                    Vector<Object> vector3 = new Vector<Object>();
                    vector3.addElement(new Integer(n2));
                    vector3.addElement(new Integer(n4));
                    vector3.addElement(listItem);
                    vector.addElement(vector3);
                }
                ++n4;
            }
            ++n2;
        }
        return vector;
    }

    public void resetModifiedState() {
        int n = this.f3.size();
        int n2 = 0;
        while (n2 < n) {
            Vector vector = (Vector)this.f3.elementAt(n2);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                ListItem listItem = (ListItem)vector.elementAt(n4);
                if (listItem.modified) {
                    listItem.modified = false;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.f4 = this.f23 > 0 ? this.f23 : fontMetrics.getHeight() + fontMetrics.getDescent();
        int n = fontMetrics.getHeight();
        Dimension dimension = this.getSize();
        if (this.f1.isVisible()) {
            dimension.height -= this.f1.getSize().height;
        }
        if (this.f2.isVisible()) {
            dimension.width -= this.f2.getSize().width;
        }
        Font font = this.getFont();
        if (this.f28) {
            this.updateCanvas();
            this.f28 = false;
            return;
        }
        if (this.f39 == null || this.f38 == null || dimension.height != this.f39.height || dimension.width != this.f39.width) {
            this.f38 = this.createImage(dimension.width, dimension.height);
            this.f39 = dimension;
        }
        Graphics graphics2 = this.f38.getGraphics();
        graphics2.setClip(0, 0, dimension.width, dimension.height);
        graphics2.clearRect(0, 0, dimension.width, dimension.height);
        this.m6(graphics2, 0, 0, dimension.width, dimension.height, false);
        int n2 = 1;
        int n3 = this.f24 > 0 ? this.f24 : (this.f5 = this.f24 == 0 ? fontMetrics.getHeight() + fontMetrics.getDescent() + 2 : this.f4 + 2);
        if (this.f25) {
            this.m5(graphics2, dimension, this.f5, fontMetrics);
            n2 = this.f5 + 1;
        }
        int n4 = -1;
        boolean bl = false;
        int n5 = 0;
        while (n5 < this.f3.size() - this.f14) {
            Vector vector = (Vector)this.f3.elementAt(n5 + this.f14);
            int n6 = (Integer)this.f10.elementAt(n5 + this.f14);
            if (n6 <= n4 || !bl) {
                bl = this.isIndexSelected(n5 + this.f14);
                n4 = bl ? n6 : -1;
            }
            if ((n2 += this.m3(graphics2, vector, this.f4, dimension, n5 + this.f14, n2, font, fontMetrics, n6, bl)) + n > dimension.height) break;
            ++n5;
        }
        this.f15 = n5 + 1;
        graphics.drawImage(this.f38, 0, 0, dimension.width, dimension.height, this);
        this.displayEditor();
    }

    private final int m3(Graphics graphics, Vector vector, int n, Dimension dimension, int n2, int n3, Font font, FontMetrics fontMetrics, int n4, boolean bl) {
        int n5;
        int n6 = 1;
        Font font2 = font;
        if (font == null) {
            return n;
        }
        if (n4 > 0) {
            int n7 = n4;
            font2 = new Font(font.getName(), font.getStyle(), font.getSize() - (n7 + n7));
            graphics.setFont(font2);
            fontMetrics = graphics.getFontMetrics();
        }
        graphics.setFont(font2);
        int n8 = n5 = vector.size() < this.f8.size() ? vector.size() : this.f8.size();
        if (this.isIndexSelected(n2) || bl) {
            graphics.setColor(SystemColor.textHighlight);
            graphics.fillRect(1, n3, dimension.width - 1, n);
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(1, n3, dimension.width - 1, n);
            graphics.setColor(SystemColor.textText);
        }
        int n9 = this.f12;
        while (n9 < n5) {
            Object e;
            int n10 = (Integer)this.f8.elementAt(n9);
            int n11 = 0;
            if (this.f9 != null && n9 < this.f9.size()) {
                n11 = (Integer)this.f9.elementAt(n9);
            }
            if (n6 + n10 > dimension.width - 1) {
                n10 = dimension.width - n6 - 1;
            }
            int n12 = this.isIndexSelected(n2) || bl ? 2 : 0;
            if (n6 + n10 > dimension.width - 1) break;
            if (n9 >= vector.size()) {
                Vector vector2 = vector;
                e = vector2.elementAt(vector2.size() - 1);
            } else {
                e = vector.elementAt(n9);
            }
            this.m4(graphics, e, n4, n6 + 1, n3, n10, n, fontMetrics, n11, false, ((ListItem)e).colour[n12], ((ListItem)e).colour[n12 + 1]);
            this.f13 = n9;
            graphics.setFont(font2);
            n6 += n10;
            if (n9 >= vector.size()) break;
            ++n9;
        }
        if (n2 == this.f30) {
            graphics.setColor(SystemColor.activeCaptionBorder);
            graphics.drawRoundRect(1, n3, dimension.width - 1, n - 1, 4, 4);
        }
        return n;
    }

    private final void m4(Graphics graphics, Object object, int n, int n2, int n3, int n4, int n5, FontMetrics fontMetrics, int n6, boolean bl, Color color, Color color2) {
        ListItem listItem = (ListItem)object;
        graphics.setColor(color2);
        graphics.fillRect(n2 - 1, n3, n4 - 1, n5);
        if (listItem.item instanceof String) {
            graphics.setColor(color);
            int n7 = n;
            int n8 = n2 + (n7 + n7);
            if (listItem.textAttr >= 0) {
                Font font = graphics.getFont();
                font = new Font(font.getName(), listItem.textAttr, font.getSize());
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics();
            }
            int n9 = fontMetrics.stringWidth((String)listItem.item);
            switch (n6) {
                case 0: {
                    graphics.drawString((String)listItem.item, n8, n3 + fontMetrics.getHeight());
                    break;
                }
                case 1: {
                    graphics.drawString((String)listItem.item, n2 + (n4 - n9 >> 1), n3 + fontMetrics.getHeight());
                    break;
                }
                case 2: {
                    graphics.drawString((String)listItem.item, n2 + (n4 - n9) - 2, n3 + fontMetrics.getHeight());
                }
            }
            if (listItem.editable && !bl) {
                Color color3 = graphics.getColor();
                graphics.setColor(Color.lightGray);
                graphics.drawRect(n2 - 1, n3, n4 - 2, n5);
                graphics.setColor(color3);
                return;
            }
        } else {
            if (listItem.item instanceof Image) {
                switch (n6) {
                    case 0: {
                        graphics.drawImage((Image)listItem.item, n2, n3, null);
                        return;
                    }
                    case 1: {
                        graphics.drawImage((Image)listItem.item, n2 - 2 + (n4 - ((Image)listItem.item).getWidth(null) >> 1), n3, null);
                        return;
                    }
                    case 2: {
                        graphics.drawImage((Image)listItem.item, n2 - 2 + (n4 - ((Image)listItem.item).getWidth(null)), n3, null);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (listItem.item instanceof Boolean && ((Boolean)listItem.item).booleanValue()) {
                graphics.setColor(color);
                int n10 = n4 > n5 ? n5 : n4;
                int n11 = (n4 >> 1) + n2 - ((n10 -= 8) >> 1);
                int n12 = (n5 >> 1) + n3 - (n10 >> 1);
                graphics.drawLine(n11, n12 + 2 * n10 / 3, n11 + n10 / 3, n12 + n10);
                graphics.drawLine(n11 + n10 / 3, n12 + n10, n11 + n10, n12);
                graphics.drawLine(n11, n12 + 2 * n10 / 3, n11 + n10 / 3, n12 + n10 - 1);
                graphics.drawLine(n11 + n10 / 3, n12 + n10 - 1, n11 + n10, n12);
                graphics.drawLine(n11, n12 + 2 * n10 / 3, n11 + n10 / 3, n12 + n10 - 2);
                graphics.drawLine(n11 + n10 / 3, n12 + n10 - 2, n11 + n10, n12);
            }
        }
    }

    private final void m5(Graphics graphics, Dimension dimension, int n, FontMetrics fontMetrics) {
        int n2 = 0;
        Font font = graphics.getFont();
        if (this.f8 != null && this.f9 != null && this.f7 != null && this.f9.size() >= this.f8.size() && this.f7.size() >= this.f8.size()) {
            int n3 = this.f12;
            while (n3 < this.f8.size()) {
                graphics.setFont(font);
                int n4 = (Integer)this.f8.elementAt(n3);
                int n5 = (Integer)this.f9.elementAt(n3);
                graphics.setClip(n2, 0, n4, n);
                String string = n3 < this.f7.size() ? this.f7.elementAt(n3) : "";
                this.m4(graphics, string, 0, n2 + 1, 1, n4, n, fontMetrics, n5, true, SystemColor.controlText, SystemColor.control);
                this.m6(graphics, n2, 0, n4, n, n3 != this.f19);
                if (this.f20 == n3 && this.f21 > 0) {
                    switch (this.f21) {
                        case 1: {
                            graphics.setColor(Color.black);
                            graphics.drawLine(n2 + n4 - 8, 2, n2 + n4 - 2, 2);
                            graphics.drawLine(n2 + n4 - 8, 2, n2 + n4 - 5, 8);
                            graphics.setColor(Color.white);
                            graphics.drawLine(n2 + n4 - 5, 8, n2 + n4 - 2, 2);
                            break;
                        }
                        case 2: {
                            graphics.setColor(Color.white);
                            graphics.drawLine(n2 + n4 - 5, 2, n2 + n4 - 2, 8);
                            graphics.drawLine(n2 + n4 - 8, 8, n2 + n4 - 2, 8);
                            graphics.setColor(Color.black);
                            graphics.drawLine(n2 + n4 - 8, 8, n2 + n4 - 5, 2);
                        }
                    }
                }
                if ((n2 += n4) > dimension.width) break;
                ++n3;
            }
        }
        graphics.setClip(0, 0, dimension.width, dimension.height);
    }

    private final void m6(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        if (bl) {
            graphics.setColor(SystemColor.controlLtHighlight);
        } else {
            graphics.setColor(SystemColor.controlDkShadow);
        }
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        if (bl) {
            graphics.setColor(SystemColor.controlDkShadow);
        } else {
            graphics.setColor(SystemColor.controlLtHighlight);
        }
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
        graphics.setColor(color);
    }

    public int locationToIndex(Point point) {
        int n = point.y;
        int n2 = -1;
        if (this.f3.size() > 0) {
            int n3;
            int n4 = n3 = this.f25 ? this.f5 : 0;
            if (!(n >= this.f3.size() * this.f4 + n3 || n <= this.f5 && this.f25)) {
                this.f6 = (n - 1 - n3) / this.f4;
                n2 = this.f14 + this.f6;
            }
        }
        return n2;
    }

    public int locationToColumn(Point point) {
        int n = point.x;
        int n2 = -1;
        int n3 = 0;
        int n4 = this.f12;
        while (n4 < this.f8.size()) {
            int n5 = (Integer)this.f8.elementAt(n4);
            if (n >= n3 && n < n3 + n5) {
                n2 = n4;
                break;
            }
            n3 += n5;
            ++n4;
        }
        return n2;
    }

    public void setAllowDeselect(boolean bl) {
        this.f29 = bl;
    }

    protected void componentSetUp() throws Exception {
        this.setLayout(null);
        this.f1.setOrientation(0);
        ComplexList complexList = this;
        complexList.add(complexList.f1);
        ComplexList complexList2 = this;
        complexList2.add(complexList2.f2);
        this.f1.setVisible(false);
        this.f1.addAdjustmentListener(this);
        this.f2.setVisible(false);
        this.f2.addAdjustmentListener(this);
        this.f31.setVisible(false);
        this.f32.setVisible(false);
        ComplexList complexList3 = this;
        complexList3.add(complexList3.f31);
        ComplexList complexList4 = this;
        complexList4.add(complexList4.f32);
        this.f31.addKeyListener(this);
        this.f32.addKeyListener(this);
        this.f31.addActionListener(this);
    }

    protected void updateCanvas() {
        this.createVScrollIfRequired();
        this.createHScrollIfRequired();
        this.repaint();
    }

    protected void createVScrollIfRequired() {
        int n = this.getSize().height;
        int n2 = this.getSize().width;
        if (n >= 1) {
            if (this.f1.isVisible()) {
                n -= this.f1.getSize().height;
            }
            if (this.f3.size() * this.f4 + this.f5 > n) {
                int n3 = (n - this.f5 - 2) / this.f4;
                this.f2.setBounds(n2 - this.f2.getPreferredSize().width - 1, 0, this.f2.getPreferredSize().width, n);
                this.f2.setVisible(true);
                this.f2.setValues(this.f14, n3, 0, this.f3.size());
                this.f2.setBlockIncrement(n3);
            } else {
                this.showLine(0);
                this.f2.setVisible(false);
            }
            this.doLayout();
        }
    }

    protected void createHScrollIfRequired() {
        if (this.getSize().width >= 1) {
            int n = this.getSize().height;
            int n2 = this.getSize().width;
            if (this.f2.isVisible()) {
                n2 -= this.f2.getSize().width;
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.f8.size()) {
                n3 += ((Integer)this.f8.elementAt(n4)).intValue();
                ++n4;
            }
            if (n3 > this.getSize().width) {
                this.f1.setBounds(0, n - this.f1.getPreferredSize().height - 1, n2, this.f1.getPreferredSize().height);
                this.f1.setVisible(true);
                this.f1.setValues(0, 1, 0, this.f8.size());
                this.f1.setBlockIncrement(2);
            } else {
                this.f1.setVisible(false);
            }
            this.createVScrollIfRequired();
            this.f12 = 0;
            this.doLayout();
        }
    }

    private final void m7(int n, int n2) {
        if (this.f31.isVisible() || this.f32.isVisible()) {
            Serializable serializable;
            boolean bl = false;
            ListItem listItem = (ListItem)((Vector)this.f3.elementAt(n)).elementAt(n2);
            String string = "";
            if (this.f31.isVisible()) {
                string = this.f31.getText();
                if (listItem.item == null || !listItem.item.equals(string)) {
                    listItem.item = string;
                    bl = true;
                }
            } else {
                serializable = new Boolean(this.f32.getState());
                if (listItem.item == null || !listItem.item.equals(serializable)) {
                    listItem.item = serializable;
                    bl = true;
                    string = serializable.toString();
                }
            }
            if (bl) {
                listItem.modified = true;
                this.repaint();
                serializable = new ActionEvent(this, 1001, "U," + Integer.toString(n) + "," + Integer.toString(n2) + "," + string);
                this.fireActionPerformed((ActionEvent)serializable);
            }
        }
    }

    private final void m8(int n, int n2) {
        this.f33 = n;
        this.f34 = n2;
        if (n < this.f14 || n > this.f14 + this.f15 || n2 < this.f12 || n2 > this.f13) {
            this.f31.setVisible(false);
            return;
        }
        ListItem listItem = (ListItem)((Vector)this.f3.elementAt(n)).elementAt(n2);
        int n3 = 0;
        int n4 = this.f12;
        while (n4 < n2) {
            n3 += ((Integer)this.f8.elementAt(n4)).intValue();
            ++n4;
        }
        if (n3 > this.getSize().width) {
            this.f31.setVisible(false);
            return;
        }
        n4 = (n - this.f14) * this.f4 + this.f5 + 2;
        if (!this.f25) {
            n4 -= this.f5;
        }
        int n5 = (Integer)this.f8.elementAt(n2);
        int n6 = this.f4;
        if (listItem.item instanceof String) {
            this.f31.setBounds(n3, n4, n5, n6);
            this.f31.setVisible(true);
            return;
        }
        if (listItem.item instanceof Boolean) {
            this.f32.setBounds(n3, n4, n5, n6);
            this.f32.setVisible(true);
        }
    }

    public void createEditor(int n, int n2) {
        ListItem listItem = (ListItem)((Vector)this.f3.elementAt(n)).elementAt(n2);
        this.closeAndUpdateEditor();
        if (listItem.editable) {
            this.f35 = true;
            this.m8(n, n2);
            if (listItem.item instanceof String) {
                this.f31.setText(listItem.item.toString());
                this.f31.requestFocus();
                return;
            }
            if (listItem.item instanceof Boolean) {
                this.f32.setState((Boolean)listItem.item);
                this.f32.requestFocus();
            }
        }
    }

    public void closeAndUpdateEditor() {
        if (this.f35) {
            ComplexList complexList = this;
            complexList.m7(complexList.f33, this.f34);
            this.cancelEditor();
        }
    }

    public void cancelEditor() {
        if (this.f35) {
            this.f35 = false;
            this.f31.setVisible(false);
            this.f32.setVisible(false);
        }
    }

    protected void displayEditor() {
        if (this.f35) {
            ComplexList complexList = this;
            complexList.m8(complexList.f33, this.f34);
        }
    }

    protected void processHScroll(AdjustmentEvent adjustmentEvent) {
        this.f12 = adjustmentEvent.getValue();
        this.repaint();
    }

    protected void processVScroll(AdjustmentEvent adjustmentEvent) {
        this.f14 = adjustmentEvent.getValue();
        int n = this.f3.size() - this.f15 + 1;
        if (this.f14 > n) {
            this.f14 = n;
        }
        this.repaint();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                break;
            }
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.f37) {
            this.requestFocus();
        }
        this.f19 = this.locationToColumn(mouseEvent.getPoint());
        if (mouseEvent.getY() < this.f5 && this.f25) {
            this.repaint();
            return;
        }
        this.f18 = this.locationToIndex(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getY() < this.f5 && this.f25) {
            int n = this.locationToColumn(mouseEvent.getPoint());
            if (this.f19 == n) {
                if (this.f20 == n) {
                    ++this.f21;
                    this.f21 = this.f21 > 2 ? 0 : this.f21;
                } else {
                    this.f21 = 1;
                }
                this.f20 = n;
                ActionEvent actionEvent = new ActionEvent(this, 1001, "C," + this.f20 + "," + this.f21);
                this.fireActionPerformed(actionEvent);
            }
        } else {
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n != -1 && this.f18 == n && n < this.f3.size()) {
                this.f22 = n;
                this.f30 = n;
                if (this.isMultipleMode() && this.isModifierRequired()) {
                    if (mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
                        ComplexList complexList = this;
                        if (complexList.isIndexSelected(complexList.f22)) {
                            if (mouseEvent.getClickCount() < 2) {
                                ComplexList complexList2 = this;
                                complexList2.m2(complexList2.f22, true);
                            }
                        } else {
                            ComplexList complexList3 = this;
                            complexList3.m1(complexList3.f22, true);
                        }
                    } else {
                        this.m1(-1, true);
                        ComplexList complexList = this;
                        complexList.m1(complexList.f22, true);
                    }
                } else {
                    ComplexList complexList = this;
                    if (complexList.isIndexSelected(complexList.f22)) {
                        if (mouseEvent.getClickCount() < 2 && (this.isMultipleMode() || this.f29)) {
                            ComplexList complexList4 = this;
                            complexList4.m2(complexList4.f22, true);
                        }
                    } else {
                        ComplexList complexList5 = this;
                        complexList5.m1(complexList5.f22, true);
                    }
                }
                if (mouseEvent.getClickCount() > 1) {
                    boolean bl = true;
                    if (this.f36 == 1 && ((ListItem)((Vector)this.f3.elementAt((int)this.f18)).elementAt((int)this.f19)).editable) {
                        ComplexList complexList = this;
                        complexList.createEditor(complexList.f18, this.f19);
                        bl = false;
                    }
                    if (bl) {
                        ActionEvent actionEvent = new ActionEvent(this, 1001, "L," + Integer.toString(this.f22));
                        this.fireActionPerformed(actionEvent);
                    }
                } else if (this.f35 && this.f36 == 1) {
                    this.closeAndUpdateEditor();
                }
            }
        }
        this.f19 = -1;
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (this.f30 <= 0) break;
                    --this.f30;
                    ComplexList complexList = this;
                    complexList.m9(complexList.f30, true);
                    break;
                }
                case 40: {
                    if (this.f30 >= this.f3.size() - 1) break;
                    ++this.f30;
                    ComplexList complexList = this;
                    complexList.m9(complexList.f30, false);
                    break;
                }
                case 32: {
                    if (this.f30 >= this.f3.size() || this.f30 < 0) break;
                    ComplexList complexList = this;
                    if (complexList.isIndexSelected(complexList.f30) && (this.isMultipleMode() || this.f29)) {
                        ComplexList complexList2 = this;
                        complexList2.m2(complexList2.f30, true);
                        break;
                    }
                    ComplexList complexList3 = this;
                    complexList3.m1(complexList3.f30, true);
                    break;
                }
                case 33: {
                    if (this.f30 <= 0) break;
                    this.f30 -= this.f15 - 1;
                    ComplexList complexList = this;
                    complexList.m9(complexList.f30, true);
                    break;
                }
                case 34: {
                    if (this.f30 >= this.f3.size() - 1) break;
                    this.f30 += this.f15 - 1;
                    ComplexList complexList = this;
                    complexList.m9(complexList.f30, false);
                    break;
                }
                case 37: {
                    if (!this.f1.isVisible() || this.f12 <= 0) break;
                    ComplexList complexList = this;
                    complexList.showColumn(complexList.f12 - 1);
                    break;
                }
                case 39: {
                    if (!this.f1.isVisible() || this.f12 >= this.f8.size() - 1) break;
                    ComplexList complexList = this;
                    complexList.showColumn(complexList.f12 + 1);
                    break;
                }
                case 36: {
                    if (this.f30 <= 0) break;
                    this.m9(0, true);
                    break;
                }
                case 35: {
                    if (this.f30 >= this.f3.size() - 1) break;
                    ComplexList complexList = this;
                    complexList.m9(complexList.f3.size() - 1, false);
                }
            }
        }
        super.processKeyEvent(keyEvent);
    }

    private final void m9(int n, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.f3.size() - 1) {
            n = this.f3.size() - 1;
        }
        if (bl) {
            if (this.f14 > n) {
                this.showLine(n);
            }
        } else if (n - this.f14 - this.f15 + 1 > 0) {
            this.showLine(n);
        }
        this.f30 = n;
        this.repaint();
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        componentEvent.getID();
        if (componentEvent.getID() == 101) {
            this.updateCanvas();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.f1) {
            this.processHScroll(adjustmentEvent);
            return;
        }
        this.processVScroll(adjustmentEvent);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.f26 != null && this.f26.contains(actionListener)) {
            Vector vector = (Vector)this.f26.clone();
            vector.removeElement(actionListener);
            this.f26 = vector;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        Vector vector = this.f26 == null ? new Vector(2) : (Vector)this.f26.clone();
        if (!vector.contains(actionListener)) {
            vector.addElement(actionListener);
            this.f26 = vector;
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.f26 != null) {
            Vector vector = this.f26;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ActionListener)vector.elementAt(n2)).actionPerformed(actionEvent);
                ++n2;
            }
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (this.f27 != null && this.f27.contains(itemListener)) {
            Vector vector = (Vector)this.f27.clone();
            vector.removeElement(itemListener);
            this.f27 = vector;
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        Vector vector = this.f27 == null ? new Vector(2) : (Vector)this.f27.clone();
        if (!vector.contains(itemListener)) {
            vector.addElement(itemListener);
            this.f27 = vector;
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (this.f27 != null) {
            Vector vector = this.f27;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ItemListener)vector.elementAt(n2)).itemStateChanged(itemEvent);
                ++n2;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    protected void previousActiveField() {
        if (this.f35) {
            int n = this.f34 - 1;
            int n2 = this.f33;
            while (n2 >= 0) {
                Vector vector = (Vector)this.f3.elementAt(n2);
                while (n >= 0) {
                    ListItem listItem = (ListItem)vector.elementAt(n);
                    if (listItem.editable && listItem.item != null) {
                        if (n2 != this.f33) {
                            this.showLine(n2);
                        }
                        this.createEditor(n2, n);
                        return;
                    }
                    --n;
                }
                if (n2 > 0) {
                    n = ((Vector)this.f3.elementAt(n2)).size() - 1;
                }
                --n2;
            }
        }
    }

    protected void nextActiveField() {
        if (this.f35) {
            int n = this.f34 + 1;
            int n2 = this.f33;
            while (n2 < this.f3.size()) {
                Vector vector = (Vector)this.f3.elementAt(n2);
                while (n < vector.size()) {
                    ListItem listItem = (ListItem)vector.elementAt(n);
                    if (listItem.editable && listItem.item != null) {
                        if (n2 != this.f33) {
                            this.showLine(n2);
                        }
                        this.createEditor(n2, n);
                        return;
                    }
                    ++n;
                }
                n = 0;
                ++n2;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            if ((keyEvent.getModifiers() & 1) != 0) {
                this.previousActiveField();
                keyEvent.consume();
                return;
            }
            this.nextActiveField();
            keyEvent.consume();
            return;
        }
        if (keyEvent.getKeyCode() == 38) {
            if (this.f33 > 0) {
                ComplexList complexList = this;
                complexList.createEditor(complexList.f33 - 1, this.f34);
                keyEvent.consume();
                return;
            }
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.f33 < this.f3.size() - 1) {
                ComplexList complexList = this;
                complexList.createEditor(complexList.f33 + 1, this.f34);
                keyEvent.consume();
                return;
            }
        } else if (keyEvent.getKeyCode() == 10 && this.f33 > 0) {
            this.closeAndUpdateEditor();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public int getEditMode() {
        return this.f36;
    }

    public void setEditMode(int n) {
        this.f36 = n;
        if (this.f31.isVisible() || this.f32.isVisible()) {
            this.closeAndUpdateEditor();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.f31) {
            this.closeAndUpdateEditor();
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004) {
            this.f37 = true;
            return;
        }
        this.f37 = false;
    }

    public void validate() {
        super.validate();
        this.updateCanvas();
    }

    public ComplexList() {
        try {
            this.componentSetUp();
            this.f12 = 0;
            this.f4 = 14;
            this.f5 = 14;
            this.setBackground(Color.white);
            this.enableEvents(61L);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

