/*
 * Decompiled with CFR 0.152.
 */
package amber.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class Calendar
extends Canvas
implements ItemSelectable {
    public static final int NoDaysDisplayed = 42;
    private int f1 = 0;
    private int f2 = 30;
    private int f3 = 30;
    private int f4 = -1;
    private String[] f5 = new String[]{"Sun", "Mon", "Tue", "Wed", "Thur", "Fri", "Sat"};
    private boolean[] f6 = new boolean[42];
    private int f7 = 0;
    private int f8 = 0;
    private int f9 = 0;
    protected boolean validEvent = false;
    protected boolean multipleMode = false;
    private int f10 = -1;
    private transient Vector f11;
    private transient Vector f12;
    private String f13 = "Starting Day outside bounds";
    private String f14 = "Current Day outside bounds";
    private String f15 = "Month Length outside bounds";
    private String f16 = "Prior Month Length outside bounds";

    public void setStartingDay(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException(this.f13);
        }
        this.f1 = n;
        this.repaint();
    }

    public int getStartingDay() {
        return this.f1;
    }

    public void setCurrentDay(int n) {
        if (n < -1 || n >= 42) {
            throw new IllegalArgumentException(this.f14);
        }
        this.f4 = n;
        this.repaint();
    }

    public int getCurrentDay() {
        return this.f4;
    }

    public void setMonthLength(int n) {
        if (n < 0 || n > 31) {
            throw new IllegalArgumentException(this.f15);
        }
        this.f2 = n;
        this.repaint();
    }

    public int getMonthLength() {
        return this.f2;
    }

    public void setPriorMonthLength(int n) {
        if (n < 0 || n > 31) {
            throw new IllegalArgumentException(this.f16);
        }
        this.f3 = n;
        this.repaint();
    }

    public int getPriorMonthLength() {
        return this.f3;
    }

    public void setMonthConfiguration(int n, int n2, int n3) {
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException(this.f15);
        }
        if (n3 < 0 || n3 > 31) {
            throw new IllegalArgumentException(this.f16);
        }
        if (n > n2) {
            throw new IllegalArgumentException(this.f13);
        }
        this.f1 = n;
        this.f2 = n2;
        this.f3 = n3;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.m1(graphics, dimension, fontMetrics);
        this.m2(graphics, dimension, fontMetrics);
        this.m3(graphics, dimension, fontMetrics);
    }

    private final void m1(Graphics graphics, Dimension dimension, FontMetrics fontMetrics) {
        this.f9 = dimension.width / 7;
        int n = fontMetrics.getHeight();
        this.f7 = n + fontMetrics.getMaxDescent();
        graphics.setColor(SystemColor.control);
        graphics.fillRect(1, 1, this.f9 * 7, this.f7);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(1, 1, this.f9 * 7, 1);
        graphics.drawLine(1, 1, 1, this.f7 + 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(1, this.f7, this.f9 * 7 - 1, this.f7);
        graphics.drawLine(this.f9 * 7 - 1, 1, this.f9 * 7 - 1, this.f7);
        int n2 = 0;
        while (n2 < 7) {
            graphics.setColor(SystemColor.controlText);
            int n3 = this.f9 - fontMetrics.stringWidth(this.f5[n2]) >> 1;
            graphics.drawString(this.f5[n2], this.f9 * n2 + n3, n);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(this.f9 * (n2 + 1) - 2, 0, this.f9 * (n2 + 1) - 2, this.f7 - 1);
            if (n2 < 6) {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(this.f9 * (n2 + 1) - 1, 0, this.f9 * (n2 + 1) - 1, this.f7 - 1);
            }
            ++n2;
        }
    }

    private final void m2(Graphics graphics, Dimension dimension, FontMetrics fontMetrics) {
        int n = fontMetrics.getHeight() + fontMetrics.getMaxDescent();
        this.f8 = (int)((double)n * 1.3);
        this.f8 = dimension.height > this.f8 * 6 + n ? (dimension.height - n) / 6 : this.f8;
        int n2 = this.f8 * 6 + n + 1;
        int n3 = 0;
        while (n3 < 7) {
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(this.f9 * n3, n + 1, this.f9 * n3, n2 - 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(this.f9 * (n3 + 1) - 2, n + 1, this.f9 * (n3 + 1) - 2, n2 - 1);
            ++n3;
        }
        n3 = 0;
        while (n3 < 6) {
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(0, n + n3 * this.f8 + 1, this.f9 * 7 - 2, n + n3 * this.f8 + 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(0, n + (n3 + 1) * this.f8, this.f9 * 7 - 2, n + (n3 + 1) * this.f8);
            ++n3;
        }
    }

    private final void m3(Graphics graphics, Dimension dimension, FontMetrics fontMetrics) {
        String string;
        int n = fontMetrics.getHeight() + fontMetrics.getMaxDescent();
        int n2 = 0;
        while (n2 < 42) {
            if (this.f6[n2]) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(this.getBackground());
            }
            graphics.fillRect(n2 % 7 * this.f9 + 1, this.f7 + this.f8 * (n2 / 7) + 2, this.f9 - 3, this.f8 - 2);
            ++n2;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < this.f1) {
            String string2 = Integer.toString(this.f3 - this.f1 + n3 + 1);
            if (n2 == this.f4) {
                this.m4(graphics, fontMetrics, string2, Color.red, n3, n);
            } else {
                this.m4(graphics, fontMetrics, string2, SystemColor.inactiveCaption, n3, n);
            }
            ++n3;
            ++n2;
        }
        n3 = 0;
        while (n3 < this.f2) {
            int n4 = n3 + this.f1;
            string = Integer.toString(n3 + 1);
            if (n2 == this.f4) {
                this.m4(graphics, fontMetrics, string, Color.red, n4, n);
            } else {
                this.m4(graphics, fontMetrics, string, this.getForeground(), n4, n);
            }
            ++n3;
            ++n2;
        }
        n3 = 0;
        while (n3 < 42 - this.f2 - this.f1) {
            int n5 = n3 + this.f1 + this.f2;
            string = Integer.toString(n3 + 1);
            if (n2 == this.f4) {
                this.m4(graphics, fontMetrics, string, Color.red, n5, n);
            } else {
                this.m4(graphics, fontMetrics, string, SystemColor.inactiveCaption, n5, n);
            }
            ++n3;
            ++n2;
        }
    }

    private final void m4(Graphics graphics, FontMetrics fontMetrics, String string, Color color, int n, int n2) {
        graphics.setColor(color);
        int n3 = (this.f9 - fontMetrics.stringWidth(string) >> 1) + n % 7 * this.f9;
        graphics.drawString(string, n3, this.f7 + this.f8 * (n / 7) + n2);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 500: {
                return;
            }
            case 501: {
                this.mousePressed(mouseEvent);
                return;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.f10 = this.getCellFromEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.getCellFromEvent(mouseEvent);
        if (n != -1 && n == this.f10) {
            this.validEvent = true;
            if (this.isIndexSelected(n)) {
                if (mouseEvent.getClickCount() < 2) {
                    this.deselect(n);
                }
            } else {
                this.select(n);
            }
            if (mouseEvent.getClickCount() > 1) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, Integer.toString(n));
                this.fireActionPerformed(actionEvent);
            } else {
                ItemEvent itemEvent = new ItemEvent(this, 701, new Integer(n), this.isIndexSelected(n) ? 1 : 2);
                this.fireItemStateChanged(itemEvent);
            }
        } else {
            this.validEvent = false;
        }
        this.repaint();
    }

    protected int getCellFromEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        if (n < this.f7 || n > this.f8 * 6 + this.f7) {
            return -1;
        }
        int n2 = (n - this.f7) / this.f8;
        int n3 = mouseEvent.getX() / this.f9;
        int n4 = n2 * 7 + n3;
        if (n4 > 41) {
            n4 = -1;
        }
        return n4;
    }

    public void setSelectedItems(int[] nArray) {
        this.deselectAll();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0 && nArray[n] < 42) {
                this.f6[nArray[n]] = true;
            }
            ++n;
        }
    }

    public void select(int n) {
        if (n > this.f6.length || n < 0) {
            throw new IndexOutOfBoundsException("No such item");
        }
        if (!this.f6[n]) {
            if (this.multipleMode) {
                this.f6[n] = true;
            } else {
                int n2 = 0;
                while (n2 < 42) {
                    this.f6[n2] = false;
                    ++n2;
                }
                this.f6[n] = true;
            }
            this.repaint();
        }
    }

    public void deselectAll() {
        int n = 0;
        while (n < this.f6.length) {
            this.f6[n] = false;
            ++n;
        }
        this.repaint();
    }

    public void deselect(int n) {
        if (n > this.f6.length || n < 0) {
            throw new IndexOutOfBoundsException("No such item");
        }
        if (this.f6[n]) {
            this.f6[n] = false;
            this.repaint();
        }
    }

    public int getSelectedIndex() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.f6.length) {
            if (this.f6[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public boolean isIndexSelected(int n) {
        if (n > this.f6.length || n < 0) {
            throw new IndexOutOfBoundsException("No such item");
        }
        return this.f6[n];
    }

    public void setMultipleMode(boolean bl) {
        this.multipleMode = bl;
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.f11 != null && this.f11.contains(actionListener)) {
            Vector vector = (Vector)this.f11.clone();
            vector.removeElement(actionListener);
            this.f11 = vector;
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        Vector vector = this.f11 == null ? new Vector(2) : (Vector)this.f11.clone();
        if (!vector.contains(actionListener)) {
            vector.addElement(actionListener);
            this.f11 = vector;
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.f11 != null) {
            Vector vector = this.f11;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ActionListener)vector.elementAt(n2)).actionPerformed(actionEvent);
                ++n2;
            }
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (this.f12 != null && this.f12.contains(itemListener)) {
            Vector vector = (Vector)this.f12.clone();
            vector.removeElement(itemListener);
            this.f12 = vector;
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        Vector vector = this.f12 == null ? new Vector(2) : (Vector)this.f12.clone();
        if (!vector.contains(itemListener)) {
            vector.addElement(itemListener);
            this.f12 = vector;
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (this.f12 != null) {
            Vector vector = this.f12;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((ItemListener)vector.elementAt(n2)).itemStateChanged(itemEvent);
                ++n2;
            }
        }
    }

    public Object[] getSelectedObjects() {
        int n = this.m5();
        Object[] objectArray = new Integer[n + n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 42 && n2 < n) {
            if (this.f6[n3]) {
                objectArray[n2] = new Integer(n3);
                ++n2;
            }
            ++n3;
        }
        return objectArray;
    }

    private final int m5() {
        int n = 0;
        int n2 = 0;
        while (n2 < 42) {
            if (this.f6[n2]) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int[] getSelectedIndexes() {
        int n = this.m5();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 42 && n2 < n) {
            if (this.f6[n3]) {
                nArray[n2] = n3;
                ++n2;
            }
            ++n3;
        }
        return nArray;
    }

    public Calendar() {
        this.enableEvents(16L);
    }
}

