/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SingleByteCharsetConverter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class StringUtils {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes;
    private static char[] byteToChars;

    public static final byte[] getBytes(String s, String encoding) throws UnsupportedEncodingException {
        SingleByteCharsetConverter converter = SingleByteCharsetConverter.getInstance(encoding);
        return StringUtils.getBytes(s, converter, encoding);
    }

    public static final byte[] getBytes(String s, SingleByteCharsetConverter converter, String encoding) throws UnsupportedEncodingException {
        byte[] b = null;
        if (converter != null) {
            b = converter.toBytes(s);
        } else if (encoding == null) {
            b = s.getBytes();
        } else {
            b = s.getBytes(encoding);
            if (encoding.equalsIgnoreCase("SJIS") || encoding.equalsIgnoreCase("BIG5") || encoding.equalsIgnoreCase("GBK")) {
                b = StringUtils.escapeSJISByteStream(b);
            }
        }
        return b;
    }

    public static final String toAsciiString(byte[] buffer) {
        return StringUtils.toAsciiString(buffer, 0, buffer.length);
    }

    public static final String toAsciiString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        int i = 0;
        while (i < length) {
            charArray[i] = (char)buffer[readpoint];
            ++readpoint;
            ++i;
        }
        return new String(charArray);
    }

    public static byte[] escapeSJISByteStream(byte[] origBytes) {
        if (origBytes == null || origBytes.length == 0) {
            return origBytes;
        }
        int stringLen = origBytes.length;
        int bufIndex = 0;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(stringLen);
        do {
            int loByte;
            if ((loByte = origBytes[bufIndex]) < 0) {
                loByte += 256;
            }
            bytesOut.write(loByte);
            if (loByte == 92) {
                bytesOut.write(92);
                continue;
            }
            if ((loByte < 129 || loByte > 159) && (loByte < 224 || loByte > 252) || bufIndex >= stringLen - 1) continue;
            int hiByte = origBytes[bufIndex + 1];
            if (hiByte < 0) {
                hiByte += 256;
            }
            bytesOut.write(hiByte);
            ++bufIndex;
            if (hiByte != 92) continue;
            bytesOut.write(hiByte);
        } while (++bufIndex < stringLen);
        return bytesOut.toByteArray();
    }

    public static char firstNonWsCharUc(String searchIn) {
        if (searchIn == null) {
            return '\u0000';
        }
        int length = searchIn.length();
        int i = 0;
        while (i < length) {
            char c = searchIn.charAt(i);
            if (!Character.isWhitespace(c)) {
                return Character.toUpperCase(c);
            }
            ++i;
        }
        return '\u0000';
    }

    public static boolean startsWithIgnoreCase(String searchIn, String searchFor) {
        return StringUtils.startsWithIgnoreCase(searchIn, 0, searchFor);
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, 0, searchFor, startAt, searchFor.length());
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        int beginPos = 0;
        int inLength = searchIn.length();
        beginPos = 0;
        while (beginPos < inLength) {
            if (!Character.isWhitespace(searchIn.charAt(beginPos))) break;
            ++beginPos;
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    static {
        BYTE_RANGE = 256;
        allBytes = new byte[256];
        byteToChars = new char[256];
        int i = -128;
        while (i <= 127) {
            StringUtils.allBytes[i - -128] = (byte)i;
            ++i;
        }
        String allBytesString = new String(allBytes, 0, 255);
        int allBytesStringLen = allBytesString.length();
        int i2 = 0;
        while (i2 < 255 && i2 < allBytesStringLen) {
            StringUtils.byteToChars[i2] = allBytesString.charAt(i2);
            ++i2;
        }
    }
}

