/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class Shutdown {
    private static final String COMMAND = "/jmx-console/HtmlAdaptor?action=invokeOpByName&name=jboss.system%3Atype%3DServer&methodName=shutdown";

    public static void main(String[] args) throws Exception {
        String protocol = "http";
        String host = "localhost";
        String username = null;
        String password = null;
        String command = COMMAND;
        int port = 8080;
        if (args.length > 0) {
            if (args[0].startsWith("-h") || args[0].startsWith("-?")) {
                System.out.println("Usage: Shutdown [host [port [protocol]]] [-u username] [-p password] [-c shutdown_command]");
                System.exit(0);
            }
            int a = 0;
            while (a < args.length) {
                if (args[a].startsWith("-u")) {
                    username = args[++a];
                } else if (args[a].startsWith("-p")) {
                    password = args[++a];
                } else if (args[a].startsWith("-c")) {
                    command = URLEncoder.encode(args[++a]);
                } else if (a == 0) {
                    host = args[0];
                } else if (a == 1) {
                    port = Integer.parseInt(args[1]);
                } else if (a == 2) {
                    protocol = args[2];
                }
                ++a;
            }
        }
        Shutdown.shutdown(protocol, host, port, username, password, command);
    }

    public static void shutdown(String protocol, String host, int port, String username, String password, String command) {
        try {
            System.out.println("Shutting down server " + protocol + "://" + host + ":" + port);
            if (username != null && password != null) {
                Authenticator.setDefault(new PasswordAuthenticator(username, password));
            }
            URL url = new URL("http", host, port, command);
            System.out.println(url);
            URLConnection conn = url.openConnection();
            conn.getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Shutdown complete");
    }

    static class PasswordAuthenticator
    extends Authenticator {
        private String username;
        private char[] password = new char[0];

        PasswordAuthenticator(String username, String password) {
            this.username = username;
            if (password != null) {
                this.password = password.toCharArray();
            }
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            PasswordAuthentication auth = new PasswordAuthentication(this.username, this.password);
            return auth;
        }
    }
}

