/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.ls.DOMWriter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer
implements DOMWriter {
    protected static final boolean DEBUG = false;
    protected final NamespaceSupport fNSBinder = new NamespaceSupport();
    protected final NamespaceSupport fLocalNSBinder = new NamespaceSupport();
    protected final SymbolTable fSymbolTable = new SymbolTable();
    protected String fEmptySymbol;
    protected String fXmlSymbol;
    protected String fXmlnsSymbol;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    private boolean fPreserveSpace;
    private String fEncoding;
    private String fLastEncoding;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(Writer writer, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(OutputStream output, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(output);
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("xml", null, false));
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        boolean addNSAttr = false;
        try {
            String value;
            String name;
            String prefix;
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(localName == null || localName.length() == 0 ? rawName : localName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            attrs = this.extractNamespaces(attrs);
            if (rawName == null || rawName.length() == 0) {
                if (localName == null) {
                    throw new SAXException("No rawName and localName is null");
                }
                rawName = namespaceURI != null && !namespaceURI.equals("") ? ((prefix = this.getPrefix(namespaceURI)) != null && prefix.length() > 0 ? prefix + ":" + localName : localName) : localName;
                addNSAttr = true;
            }
            this._printer.printText('<');
            this._printer.printText(rawName);
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this._printer.printSpace();
                    name = attrs.getQName(i);
                    if (name != null && name.length() == 0) {
                        name = attrs.getLocalName(i);
                        String attrURI = attrs.getURI(i);
                        if (!(attrURI == null || attrURI.length() == 0 || namespaceURI != null && namespaceURI.length() != 0 && attrURI.equals(namespaceURI) || (prefix = this.getPrefix(attrURI)) == null || prefix.length() <= 0)) {
                            name = prefix + ":" + name;
                        }
                    }
                    if ((value = attrs.getValue(i)) == null) {
                        value = "";
                    }
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                    if (name.equals("xml:space")) {
                        preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++i;
                }
            }
            if (this._prefixes != null) {
                Enumeration enumeration = this._prefixes.keys();
                while (enumeration.hasMoreElements()) {
                    this._printer.printSpace();
                    value = (String)enumeration.nextElement();
                    name = (String)this._prefixes.get(value);
                    if (name.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
            }
            state = this.enterElementState(namespaceURI, localName, rawName, preserveSpace);
            name = localName == null || localName.length() == 0 ? rawName : namespaceURI + "^" + localName;
            state.doCData = this._format.isCDataElement(name);
            state.unescaped = this._format.isNonEscapingElement(name);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            this.endElementIO(namespaceURI, localName, rawName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty) {
            this._printer.printText("/>");
        } else {
            if (state.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !state.preserveSpace && (state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(state.rawName);
            this._printer.printText('>');
        }
        state = this.leaveElementState();
        state.afterElement = true;
        state.afterComment = false;
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        try {
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(tagName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(tagName);
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this._printer.printSpace();
                    String name = attrs.getName(i);
                    String value = attrs.getValue(i);
                    if (value != null) {
                        this._printer.printText(name);
                        this._printer.printText("=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                    }
                    if (name.equals("xml:space")) {
                        preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++i;
                }
            }
            state = this.enterElementState(null, null, tagName, preserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String tagName) throws SAXException {
        this.endElement(null, null, tagName);
    }

    protected void startDocument(String rootTagName) throws IOException {
        String dtd = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer buffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    buffer.append(this._format.getVersion());
                } else {
                    buffer.append("1.0");
                }
                buffer.append('\"');
                if (this._format.getEncoding() != null) {
                    buffer.append(" encoding=\"");
                    buffer.append(this._format.getEncoding());
                    buffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    buffer.append(" standalone=\"yes\"");
                }
                buffer.append("?>");
                this._printer.printText(buffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int i = 0;
                            while (i < 18 + rootTagName.length()) {
                                this._printer.printText(" ");
                                ++i;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (dtd != null && dtd.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(dtd, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (dtd != null && dtd.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    this._printer.printText(" [");
                    this.printText(dtd, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    /*
     * Unable to fully structure code
     */
    protected void serializeElement(Element elem) throws IOException {
        block50: {
            this.fLocalNSBinder.reset(this.fSymbolTable);
            this.fLocalNSBinder.pushContext();
            this.fNSBinder.pushContext();
            tagName = elem.getTagName();
            state = this.getElementState();
            if (this.isDocumentState()) {
                v0 = this.fDOML1 = elem.getLocalName() == null;
                if (!this._started) {
                    this.startDocument(tagName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            this.fPreserveSpace = state.preserveSpace;
            attrMap = elem.getAttributes();
            length = false;
            uri = elem.getNamespaceURI();
            prefix = elem.getPrefix();
            if (uri != null && prefix != null && uri.length() == 0 && prefix.length() != 0) {
                prefix = null;
                this._printer.printText('<');
                this._printer.printText(elem.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(tagName);
                this._printer.indent();
            }
            if (uri != null) {
                uri = this.fSymbolTable.addSymbol(uri);
                v1 = prefix = prefix == null ? this.fEmptySymbol : this.fSymbolTable.addSymbol(prefix);
                if (this.fNSBinder.getURI(prefix) != uri) {
                    this.printNamespaceAttr(prefix, uri);
                    this.fLocalNSBinder.declarePrefix(prefix, uri);
                    this.fNSBinder.declarePrefix(prefix, uri);
                }
            } else {
                colon = tagName.indexOf(58);
                if (colon > -1) {
                    colon2 = tagName.lastIndexOf(58);
                    if (colon != colon2) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("Element's name is not a QName: " + tagName, (short)1);
                            continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                        }
                    } else if (this.fDOMErrorHandler != null) {
                        this.modifyDOMError("Element <" + tagName + "> does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0);
                        continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                } else {
                    uri = this.fNSBinder.getURI(this.fEmptySymbol);
                    if (uri != null && uri.length() > 0) {
                        this.printNamespaceAttr(this.fEmptySymbol, this.fEmptySymbol);
                        this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                        this.fNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                    }
                }
            }
            if (attrMap == null) break block50;
            i = 0;
            while (i < attrMap.getLength()) {
                block52: {
                    block51: {
                        attr = (Attr)attrMap.item(i);
                        value = attr.getValue();
                        name = attr.getNodeName();
                        uri = attr.getNamespaceURI();
                        if (uri != null && uri.length() == 0) {
                            uri = null;
                            name = attr.getLocalName();
                        }
                        if (value == null) {
                            value = this.fEmptySymbol;
                        }
                        if (uri == null) break block51;
                        prefix = attr.getPrefix();
                        prefix = prefix == null ? this.fEmptySymbol : this.fSymbolTable.addSymbol(prefix);
                        localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (prefix == this.fXmlnsSymbol) {
                            uri = this.fNSBinder.getURI(localpart);
                            localUri = this.fLocalNSBinder.getURI(localpart);
                            value = this.fSymbolTable.addSymbol(value);
                            if ((uri == null || localUri == null) && value.length() != 0) {
                                this.printNamespaceAttr(localpart, value);
                                this.fNSBinder.declarePrefix(localpart, value);
                                this.fLocalNSBinder.declarePrefix(localpart, value);
                            }
                        } else if (localpart == this.fXmlnsSymbol && prefix == this.fEmptySymbol) {
                            uri = this.fNSBinder.getURI(this.fEmptySymbol);
                            localUri = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                            value = this.fSymbolTable.addSymbol(value);
                            if (localUri == null) {
                                this.printNamespaceAttr(this.fEmptySymbol, value);
                                this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, value);
                                this.fNSBinder.declarePrefix(this.fEmptySymbol, value);
                            }
                        } else {
                            uri = this.fSymbolTable.addSymbol(uri);
                            declaredURI = this.fNSBinder.getURI(prefix);
                            if (prefix == this.fEmptySymbol || declaredURI != uri) {
                                name = attr.getNodeName();
                                declaredPrefix = this.fNSBinder.getPrefix(uri);
                                if (declaredPrefix == null || declaredPrefix == this.fEmptySymbol) {
                                    if (prefix == this.fEmptySymbol) {
                                        prefix = "NS" + this.fNamespaceCounter++;
                                    }
                                    this.printNamespaceAttr(prefix, uri);
                                    value = this.fSymbolTable.addSymbol(value);
                                    this.fLocalNSBinder.declarePrefix(prefix, value);
                                    this.fNSBinder.declarePrefix(prefix, uri);
                                } else {
                                    prefix = declaredPrefix;
                                }
                                name = prefix + ":" + localpart;
                            }
                            this.printAttribute(name, value == null ? this.fEmptySymbol : value, attr.getSpecified());
                        }
                        break block52;
                    }
                    colon = name.indexOf(58);
                    colon2 = name.lastIndexOf(58);
                    if (!name.startsWith(this.fXmlnsSymbol)) ** GOTO lbl156
                    if (colon < 0) {
                        uri = this.fNSBinder.getURI(this.fEmptySymbol);
                        localUri = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                        if (localUri == null) {
                            value = this.fSymbolTable.addSymbol(value);
                            this.fNSBinder.declarePrefix(this.fEmptySymbol, value);
                            this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, value);
                            this.printAttribute(name, value, attr.getSpecified());
                        }
                    } else {
                        if (colon == colon2) {
                            prefix = name.substring(6);
                            v2 = prefix = prefix.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(prefix);
                            if (prefix.length() == 0) {
                                if (this.fDOMErrorHandler != null) {
                                    this.modifyDOMError("Namespace declaration syntax is incorrect " + name, (short)1);
                                    continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (value.length() == 0 && this.fDOMErrorHandler != null) {
                                this.modifyDOMError("Namespace declaration syntax is incorrect " + name, (short)1);
                                continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                            uri = this.fNSBinder.getURI(prefix);
                            localUri = this.fLocalNSBinder.getURI(prefix);
                            if ((uri == null || localUri == null) && value.length() != 0) {
                                value = this.fSymbolTable.addSymbol(value);
                                this.fNSBinder.declarePrefix(prefix, value);
                                this.fLocalNSBinder.declarePrefix(prefix, value);
                            }
                        }
lbl156:
                        // 6 sources

                        if (colon > -1) {
                            if (colon != colon2) {
                                if (this.fDOMErrorHandler != null) {
                                    this.modifyDOMError("Attribute's name is not a QName: " + name, (short)1);
                                    continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (this.fDOMErrorHandler != null) {
                                this.modifyDOMError("Attribute '" + name + "' does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0);
                                continueProcess = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                            this.printAttribute(name, value, attr.getSpecified());
                        } else {
                            this.printAttribute(name, value, attr.getSpecified());
                        }
                    }
                }
                ++i;
            }
        }
        if (elem.hasChildNodes()) {
            state = this.enterElementState(null, null, tagName, this.fPreserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
            child = elem.getFirstChild();
            while (child != null) {
                this.serializeNode(child);
                child = child.getNextSibling();
            }
            this.fNSBinder.popContext();
            this.endElementIO(null, null, tagName);
        } else {
            this.fNSBinder.popContext();
            this._printer.unindent();
            this._printer.printText("/>");
            state.afterElement = true;
            state.afterComment = false;
            state.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String prefix, String uri) throws IOException {
        this._printer.printSpace();
        if (prefix == this.fEmptySymbol) {
            this._printer.printText(this.fXmlnsSymbol);
        } else {
            this._printer.printText(this.fXmlnsSymbol + ":" + prefix);
        }
        this._printer.printText("=\"");
        this.printEscaped(uri);
        this._printer.printText('\"');
    }

    private void printAttribute(String name, String value, boolean isSpecified) throws IOException {
        if (isSpecified || !this.getFeature("discard-default-content")) {
            this._printer.printSpace();
            this._printer.printText(name);
            this._printer.printText("=\"");
            this.printEscaped(value);
            this._printer.printText('\"');
        }
        if (name.equals("xml:space")) {
            this.fPreserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int ch) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attrs) throws SAXException {
        if (attrs == null) {
            return null;
        }
        int length = attrs.getLength();
        AttributesImpl attrsOnly = new AttributesImpl(attrs);
        int i = length - 1;
        while (i >= 0) {
            String rawName = attrsOnly.getQName(i);
            if (rawName.startsWith("xmlns")) {
                if (rawName.length() == 5) {
                    this.startPrefixMapping("", attrs.getValue(i));
                    attrsOnly.removeAttribute(i);
                } else if (rawName.charAt(5) == ':') {
                    this.startPrefixMapping(rawName.substring(6), attrs.getValue(i));
                    attrsOnly.removeAttribute(i);
                }
            }
            --i;
        }
        return attrsOnly;
    }

    private void initFeatures() {
        this.fFeatures.put("normalize-characters", new Boolean(false));
        this.fFeatures.put("split-cdata-sections", new Boolean(true));
        this.fFeatures.put("validation", new Boolean(false));
        this.fFeatures.put("expand-entity-references", new Boolean(false));
        this.fFeatures.put("whitespace-in-element-content", new Boolean(true));
        this.fFeatures.put("discard-default-content", new Boolean(true));
        this.fFeatures.put("format-canonical", new Boolean(false));
        this.fFeatures.put("format-pretty-print", new Boolean(false));
    }

    private void checkAllFeatures() {
        if (this.getFeature("whitespace-in-element-content")) {
            this._format.setPreserveSpace(true);
        } else {
            this._format.setPreserveSpace(false);
        }
    }

    public void setFeature(String name, boolean state) throws DOMException {
        if (name != null && this.fFeatures.containsKey(name)) {
            if (!this.canSetFeature(name, state)) {
                throw new DOMException(9, "Feature " + name + " cannot be set as " + state);
            }
        } else {
            throw new DOMException(8, "Feature " + name + " not found");
        }
        this.fFeatures.put(name, new Boolean(state));
    }

    public boolean canSetFeature(String name, boolean state) {
        if (name.equals("normalize-characters") && state) {
            return false;
        }
        if (name.equals("validation") && state) {
            return false;
        }
        if (name.equals("whitespace-in-element-content") && !state) {
            return false;
        }
        if (name.equals("format-canonical") && state) {
            return false;
        }
        return !name.equals("format-pretty-print") || !state;
    }

    public boolean getFeature(String name) throws DOMException {
        Boolean state = (Boolean)this.fFeatures.get(name);
        if (state == null) {
            throw new DOMException(8, "Feature " + name + " not found");
        }
        return state;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this._format.setEncoding(encoding);
        this.fEncoding = this._format.getEncoding();
    }

    public String getLastEncoding() {
        return this.fLastEncoding;
    }

    public String getNewLine() {
        return this._format.getLineSeparator();
    }

    public void setNewLine(String newLine) {
        this._format.setLineSeparator(newLine);
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler errorHandler) {
        this.fDOMErrorHandler = errorHandler;
    }

    public boolean writeNode(OutputStream destination, Node wnode) throws Exception {
        block7: {
            this.checkAllFeatures();
            try {
                this.setOutputByteStream(destination);
                if (wnode == null) {
                    return false;
                }
                if (wnode.getNodeType() == 9) {
                    this.serialize((Document)wnode);
                    break block7;
                }
                if (wnode.getNodeType() == 11) {
                    this.serialize((DocumentFragment)wnode);
                    break block7;
                }
                if (wnode.getNodeType() == 1) {
                    this.serialize((Element)wnode);
                    break block7;
                }
                return false;
            }
            catch (NullPointerException npe) {
                throw npe;
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
        this.fLastEncoding = this.getEncoding();
        return true;
    }

    public String writeToString(Node wnode) throws DOMException {
        StringWriter destination;
        block6: {
            this.checkAllFeatures();
            destination = new StringWriter();
            try {
                this.setOutputCharStream(destination);
                if (wnode == null) {
                    return null;
                }
                if (wnode.getNodeType() == 9) {
                    this.serialize((Document)wnode);
                    break block6;
                }
                if (wnode.getNodeType() == 11) {
                    this.serialize((DocumentFragment)wnode);
                    break block6;
                }
                if (wnode.getNodeType() == 1) {
                    this.serialize((Element)wnode);
                    break block6;
                }
                return null;
            }
            catch (IOException ioe) {
                throw new DOMException(2, "The resulting string is too long to fit in a DOMString: " + ioe.getMessage());
            }
        }
        this.fLastEncoding = this.getEncoding();
        return destination.toString();
    }

    public boolean reset() {
        super.reset();
        this.fNSBinder.reset(this.fSymbolTable);
        this.fNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
        this.fNamespaceCounter = 1;
        this.fXmlSymbol = this.fSymbolTable.addSymbol("xml");
        this.fXmlnsSymbol = this.fSymbolTable.addSymbol("xmlns");
        this.fEmptySymbol = this.fSymbolTable.addSymbol("");
        return true;
    }
}

