/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.validation;

import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

public class XMLGrammarPoolImpl
implements XMLGrammarPool {
    protected static final int TABLE_SIZE = 11;
    protected Entry[] fGrammars = null;
    private static final boolean DEBUG = false;

    public XMLGrammarPoolImpl() {
        this.fGrammars = new Entry[11];
    }

    public XMLGrammarPoolImpl(int initialCapacity) {
        this.fGrammars = new Entry[initialCapacity];
    }

    public Grammar[] retrieveInitialGrammarSet(String grammarType) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int grammarSize = this.fGrammars.length;
            Grammar[] tempGrammars = new Grammar[grammarSize];
            int pos = 0;
            int i = 0;
            while (i < grammarSize) {
                Entry e = this.fGrammars[i];
                while (e != null) {
                    if (e.desc.getGrammarType().equals(grammarType)) {
                        tempGrammars[pos++] = e.grammar;
                    }
                    e = e.next;
                }
                ++i;
            }
            Grammar[] toReturn = new Grammar[pos];
            System.arraycopy(tempGrammars, 0, toReturn, 0, pos);
            Grammar[] grammarArray = toReturn;
            return grammarArray;
        }
    }

    public void cacheGrammars(String grammarType, Grammar[] grammars) {
        int i = 0;
        while (i < grammars.length) {
            this.putGrammar(grammars[i]);
            ++i;
        }
    }

    public Grammar retrieveGrammar(XMLGrammarDescription desc) {
        return this.getGrammar(desc);
    }

    public void putGrammar(Grammar grammar) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            Entry entry;
            XMLGrammarDescription desc = grammar.getGrammarDescription();
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry2 = this.fGrammars[index];
            while (entry2 != null) {
                if (entry2.hash == hash && this.equals(entry2.desc, desc)) {
                    entry2.grammar = grammar;
                    return;
                }
                entry2 = entry2.next;
            }
            this.fGrammars[index] = entry = new Entry(hash, desc, grammar, this.fGrammars[index]);
        }
    }

    public Grammar getGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    Grammar grammar = entry.grammar;
                    return grammar;
                }
                entry = entry.next;
            }
            Grammar grammar = null;
            return grammar;
        }
    }

    public Grammar removeGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            Entry prev = null;
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    if (prev != null) {
                        prev.next = entry.next;
                    } else {
                        this.fGrammars[index] = entry.next;
                    }
                    Grammar tempGrammar = entry.grammar;
                    entry.grammar = null;
                    Grammar grammar = tempGrammar;
                    return grammar;
                }
                prev = entry;
                entry = entry.next;
            }
            Grammar grammar = null;
            return grammar;
        }
    }

    public boolean containsGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    boolean bl = true;
                    return bl;
                }
                entry = entry.next;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean equals(XMLGrammarDescription desc1, XMLGrammarDescription desc2) {
        return desc1.equals(desc2);
    }

    public int hashCode(XMLGrammarDescription desc) {
        return desc.hashCode();
    }

    public void print(XMLGrammarDescription description) {
        if (!description.getGrammarType().equals("DTD") && description.getGrammarType().equals("XSD")) {
            XSDDescription schema = (XSDDescription)description;
            System.out.println("Context = " + schema.getContextType());
            System.out.println("TargetNamespace = " + schema.getTargetNamespace());
            String[] temp = schema.getLocationHints();
            int i = 0;
            while (temp != null && i < temp.length) {
                System.out.println("LocationHint " + i + " = " + temp[i]);
                ++i;
            }
            System.out.println("Triggering Component = " + schema.getTriggeringComponent());
            System.out.println("EnclosingElementName =" + schema.getEnclosingElementName());
        }
    }

    protected static final class Entry {
        public int hash;
        public XMLGrammarDescription desc;
        public Grammar grammar;
        public Entry next;

        protected Entry(int hash, XMLGrammarDescription desc, Grammar grammar, Entry next) {
            this.hash = hash;
            this.desc = desc;
            this.grammar = grammar;
            this.next = next;
        }
    }
}

