/*
 * Decompiled with CFR 0.152.
 */
package com.jeans.trayicon;

import com.jeans.trayicon.TrayDummyComponent;
import com.jeans.trayicon.TrayIconCallback;
import com.jeans.trayicon.TrayIconException;
import com.jeans.trayicon.TrayIconKeeper;
import com.jeans.trayicon.TrayIconPopup;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.PixelGrabber;
import java.util.Enumeration;
import java.util.Vector;

public class WindowsTrayIcon {
    public static final String TRAY_VERSION = "1.7.6";
    private static TrayIconKeeper m_Keeper;
    private static TrayDummyComponent m_Dummy;
    private static MouseListener m_MouseHook;
    private static Window m_CurrentWindow;
    public static final int BALLOON_NONE = 0;
    public static final int BALLOON_INFO = 1;
    public static final int BALLOON_WARNING = 2;
    public static final int BALLOON_ERROR = 3;
    public static final int BALLOON_NOSOUND = 16;
    public static final int NOERR = 0;
    public static final int NOTIFYPROCERR = -1;
    public static final int TOOMANYICONS = -2;
    public static final int NOTENOUGHMEM = -3;
    public static final int WRONGICONID = -4;
    public static final int DLLNOTFOUND = -5;
    public static final int NOVMS = -6;
    public static final int ERRTHREAD = -7;
    public static final int METHODID = -8;
    public static final int NOLISTENER = -9;
    public static final int JNIERR = -10;
    public static final int WIN_VER_UNKNOWN = 0;
    public static final int WIN_VER_WIN32 = 1;
    public static final int WIN_VER_95 = 2;
    public static final int WIN_VER_98 = 3;
    public static final int WIN_VER_ME = 4;
    public static final int WIN_VER_NT = 5;
    public static final int WIN_VER_2K = 6;
    public static final int WIN_VER_XP = 7;
    public static final int WIN_VER_NET = 8;
    private int m_ID = WindowsTrayIcon.getFreeId();
    private TrayIconPopup m_Popup;
    private Vector m_ActList;
    private Vector m_MouseList;
    private static TrayIconCallback m_WMessageCallback;
    private static final int MOUSE_BTN_UP = 1;
    private static final int MOUSE_BTN_DOUBLE = 2;
    static final int POPUP_TYPE_ITEM = 0;
    static final int POPUP_TYPE_SEPARATOR = 1;
    static final int POPUP_TYPE_CHECKBOX = 2;
    static final int POPUP_TYPE_INIT_LEVEL = 3;
    static final int POPUP_TYPE_DONE_LEVEL = 4;
    static final int POPUP_MODE_ENABLE = 1;
    static final int POPUP_MODE_CHECK = 2;
    static final int POPUP_MODE_DEFAULT = 4;

    static {
        boolean ok = false;
        String version = System.getProperty("java.version");
        if (version.length() >= 3) {
            String v1 = version.substring(0, 3);
            if (v1.equals("1.1")) {
                System.loadLibrary("TrayIcon11");
                ok = true;
            } else {
                System.loadLibrary("TrayIcon12");
                ok = true;
            }
        }
        if (!ok) {
            System.out.println("Wrong Java VM version: " + version);
            System.exit(-1);
        }
    }

    public static native void initTrayIcon(String var0);

    public static void cleanUp() {
        if (m_Keeper != null) {
            m_Keeper.doNotify();
            m_Keeper = null;
        }
        WindowsTrayIcon.termTrayIcon();
    }

    public WindowsTrayIcon(Image image, int w, int h) throws TrayIconException, InterruptedException {
        if (this.m_ID == -2) {
            throw new TrayIconException("Too many icons allocated");
        }
        if (this.m_ID == -5) {
            throw new TrayIconException("Error initializing native code DLL");
        }
        if (this.m_ID == -1) {
            throw new TrayIconException("Error setting up Windows notify procedure");
        }
        this.setImage(image, w, h);
    }

    public void setImage(Image image, int w, int h) throws TrayIconException, InterruptedException {
        try {
            int[] pixels = new int[w * h];
            PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
            pg.grabPixels();
            if ((pg.getStatus() & 0x80) != 0) {
                this.freeIcon();
                throw new TrayIconException("Error loading icon image");
            }
            WindowsTrayIcon.setIconData(this.m_ID, w, h, pixels);
        }
        catch (InterruptedException ex) {
            this.freeIcon();
            throw ex;
        }
        catch (NullPointerException ex) {
            this.freeIcon();
            throw ex;
        }
    }

    public void setVisible(boolean status) {
        WindowsTrayIcon.showIcon(this.m_ID, status);
    }

    public boolean isVisible() {
        return WindowsTrayIcon.testVisible(this.m_ID) == 1;
    }

    public void setToolTipText(String tip) {
        WindowsTrayIcon.setToolTip(this.m_ID, tip);
    }

    public void showBalloon(String msg, String title, int timeout, int flags) {
        WindowsTrayIcon.showBalloon(this.m_ID, msg, title, timeout, flags);
    }

    public void addActionListener(ActionListener listener) {
        if (this.m_ActList == null) {
            this.m_ActList = new Vector();
            WindowsTrayIcon.clickEnable(this, this.m_ID, true);
        }
        this.m_ActList.addElement(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.m_ActList.removeElement(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.m_MouseList == null) {
            this.m_MouseList = new Vector();
            WindowsTrayIcon.clickEnable(this, this.m_ID, true);
        }
        this.m_MouseList.addElement(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.m_MouseList.removeElement(listener);
    }

    public void setPopup(TrayIconPopup popup) {
        if (popup == null) {
            this.m_Popup = null;
            WindowsTrayIcon.initPopup(this.m_ID, -1);
        } else {
            if (this.m_Popup == null) {
                WindowsTrayIcon.clickEnable(this, this.m_ID, true);
            }
            int levels = popup.getNbLevels();
            WindowsTrayIcon.initPopup(this.m_ID, levels);
            popup.setTrayIcon(this, this.m_ID, -1);
            this.m_Popup = popup;
        }
    }

    public void freeIcon() {
        WindowsTrayIcon.clickEnable(this, this.m_ID, false);
        WindowsTrayIcon.freeIcon(this.m_ID);
    }

    public static native void setAlwaysOnTop(Component var0, boolean var1);

    public static native int getLastError();

    public static native boolean isRunning(String var0);

    public static native int sendWindowsMessage(String var0, int var1);

    public static void setWindowsMessageCallback(TrayIconCallback callback) {
        m_WMessageCallback = callback;
    }

    public static void keepAlive() {
        if (m_Keeper == null) {
            m_Keeper = new TrayIconKeeper();
            m_Keeper.start();
        }
    }

    public static void setCurrentWindow(Window wnd) {
        m_CurrentWindow = wnd;
    }

    public static native String getWindowsVersionString();

    public static native int getWindowsVersion();

    public static boolean supportsBallonInfo() {
        int version = WindowsTrayIcon.getWindowsVersion();
        return version >= 6;
    }

    public static TrayDummyComponent getDummyComponent() {
        if (m_Dummy == null) {
            m_Dummy = new TrayDummyComponent();
        }
        return m_Dummy;
    }

    private void notifyMouseListeners(int button, int mask, int xp, int yp) {
        boolean up;
        int clicks = (mask & 2) != 0 ? 2 : 1;
        boolean bl = up = (mask & 1) != 0;
        if (this.m_ActList != null && clicks == 1 && !up) {
            ActionEvent evt = null;
            evt = button == 0 ? new ActionEvent(this, 0, "Left") : (button == 1 ? new ActionEvent(this, 0, "Right") : new ActionEvent(this, 0, "Middle"));
            Enumeration enumeration = this.m_ActList.elements();
            while (enumeration.hasMoreElements()) {
                ActionListener listener = (ActionListener)enumeration.nextElement();
                listener.actionPerformed(evt);
            }
        }
        if (this.m_MouseList != null) {
            int modifiers = 0;
            modifiers = button == 0 ? (modifiers |= 0x10) : (button == 1 ? (modifiers |= 8) : (modifiers |= 4));
            MouseEvent evt = new MouseEvent(WindowsTrayIcon.getDummyComponent(), 0, 0L, modifiers, xp, yp, clicks, button == 1);
            Enumeration enumeration = this.m_MouseList.elements();
            while (enumeration.hasMoreElements()) {
                MouseListener listener = (MouseListener)enumeration.nextElement();
                if (up) {
                    listener.mouseReleased(evt);
                    continue;
                }
                listener.mousePressed(evt);
            }
        }
    }

    private void notifyMenuListeners(int id) {
        if (this.m_Popup != null) {
            this.m_Popup.onSelected(id);
        }
    }

    private static int callWindowsMessage(int lParam) {
        if (m_WMessageCallback != null) {
            return m_WMessageCallback.callback(lParam);
        }
        return 0;
    }

    private static void callMouseHook(int xp, int yp) {
        if (m_MouseHook != null) {
            MouseEvent evt = new MouseEvent(WindowsTrayIcon.getDummyComponent(), 0, 0L, 0, xp, yp, 1, true);
            m_MouseHook.mousePressed(evt);
        }
    }

    void modifyPopup(int menuId, int what, boolean state) {
        WindowsTrayIcon.modifyPopup(this.m_ID, menuId, what, state);
    }

    static native void initPopup(int var0, int var1);

    static native int subPopup(int var0, int var1, String var2, int var3, int var4);

    private static native void modifyPopup(int var0, int var1, int var2, boolean var3);

    private static native int getFreeId();

    private static native void setIconData(int var0, int var1, int var2, int[] var3);

    private static native void showIcon(int var0, boolean var1);

    private static native int testVisible(int var0);

    private static native void clickEnable(WindowsTrayIcon var0, int var1, boolean var2);

    private static native void setToolTip(int var0, String var1);

    private static native void freeIcon(int var0);

    private static native void detectAllClicks(int var0);

    public static native void initJAWT();

    public static native void initHook();

    public static native void setMouseHookEnabled(int var0);

    public static void setMouseClickHook(MouseListener listener) {
        m_MouseHook = listener;
        WindowsTrayIcon.setMouseHookEnabled(listener == null ? 0 : 1);
    }

    private static native void showBalloon(int var0, String var1, String var2, int var3, int var4);

    private static native void termTrayIcon();

    public static Window getCurrentWindow() {
        return m_CurrentWindow;
    }
}

