/*
 * Decompiled with CFR 0.152.
 */
package Validators;

import Data.UserData;

public class UserValidator {
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean validate(UserData userData) {
        UserData userdata = userData;
        String uName = userdata.getLoginId();
        String fName = userdata.getFName();
        String lName = userdata.getLName();
        String contactNumber = userdata.getContactNumber();
        String emailAddress = userdata.getEmailAddress();
        String mobileNumber = userdata.getMobileNumber();
        if (fName.equals("") || lName.equals("") || uName.equals("")) {
            this.message = " Enter the required details. ";
            return false;
        }
        if (!uName.matches("^[a-zA-Z/`/'/s/ ]{1,20}+$")) {
            this.message = String.valueOf(this.message) + " Username should  be less than 20 characters. ";
            return false;
        }
        if (contactNumber.equals("")) {
            this.message = "Contact Number is empty. ";
            return false;
        }
        if (!fName.matches("^[a-zA-Z/`/'/s/ ]{1,50}+$")) {
            this.message = "First name has invalid characters.";
            this.message = String.valueOf(this.message) + " First name has to be less than 50 characters. ";
            return false;
        }
        if (!lName.matches("^[a-zA-Z/`/'/s/ ]{1,50}+$")) {
            this.message = "Last name has invalid characters.";
            this.message = String.valueOf(this.message) + " Last name has to be less than 50 characters. ";
            return false;
        }
        if (!contactNumber.matches("^[/(/)0-9/s/ ]{7,12}+$")) {
            this.message = "Phone number has invalid characters.";
            this.message = String.valueOf(this.message) + " Phone number must be between 7 and 12 digits long";
            return false;
        }
        if (!mobileNumber.matches("^[/(/)0-9/s/ ]{7,12}+$")) {
            this.message = "Phone number has invalid characters.";
            this.message = String.valueOf(this.message) + " Phone number must be between 7 and 12 digits long";
            return false;
        }
        if (!this.validEmail(emailAddress)) {
            this.message = "The email address is invalid.";
            return false;
        }
        return true;
    }

    private boolean validEmail(String strEmailAddress) {
        boolean bValid = true;
        if (UserValidator.isNullorEmpty(strEmailAddress)) {
            this.setMessage("Email address is empty.");
            return false;
        }
        int iLength = strEmailAddress.length();
        int iCharAtPosition = strEmailAddress.indexOf("@");
        if (iCharAtPosition == -1) {
            this.setMessage("@ character is not found in Email address.");
            bValid = false;
        } else if (iCharAtPosition == 0 || iCharAtPosition == iLength - 1) {
            this.setMessage("@ character is not allowed to be in the first or last position in Email address.");
            bValid = false;
        } else if (strEmailAddress.indexOf("@", iCharAtPosition + 1) > -1) {
            this.setMessage("More than 1 @ characters are not allowed in Email address.");
            bValid = false;
        } else {
            int i = 0;
            while (i < iLength) {
                char c = strEmailAddress.charAt(i);
                if (c == '.') {
                    if (i == 0 || i == iLength - 1) {
                        this.setMessage(". character is not allowed in the first or the last postion in Email address.");
                        bValid = false;
                        break;
                    }
                    if (i == iCharAtPosition - 1) {
                        this.setMessage(". character cannot immediately precede @ character in Email address.");
                        bValid = false;
                        break;
                    }
                } else if (c > '~' || c < '!' || c == '(' || c == ')' || c == '<' || c == '>' || c == '[' || c == ']' || c == ',' || c == ';' || c == ':' || c == '\\' || c == '\"') {
                    this.setMessage("Invalid character " + c + " found in Email address.");
                    bValid = false;
                    break;
                }
                ++i;
            }
        }
        return bValid;
    }

    private static boolean isNullorEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

