/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Data.UserData;
import DatabaseCommunication.UserManager;
import Validators.NewLoginValidator;
import Validators.UserValidator;
import XmlCommunication.ServletConnection;
import XmlCommunication.XmlGenerator;
import XmlCommunication.XmlUnmarshal;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TabRegister
extends JFrame
implements ActionListener {
    private static int unique = 0;
    private XmlGenerator xmlgenerator;
    private XmlUnmarshal xmlunmarshal;
    static JLabel uLabel = new JLabel("User Name");
    static JTextField uName = new JTextField(15);
    static JLabel fLabel = new JLabel("First Name");
    static JTextField fName = new JTextField(15);
    static JLabel lLabel = new JLabel("Last Name");
    static JTextField lName = new JTextField(15);
    static JLabel cLabel = new JLabel("Contact Number");
    static JTextField contactNumber = new JTextField(15);
    static JLabel mLabel = new JLabel("Mobile Number(optional)");
    static JTextField mobileNumber = new JTextField(15);
    static JLabel eLabel = new JLabel("Email Address");
    static JTextField emailAddress = new JTextField(15);
    static JLabel pLabel = new JLabel("Password");
    static JPasswordField password = new JPasswordField(15);
    static JLabel vLabel = new JLabel("Verify");
    static JPasswordField verifier = new JPasswordField(15);
    static JButton registerButton = new JButton("REGISTER");
    static JButton loginButton = new JButton("LOGIN");
    static UserData user = new UserData();
    static JLabel message = new JLabel();
    static JFrame login;

    public TabRegister(JFrame login) {
        TabRegister.login = login;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TabRegister.this.displayMessage("Window closing", e);
                TabRegister.this.dispose();
                System.exit(0);
            }

            public void windowClosed(WindowEvent e) {
                TabRegister.this.displayMessage("Window closed", e);
            }

            public void windowOpened(WindowEvent e) {
                TabRegister.this.displayMessage("Window opened", e);
            }

            public void windowIconified(WindowEvent e) {
                TabRegister.this.displayMessage("Window iconified", e);
            }

            public void windowDeiconified(WindowEvent e) {
                TabRegister.this.displayMessage("Window deiconified", e);
            }

            public void windowActivated(WindowEvent e) {
                TabRegister.this.displayMessage("Window activated", e);
            }

            public void windowDeactivated(WindowEvent e) {
                TabRegister.this.displayMessage("Window deactivated", e);
            }
        });
        this.displayWindow();
        this.createPanel();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == "register") {
            this.doRegister();
        }
        if (command == "back to login") {
            ((Component)login).setVisible(true);
            ((Component)this).setVisible(false);
        }
    }

    public void doRegister() {
        user.setLoginId(uName.getText());
        user.setFName(fName.getText());
        user.setLName(lName.getText());
        user.setContactNumber(contactNumber.getText());
        user.setMobileNumber(mobileNumber.getText());
        user.setEmailAddress(emailAddress.getText());
        user.setPassword(password.getText());
        user.setVerifier(verifier.getText());
        UserValidator uv = new UserValidator();
        NewLoginValidator nlv = new NewLoginValidator();
        if (!uv.validate(user)) {
            System.out.println("Register Failed :" + uv.getMessage());
            message.setText("Register Failed :" + uv.getMessage());
            return;
        }
        if (!nlv.validate(user)) {
            System.out.println("Register Failed :" + uv.getMessage());
            message.setText("Register Failed :" + nlv.getMessage());
            return;
        }
        String xmlstr = this.xmlgenerator.adminAddXml(user);
        String res = ServletConnection.sendXml(xmlstr);
        String s = this.xmlunmarshal.readResponse(res);
        int rgCode = Integer.parseInt(this.xmlunmarshal.getResponseGeneralCode());
        if (rgCode == 9) {
            System.out.println(rgCode);
            message.setText("Register Failed : Username is already in use.");
            System.out.println(this.xmlunmarshal.getResponseGeneralDescription());
            return;
        }
        if (rgCode > 0) {
            message.setText("Register Failed.");
            return;
        }
        this.populateLocalDatabase();
        message.setText("Register Successful.\nYour username is " + user.getLoginId());
        int id = this.xmlunmarshal.getNcbId();
        if (id != -1) {
            s = "Your Ncb ID is: " + id + ". ";
            user.setNcbId(id);
        }
    }

    void displayMessage(String prefix, WindowEvent e) {
    }

    void displayWindow() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        ((Component)this).setSize(550, 350);
        TabRegister.centerDialog(this);
        this.setTitle("Pinboard Application");
        ImageIcon img = new ImageIcon("./Interface/pinboard.gif");
        ((Frame)this).setIconImage(img.getImage());
    }

    void createPanel() {
        Container contentPane = this.getContentPane();
        TitledBorder loginTitled = BorderFactory.createTitledBorder("Register");
        JPanel rPanel = new JPanel();
        rPanel.setBorder(loginTitled);
        rPanel.setLayout(new GridLayout(0, 2));
        rPanel.add(uLabel);
        uLabel.setLabelFor(uName);
        uName.setEditable(true);
        rPanel.add(uName);
        rPanel.add(fLabel);
        fLabel.setLabelFor(fName);
        fName.setEditable(true);
        rPanel.add(fName);
        rPanel.add(lLabel);
        lLabel.setLabelFor(lName);
        lName.setEditable(true);
        rPanel.add(lName);
        rPanel.add(cLabel);
        cLabel.setLabelFor(contactNumber);
        contactNumber.setEditable(true);
        rPanel.add(contactNumber);
        rPanel.add(mLabel);
        mLabel.setLabelFor(mobileNumber);
        mobileNumber.setEditable(true);
        rPanel.add(mobileNumber);
        rPanel.add(eLabel);
        eLabel.setLabelFor(emailAddress);
        emailAddress.setEditable(true);
        rPanel.add(emailAddress);
        rPanel.add(pLabel);
        eLabel.setLabelFor(password);
        password.setEditable(true);
        rPanel.add(password);
        rPanel.add(vLabel);
        eLabel.setLabelFor(verifier);
        verifier.setEditable(true);
        rPanel.add(verifier);
        rPanel.add(loginButton);
        rPanel.add(registerButton);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(rPanel);
        message.setHorizontalAlignment(0);
        message.setFont(new Font("Times New Roman", 2, 16));
        message.setForeground(Color.RED);
        panel.add(message);
        registerButton.setActionCommand("register");
        loginButton.addActionListener(this);
        loginButton.setActionCommand("back to login");
        registerButton.addActionListener(this);
        contentPane.add((Component)panel, "Center");
        ((Component)this).setVisible(true);
    }

    private void populateLocalDatabase() {
        UserManager uManager = new UserManager();
        try {
            uManager.insertUserData(user);
            message.setText("user is now inserted");
        }
        catch (Exception exp) {
            message.setText("Error while inserting user data " + exp.toString());
            return;
        }
    }

    public static void centerDialog(Window frame) {
        Dimension dialogSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(screenSize.width / 2 - dialogSize.width / 2, screenSize.height / 2 - dialogSize.height / 2);
    }
}

