/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Data.MessageData;
import Data.UserData;
import DatabaseCommunication.MessageManager;
import DatabaseCommunication.UserManager;
import Interface.Mail;
import Validators.MessageValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TabMessage
extends JPanel
implements ActionListener,
ListSelectionListener {
    static final JLabel timeLabel = new JLabel("Time :");
    static final JLabel subjectLabel = new JLabel("Subject :");
    static final JLabel postSubjectLabel = new JLabel("Subject :");
    static final JLabel messageLabel = new JLabel("Message :");
    static final JLabel fromLabel = new JLabel("From :");
    static final JLabel label = new JLabel("Time     Message");
    static final JLabel postLabel = new JLabel("Post    Messages");
    static JList listM;
    static DefaultListModel listModel;
    static JTextField from;
    static JTextArea messageArea;
    static JTextArea postArea;
    static JTextArea subjectArea;
    static JTextArea postSubject;
    static JTextField timeBoxM;
    static JCheckBox sms;
    static JButton readButton;
    static JButton postButton;
    static JLabel message;
    static JComboBox comboBoxN;
    static DefaultComboBoxModel comboBoxModel;
    static MessageData[] messageArray;
    static UserData[] userArray;
    static MessageData messagedata;
    private static UserData user;

    static {
        from = new JTextField();
        messageArea = new JTextArea(5, 5);
        postArea = new JTextArea();
        subjectArea = new JTextArea(2, 5);
        postSubject = new JTextArea(2, 5);
        timeBoxM = new JTextField();
        sms = new JCheckBox("SMS");
        readButton = new JButton("READ");
        postButton = new JButton("POST");
        message = new JLabel();
        messagedata = new MessageData();
    }

    public TabMessage() {
    }

    public TabMessage(UserData user) {
        TabMessage.user = user;
    }

    public JPanel createTabMessage() {
        listModel = new DefaultListModel();
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        JPanel titledLeftBorders = new JPanel();
        TitledBorder readTitled = BorderFactory.createTitledBorder("Read Messages");
        JPanel read = new JPanel();
        read.setBorder(readTitled);
        read.setLayout(new BoxLayout(read, 1));
        listModel = new DefaultListModel();
        TabMessage.fillMessages();
        listM = new JList(listModel);
        listM.setFont(new Font("Times New Roman", 1, 12));
        listM.setModel(listModel);
        listM.addListSelectionListener(this);
        listM.setVisibleRowCount(5);
        listM.setSelectionMode(0);
        listM.setLayoutOrientation(0);
        listM.setVisibleRowCount(-1);
        JScrollPane listScroller = new JScrollPane(listM);
        listScroller.setPreferredSize(new Dimension(250, 50));
        read.add(listScroller);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        label.setLabelFor(listM);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        read.add(listPane);
        read.add(readButton);
        readButton.setActionCommand("read");
        readButton.addActionListener(this);
        read.add(timeLabel);
        timeLabel.setLabelFor(timeBoxM);
        timeBoxM.setEditable(false);
        read.add(timeBoxM);
        read.add(subjectLabel);
        subjectLabel.setLabelFor(subjectArea);
        read.add(subjectArea);
        subjectArea.setEditable(false);
        subjectArea.setLineWrap(true);
        JScrollPane scrollSubject = new JScrollPane(subjectArea);
        scrollSubject.setPreferredSize(new Dimension(10, 25));
        scrollSubject.setHorizontalScrollBarPolicy(31);
        read.add(scrollSubject);
        read.add(messageLabel);
        messageLabel.setLabelFor(messageArea);
        read.add(messageArea);
        messageArea.setEditable(false);
        subjectArea.setLineWrap(true);
        JScrollPane scrollMessage = new JScrollPane(messageArea);
        scrollMessage.setPreferredSize(new Dimension(10, 50));
        scrollMessage.setHorizontalScrollBarPolicy(31);
        read.add(scrollMessage);
        read.add(fromLabel);
        fromLabel.setLabelFor(from);
        read.add(from);
        from.setEditable(false);
        titledLeftBorders.add(read);
        aPanel.add((Component)titledLeftBorders, "West");
        JPanel rightTitledBorders = new JPanel();
        TitledBorder rightTitled = BorderFactory.createTitledBorder("Post");
        JPanel post = new JPanel();
        post.setBorder(rightTitled);
        post.setLayout(new BoxLayout(post, 1));
        post.add(postSubjectLabel);
        post.add(postSubject);
        postSubject.setEditable(true);
        postSubject.setLineWrap(true);
        JScrollPane scrollPostSubject = new JScrollPane(postSubject);
        scrollPostSubject.setPreferredSize(new Dimension(10, 25));
        scrollPostSubject.setHorizontalScrollBarPolicy(31);
        post.add(scrollPostSubject);
        postArea.setEditable(true);
        postArea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(postArea);
        scrollPane.setPreferredSize(new Dimension(50, 100));
        scrollPane.setHorizontalScrollBarPolicy(31);
        post.add(scrollPane);
        post.add(sms);
        comboBoxModel = new DefaultComboBoxModel();
        TabMessage.populateComboBox();
        comboBoxN = new JComboBox(comboBoxModel);
        comboBoxN.setModel(comboBoxModel);
        comboBoxN.addActionListener(this);
        post.add(comboBoxN);
        postButton.setActionCommand("post");
        postButton.addActionListener(this);
        post.add(postButton);
        rightTitledBorders.add(post);
        message.setPreferredSize(new Dimension(200, 50));
        post.add(message);
        aPanel.add((Component)rightTitledBorders, "East");
        return aPanel;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == "read") {
            this.display(listM.getSelectedIndex());
        } else if (command == "post") {
            UserManager uManager = new UserManager();
            String name = "";
            try {
                name = uManager.getName(user.getLoginId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            messagedata.setFrom(name);
            messagedata.setTo(comboBoxN.getSelectedItem().toString());
            messagedata.setBody(postArea.getText());
            messagedata.setSubject(postSubject.getText());
            long currentTime = System.currentTimeMillis();
            messagedata.setTime(new Timestamp(currentTime));
            TabMessage.updateDatabase();
        } else {
            message.setText("");
        }
    }

    public static void fillMessages() {
        MessageManager mManager = new MessageManager();
        messageArray = new MessageData[10];
        try {
            UserManager uManager = new UserManager();
            String name = uManager.getName(user.getLoginId());
            messageArray = mManager.selectAllMessages(name);
            int i = 0;
            while (i < messageArray.length) {
                if (messageArray[i] != null) {
                    long expiry = TabMessage.addDays(messageArray[i].getTime(), 1);
                    Timestamp expiryTime = new Timestamp(expiry);
                    if (expiryTime.after(new Timestamp(System.currentTimeMillis()))) {
                        listModel.addElement(String.valueOf(messageArray[i].getTime().getHours()) + ":" + messageArray[i].getTime().getMinutes() + "   " + messageArray[i].getSubject());
                    } else {
                        listModel.removeElement(String.valueOf(messageArray[i].getTime().getHours()) + ":" + messageArray[i].getTime().getMinutes() + "   " + messageArray[i].getSubject());
                    }
                    listM.setModel(listModel);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void populateComboBox() {
        UserManager uManager = new UserManager();
        userArray = new UserData[10];
        try {
            userArray = uManager.selectAllUsers();
            int i = 0;
            while (i < userArray.length) {
                if (userArray[i] != null) {
                    comboBoxModel.addElement(String.valueOf(userArray[i].getFName()) + " " + userArray[i].getLName());
                    comboBoxN.setModel(comboBoxModel);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendSMS() {
        String fName = "";
        String lName = "";
        try {
            UserManager uManager = new UserManager();
            StringTokenizer st = new StringTokenizer(comboBoxN.getSelectedItem().toString());
            while (st.hasMoreTokens()) {
                fName = st.nextToken();
                lName = st.nextToken();
            }
            String[] sendEmailTo = new String[]{uManager.getEmailAddress(fName, lName)};
            System.out.println("Sending email to " + sendEmailTo);
            Mail.postMail(sendEmailTo, postSubject.getText(), postArea.getText());
        }
        catch (Exception exp) {
            System.out.println("Exception :" + exp.toString());
        }
    }

    public void refresh() {
        listModel = new DefaultListModel();
        TabMessage.fillMessages();
        comboBoxModel = new DefaultComboBoxModel();
        TabMessage.populateComboBox();
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    private void display(int i) {
        String time = messageArray[i].getTime().toString();
        String subject = messageArray[i].getSubject();
        timeBoxM.setText(time);
        subjectArea.setText(subject);
        messageArea.setText(messageArray[i].getBody());
        from.setText(messageArray[i].getFrom());
    }

    public static void updateDatabase() {
        MessageValidator mValidator = new MessageValidator();
        boolean validMessage = mValidator.validate(messagedata);
        if (!validMessage) {
            message.setText(mValidator.getMessage());
            return;
        }
        if (sms.isSelected()) {
            TabMessage.sendSMS();
        }
        MessageManager mManager = new MessageManager();
        try {
            mManager.insertMessageData(messagedata);
            message.setText("Message has been posted");
        }
        catch (Exception exp) {
            message.setText("Message could not be posted .Please try again later.");
        }
    }

    public static long addDays(Date startDate, int numberOfDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startDate);
        cal.add(5, numberOfDays);
        return cal.getTimeInMillis();
    }
}

