/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Data.UserData;
import DatabaseCommunication.UserManager;
import Validators.TimeValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TabMe
extends JFrame
implements ActionListener {
    static final JLabel adLabel = new JLabel("I will be out : ");
    static final String STRINGONE = "The Rest of the Day";
    static final String STRINGTWO = "From now Until ";
    static final String STRINGTHREE = "From";
    static final String STRINGFOUR = "All day tomorrow";
    static JLabel message = new JLabel();
    static JPanel adPanel = new JPanel();
    static JTextField untill2hr = new JTextField(3);
    static JTextField untill2min = new JTextField(3);
    static JTextField untill3hr = new JTextField(3);
    static JTextField untill3min = new JTextField(3);
    static JTextField from3hr = new JTextField(3);
    static JTextField from3min = new JTextField(3);
    static JRadioButton one = new JRadioButton("The Rest of the Day");
    static JRadioButton two = new JRadioButton("From now Until ");
    static JRadioButton three = new JRadioButton("From");
    static JRadioButton four = new JRadioButton("All day tomorrow");
    static JLabel note = new JLabel("Note: All times must be specified using a 24 hr clock.");
    private static UserData user = new UserData();

    public TabMe() {
    }

    public TabMe(UserData user) {
        TabMe.user = user;
    }

    public JPanel createTabMe() {
        JPanel aPanel = new JPanel();
        JPanel titledBorders = new JPanel();
        TitledBorder advertiseTitled = BorderFactory.createTitledBorder("Advertise Availability");
        adPanel.setBorder(advertiseTitled);
        adPanel.setLayout(new BoxLayout(adPanel, 1));
        adPanel.setLayout(new GridLayout(0, 1));
        adPanel.add((Component)adLabel, 0);
        note.setHorizontalAlignment(0);
        note.setBackground(Color.RED);
        adPanel.add(note);
        one.setMnemonic(66);
        one.setActionCommand(STRINGONE);
        one.setSelected(true);
        two.setMnemonic(67);
        two.setActionCommand(STRINGTWO);
        three.setMnemonic(68);
        three.setActionCommand(STRINGTHREE);
        four.setMnemonic(82);
        four.setActionCommand(STRINGFOUR);
        ButtonGroup group = new ButtonGroup();
        group.add(one);
        group.add(two);
        group.add(three);
        group.add(four);
        one.addActionListener(this);
        two.addActionListener(this);
        three.addActionListener(this);
        four.addActionListener(this);
        JPanel onePanel = new JPanel();
        onePanel.add(one);
        JPanel twoPanel = new JPanel();
        twoPanel.setLayout(new FlowLayout());
        twoPanel.add(two);
        twoPanel.add(untill2hr);
        twoPanel.add(new JLabel(":"));
        twoPanel.add(untill2min);
        JPanel threePanel = new JPanel();
        threePanel.setLayout(new FlowLayout());
        threePanel.add(three);
        threePanel.add(from3hr);
        threePanel.add(new JLabel(":"));
        threePanel.add(from3min);
        threePanel.add(new JLabel("until"));
        threePanel.add(untill3hr);
        threePanel.add(new JLabel(":"));
        threePanel.add(untill3min);
        JPanel fourPanel = new JPanel();
        fourPanel.add(four);
        adPanel.add(onePanel);
        adPanel.add(twoPanel);
        adPanel.add(threePanel);
        adPanel.add(fourPanel);
        titledBorders.add(adPanel);
        aPanel.add((Component)titledBorders, "West");
        JPanel btnPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.setActionCommand("ok");
        ok.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this);
        JButton exit = new JButton("Log out");
        exit.setActionCommand("logout");
        exit.addActionListener(this);
        btnPanel.add(ok);
        btnPanel.add(cancel);
        btnPanel.add(exit);
        adPanel.add(btnPanel);
        message.setPreferredSize(new Dimension(250, 50));
        message.setHorizontalAlignment(0);
        adPanel.add(message);
        return adPanel;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == "ok") {
            if (one.isSelected()) {
                TabMe.setUserDetails();
                long currentTime = System.currentTimeMillis();
                Timestamp timestamp = new Timestamp(currentTime);
                user.setOutFrom(timestamp);
                System.out.println("User outfrom " + timestamp);
                long endTime = TabMe.addDays(new Date(System.currentTimeMillis()), 1);
                Timestamp untill = new Timestamp(endTime);
                untill.setHours(0);
                untill.setMinutes(0);
                untill.setSeconds(0);
                untill.setNanos(0);
                user.setOutTo(untill);
                System.out.println("User outTo" + untill);
                TabMe.updateDatabase();
                return;
            }
            if (two.isSelected()) {
                TabMe.setUserDetails();
                long currentTime = System.currentTimeMillis();
                user.setOutFrom(new Timestamp(currentTime));
                System.out.println("User outFrom " + user.getOutFrom());
                Timestamp timestamp = new Timestamp(currentTime);
                timestamp.setHours(Integer.parseInt(untill2hr.getText()));
                timestamp.setMinutes(Integer.parseInt(untill2min.getText()));
                user.setOutTo(timestamp);
                System.out.println("User outTo " + user.getOutTo());
                TabMe.updateDatabase();
                return;
            }
            if (three.isSelected()) {
                TabMe.setUserDetails();
                long currentTime = System.currentTimeMillis();
                Timestamp from = new Timestamp(currentTime);
                from.setHours(Integer.parseInt(from3hr.getText()));
                from.setMinutes(Integer.parseInt(from3min.getText()));
                user.setOutFrom(from);
                System.out.println("User outFrom " + user.getOutFrom());
                Timestamp end = new Timestamp(currentTime);
                end.setHours(Integer.parseInt(untill3hr.getText()));
                end.setMinutes(Integer.parseInt(untill3min.getText()));
                user.setOutTo(end);
                System.out.println("User outTo " + user.getOutTo());
                TabMe.updateDatabase();
                return;
            }
            if (four.isSelected()) {
                TabMe.setUserDetails();
                long from = TabMe.addDays(new Date(System.currentTimeMillis()), 1);
                Timestamp fromTime = new Timestamp(from);
                fromTime.setHours(0);
                fromTime.setMinutes(0);
                fromTime.setSeconds(0);
                fromTime.setNanos(0);
                user.setOutFrom(fromTime);
                System.out.println("User outFrom " + user.getOutFrom());
                long end = TabMe.addDays(new Date(System.currentTimeMillis()), 2);
                Timestamp endTime = new Timestamp(end);
                endTime.setHours(0);
                endTime.setMinutes(0);
                endTime.setSeconds(0);
                endTime.setNanos(0);
                user.setOutTo(endTime);
                System.out.println("User outTo " + user.getOutTo());
                TabMe.updateDatabase();
                return;
            }
            message.setText("Select atleast one option.");
            return;
        }
        if (command == "cancel") {
            one.setSelected(true);
            return;
        }
        if (command == "logout") {
            this.dispose();
            System.exit(0);
            return;
        }
        message.setText("");
    }

    public static void setUserDetails() {
        System.out.println("User loginId " + user.getLoginId());
        String loginId = user.getLoginId();
        user.setLoginId(loginId);
        System.out.println("User loginId " + user.getLoginId());
        UserManager uManager = new UserManager();
        try {
            user = uManager.selectUser(user.getLoginId());
            message.setText("Request has been processed successfully.");
        }
        catch (Exception exp) {
            message.setText("System couldnt process the request\nPlease try again later.");
        }
        String fName = user.getFName();
        String lName = user.getLName();
        user.setFName(fName);
        System.out.println("User firstname " + user.getFName());
        user.setLName(lName);
        System.out.println("User lastname " + user.getLName());
    }

    public static void updateDatabase() {
        TimeValidator timeValidator = new TimeValidator();
        boolean validTime = timeValidator.validate(user);
        if (!validTime) {
            message.setText(timeValidator.getMessage());
            return;
        }
        UserManager uManager = new UserManager();
        try {
            uManager.insertUserData(user);
            message.setText("Request has been processed successfully.");
        }
        catch (Exception exp) {
            message.setText("System couldnt process the request\nPlease try again later.");
        }
    }

    public static long addDays(Date startDate, int numberOfDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startDate);
        cal.add(5, numberOfDays);
        return cal.getTimeInMillis();
    }

    public static String getLoginId() {
        return user.getLoginId();
    }
}

