/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Data.UserData;
import Interface.Pinboard;
import Interface.TabRegister;
import Validators.LoginValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class TabLogin
extends JFrame
implements ActionListener {
    static JLabel uLabel = new JLabel("User Name");
    static JTextField userName = new JTextField(15);
    static JLabel pLabel = new JLabel("Password");
    static JPasswordField password = new JPasswordField(15);
    static JButton loginButton = new JButton("LOGIN");
    static JButton registerButton = new JButton("REGISTER");
    static JLabel message = new JLabel();
    private static UserData user = new UserData();

    public TabLogin() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TabLogin.this.displayMessage("Window closing", e);
                TabLogin.this.dispose();
                System.exit(0);
            }

            public void windowClosed(WindowEvent e) {
                TabLogin.this.displayMessage("Window closed", e);
            }

            public void windowOpened(WindowEvent e) {
                TabLogin.this.displayMessage("Window opened", e);
            }

            public void windowIconified(WindowEvent e) {
                TabLogin.this.displayMessage("Window iconified", e);
            }

            public void windowDeiconified(WindowEvent e) {
                TabLogin.this.displayMessage("Window deiconified", e);
            }

            public void windowActivated(WindowEvent e) {
                TabLogin.this.displayMessage("Window activated", e);
            }

            public void windowDeactivated(WindowEvent e) {
                TabLogin.this.displayMessage("Window deactivated", e);
            }
        });
        this.displayWindow();
        this.createPanel();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (e.getActionCommand() == "enter") {
            this.doLogin();
        }
        if (command == "login") {
            this.doLogin();
        }
        if (command == "register") {
            TabRegister register = new TabRegister(this);
            this.dispose();
        }
    }

    public void doLogin() {
        user.setLoginId(userName.getText());
        user.setPassword(password.getText());
        LoginValidator lv = new LoginValidator();
        if (!lv.validate(user)) {
            message.setText("Login Failed: \n" + lv.getMessage());
            return;
        }
        System.out.println("Id while loging in" + user.getLoginId());
        Pinboard window = new Pinboard(user);
        ((Component)this).setVisible(false);
    }

    void displayMessage(String prefix, WindowEvent e) {
    }

    void displayWindow() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        ((Component)this).setSize(500, 250);
        TabLogin.centerDialog(this);
        this.setTitle("Pinboard Application");
        ImageIcon img = new ImageIcon("./Interface/pinboard.gif");
        ((Frame)this).setIconImage(img.getImage());
    }

    void createPanel() {
        Container contentPane = this.getContentPane();
        TitledBorder loginTitled = BorderFactory.createTitledBorder("Login");
        JPanel lPanel = new JPanel();
        lPanel.setBorder(loginTitled);
        lPanel.setLayout(new BoxLayout(lPanel, 1));
        JPanel uPanel = new JPanel();
        JPanel pPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        uPanel.setLayout(new FlowLayout());
        pPanel.setLayout(new FlowLayout());
        buttonPanel.setLayout(new FlowLayout());
        uPanel.add(uLabel);
        uLabel.setLabelFor(userName);
        userName.setSize(15, 10);
        userName.setEditable(true);
        userName.setActionCommand("enter");
        userName.addActionListener(this);
        uPanel.add(userName);
        pPanel.add(pLabel);
        pLabel.setLabelFor(password);
        password.setEditable(true);
        password.setActionCommand("enter");
        password.addActionListener(this);
        pPanel.add(password);
        lPanel.add(uPanel);
        lPanel.add(pPanel);
        buttonPanel.add(loginButton);
        buttonPanel.add(registerButton);
        lPanel.add(buttonPanel);
        loginButton.setActionCommand("login");
        loginButton.addActionListener(this);
        registerButton.setActionCommand("register");
        registerButton.addActionListener(this);
        message.setHorizontalAlignment(2);
        message.setFont(new Font("Times New Roman", 2, 16));
        message.setForeground(Color.RED);
        lPanel.add(message);
        contentPane.add((Component)lPanel, "Center");
        ((Component)this).setVisible(true);
    }

    public static void centerDialog(Window frame) {
        Dimension dialogSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(screenSize.width / 2 - dialogSize.width / 2, screenSize.height / 2 - dialogSize.height / 2);
    }
}

