/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Data.AnnouncementData;
import Data.UserData;
import DatabaseCommunication.AnnouncementManager;
import DatabaseCommunication.UserManager;
import Validators.AnnouncementValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TabAnnouncement
extends JPanel
implements ActionListener,
ListSelectionListener {
    static final JLabel timeLabel = new JLabel("Time :");
    static final JLabel subjectLabel = new JLabel("Subject :");
    static final JLabel postSubjectLabel = new JLabel("Subject :");
    static final JLabel announcementLabel = new JLabel("Announcement :");
    static final JLabel fromLabel = new JLabel("From :");
    static final JLabel label = new JLabel("Time     Subject");
    static final JLabel message = new JLabel();
    static JList listA;
    static DefaultListModel listModel;
    static JTextField from;
    static JTextField timeBoxA;
    static JTextArea announcementArea;
    static JTextArea postArea;
    static JTextArea subjectArea;
    static JTextArea postSubject;
    static JButton readButton;
    static JButton postButton;
    static AnnouncementData[] announcementArray;
    static AnnouncementData announcement;
    private static UserData user;

    static {
        from = new JTextField();
        timeBoxA = new JTextField();
        announcementArea = new JTextArea(5, 5);
        postArea = new JTextArea();
        subjectArea = new JTextArea(2, 5);
        postSubject = new JTextArea(2, 5);
        readButton = new JButton("READ");
        postButton = new JButton("POST");
        announcement = new AnnouncementData();
        user = new UserData();
    }

    public TabAnnouncement() {
    }

    public TabAnnouncement(UserData user) {
        TabAnnouncement.user = user;
    }

    public JPanel createTabAnnouncement() {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 0));
        JPanel titledLeftBorders = new JPanel();
        TitledBorder readTitled = BorderFactory.createTitledBorder("Read Announcements");
        JPanel read = new JPanel();
        read.setBorder(readTitled);
        read.setLayout(new BoxLayout(read, 1));
        listModel = new DefaultListModel();
        TabAnnouncement.fillAnnouncements();
        listA = new JList(listModel);
        listA.setFont(new Font("Times New Roman", 1, 12));
        listA.setModel(listModel);
        listA.addListSelectionListener(this);
        listA.setSelectionMode(0);
        listA.setLayoutOrientation(0);
        listA.setVisibleRowCount(-1);
        JScrollPane listScroller = new JScrollPane(listA);
        listScroller.setPreferredSize(new Dimension(250, 50));
        read.add(listScroller);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        label.setLabelFor(listA);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        read.add(listPane);
        read.add(readButton);
        readButton.setActionCommand("read");
        readButton.addActionListener(this);
        read.add(timeLabel);
        timeLabel.setLabelFor(timeBoxA);
        timeBoxA.setEditable(false);
        read.add(timeBoxA);
        read.add(subjectLabel);
        subjectLabel.setLabelFor(subjectArea);
        read.add(subjectArea);
        subjectArea.setEditable(false);
        subjectArea.setLineWrap(true);
        JScrollPane scrollSubject = new JScrollPane(subjectArea);
        scrollSubject.setPreferredSize(new Dimension(10, 25));
        scrollSubject.setHorizontalScrollBarPolicy(31);
        read.add(scrollSubject);
        read.add(announcementLabel);
        announcementLabel.setLabelFor(announcementArea);
        read.add(announcementArea);
        announcementArea.setEditable(false);
        subjectArea.setLineWrap(true);
        JScrollPane scrollAnnouncement = new JScrollPane(announcementArea);
        scrollAnnouncement.setPreferredSize(new Dimension(10, 50));
        scrollAnnouncement.setHorizontalScrollBarPolicy(31);
        read.add(scrollAnnouncement);
        read.add(fromLabel);
        fromLabel.setLabelFor(from);
        read.add(from);
        from.setEditable(false);
        titledLeftBorders.add(read);
        aPanel.add((Component)titledLeftBorders, "West");
        JPanel rightTitledBorders = new JPanel();
        TitledBorder rightTitled = BorderFactory.createTitledBorder("Post");
        JPanel post = new JPanel();
        post.setBorder(rightTitled);
        post.setLayout(new BoxLayout(post, 1));
        JLabel postLabel = new JLabel("Post Announcements");
        post.add(postSubjectLabel);
        post.add(postSubject);
        postSubject.setEditable(true);
        postSubject.setLineWrap(true);
        JScrollPane scrollPostSubject = new JScrollPane(postSubject);
        scrollPostSubject.setPreferredSize(new Dimension(10, 25));
        scrollPostSubject.setHorizontalScrollBarPolicy(31);
        post.add(scrollPostSubject);
        postArea.setEditable(true);
        postArea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(postArea);
        scrollPane.setPreferredSize(new Dimension(50, 100));
        scrollPane.setHorizontalScrollBarPolicy(31);
        post.add(scrollPane);
        postButton.setActionCommand("post");
        postButton.addActionListener(this);
        post.add(postButton);
        rightTitledBorders.add(post);
        message.setHorizontalAlignment(0);
        message.setPreferredSize(new Dimension(200, 50));
        post.add(message);
        aPanel.add((Component)rightTitledBorders, "East");
        return aPanel;
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    public static void fillAnnouncements() {
        AnnouncementManager aManager = new AnnouncementManager();
        announcementArray = new AnnouncementData[10];
        try {
            announcementArray = aManager.selectAllAnnouncements();
            int i = 0;
            while (i < announcementArray.length) {
                if (announcementArray[i] != null) {
                    listModel.addElement(String.valueOf(announcementArray[i].getTime().getHours()) + ":" + announcementArray[i].getTime().getMinutes() + "   " + announcementArray[i].getSubject());
                    listA.setModel(listModel);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refresh() {
        listModel = new DefaultListModel();
        TabAnnouncement.fillAnnouncements();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == "read") {
            this.display(listA.getSelectedIndex());
        } else if (command == "post") {
            UserManager uManager = new UserManager();
            String name = "";
            try {
                name = uManager.getName(user.getLoginId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            announcement.setFrom(name);
            announcement.setBody(postArea.getText());
            announcement.setSubject(postSubject.getText());
            long currentTime = System.currentTimeMillis();
            announcement.setTime(new Timestamp(currentTime));
            System.out.println("Announcement time " + announcement.getTime());
            TabAnnouncement.updateDatabase();
        } else {
            message.setText("");
        }
    }

    public static void updateDatabase() {
        AnnouncementValidator aValidator = new AnnouncementValidator();
        boolean validAnnouncement = aValidator.validate(announcement);
        if (!validAnnouncement) {
            message.setText(aValidator.getMessage());
            return;
        }
        AnnouncementManager aManager = new AnnouncementManager();
        try {
            aManager.insertAnnouncementData(announcement);
            message.setText("Announcement has been posted");
        }
        catch (Exception exp) {
            message.setText("Announcement could not be posted .Please try again later.");
        }
    }

    private void display(int i) {
        String time = announcementArray[i].getTime().toString();
        String subject = announcementArray[i].getSubject();
        timeBoxA.setText(time);
        subjectArea.setText(subject);
        announcementArea.setText(announcementArray[i].getBody());
        from.setText(announcementArray[i].getFrom());
    }

    public static long addDays(Date startDate, int numberOfDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startDate);
        cal.add(5, numberOfDays);
        return cal.getTimeInMillis();
    }
}

