/*
 * Decompiled with CFR 0.152.
 */
package Interface;

import Data.UserData;
import Interface.AboutBox;
import Interface.TabAnnouncement;
import Interface.TabAvailability;
import Interface.TabMe;
import Interface.TabMessage;
import Interface.WarningBox;
import com.jeans.trayicon.TrayIconCallback;
import com.jeans.trayicon.TrayIconPopup;
import com.jeans.trayicon.TrayIconPopupSeparator;
import com.jeans.trayicon.TrayIconPopupSimpleItem;
import com.jeans.trayicon.WindowsTrayIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Pinboard
extends JFrame
implements ActionListener {
    public static final int ONE_SECOND = 1000;
    private Timer timer;
    static final String ME = "Me";
    static final String AVIALABILITY = "Availability";
    static final String MESSAGES = "Messages";
    static final String ANNOUNCEMENTS = "Announcements";
    private static UserData user;
    JTabbedPane tabbedPane = new JTabbedPane();

    public Pinboard(UserData user) {
        WindowsTrayIcon.setWindowsMessageCallback(new WindowsMessageCallback());
        if (WindowsTrayIcon.isRunning("Pinboard")) {
            System.out.println("Previous Instance is already Running.To create new Instance exit the previous instance.");
            WarningBox box = new WarningBox(this);
            Pinboard.centerDialog(box);
            ((Component)box).setVisible(true);
            return;
        }
        Pinboard.user = user;
        JFrame.setDefaultLookAndFeelDecorated(true);
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Pinboard.this.SetTitle();
            }
        };
        new Timer(1000, taskPerformer).start();
        ((Component)this).setSize(600, 400);
        Pinboard.centerDialog(this);
        this.setResizable(false);
        ImageIcon img = new ImageIcon("./Interface/pinboard.gif");
        ((Frame)this).setIconImage(img.getImage());
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.tabbedPane, "Center");
        TabMe me = new TabMe(user);
        System.out.println("TabMe " + user.getLoginId());
        JPanel mePanel = me.createTabMe();
        this.tabbedPane.addTab(ME, mePanel);
        final TabAnnouncement announcement = new TabAnnouncement(user);
        JPanel aPanel = announcement.createTabAnnouncement();
        this.tabbedPane.addTab(ANNOUNCEMENTS, aPanel);
        final TabMessage message = new TabMessage(user);
        JPanel mPanel = message.createTabMessage();
        this.tabbedPane.addTab(MESSAGES, mPanel);
        final TabAvailability av = new TabAvailability();
        JPanel avPanel = av.createTabAvailability();
        this.tabbedPane.addTab(AVIALABILITY, avPanel);
        this.tabbedPane.validate();
        ((Component)this).setVisible(true);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                System.out.println("State is changed");
                if (Pinboard.this.tabbedPane.getTitleAt(Pinboard.this.tabbedPane.getSelectedIndex()).equals(Pinboard.AVIALABILITY)) {
                    av.refresh();
                } else if (Pinboard.this.tabbedPane.getTitleAt(Pinboard.this.tabbedPane.getSelectedIndex()).equals(Pinboard.ANNOUNCEMENTS)) {
                    announcement.refresh();
                } else if (Pinboard.this.tabbedPane.getTitleAt(Pinboard.this.tabbedPane.getSelectedIndex()).equals(Pinboard.MESSAGES)) {
                    message.refresh();
                } else {
                    Pinboard.this.tabbedPane.getTitleAt(Pinboard.this.tabbedPane.getSelectedIndex()).equals(Pinboard.ME);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
                Pinboard.this.makeIcon();
                Pinboard.this.displayMessage("Window opened", e);
            }

            public void windowIconified(WindowEvent e) {
                Pinboard.this.displayMessage("Window iconified", e);
            }

            public void windowDeiconified(WindowEvent e) {
                Pinboard.this.displayMessage("Window deiconified", e);
            }

            public void windowActivated(WindowEvent e) {
                Pinboard.this.displayMessage("Window activated", e);
            }

            public void windowDeactivated(WindowEvent e) {
                Pinboard.this.displayMessage("Window deactivated", e);
            }
        });
    }

    public void makeIcon() {
        try {
            if (WindowsTrayIcon.isRunning("Pinboard")) {
                return;
            }
            WindowsTrayIcon.initTrayIcon("Pinboard");
            System.out.println("making icon");
            ImageIcon imageicon = new ImageIcon("./Interface/pinboard.gif");
            final WindowsTrayIcon icon = new WindowsTrayIcon(imageicon.getImage(), 16, 16);
            icon.setToolTipText("Pinboard");
            icon.setPopup(this.makePopup());
            icon.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent evt) {
                    if ((evt.getModifiers() & 0x10) != 0 && evt.getClickCount() == 2) {
                        icon.addActionListener(new RestoreListener(true));
                        System.out.println("[Tray icon double clicked].");
                    }
                }
            });
            icon.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TrayIconPopup makePopup() {
        TrayIconPopup popup = new TrayIconPopup();
        TrayIconPopupSimpleItem item = new TrayIconPopupSimpleItem("&Show");
        item.setDefault(true);
        item.addActionListener(new RestoreListener(true));
        popup.addMenuItem(item);
        item = new TrayIconPopupSimpleItem("&About");
        item.addActionListener(new AboutListener());
        popup.addMenuItem(item);
        popup.addMenuItem(new TrayIconPopupSeparator());
        item = new TrayIconPopupSimpleItem("E&xit");
        item.addActionListener(new ExitListener());
        popup.addMenuItem(item);
        return popup;
    }

    void displayMessage(String prefix, WindowEvent e) {
    }

    public static void centerDialog(Window frame) {
        Dimension dialogSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(screenSize.width / 2 - dialogSize.width / 2, screenSize.height / 2 - dialogSize.height / 2);
    }

    public void actionPerformed(ActionEvent evt) {
        this.timer.start();
    }

    public void SetTitle() {
        long currentTime = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(currentTime);
        GregorianCalendar cal = new GregorianCalendar();
        this.setTitle("Pinboard Application                               " + cal.getTime());
    }

    private class WindowsMessageCallback
    implements TrayIconCallback {
        WindowsMessageCallback() {
        }

        public int callback(int param) {
            System.out.println("[Other instance started (parameter: " + param + ")].");
            ((Component)Pinboard.this).setVisible(true);
            Pinboard.this.toFront();
            Pinboard.this.requestFocus();
            return 4321;
        }
    }

    private class AboutListener
    implements ActionListener {
        AboutListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            System.out.println("[About selected].");
            AboutBox box = new AboutBox(Pinboard.this);
            Pinboard.centerDialog(box);
            ((Component)box).setVisible(true);
        }
    }

    private class ExitListener
    implements ActionListener {
        ExitListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Pinboard.this.dispose();
            System.exit(0);
        }
    }

    private class RestoreListener
    implements ActionListener {
        protected boolean from_menu;

        public RestoreListener(boolean fromMenu) {
            this.from_menu = fromMenu;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.from_menu) {
                ((Component)Pinboard.this).setVisible(true);
                Pinboard.this.toFront();
                Pinboard.this.requestFocus();
            } else if (evt.getActionCommand().equals("Left")) {
                if (!Pinboard.this.isVisible()) {
                    ((Component)Pinboard.this).setVisible(true);
                    Pinboard.this.toFront();
                    Pinboard.this.requestFocus();
                } else {
                    this.doHide(false);
                }
            }
        }

        public void doHide(boolean exitOnFail) {
            System.out.println("[Hide selected].");
            boolean visible = true;
            ((Component)Pinboard.this).setVisible(visible);
            if (visible) {
                System.out.println("[Hide works only when there's an icon in the system tray].");
                if (exitOnFail) {
                    this.doExit();
                }
            }
        }

        public void doExit() {
            System.out.println("[Exit selected / Close requested].");
            WindowsTrayIcon.cleanUp();
            System.exit(0);
        }
    }
}

