/*
 * Decompiled with CFR 0.152.
 */
package DatabaseCommunication;

import Data.AnnouncementData;
import DatabaseCommunication.DatabaseConnection;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;

public class AnnouncementManager {
    DatabaseConnection dbcon = new DatabaseConnection();

    public AnnouncementData[] selectAllAnnouncements() throws Exception {
        ResultSet rs = this.dbcon.executeSelect("SELECT * FROM announcement ORDER BY expiryTime DESC;");
        AnnouncementData[] announcementArray = new AnnouncementData[10];
        int i = 0;
        while (rs.next()) {
            if (rs.getTimestamp("expiryTime").after(new Timestamp(System.currentTimeMillis()))) {
                AnnouncementData announcement;
                announcementArray[i] = announcement = new AnnouncementData(this.stripTrailing(rs.getString("fromUser")), this.stripTrailing(rs.getString("body")), this.stripTrailing(rs.getString("subject")), rs.getTimestamp("time"));
            }
            ++i;
        }
        return announcementArray;
    }

    public String stripTrailing(String value) {
        if (value == null) {
            return "";
        }
        char[] cs = value.toCharArray();
        int end = cs.length;
        while (end > 0 && cs[end - 1] == ' ') {
            --end;
        }
        return new String(cs, 0, end);
    }

    public void insertAnnouncementData(AnnouncementData data) throws Exception {
        this.dbcon.execute("INSERT INTO announcement (fromUser,body,subject,time,expiryTime) VALUES ('" + data.getFrom() + "'," + "'" + data.getBody() + "'," + "'" + data.getSubject() + "'," + "'" + data.getTime() + "'," + "'" + this.calculateExpiry(data.getTime()) + "');");
    }

    public void updateAnnouncementData(AnnouncementData data) throws Exception {
        this.dbcon.execute("UPDATE announcement SET  from = '" + data.getFrom() + "'," + " body = '" + data.getBody() + "'," + " subject = '" + data.getSubject() + "'," + " time = '" + data.getTime() + "'," + " expiryTime = '" + this.calculateExpiry(data.getTime()) + "',");
    }

    public void deleteUserData(AnnouncementData data) throws Exception {
        this.dbcon.execute("DELETE FROM announcement WHERE time = '" + data.getTime() + "'");
    }

    private Timestamp calculateExpiry(Timestamp fromTime) {
        if (fromTime != null) {
            long expiry = AnnouncementManager.addDays(fromTime, 1);
            Timestamp expiryTime = new Timestamp(expiry);
            return expiryTime;
        }
        return null;
    }

    public static long addDays(Date startDate, int numberOfDays) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startDate);
        cal.add(5, numberOfDays);
        return cal.getTimeInMillis();
    }
}

