/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.Stack;
import org.exolab.castor.xml.Namespaces;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAX2ANY
implements ContentHandler,
DocumentHandler,
ErrorHandler {
    private static final String XMLNS_PREFIX = "xmlns";
    private static final int XMLNS_PREFIX_LENGTH = "xmlns".length() + 1;
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private AnyNode _startingNode;
    private AnyNode _node;
    private Stack _nodeStack = new Stack();
    private Stack _namespaces = new Stack();
    private Locator _locator;
    private boolean _character = false;
    private Namespaces _context;

    public SAX2ANY() {
        this.init();
    }

    public SAX2ANY(Namespaces context) {
        this._context = context;
        this.init();
    }

    private void init() {
        if (this._context == null) {
            this._context = new Namespaces();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        AnyNode temp = new AnyNode(3, null, prefix, uri, null);
        this._namespaces.push(temp);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        String value;
        String qName;
        this._character = false;
        AnyNode tempNode = null;
        this._context = this._context.createNamespaces();
        String prefix = "";
        String namespaceURI = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            prefix = name.substring(0, idx);
        }
        namespaceURI = this._context.getNamespaceURI(prefix);
        int i = 0;
        while (i < atts.getLength()) {
            qName = atts.getName(i);
            value = atts.getValue(i);
            String nsPrefix = null;
            if (qName.startsWith(XMLNS_PREFIX)) {
                nsPrefix = qName.equals(XMLNS_PREFIX) ? null : qName.substring(XMLNS_PREFIX_LENGTH);
                tempNode = new AnyNode(3, this.getLocalPart(qName), nsPrefix, value, null);
                this._context.addNamespace(nsPrefix, value);
                this._namespaces.push(tempNode);
                if (prefix.equals(nsPrefix)) {
                    namespaceURI = value;
                }
            }
            ++i;
        }
        this.createNodeElement(namespaceURI, this.getLocalPart(name), name);
        while (!this._namespaces.empty()) {
            tempNode = (AnyNode)this._namespaces.pop();
            this._node.addNamespace(tempNode);
        }
        int i2 = 0;
        while (i2 < atts.getLength()) {
            qName = atts.getName(i2);
            value = atts.getValue(i2);
            if (!qName.startsWith(XMLNS_PREFIX)) {
                tempNode = new AnyNode(2, this.getLocalPart(qName), null, null, value);
                this._node.addAttribute(tempNode);
            }
            ++i2;
        }
        tempNode = null;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.createNodeElement(namespaceURI, localName, qName);
        AnyNode tempNode = null;
        while (!this._namespaces.empty()) {
            tempNode = (AnyNode)this._namespaces.pop();
            this._node.addNamespace(tempNode);
        }
        int i = 0;
        while (i < atts.getLength()) {
            String uri = atts.getURI(i);
            String qname = atts.getQName(i);
            String localname = atts.getLocalName(i);
            String value = atts.getValue(i);
            tempNode = new AnyNode(2, localname, null, uri, value);
            this._node.addAttribute(tempNode);
            ++i;
        }
        tempNode = null;
    }

    public void endElement(String name) throws SAXException {
        String prefix = "";
        String namespaceURI = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            prefix = name.substring(0, idx);
        }
        namespaceURI = this._context.getNamespaceURI(prefix);
        this.endElement(namespaceURI, this.getLocalPart(name), name);
        this._context = this._context.getParent();
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this._character = false;
        if (this._startingNode.getLocalName().equals(localName) && this._nodeStack.empty()) {
            return;
        }
        this._node = (AnyNode)this._nodeStack.pop();
        if (this._nodeStack.empty()) {
            this._startingNode.addChild(this._node);
            this._node = this._startingNode;
        } else {
            AnyNode previousNode = (AnyNode)this._nodeStack.peek();
            previousNode.addChild(this._node);
            this._node = previousNode;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String temp = new String(ch, start, length);
        if (this.isWhitespace(temp) & !this._character) {
            return;
        }
        AnyNode tempNode = new AnyNode(6, null, null, null, temp);
        this._node.addChild(tempNode);
        this._character = true;
    }

    public void warning(SAXParseException e) throws SAXException {
        String err = "SAX2ANY warning\nLine : " + e.getLineNumber() + '\n' + "URI : " + e.getSystemId() + '\n' + e.getMessage();
        throw new SAXException(err, e);
    }

    public void error(SAXParseException e) throws SAXException {
        String err = "SAX2ANY Error \nLine : " + e.getLineNumber() + '\n' + "URI : " + e.getSystemId() + '\n' + e.getMessage();
        throw new SAXException(err, e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        String err = "SAX2ANY Fatal Error \nLine : " + e.getLineNumber() + '\n' + "URI : " + e.getSystemId() + '\n' + e.getMessage();
        throw new SAXException(err, e);
    }

    public AnyNode getStartingNode() {
        return this._startingNode;
    }

    public Namespaces getNamespaceContext() {
        return this._context;
    }

    public void setNamespaceContext(Namespaces context) {
        this._context = context;
    }

    private boolean isWhitespace(String string) {
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private String getLocalPart(String ncName) {
        int idx = ncName.indexOf(58);
        if (idx >= 0) {
            return ncName.substring(idx + 1);
        }
        return ncName;
    }

    private void createNodeElement(String namespaceURI, String localName, String qName) {
        String prefix = null;
        if (qName.length() != 0 && qName.indexOf(58) != -1) {
            prefix = qName.substring(0, qName.indexOf(58));
        }
        if (this._nodeStack.empty() && this._startingNode == null) {
            this._node = this._startingNode = new AnyNode(1, localName, prefix, namespaceURI, null);
        } else {
            this._node = new AnyNode(1, localName, prefix, namespaceURI, null);
            this._nodeStack.push(this._node);
        }
    }
}

