/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.FileLocation;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.UnmarshalListener;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.exolab.castor.xml.util.DOMEventProducer;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderAdapter;

public class Unmarshaller {
    private ClassDescriptorResolver _cdResolver = null;
    private Class _class = null;
    private boolean _clearCollections = false;
    private Configuration _config = null;
    private IDResolver _idResolver = null;
    private boolean _ignoreExtraAtts = true;
    private boolean _ignoreExtraElements = false;
    private Object _instanceObj = null;
    EntityResolver entityResolver = null;
    private ClassLoader _loader = null;
    private PrintWriter _pw = null;
    private boolean _debug = false;
    private boolean _reuseObjects = false;
    private UnmarshalListener _unmarshalListener = null;
    private boolean _validate = false;

    public Unmarshaller() {
        this(null, null);
    }

    public Unmarshaller(Class c) {
        this(c, null);
    }

    public Unmarshaller(Class c, ClassLoader loader) {
        this.initConfig();
        this._class = c;
        this._loader = loader;
        this._cdResolver = new ClassDescriptorResolverImpl(loader);
    }

    public Unmarshaller(Mapping mapping) throws MappingException {
        this.initConfig();
        if (mapping != null) {
            this.setMapping(mapping);
            this._loader = mapping.getClassLoader();
        }
    }

    public Unmarshaller(Object root) {
        this.initConfig();
        if (root != null) {
            this._class = root.getClass();
            this._loader = this._class.getClassLoader();
        }
        this._instanceObj = root;
    }

    private void initConfig() {
        this._config = LocalConfiguration.getInstance();
        this._debug = this._config.debug();
        this._validate = this._config.marshallingValidation();
        this._ignoreExtraElements = !this._config.strictElements();
    }

    public UnmarshalHandler createHandler() {
        UnmarshalHandler handler = new UnmarshalHandler(this._class);
        if (this._cdResolver == null) {
            this._cdResolver = new ClassDescriptorResolverImpl(this._loader);
        }
        handler.setResolver(this._cdResolver);
        handler.setLogWriter(this._pw);
        handler.setClearCollections(this._clearCollections);
        handler.setDebug(this._debug);
        handler.setReuseObjects(this._reuseObjects);
        handler.setValidation(this._validate);
        handler.setIgnoreExtraAttributes(this._ignoreExtraAtts);
        handler.setIgnoreExtraElements(this._ignoreExtraElements);
        handler.setConfiguration(this._config);
        if (this._instanceObj != null) {
            handler.setRootObject(this._instanceObj);
        }
        if (this._idResolver != null) {
            handler.setIDResolver(this._idResolver);
        }
        if (this._loader != null) {
            handler.setClassLoader(this._loader);
        }
        if (this._unmarshalListener != null) {
            handler.setUnmarshalListener(this._unmarshalListener);
        }
        return handler;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setClearCollections(boolean clear) {
        this._clearCollections = clear;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setIDResolver(IDResolver idResolver) {
        this._idResolver = idResolver;
    }

    public void setIgnoreExtraAttributes(boolean ignoreExtraAtts) {
        this._ignoreExtraAtts = ignoreExtraAtts;
    }

    public void setIgnoreExtraElements(boolean ignoreExtraElements) {
        this._ignoreExtraElements = ignoreExtraElements;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._pw = printWriter;
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._loader == null) {
            this._loader = mapping.getClassLoader();
        }
        if (this._cdResolver == null) {
            this._cdResolver = new ClassDescriptorResolverImpl(this._loader);
        }
        this._cdResolver.setMappingLoader((XMLMappingLoader)mapping.getResolver(Mapping.XML));
    }

    public void setReuseObjects(boolean reuse) {
        this._reuseObjects = reuse;
    }

    public void setResolver(ClassDescriptorResolver cdr) {
        this._cdResolver = cdr != null ? cdr : new ClassDescriptorResolverImpl(this._loader);
    }

    public void setUnmarshalListener(UnmarshalListener listener) {
        this._unmarshalListener = listener;
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return this.unmarshal(new InputSource(reader));
    }

    public Object unmarshal(EventProducer eventProducer) throws MarshalException, ValidationException {
        UnmarshalHandler handler = this.createHandler();
        eventProducer.setDocumentHandler(handler);
        try {
            eventProducer.start();
        }
        catch (SAXException sx) {
            Exception except = sx.getException();
            if (except == null) {
                except = sx;
            }
            MarshalException marshalEx = new MarshalException(except);
            if (handler.getDocumentLocator() != null) {
                FileLocation location = new FileLocation();
                location.setFilename(handler.getDocumentLocator().getSystemId());
                location.setLineNumber(handler.getDocumentLocator().getLineNumber());
                location.setColumnNumber(handler.getDocumentLocator().getColumnNumber());
                marshalEx.setLocation(location);
            }
            throw marshalEx;
        }
        return handler.getObject();
    }

    public Object unmarshal(InputSource source) throws MarshalException, ValidationException {
        Parser parser = this._config.getParser();
        if (parser == null) {
            throw new MarshalException("unable to create parser");
        }
        if (this.entityResolver != null) {
            parser.setEntityResolver(this.entityResolver);
        }
        UnmarshalHandler handler = this.createHandler();
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            parser.parse(source);
        }
        catch (IOException ioe) {
            throw new MarshalException(ioe);
        }
        catch (SAXException sx) {
            Exception except = sx.getException();
            if (except == null) {
                except = sx;
            }
            MarshalException marshalEx = new MarshalException(except);
            if (handler.getDocumentLocator() != null) {
                FileLocation location = new FileLocation();
                location.setFilename(handler.getDocumentLocator().getSystemId());
                location.setLineNumber(handler.getDocumentLocator().getLineNumber());
                location.setColumnNumber(handler.getDocumentLocator().getColumnNumber());
                marshalEx.setLocation(location);
            }
            throw marshalEx;
        }
        return handler.getObject();
    }

    public Object unmarshal(Node node) throws MarshalException, ValidationException {
        return this.unmarshal(new DOMEventProducer(node));
    }

    public static ContentHandler getContentHandler(UnmarshalHandler handler) throws SAXException {
        XMLReaderAdapter adapter = new XMLReaderAdapter();
        adapter.setDocumentHandler(handler);
        return adapter;
    }

    public static Object unmarshal(Class c, Reader reader) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(c);
        return unmarshaller.unmarshal(reader);
    }

    public static Object unmarshal(Class c, InputSource source) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(c);
        return unmarshaller.unmarshal(source);
    }

    public static Object unmarshal(Class c, Node node) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(c);
        return unmarshaller.unmarshal(node);
    }
}

