/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.exolab.castor.mapping.AbstractFieldHandler;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.ExtendedFieldHandler;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingRuntimeException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.util.Messages;

public final class FieldHandlerImpl
extends AbstractFieldHandler {
    private static final String ADD_PREFIX = "add";
    private final FieldHandler _handler;
    private final Field _field;
    private Method[] _getSequence;
    private Method[] _setSequence;
    private Method _addMethod;
    private Method _getMethod;
    private Method _setMethod;
    private Method _hasMethod;
    private Method _deleteMethod;
    private Method _createMethod;
    private final String _fieldName;
    private final Class _fieldType;
    private final boolean _immutable;
    private final Object _default;
    private boolean _required;
    private TypeConvertor _convertTo = null;
    private TypeConvertor _convertFrom = null;
    private final String _convertParam;
    private final CollectionHandler _colHandler;

    public FieldHandlerImpl(FieldHandler handler, TypeInfo typeInfo) throws MappingException {
        this._handler = handler;
        this._field = null;
        this._fieldName = handler.toString();
        this._fieldType = Types.typeFromPrimitive(typeInfo.getFieldType());
        this._immutable = typeInfo.isImmutable();
        this._required = typeInfo.isRequired();
        this._default = typeInfo.getDefaultValue();
        this._convertTo = typeInfo.getConvertorTo();
        this._convertFrom = typeInfo.getConvertorFrom();
        this._convertParam = typeInfo.getConvertorParam();
        this._colHandler = typeInfo.getCollectionHandler();
    }

    public FieldHandlerImpl(Field field, TypeInfo typeInfo) throws MappingException {
        if (field.getModifiers() != 1 && field.getModifiers() != 65) {
            throw new MappingException("mapping.fieldNotAccessible", field.getName(), field.getDeclaringClass().getName());
        }
        this._handler = null;
        this._field = field;
        this._fieldType = Types.typeFromPrimitive(typeInfo.getFieldType());
        this._fieldName = field.getName() + "(" + this._fieldType.getName() + ")";
        this._immutable = typeInfo.isImmutable();
        this._required = typeInfo.isRequired();
        this._default = this._field.getType().isPrimitive() ? typeInfo.getDefaultValue() : null;
        this._convertTo = typeInfo.getConvertorTo();
        this._convertFrom = typeInfo.getConvertorFrom();
        this._convertParam = typeInfo.getConvertorParam();
        this._colHandler = typeInfo.getCollectionHandler();
    }

    public FieldHandlerImpl(String fieldName, Method[] getSequence, Method[] setSequence, Method getMethod, Method setMethod, TypeInfo typeInfo) throws MappingException {
        this._handler = null;
        this._field = null;
        if (fieldName == null) {
            throw new IllegalArgumentException("Argument 'fieldName' is null");
        }
        this._getSequence = getSequence;
        this._setSequence = setSequence;
        if (setMethod != null) {
            if (setMethod.getName().startsWith(ADD_PREFIX)) {
                Class<?> pType = setMethod.getParameterTypes()[0];
                if (pType != typeInfo.getFieldType()) {
                    this.setAddMethod(setMethod);
                } else {
                    this.setWriteMethod(setMethod);
                }
            } else {
                this.setWriteMethod(setMethod);
            }
        }
        if (getMethod != null) {
            this.setReadMethod(getMethod);
        }
        this._fieldType = Types.typeFromPrimitive(typeInfo.getFieldType());
        this._fieldName = fieldName + "(" + this._fieldType.getName() + ")";
        this._immutable = typeInfo.isImmutable();
        this._required = typeInfo.isRequired();
        this._default = setMethod != null && setMethod.getParameterTypes()[0].isPrimitive() ? typeInfo.getDefaultValue() : null;
        this._convertTo = typeInfo.getConvertorTo();
        this._convertFrom = typeInfo.getConvertorFrom();
        this._convertParam = typeInfo.getConvertorParam();
        this._colHandler = typeInfo.getCollectionHandler();
    }

    public TypeConvertor getConvertFrom() {
        return this._convertFrom;
    }

    public TypeConvertor getConvertTo() {
        return this._convertTo;
    }

    public String getConvertParam() {
        return this._convertParam;
    }

    public Object getValue(Object object) {
        Object value;
        try {
            if (this._handler != null) {
                value = this._handler.getValue(object);
            } else if (this._field != null) {
                value = this._field.get(object);
            } else if (this._getMethod != null) {
                if (this._getSequence != null) {
                    int i = 0;
                    while (i < this._getSequence.length) {
                        if ((object = this._getSequence[i].invoke(object, null)) == null) break;
                        ++i;
                    }
                }
                value = object == null || this._hasMethod != null && !((Boolean)this._hasMethod.invoke(object, null)).booleanValue() ? null : this._getMethod.invoke(object, null);
            } else {
                value = null;
            }
        }
        catch (IllegalAccessException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
        }
        catch (InvocationTargetException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaChangeInvocation", this.toString(), except));
        }
        if (this._colHandler != null && this._convertFrom == null) {
            if (value == null) {
                return new CollectionHandlers.EmptyEnumerator();
            }
            return this._colHandler.elements(value);
        }
        if (this._convertFrom == null || value == null) {
            return value;
        }
        try {
            return this._convertFrom.convert(value, this._convertParam);
        }
        catch (ClassCastException except) {
            throw new IllegalArgumentException(Messages.format("mapping.wrongConvertor", value.getClass().getName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object object, Object value) {
        if (this._colHandler == null || this._addMethod != null) {
            if (value != null && this._convertTo != null) {
                try {
                    value = this._convertTo.convert(value, this._convertParam);
                }
                catch (ClassCastException except) {
                    throw new IllegalArgumentException(Messages.format("mapping.wrongConvertor", value.getClass().getName()));
                }
            }
            try {
                if (this._handler != null) {
                    this._handler.setValue(object, value);
                    return;
                }
                if (this._field != null) {
                    this._field.set(object, value == null ? this._default : value);
                    return;
                }
                Method setter = this.selectWriteMethod(value);
                if (setter == null) return;
                if (this._getSequence != null) {
                    int i = 0;
                    while (i < this._getSequence.length) {
                        Object last = object;
                        if ((object = this._getSequence[i].invoke(object, null)) == null) {
                            if (value == null || this._setSequence[i] == null) break;
                            object = Types.newInstance(this._getSequence[i].getReturnType());
                            this._setSequence[i].invoke(last, object);
                        }
                        ++i;
                    }
                }
                if (object == null) return;
                if (value == null && this._deleteMethod != null) {
                    this._deleteMethod.invoke(object, null);
                    return;
                }
                setter.invoke(object, value == null ? this._default : value);
                return;
            }
            catch (IllegalArgumentException except) {
                if (value != null) throw new IllegalArgumentException(Messages.format("mapping.typeConversion", this.toString(), value.getClass().getName()));
                throw new IllegalArgumentException(Messages.format("mapping.typeConversionNull", this.toString()));
            }
            catch (IllegalAccessException except) {
                throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
            }
            catch (InvocationTargetException except) {
                throw new MappingRuntimeException(except.getTargetException());
            }
        }
        if (value == null) return;
        try {
            if (this._handler != null) {
                Object collect = this._handler.getValue(object);
                if ((collect = this._colHandler.add(collect, value)) == null) return;
                this._handler.setValue(object, collect);
                return;
            }
            if (this._field != null) {
                Class<?> type;
                Object collect = this._field.get(object);
                if (collect == null && (type = this._field.getType()).isArray()) {
                    Class<?> componentType = type.getComponentType();
                    Class<?> valueType = value.getClass();
                    if (componentType.isPrimitive() || !valueType.isArray() && valueType != componentType) {
                        try {
                            collect = Array.newInstance(componentType, 0);
                        }
                        catch (Exception e) {
                            String err = "Unable to instantiate an array of '" + componentType + "' : " + e;
                            throw new IllegalStateException(err);
                        }
                    }
                }
                if ((collect = this._colHandler.add(collect, value)) == null) return;
                this._field.set(object, collect);
                return;
            }
            if (this._getMethod == null) return;
            if (this._getSequence != null) {
                int i = 0;
                while (i < this._getSequence.length) {
                    object = this._getSequence[i].invoke(object, null);
                    ++i;
                }
            }
            Object collect = this._getMethod.invoke(object, null);
            boolean setCollection = false;
            if (collect == null) {
                Class<?> type = this._getMethod.getReturnType();
                if (type.isArray()) {
                    Class<?> componentType = type.getComponentType();
                    Class<?> valueType = value.getClass();
                    if (componentType.isPrimitive() || !valueType.isArray() && valueType != componentType) {
                        try {
                            collect = Array.newInstance(componentType, 0);
                        }
                        catch (Exception e) {
                            String err = "Unable to instantiate an array of '" + componentType + "' : " + e;
                            throw new IllegalStateException(err);
                        }
                    }
                }
                setCollection = true;
            } else {
                setCollection = collect.getClass().isArray();
            }
            Object tmp = this._colHandler.add(collect, value);
            if (tmp != null) {
                collect = tmp;
            }
            if (!setCollection || this._setMethod == null) return;
            this._setMethod.invoke(object, collect);
            return;
        }
        catch (IllegalAccessException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
        }
        catch (InvocationTargetException except) {
            throw new MappingRuntimeException(except.getTargetException());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetValue(Object object) {
        if (this._colHandler == null) {
            try {
                if (this._handler != null) {
                    this._handler.resetValue(object);
                    return;
                }
                if (this._field != null) {
                    this._field.set(object, this._default);
                    return;
                }
                if (this._setMethod == null) return;
                if (this._getSequence != null) {
                    int i = 0;
                    while (i < this._getSequence.length) {
                        if ((object = this._getSequence[i].invoke(object, null)) == null) break;
                        ++i;
                    }
                }
                if (object == null) return;
                if (this._deleteMethod != null) {
                    this._deleteMethod.invoke(object, null);
                    return;
                }
                this._setMethod.invoke(object, this._default);
                return;
            }
            catch (IllegalArgumentException except) {
                throw new IllegalArgumentException(Messages.format("mapping.typeConversionNull", this.toString()));
            }
            catch (IllegalAccessException except) {
                throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
            }
            catch (InvocationTargetException except) {
                throw new MappingRuntimeException(except.getTargetException());
            }
        }
        try {
            if (this._handler != null) {
                this._handler.resetValue(object);
                return;
            } else if (this._field != null) {
                Object collect = this._field.get(object);
                if ((collect = this._colHandler.clear(collect)) == null) return;
                this._field.set(object, collect);
                return;
            } else {
                if (this._getMethod == null) return;
                if (this._getSequence != null) {
                    int i = 0;
                    while (i < this._getSequence.length) {
                        object = this._getSequence[i].invoke(object, null);
                        ++i;
                    }
                }
                Object collect = this._getMethod.invoke(object, null);
                if ((collect = this._colHandler.clear(collect)) == null || this._setMethod == null) return;
                this._setMethod.invoke(object, collect);
            }
            return;
        }
        catch (IllegalAccessException except) {
            throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
        }
        catch (InvocationTargetException except) {
            throw new MappingRuntimeException(except.getTargetException());
        }
    }

    public Object newInstance(Object parent) throws IllegalStateException {
        return this.newInstance(parent, null);
    }

    public Object newInstance(Object parent, Object[] args) throws IllegalStateException {
        if (this._fieldType.isInterface() && this._createMethod == null) {
            return null;
        }
        if (this._immutable) {
            throw new IllegalStateException(Messages.format("mapping.classNotConstructable", this._fieldType));
        }
        if (this._handler != null) {
            if (this._handler instanceof ExtendedFieldHandler) {
                return ((ExtendedFieldHandler)this._handler).newInstance(parent, args);
            }
            return this._handler.newInstance(parent);
        }
        if (this._createMethod != null && parent != null) {
            try {
                return this._createMethod.invoke(parent, args);
            }
            catch (IllegalAccessException except) {
                throw new IllegalStateException(Messages.format("mapping.schemaChangeNoAccess", this.toString()));
            }
            catch (InvocationTargetException except) {
                throw new MappingRuntimeException(except.getTargetException());
            }
        }
        return Types.newInstance(this._fieldType, args);
    }

    void setRequired(boolean required) {
        this._required = required;
    }

    public void setConvertFrom(TypeConvertor convertor) {
        this._convertFrom = convertor;
    }

    public void setConvertTo(TypeConvertor convertor) {
        this._convertTo = convertor;
    }

    public void setCreateMethod(Method method) throws MappingException {
        if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
            throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
        }
        if (method.getParameterTypes().length != 0) {
            throw new MappingException("mapping.createMethodNoParam", method, method.getDeclaringClass().getName());
        }
        this._createMethod = method;
    }

    public void setHasDeleteMethod(Method hasMethod, Method deleteMethod) throws MappingException {
        if (hasMethod != null) {
            if ((hasMethod.getModifiers() & 1) == 0 || (hasMethod.getModifiers() & 8) != 0) {
                throw new MappingException("mapping.accessorNotAccessible", hasMethod, hasMethod.getDeclaringClass().getName());
            }
            if (hasMethod.getParameterTypes().length != 0) {
                throw new MappingException("mapping.createMethodNoParam", hasMethod, hasMethod.getDeclaringClass().getName());
            }
            this._hasMethod = hasMethod;
        }
        if (deleteMethod != null) {
            if ((deleteMethod.getModifiers() & 1) == 0 || (deleteMethod.getModifiers() & 8) != 0) {
                throw new MappingException("mapping.accessorNotAccessible", deleteMethod, deleteMethod.getDeclaringClass().getName());
            }
            if (deleteMethod.getParameterTypes().length != 0) {
                throw new MappingException("mapping.createMethodNoParam", deleteMethod, deleteMethod.getDeclaringClass().getName());
            }
            this._deleteMethod = deleteMethod;
        }
    }

    public void setReadMethod(Method method) throws MappingException {
        if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
            throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
        }
        if (method.getParameterTypes().length != 0) {
            throw new MappingException("mapping.readMethodHasParam", method, method.getDeclaringClass().getName());
        }
        this._getMethod = method;
    }

    public void setWriteMethod(Method method) throws MappingException {
        if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
            throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
        }
        if (method.getParameterTypes().length != 1) {
            throw new MappingException("mapping.writeMethodNoParam", method, method.getDeclaringClass().getName());
        }
        this._setMethod = method;
    }

    public void setAddMethod(Method method) throws MappingException {
        if ((method.getModifiers() & 1) == 0 || (method.getModifiers() & 8) != 0) {
            throw new MappingException("mapping.accessorNotAccessible", method, method.getDeclaringClass().getName());
        }
        if (method.getParameterTypes().length != 1) {
            throw new MappingException("mapping.writeMethodNoParam", method, method.getDeclaringClass().getName());
        }
        this._addMethod = method;
        if (this._addMethod == this._setMethod) {
            this._setMethod = null;
        }
    }

    private Method selectWriteMethod(Object value) {
        Object setter = null;
        if (this._setMethod != null) {
            Class<?> paramType;
            if (this._addMethod == null) {
                return this._setMethod;
            }
            if (value == null) {
                if (this._default != null) {
                    value = this._default;
                } else {
                    return this._setMethod;
                }
            }
            if ((paramType = this._setMethod.getParameterTypes()[0]).isAssignableFrom(value.getClass())) {
                return this._setMethod;
            }
        }
        return this._addMethod;
    }

    public boolean isCollection() {
        return this._colHandler != null;
    }

    public String toString() {
        return this._fieldName;
    }
}

