/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.BaseFactory;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.SQLTypes;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;

public final class SQLEngine
implements Persistence {
    private static final boolean ID_TYPE = true;
    private static final boolean FIELD_TYPE = false;
    private static Hashtable _separateConnections = new Hashtable();
    private String _pkLookup;
    private String _sqlCreate;
    private String _sqlRemove;
    private String _sqlStore;
    private String _sqlStoreDirty;
    private String _sqlLoad;
    private String _sqlLoadLock;
    private FieldInfo[] _fields;
    private ColumnInfo[] _ids;
    private SQLEngine _extends;
    private QueryExpression _sqlFinder;
    private PersistenceFactory _factory;
    private String _stampField;
    private String _type;
    private String _mapTo;
    private String _extTable;
    private LogInterceptor _logInterceptor;
    private JDOClassDescriptor _clsDesc;
    private KeyGenerator _keyGen;
    private ClassMolder _mold;
    private static Logger _logger;

    SQLEngine(JDOClassDescriptor clsDesc, LogInterceptor logInterceptor, PersistenceFactory factory, String stampField) throws MappingException {
        KeyGeneratorDescriptor keyGenDesc;
        this._clsDesc = clsDesc;
        this._stampField = stampField;
        this._factory = factory;
        this._logInterceptor = logInterceptor;
        this._keyGen = null;
        this._type = clsDesc.getJavaClass().getName();
        this._mapTo = clsDesc.getTableName();
        if (this._clsDesc.getExtends() == null && (keyGenDesc = clsDesc.getKeyGeneratorDescriptor()) != null) {
            int[] tempType = ((JDOFieldDescriptor)this._clsDesc.getIdentity()).getSQLType();
            this._keyGen = keyGenDesc.getKeyGeneratorRegistry().getKeyGenerator(this._factory, keyGenDesc, tempType == null ? 0 : tempType[0], this._logInterceptor);
        }
        Vector<ColumnInfo> idsInfo = new Vector<ColumnInfo>();
        Vector<FieldInfo> fieldsInfo = new Vector<FieldInfo>();
        JDOClassDescriptor base = clsDesc;
        base = clsDesc;
        Stack<JDOClassDescriptor> stack = new Stack<JDOClassDescriptor>();
        stack.push(base);
        while (base.getExtends() != null) {
            base = (JDOClassDescriptor)base.getExtends();
            stack.push(base);
        }
        if (base != clsDesc) {
            this._extTable = base.getTableName();
        }
        JDOClassDescriptor jdoBase = base;
        FieldDescriptor[] baseIdDescriptors = base.getIdentities();
        FieldDescriptor[] idDescriptors = clsDesc.getIdentities();
        int i = 0;
        while (i < baseIdDescriptors.length) {
            FieldHandlerImpl fh;
            int[] sqlType;
            String[] sqlName;
            if (baseIdDescriptors[i] instanceof JDOFieldDescriptor) {
                String name = baseIdDescriptors[i].getFieldName();
                sqlName = ((JDOFieldDescriptor)baseIdDescriptors[i]).getSQLName();
                sqlType = ((JDOFieldDescriptor)baseIdDescriptors[i]).getSQLType();
                fh = (FieldHandlerImpl)baseIdDescriptors[i].getHandler();
                int j = 0;
                while (j < idDescriptors.length) {
                    if (name.equals(idDescriptors[j].getFieldName()) && idDescriptors[j] instanceof JDOFieldDescriptor) {
                        sqlName = ((JDOFieldDescriptor)idDescriptors[j]).getSQLName();
                        break;
                    }
                    ++j;
                }
            } else {
                throw new MappingException("Except JDOFieldDescriptor");
            }
            idsInfo.add(new ColumnInfo(sqlName[0], sqlType[0], fh.getConvertTo(), fh.getConvertFrom(), fh.getConvertParam()));
            ++i;
        }
        boolean extendField = true;
        while (!stack.empty()) {
            base = (JDOClassDescriptor)stack.pop();
            FieldDescriptor[] fieldDescriptors = base.getFields();
            int i2 = 0;
            while (i2 < fieldDescriptors.length) {
                if (fieldDescriptors[i2] instanceof JDOFieldDescriptor || fieldDescriptors[i2].getClassDescriptor() != null) {
                    if (stack.empty()) {
                        fieldsInfo.add(new FieldInfo(clsDesc, fieldDescriptors[i2], clsDesc.getTableName(), !extendField));
                    } else {
                        fieldsInfo.add(new FieldInfo(clsDesc, fieldDescriptors[i2], base.getTableName(), extendField));
                    }
                }
                ++i2;
            }
        }
        this._ids = new ColumnInfo[idsInfo.size()];
        idsInfo.copyInto(this._ids);
        this._fields = new FieldInfo[fieldsInfo.size()];
        fieldsInfo.copyInto(this._fields);
        try {
            this.buildSql();
            this.buildFinder(clsDesc);
        }
        catch (QueryException except) {
            except.printStackTrace();
            throw new MappingException(except);
        }
    }

    public Persistence.FieldInfo[] getInfo() {
        return this._fields;
    }

    public void setExtends(SQLEngine engine) {
        this._extends = engine;
    }

    private synchronized Connection getSeparateConnection(Database database) throws PersistenceException {
        DatabaseRegistry dr = DatabaseRegistry.getDatabaseRegistry(database.getDatabaseName());
        Connection conn = (Connection)_separateConnections.get(dr);
        if (conn == null) {
            try {
                conn = dr.createConnection();
                conn.setAutoCommit(false);
                _separateConnections.put(dr, conn);
            }
            catch (SQLException except) {
                throw new PersistenceException(Messages.message("persist.cannotCreateSeparateConn"), except);
            }
        }
        return conn;
    }

    public JDOClassDescriptor getDescriptor() {
        return this._clsDesc;
    }

    public String quoteName(String name) {
        return this._factory.quoteName(name);
    }

    public PersistenceQuery createQuery(QueryExpression query, Class[] types, AccessMode accessMode) throws QueryException {
        if (accessMode == null) {
            accessMode = this._clsDesc.getAccessMode();
        }
        String sql = query.getStatement(accessMode == AccessMode.DbLocked);
        if (this._logInterceptor != null) {
            this._logInterceptor.queryStatement(sql);
        }
        return new SQLQuery(this, sql, types);
    }

    public PersistenceQuery createCall(String spCall, Class[] types) {
        if (this._logInterceptor != null) {
            this._logInterceptor.queryStatement(spCall);
        }
        FieldDescriptor[] fields = this._clsDesc.getFields();
        String[] jdoFields0 = new String[fields.length + 1];
        int[] sqlTypes0 = new int[fields.length + 1];
        int count = 1;
        jdoFields0[0] = this._clsDesc.getIdentity().getFieldName();
        sqlTypes0[0] = ((JDOFieldDescriptor)this._clsDesc.getIdentity()).getSQLType()[0];
        int i = 0;
        while (i < fields.length) {
            if (fields[i] instanceof JDOFieldDescriptor) {
                jdoFields0[count] = ((JDOFieldDescriptor)fields[i]).getSQLName()[0];
                sqlTypes0[count] = ((JDOFieldDescriptor)fields[i]).getSQLType()[0];
                ++count;
            }
            ++i;
        }
        String[] jdoFields = new String[count];
        int[] sqlTypes = new int[count];
        System.arraycopy(jdoFields0, 0, jdoFields, 0, count);
        System.arraycopy(sqlTypes0, 0, sqlTypes, 0, count);
        if (spCall.startsWith("SQL")) {
            String sql = spCall.substring(4);
            return new SQLQuery(this, sql, types);
        }
        return ((BaseFactory)this._factory).getCallQuery(spCall, types, this._clsDesc.getJavaClass(), jdoFields, sqlTypes);
    }

    public QueryExpression getQueryExpression() {
        return this._factory.getQueryExpression();
    }

    public QueryExpression getFinder() {
        return (QueryExpression)this._sqlFinder.clone();
    }

    private Object idToSQL(int index, Object object) throws PersistenceException {
        if (object == null || this._ids[index].convertFrom == null) {
            return object;
        }
        return this._ids[index].convertFrom.convert(object, this._ids[index].convertParam);
    }

    private Object toSQL(int field, int column, Object object) throws PersistenceException {
        ColumnInfo col = this._fields[field].columns[column];
        if (object == null || col.convertFrom == null) {
            return object;
        }
        return col.convertFrom.convert(object, col.convertParam);
    }

    private Object idToJava(int index, Object object) throws PersistenceException {
        if (object == null || this._ids[index].convertTo == null) {
            return object;
        }
        return this._ids[index].convertTo.convert(object, this._ids[index].convertParam);
    }

    private Object toJava(int field, int column, Object object) throws PersistenceException {
        ColumnInfo col = this._fields[field].columns[column];
        if (object == null || col.convertTo == null) {
            return object;
        }
        return col.convertTo.convert(object, col.convertParam);
    }

    private Object generateKey(Database database, Object conn, PreparedStatement stmt) throws PersistenceException {
        Object identity;
        Properties prop = null;
        Connection connection = this._keyGen.isInSameConnection() ? (Connection)conn : this.getSeparateConnection(database);
        if (stmt != null) {
            prop = new Properties();
            ((Hashtable)prop).put("insertStatement", stmt);
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            identity = this._keyGen.generateKey(connection, this._clsDesc.getTableName(), this._ids[0].name, prop);
        }
        if (identity == null) {
            throw new PersistenceException(Messages.format("persist.noIdentity", this._clsDesc.getJavaClass().getName()));
        }
        return this.idToJava(0, identity);
    }

    public Object create(Database database, Object conn, Object[] fields, Object identity) throws DuplicateIdentityException, PersistenceException {
        PreparedStatement stmt = null;
        if (this._extends == null && this._keyGen == null && identity == null) {
            throw new PersistenceException(Messages.format("persist.noIdentity", this._clsDesc.getJavaClass().getName()));
        }
        try {
            if (this._extends != null) {
                if (!this._extends._mapTo.equals(this._mapTo)) {
                    identity = this._extends.create(database, conn, fields, identity);
                }
            } else if (this._keyGen != null && this._keyGen.getStyle() == -1) {
                identity = this.generateKey(database, conn, null);
            }
            stmt = this._keyGen != null && this._keyGen.getStyle() == 0 ? ((Connection)conn).prepareCall(this._sqlCreate) : ((Connection)conn).prepareStatement(this._sqlCreate);
            if (_logger != null) {
                _logger.println(this._sqlCreate);
            }
            int count = 1;
            if (this._keyGen == null || this._keyGen.getStyle() == -1) {
                if (this._ids.length > 1 && !(identity instanceof Complex)) {
                    throw new PersistenceException("Multiple identities expected!");
                }
                if (identity instanceof Complex) {
                    Complex id = (Complex)identity;
                    if (id.size() != this._ids.length || this._ids.length <= 1) {
                        throw new PersistenceException("Size of complex field mismatched!");
                    }
                    int i = 0;
                    while (i < this._ids.length) {
                        stmt.setObject(count++, this.idToSQL(i, id.get(i)));
                        ++i;
                    }
                } else {
                    if (this._ids.length != 1) {
                        throw new PersistenceException("Complex field expected!");
                    }
                    stmt.setObject(count++, this.idToSQL(0, identity));
                }
            }
            int i = 0;
            while (i < this._fields.length) {
                if (this._fields[i].store) {
                    if (fields[i] == null) {
                        int j = 0;
                        while (j < this._fields[i].columns.length) {
                            stmt.setNull(count++, this._fields[i].columns[j].sqlType);
                            ++j;
                        }
                    } else if (fields[i] instanceof Complex) {
                        Complex complex = (Complex)fields[i];
                        if (complex.size() != this._fields[i].columns.length) {
                            throw new PersistenceException("Size of complex field mismatch!");
                        }
                        int j = 0;
                        while (j < this._fields[i].columns.length) {
                            Object value = complex == null ? null : complex.get(j);
                            SQLTypes.setObject(stmt, count++, this.toSQL(i, j, value), this._fields[i].columns[j].sqlType);
                            ++j;
                        }
                    } else {
                        if (this._fields[i].columns.length != 1) {
                            throw new PersistenceException("Complex field expected! ");
                        }
                        SQLTypes.setObject(stmt, count++, this.toSQL(i, 0, fields[i]), this._fields[i].columns[0].sqlType);
                    }
                }
                ++i;
            }
            if (this._keyGen != null && this._keyGen.getStyle() == 0) {
                CallableStatement cstmt = (CallableStatement)stmt;
                int sqlType = this._ids[0].sqlType;
                cstmt.registerOutParameter(count, sqlType);
                cstmt.execute();
                while (cstmt.getMoreResults() || cstmt.getUpdateCount() != -1) {
                }
                identity = sqlType == 4 ? new Integer(cstmt.getInt(count)) : cstmt.getObject(count);
                identity = this.idToJava(0, identity);
            } else {
                stmt.executeUpdate();
            }
            stmt.close();
            if (this._keyGen != null && this._keyGen.getStyle() == 1) {
                identity = this.generateKey(database, conn, stmt);
            }
            return identity;
        }
        catch (SQLException except) {
            Boolean isDupKey;
            if (this._logInterceptor != null) {
                this._logInterceptor.storeStatement("Error creating " + this._type + ", SQL : " + this._sqlCreate);
            }
            if (Boolean.TRUE.equals(isDupKey = this._factory.isDuplicateKeyException(except))) {
                throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", this._clsDesc.getJavaClass().getName(), identity));
            }
            if (Boolean.FALSE.equals(isDupKey)) {
                throw new PersistenceException(Messages.format("persist.nested", except), except);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                stmt = ((Connection)conn).prepareStatement(this._pkLookup);
                if (_logger != null) {
                    _logger.println(this._pkLookup);
                }
                int count = 1;
                if (identity instanceof Complex) {
                    Complex id = (Complex)identity;
                    if (id.size() != this._ids.length || this._ids.length <= 1) {
                        throw new PersistenceException("Size of complex field mismatched!");
                    }
                    int i = 0;
                    while (i < this._ids.length) {
                        stmt.setObject(count++, this.idToSQL(i, id.get(i)));
                        ++i;
                    }
                } else {
                    if (this._ids.length != 1) {
                        throw new PersistenceException("Complex field expected!");
                    }
                    stmt.setObject(count++, this.idToSQL(0, identity));
                }
                if (stmt.executeQuery().next()) {
                    stmt.close();
                    throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", this._clsDesc.getJavaClass().getName(), identity));
                }
            }
            catch (SQLException except2) {
                // empty catch block
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException except2) {
            // empty catch block
        }
        throw new PersistenceException(Messages.format("persist.nested", except), except);
    }

    private int nextParameter(boolean isNull, StringBuffer sb, int pos) {
        while (pos > 0) {
            if (sb.charAt(pos - 1) == '=' && sb.charAt(pos) == '?') break;
            --pos;
        }
        if (pos > 0) {
            --pos;
            if (isNull) {
                sb.delete(pos, pos + 2);
                sb.insert(pos, " IS NULL");
            }
        }
        return pos;
    }

    private String getStoreStatement(Object[] original) throws PersistenceException {
        StringBuffer sb = null;
        int pos = 0;
        if (original == null) {
            return this._sqlStore;
        }
        if (((BaseFactory)this._factory).supportsSetNullInWhere()) {
            return this._sqlStoreDirty;
        }
        pos = this._sqlStoreDirty.length() - 1;
        sb = new StringBuffer(pos * 4);
        sb.append(this._sqlStoreDirty);
        int i = this._fields.length - 1;
        while (i >= 0) {
            if (this._fields[i].store && this._fields[i].dirtyCheck) {
                if (original[i] == null) {
                    int j = this._fields[i].columns.length - 1;
                    while (j >= 0) {
                        pos = this.nextParameter(true, sb, pos);
                        --j;
                    }
                } else if (original[i] instanceof Complex) {
                    Complex complex = (Complex)original[i];
                    if (complex.size() != this._fields[i].columns.length) {
                        throw new PersistenceException("Size of complex field mismatch!");
                    }
                    int j = this._fields[i].columns.length - 1;
                    while (j >= 0) {
                        pos = this.nextParameter(complex.get(j) == null, sb, pos);
                        --j;
                    }
                } else {
                    if (this._fields[i].columns.length != 1) {
                        throw new PersistenceException("Complex field expected! ");
                    }
                    pos = this.nextParameter(false, sb, pos);
                }
            }
            --i;
        }
        return sb.toString();
    }

    public Object store(Object conn, Object[] fields, Object identity, Object[] original, Object stamp) throws ObjectModifiedException, ObjectDeletedException, PersistenceException {
        Statement stmt = null;
        String storeStatement = null;
        try {
            int i;
            if (this._extends != null && !this._extends._mapTo.equals(this._mapTo)) {
                this._extends.store(conn, fields, identity, original, stamp);
            }
            storeStatement = this.getStoreStatement(original);
            stmt = ((Connection)conn).prepareStatement(storeStatement);
            if (_logger != null) {
                _logger.println(storeStatement);
            }
            int count = 1;
            int i2 = 0;
            while (i2 < this._fields.length) {
                if (this._fields[i2].store) {
                    if (fields[i2] == null) {
                        int j = 0;
                        while (j < this._fields[i2].columns.length) {
                            stmt.setNull(count++, this._fields[i2].columns[j].sqlType);
                            ++j;
                        }
                    } else if (fields[i2] instanceof Complex) {
                        Complex complex = (Complex)fields[i2];
                        if (complex.size() != this._fields[i2].columns.length) {
                            throw new PersistenceException("Size of complex field mismatch!");
                        }
                        int j = 0;
                        while (j < this._fields[i2].columns.length) {
                            SQLTypes.setObject((PreparedStatement)stmt, count++, this.toSQL(i2, j, complex.get(j)), this._fields[i2].columns[j].sqlType);
                            ++j;
                        }
                    } else {
                        if (this._fields[i2].columns.length != 1) {
                            throw new PersistenceException("Complex field expected! ");
                        }
                        SQLTypes.setObject((PreparedStatement)stmt, count++, this.toSQL(i2, 0, fields[i2]), this._fields[i2].columns[0].sqlType);
                    }
                }
                ++i2;
            }
            if (identity instanceof Complex) {
                Complex id = (Complex)identity;
                if (id.size() != this._ids.length || this._ids.length <= 1) {
                    throw new PersistenceException("Size of complex field mismatched!");
                }
                i = 0;
                while (i < this._ids.length) {
                    stmt.setObject(count++, this.idToSQL(i, id.get(i)));
                    ++i;
                }
            } else {
                if (this._ids.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                stmt.setObject(count++, this.idToSQL(0, identity));
            }
            if (original != null) {
                boolean supportsSetNull = ((BaseFactory)this._factory).supportsSetNullInWhere();
                i = 0;
                while (i < this._fields.length) {
                    if (this._fields[i].store && this._fields[i].dirtyCheck) {
                        if (original[i] == null) {
                            if (supportsSetNull) {
                                int j = 0;
                                while (j < this._fields[i].columns.length) {
                                    stmt.setNull(count++, this._fields[i].columns[j].sqlType);
                                    ++j;
                                }
                            }
                        } else if (original[i] instanceof Complex) {
                            Complex complex = (Complex)original[i];
                            if (complex.size() != this._fields[i].columns.length) {
                                throw new PersistenceException("Size of complex field mismatch!");
                            }
                            int j = 0;
                            while (j < this._fields[i].columns.length) {
                                SQLTypes.setObject((PreparedStatement)stmt, count++, this.toSQL(i, j, complex.get(j)), this._fields[i].columns[j].sqlType);
                                ++j;
                            }
                        } else {
                            if (this._fields[i].columns.length != 1) {
                                throw new PersistenceException("Complex field expected! ");
                            }
                            SQLTypes.setObject((PreparedStatement)stmt, count++, this.toSQL(i, 0, original[i]), this._fields[i].columns[0].sqlType);
                        }
                    }
                    ++i;
                }
            }
            if (stmt.executeUpdate() <= 0) {
                stmt.close();
                if (original != null) {
                    stmt = ((Connection)conn).prepareStatement(this._sqlLoad);
                    if (_logger != null) {
                        _logger.println(this._sqlLoad);
                    }
                    count = 1;
                    if (identity instanceof Complex) {
                        Complex id = (Complex)identity;
                        i = 0;
                        while (i < this._ids.length) {
                            stmt.setObject(count++, this.idToSQL(i, id.get(i)));
                            ++i;
                        }
                    } else {
                        stmt.setObject(count++, this.idToSQL(0, identity));
                    }
                    ResultSet res = stmt.executeQuery();
                    int c = res.getMetaData().getColumnCount();
                    if (res.next()) {
                        stmt.close();
                        throw new ObjectModifiedException(Messages.format("persist.objectModified", this._clsDesc.getJavaClass().getName(), identity));
                    }
                    stmt.close();
                }
                throw new ObjectDeletedException(Messages.format("persist.objectDeleted", this._clsDesc.getJavaClass().getName(), identity));
            }
            stmt.close();
            return null;
        }
        catch (SQLException except) {
            if (this._logInterceptor != null) {
                this._logInterceptor.storeStatement("Error updating " + this._type + ", SQL : " + storeStatement);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                // empty catch block
            }
            throw new PersistenceException(Messages.format("persist.nested", except), except);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Object conn, Object identity) throws PersistenceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = ((Connection)conn).prepareStatement(this._sqlRemove);
                if (_logger != null) {
                    _logger.println(this._sqlRemove);
                }
                int count = 1;
                if (identity instanceof Complex) {
                    Complex id = (Complex)identity;
                    if (id.size() != this._ids.length) throw new PersistenceException("Size of complex field mismatched!");
                    if (this._ids.length <= 1) {
                        throw new PersistenceException("Size of complex field mismatched!");
                    }
                    int i = 0;
                    while (i < this._ids.length) {
                        stmt.setObject(count++, this.idToSQL(i, id.get(i)));
                        ++i;
                    }
                } else {
                    if (this._ids.length != 1) {
                        throw new PersistenceException("Complex field expected!");
                    }
                    stmt.setObject(count++, this.idToSQL(0, identity));
                }
                int result = stmt.executeUpdate();
                if (result < 1) {
                    throw new PersistenceException("Object to be deleted does not exist! " + identity);
                }
                if (this._extends != null) {
                    this._extends.delete(conn, identity);
                }
            }
            catch (SQLException except) {
                if (this._logInterceptor == null) throw new PersistenceException(Messages.format("persist.nested", except), except);
                this._logInterceptor.storeStatement("Error deleting " + this._type + ", SQL : " + this._sqlRemove);
                throw new PersistenceException(Messages.format("persist.nested", except), except);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (stmt == null) return;
        stmt.close();
        return;
    }

    public void writeLock(Object conn, Object identity) throws ObjectDeletedException, PersistenceException {
        Statement stmt = null;
        try {
            if (this._extends != null) {
                this._extends.writeLock(conn, identity);
            }
            stmt = ((Connection)conn).prepareStatement(this._pkLookup);
            if (_logger != null) {
                _logger.println(this._pkLookup);
            }
            int count = 1;
            if (identity instanceof Complex) {
                Complex id = (Complex)identity;
                if (id.size() != this._ids.length || this._ids.length <= 1) {
                    throw new PersistenceException("Size of complex field mismatched!");
                }
                int i = 0;
                while (i < this._ids.length) {
                    stmt.setObject(count++, this.idToSQL(i, id.get(i)));
                    ++i;
                }
            } else {
                if (this._ids.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                stmt.setObject(count++, this.idToSQL(0, identity));
            }
            if (!stmt.executeQuery().next()) {
                throw new ObjectDeletedException(Messages.format("persist.objectDeleted", this._clsDesc.getJavaClass().getName(), identity));
            }
            stmt.close();
        }
        catch (SQLException except) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException except2) {
                // empty catch block
            }
            throw new PersistenceException(Messages.format("persist.nested", except), except);
        }
    }

    /*
     * Loose catch block
     */
    public Object load(Object conn, Object[] fields, Object identity, AccessMode accessMode) throws ObjectNotFoundException, PersistenceException {
        Object stamp;
        block48: {
            boolean notNull;
            int i;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            stamp = null;
            stmt = ((Connection)conn).prepareStatement(accessMode == AccessMode.DbLocked ? this._sqlLoadLock : this._sqlLoad);
            if (_logger != null) {
                _logger.println(accessMode == AccessMode.DbLocked ? this._sqlLoadLock : this._sqlLoad);
            }
            int count = 1;
            if (identity instanceof Complex) {
                Complex id = (Complex)identity;
                if (id.size() != this._ids.length || this._ids.length <= 1) {
                    throw new PersistenceException("Size of complex field mismatched! expected: " + this._ids.length + " found: " + id.size());
                }
                i = 0;
                while (i < this._ids.length) {
                    stmt.setObject(count++, this.idToSQL(i, id.get(i)));
                    ++i;
                }
            } else {
                if (this._ids.length != 1) {
                    throw new PersistenceException("Complex field expected!");
                }
                stmt.setObject(count++, this.idToSQL(0, identity));
            }
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", this._clsDesc.getJavaClass().getName(), identity));
            }
            count = 1;
            Object[] temp = new Object[10];
            i = 0;
            while (i < this._fields.length) {
                if (this._fields[i].load) {
                    if (!this._fields[i].multi) {
                        notNull = false;
                        if (this._fields[i].columns.length == 1) {
                            fields[i] = this.toJava(i, 0, SQLTypes.getObject(rs, count++, this._fields[i].columns[0].sqlType));
                        } else {
                            int j = 0;
                            while (j < this._fields[i].columns.length) {
                                temp[j] = this.toJava(i, j, SQLTypes.getObject(rs, count++, this._fields[i].columns[j].sqlType));
                                if (temp[j] != null) {
                                    notNull = true;
                                }
                                ++j;
                            }
                            fields[i] = notNull ? new Complex(this._fields[i].columns.length, temp) : null;
                        }
                    } else {
                        ArrayList<Object> res = new ArrayList<Object>();
                        notNull = false;
                        int j = 0;
                        while (j < this._fields[i].columns.length) {
                            temp[j] = this.toJava(i, j, SQLTypes.getObject(rs, count, this._fields[i].columns[j].sqlType));
                            if (temp[j] != null) {
                                notNull = true;
                            }
                            ++count;
                            ++j;
                        }
                        if (notNull) {
                            if (this._fields[i].columns.length == 1) {
                                res.add(temp[0]);
                            } else {
                                res.add(new Complex(this._fields[i].columns.length, temp));
                            }
                        }
                        fields[i] = res;
                    }
                }
                ++i;
            }
            while (rs.next()) {
                count = 1;
                int i2 = 0;
                while (i2 < this._fields.length) {
                    if (this._fields[i2].load) {
                        if (this._fields[i2].multi) {
                            ArrayList res = (ArrayList)fields[i2];
                            notNull = false;
                            int j = 0;
                            while (j < this._fields[i2].columns.length) {
                                temp[j] = this.toJava(i2, j, SQLTypes.getObject(rs, count, this._fields[i2].columns[j].sqlType));
                                if (temp[j] != null) {
                                    notNull = true;
                                }
                                ++count;
                                ++j;
                            }
                            if (notNull) {
                                if (this._fields[i2].columns.length == 1) {
                                    if (!res.contains(temp[0])) {
                                        res.add(temp[0]);
                                    }
                                } else {
                                    Complex com = new Complex(this._fields[i2].columns.length, temp);
                                    if (!res.contains(com)) {
                                        res.add(new Complex(this._fields[i2].columns.length, temp));
                                    }
                                }
                            }
                        } else {
                            count += this._fields[i2].columns.length;
                        }
                    }
                    ++i2;
                }
            }
            Object var17_21 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block48;
            }
            catch (SQLException sqle) {}
            break block48;
            {
                catch (SQLException except) {
                    if (this._logInterceptor != null) {
                        this._logInterceptor.storeStatement("Error loading " + this._type + ", SQL : " + (accessMode == AccessMode.DbLocked ? this._sqlLoadLock : this._sqlLoad));
                    }
                    throw new PersistenceException(Messages.format("persist.nested", except), except);
                }
            }
            catch (Throwable throwable) {
                Object var17_22 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return stamp;
    }

    private void buildSql() throws QueryException {
        boolean keyGened = false;
        String tableName = this._mapTo;
        QueryExpression query = this._factory.getQueryExpression();
        int i = 0;
        while (i < this._ids.length) {
            query.addParameter(tableName, this._ids[i].name, "=");
            ++i;
        }
        this._pkLookup = query.getStatement(true);
        StringBuffer sb = new StringBuffer();
        sb.append(" WHERE ");
        int i2 = 0;
        while (i2 < this._ids.length) {
            if (i2 > 0) {
                sb.append(" AND ");
            }
            sb.append(this._factory.quoteName(this._ids[i2].name));
            sb.append("=");
            sb.append("?");
            ++i2;
        }
        String wherePK = sb.toString();
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(this._factory.quoteName(tableName)).append(" (");
        int count = 0;
        int i3 = 0;
        while (i3 < this._ids.length) {
            if (this._keyGen == null || this._keyGen.getStyle() == -1) {
                if (count > 0) {
                    sql.append(',');
                }
                keyGened = true;
                sql.append(this._factory.quoteName(this._ids[i3].name));
                ++count;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this._fields.length) {
            if (this._fields[i4].store) {
                int j = 0;
                while (j < this._fields[i4].columns.length) {
                    if (count > 0) {
                        sql.append(',');
                    }
                    sql.append(this._factory.quoteName(this._fields[i4].columns[j].name));
                    ++count;
                    ++j;
                }
            }
            ++i4;
        }
        if (count == 0) {
            sql.setLength(sql.length() - 2);
        } else {
            sql.append(")");
        }
        sql.append(" VALUES (");
        int i5 = 0;
        while (i5 < count) {
            if (i5 > 0) {
                sql.append(',');
            }
            sql.append('?');
            ++i5;
        }
        sql.append(')');
        this._sqlCreate = sql.toString();
        if (!keyGened) {
            try {
                this._sqlCreate = this._keyGen.patchSQL(this._sqlCreate, this._ids[0].name);
            }
            catch (MappingException except) {
                this._logInterceptor.exception(except);
                this._keyGen = null;
                this.buildSql();
                return;
            }
            if (this._keyGen.getStyle() == 0) {
                this._sqlCreate = "{call " + this._sqlCreate + "}";
            }
        }
        if (this._logInterceptor != null) {
            this._logInterceptor.storeStatement("SQL for creating " + this._type + ": " + this._sqlCreate);
        }
        sql = new StringBuffer("DELETE FROM ").append(this._factory.quoteName(tableName));
        sql.append(wherePK);
        this._sqlRemove = sql.toString();
        if (this._logInterceptor != null) {
            this._logInterceptor.storeStatement("SQL for deleting " + this._type + ": " + this._sqlRemove);
        }
        sql = new StringBuffer("UPDATE ");
        sql.append(this._factory.quoteName(this._mapTo));
        sql.append(" SET ");
        count = 0;
        int i6 = 0;
        while (i6 < this._fields.length) {
            if (this._fields[i6].store) {
                int j = 0;
                while (j < this._fields[i6].columns.length) {
                    if (count > 0) {
                        sql.append(',');
                    }
                    sql.append(this._factory.quoteName(this._fields[i6].columns[j].name));
                    sql.append("=?");
                    ++count;
                    ++j;
                }
            }
            ++i6;
        }
        sql.append(wherePK);
        this._sqlStore = sql.toString();
        int i7 = 0;
        while (i7 < this._fields.length) {
            if (this._fields[i7].store && this._fields[i7].dirtyCheck) {
                int j = 0;
                while (j < this._fields[i7].columns.length) {
                    sql.append(" AND ");
                    sql.append(this._factory.quoteName(this._fields[i7].columns[j].name));
                    sql.append("=?");
                    ++j;
                }
            }
            ++i7;
        }
        this._sqlStoreDirty = sql.toString();
        if (this._logInterceptor != null) {
            this._logInterceptor.storeStatement("SQL for updating " + this._type + ": " + this._sqlStoreDirty);
        }
    }

    private void buildFinder(JDOClassDescriptor clsDesc) throws MappingException, QueryException {
        Vector fields = new Vector();
        QueryExpression expr = this._factory.getQueryExpression();
        QueryExpression find = this._factory.getQueryExpression();
        String[] idnames = this._clsDesc.getIdentityColumnNames();
        int i = 0;
        while (i < this._ids.length) {
            expr.addParameter(this._mapTo, this._ids[i].name, "=");
            ++i;
        }
        JDOClassDescriptor curDesc = clsDesc;
        while (curDesc.getExtends() != null) {
            JDOClassDescriptor baseDesc = (JDOClassDescriptor)curDesc.getExtends();
            expr.addInnerJoin(curDesc.getTableName(), curDesc.getIdentityColumnNames(), baseDesc.getTableName(), baseDesc.getIdentityColumnNames());
            find.addInnerJoin(curDesc.getTableName(), curDesc.getIdentityColumnNames(), baseDesc.getTableName(), baseDesc.getIdentityColumnNames());
            curDesc = baseDesc;
        }
        int i2 = 0;
        while (i2 < this._ids.length) {
            find.addColumn(this._mapTo, idnames[i2]);
            ++i2;
        }
        Vector<String> joinTables = new Vector<String>();
        int i3 = 0;
        while (i3 < this._fields.length) {
            String alias = this._fields[i3].tableName;
            if (this._fields[i3].load) {
                if (this._fields[i3].joined) {
                    int offset = 0;
                    String[] rightCol = this._fields[i3].joinFields;
                    String[] leftCol = new String[this._ids.length - offset];
                    int j = 0;
                    while (j < leftCol.length) {
                        leftCol[j] = this._ids[j + offset].name;
                        ++j;
                    }
                    if (joinTables.contains(this._fields[i3].tableName) || clsDesc.getTableName().equals(this._fields[i3].tableName)) {
                        alias = alias.replace('.', '_') + "_f" + i3;
                        expr.addOuterJoin(this._mapTo, leftCol, this._fields[i3].tableName, rightCol, alias);
                        find.addOuterJoin(this._mapTo, leftCol, this._fields[i3].tableName, rightCol, alias);
                    } else {
                        expr.addOuterJoin(this._mapTo, leftCol, this._fields[i3].tableName, rightCol);
                        find.addOuterJoin(this._mapTo, leftCol, this._fields[i3].tableName, rightCol);
                        joinTables.add(this._fields[i3].tableName);
                    }
                }
                int j = 0;
                while (j < this._fields[i3].columns.length) {
                    expr.addColumn(alias, this._fields[i3].columns[j].name);
                    find.addColumn(alias, this._fields[i3].columns[j].name);
                    ++j;
                }
                expr.addTable(this._fields[i3].tableName, alias);
                find.addTable(this._fields[i3].tableName, alias);
            }
            ++i3;
        }
        this._sqlLoad = expr.getStatement(false);
        this._sqlLoadLock = expr.getStatement(true);
        this._sqlFinder = find;
        if (this._logInterceptor != null) {
            this._logInterceptor.storeStatement("SQL for loading " + this._type + ":  " + this._sqlLoad);
        }
    }

    private void addLoadSql(QueryExpression expr, Vector allFields, boolean loadPk, boolean queryPk, boolean store) throws MappingException {
    }

    public String toString() {
        return this._clsDesc.toString();
    }

    static final class SQLQuery
    implements PersistenceQuery {
        private PreparedStatement _stmt;
        private ResultSet _rs;
        private final SQLEngine _engine;
        private final Class[] _types;
        private final Object[] _values;
        private final String _sql;
        private Object[] _lastIdentity;
        private int[] _identSqlType;
        private boolean _resultSetDone;
        private Object[] _fields;

        SQLQuery(SQLEngine engine, String sql, Class[] types) {
            this._engine = engine;
            this._types = types;
            this._values = new Object[this._types.length];
            this._sql = sql;
            this._identSqlType = new int[this._engine._clsDesc.getIdentities().length];
            int i = 0;
            while (i < this._identSqlType.length) {
                this._identSqlType[i] = ((JDOFieldDescriptor)this._engine._clsDesc.getIdentities()[i]).getSQLType()[0];
                ++i;
            }
        }

        public int getParameterCount() {
            return this._types.length;
        }

        public Class getParameterType(int index) throws ArrayIndexOutOfBoundsException {
            return this._types[index];
        }

        public void setParameter(int index, Object value) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
            this._values[index] = value;
        }

        public Class getResultType() {
            return this._engine._clsDesc.getJavaClass();
        }

        public boolean absolute(int row) throws PersistenceException {
            boolean retval = false;
            try {
                if (this._rs != null) {
                    retval = this._rs.absolute(row);
                }
            }
            catch (SQLException e) {
                throw new PersistenceException(e.getMessage());
            }
            return retval;
        }

        public int size() throws PersistenceException {
            int whereIAm = 1;
            int retval = 0;
            try {
                if (this._rs != null) {
                    whereIAm = this._rs.getRow();
                    retval = this._rs.last() ? this._rs.getRow() : 0;
                    if (whereIAm > 0) {
                        this._rs.absolute(whereIAm);
                    } else {
                        this._rs.beforeFirst();
                    }
                }
            }
            catch (SQLException se) {
                throw new PersistenceException(se.getMessage());
            }
            return retval;
        }

        public void execute(Object conn, AccessMode accessMode) throws QueryException, PersistenceException {
            this.execute(conn, accessMode, false);
        }

        public void execute(Object conn, AccessMode accessMode, boolean scrollable) throws QueryException, PersistenceException {
            this._lastIdentity = null;
            try {
                this._stmt = scrollable ? ((Connection)conn).prepareStatement(this._sql, 1004, 1007) : ((Connection)conn).prepareStatement(this._sql);
                if (_logger != null) {
                    _logger.println(this._sql);
                }
                int i = 0;
                while (i < this._values.length) {
                    this._stmt.setObject(i + 1, this._values[i]);
                    this._values[i] = null;
                    ++i;
                }
                this._rs = this._stmt.executeQuery();
                this._resultSetDone = false;
            }
            catch (SQLException except) {
                if (this._stmt != null) {
                    try {
                        this._stmt.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                }
                this._resultSetDone = true;
                throw new PersistenceException(Messages.format("persist.nested", except) + " while executing " + this._sql, except);
            }
        }

        private Object loadIdentity() throws SQLException, PersistenceException {
            if (this._resultSetDone) {
                return null;
            }
            boolean empty = false;
            Object[] returnId = new Object[this._engine._ids.length];
            empty = true;
            int i = 0;
            while (i < this._engine._ids.length) {
                Object tmp = SQLTypes.getObject(this._rs, 1 + i, this._identSqlType[i]);
                returnId[i] = this._engine.idToJava(i, tmp);
                if (tmp != null) {
                    empty = false;
                }
                ++i;
            }
            if (!empty) {
                switch (this._engine._ids.length) {
                    case 1: {
                        return returnId[0];
                    }
                    case 2: {
                        return new Complex(returnId[0], returnId[1]);
                    }
                }
                return new Complex(returnId);
            }
            return null;
        }

        public Object nextIdentity(Object identity) throws PersistenceException {
            try {
                if (this._lastIdentity == null && (this._resultSetDone || !this._rs.next())) {
                    this._resultSetDone = true;
                    return null;
                }
                this._lastIdentity = this.identityToSQL(identity);
                identity = this.loadIdentity();
                if (this.identitiesEqual(this._lastIdentity, this.identityToSQL(identity))) {
                    this.fetchRaw(null);
                }
                identity = this.loadIdentity();
                this.fetchRaw(null);
            }
            catch (SQLException except) {
                this._lastIdentity = null;
                throw new PersistenceException(Messages.format("persist.nested", except), except);
            }
            return identity;
        }

        public void close() {
            if (this._rs != null) {
                try {
                    this._rs.close();
                }
                catch (SQLException except) {
                    // empty catch block
                }
                this._rs = null;
            }
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this._stmt = null;
            }
        }

        private Object[] identityToSQL(Object identity) {
            Object[] sqlIdentity = new Object[this._engine._ids.length];
            if (identity != null) {
                if (this._engine._ids.length > 1) {
                    Complex id = (Complex)identity;
                    int i = 0;
                    while (i < this._engine._ids.length) {
                        sqlIdentity[i] = id.get(i);
                        ++i;
                    }
                } else {
                    sqlIdentity[0] = identity;
                }
            }
            return sqlIdentity;
        }

        private Object loadSingleField(int i, int count) throws SQLException, PersistenceException {
            Object field;
            Object[] temp = new Object[10];
            boolean notNull = false;
            if (((SQLEngine)this._engine)._fields[i].columns.length == 1) {
                field = this._engine.toJava(i, 0, SQLTypes.getObject(this._rs, count++, ((SQLEngine)this._engine)._fields[i].columns[0].sqlType));
            } else {
                int j = 0;
                while (j < ((SQLEngine)this._engine)._fields[i].columns.length) {
                    temp[j] = this._engine.toJava(i, j, SQLTypes.getObject(this._rs, count++, ((SQLEngine)this._engine)._fields[i].columns[j].sqlType));
                    if (temp[j] != null) {
                        notNull = true;
                    }
                    ++j;
                }
                field = notNull ? new Complex(((SQLEngine)this._engine)._fields[i].columns.length, temp) : null;
            }
            return field;
        }

        private Object loadMultiField(int i, int count, Object field) throws SQLException, PersistenceException {
            Object[] temp = new Object[10];
            boolean notNull = false;
            ArrayList<Object> res = field == null ? new ArrayList<Object>() : (ArrayList<Object>)field;
            int j = 0;
            while (j < ((SQLEngine)this._engine)._fields[i].columns.length) {
                temp[j] = this._engine.toJava(i, j, SQLTypes.getObject(this._rs, count, ((SQLEngine)this._engine)._fields[i].columns[j].sqlType));
                if (temp[j] != null) {
                    notNull = true;
                }
                ++count;
                ++j;
            }
            if (notNull) {
                if (((SQLEngine)this._engine)._fields[i].columns.length == 1) {
                    if (!res.contains(temp[0])) {
                        res.add(temp[0]);
                    }
                } else {
                    Complex com = new Complex(((SQLEngine)this._engine)._fields[i].columns.length, temp);
                    if (!res.contains(com)) {
                        res.add(com);
                    }
                }
            }
            return res;
        }

        private int loadRow(Object[] fields, boolean isFirst) throws SQLException, PersistenceException {
            int count = this._engine._ids.length + 1;
            int i = 0;
            while (i < this._engine._fields.length) {
                if (((SQLEngine)this._engine)._fields[i].load) {
                    if (((SQLEngine)this._engine)._fields[i].multi) {
                        fields[i] = this.loadMultiField(i, count, fields[i]);
                    } else if (isFirst) {
                        fields[i] = this.loadSingleField(i, count);
                    }
                    count += ((SQLEngine)this._engine)._fields[i].columns.length;
                }
                ++i;
            }
            return count;
        }

        private Object[] loadSQLIdentity() throws SQLException, PersistenceException {
            Object[] identity = new Object[this._engine._ids.length];
            int i = 0;
            while (i < this._engine._ids.length) {
                identity[i] = SQLTypes.getObject(this._rs, 1 + i, this._identSqlType[i]);
                ++i;
            }
            return identity;
        }

        private boolean identitiesEqual(Object[] wantedIdentity, Object[] currentIdentity) {
            int i = 0;
            while (i < wantedIdentity.length) {
                if (wantedIdentity[i] == null || currentIdentity[i] == null ? wantedIdentity[i] != currentIdentity[i] : !wantedIdentity[i].toString().equals(currentIdentity[i].toString())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public Object fetch(Object[] fields, Object identity) throws ObjectNotFoundException, PersistenceException {
            int i = 0;
            while (i < this._fields.length) {
                fields[i] = this._fields[i];
                ++i;
            }
            return null;
        }

        private Object fetchRaw(Object identity) throws ObjectNotFoundException, PersistenceException {
            this._fields = new Object[this._engine._fields.length];
            if (this._resultSetDone) {
                return null;
            }
            Object stamp = null;
            try {
                Object[] wantedIdentity = identity != null ? this.identityToSQL(identity) : this.loadSQLIdentity();
                this.loadRow(this._fields, true);
                while (this._rs.next()) {
                    Object[] currentIdentity = this.loadSQLIdentity();
                    if (this.identitiesEqual(wantedIdentity, currentIdentity)) {
                        this.loadRow(this._fields, false);
                        continue;
                    }
                    this._lastIdentity = currentIdentity;
                    return stamp;
                }
                this._resultSetDone = true;
                this._lastIdentity = null;
            }
            catch (SQLException except) {
                throw new PersistenceException(Messages.format("persist.nested", except), except);
            }
            return null;
        }
    }

    static final class ColumnInfo {
        final String name;
        final int sqlType;
        final TypeConvertor convertTo;
        final TypeConvertor convertFrom;
        final String convertParam;

        ColumnInfo(String name, int type, TypeConvertor convertTo, TypeConvertor convertFrom, String convertParam) {
            this.name = name;
            this.sqlType = type;
            this.convertTo = convertTo;
            this.convertFrom = convertFrom;
            this.convertParam = convertParam;
        }
    }

    static final class FieldInfo
    implements Persistence.FieldInfo {
        final String tableName;
        final String jdoName;
        final boolean load;
        final boolean store;
        final boolean multi;
        final boolean joined;
        final boolean dirtyCheck;
        final String[] joinFields;
        ColumnInfo[] columns;

        FieldInfo(JDOClassDescriptor clsDesc, FieldDescriptor fieldDesc, String classTable, boolean ext) throws MappingException {
            boolean FIELD_TYPE = false;
            boolean REF_TYPE = true;
            int REL_TABLE_TYPE = 2;
            FieldDescriptor[] classids = clsDesc.getIdentities();
            ClassDescriptor related = fieldDesc.getClassDescriptor();
            if (related != null && !(related instanceof JDOClassDescriptor)) {
                throw new MappingException("Related class is not JDOClassDescriptor");
            }
            if (fieldDesc.getClassDescriptor() != null) {
                int type = !(fieldDesc instanceof JDOFieldDescriptor) ? 1 : (((JDOFieldDescriptor)fieldDesc).getManyTable() != null ? 2 : (((JDOFieldDescriptor)fieldDesc).getSQLName() != null ? 0 : 1));
                FieldDescriptor[] relids = ((JDOClassDescriptor)related).getIdentities();
                String[] names = null;
                if (fieldDesc instanceof JDOFieldDescriptor) {
                    names = ((JDOFieldDescriptor)fieldDesc).getSQLName();
                }
                String[] relnames = new String[relids.length];
                int i = 0;
                while (i < relids.length) {
                    relnames[i] = ((JDOFieldDescriptor)relids[i]).getSQLName()[0];
                    if (relnames[i] == null) {
                        throw new MappingException("Related class identities field does not contains sql information!");
                    }
                    ++i;
                }
                String[] joins = null;
                if (fieldDesc instanceof JDOFieldDescriptor) {
                    joins = ((JDOFieldDescriptor)fieldDesc).getManyKey();
                }
                String[] classnames = new String[classids.length];
                int i2 = 0;
                while (i2 < classids.length) {
                    classnames[i2] = ((JDOFieldDescriptor)classids[i2]).getSQLName()[0];
                    if (classnames[i2] == null) {
                        throw new MappingException("Related class identities field does not contains sql information!");
                    }
                    ++i2;
                }
                if (names != null && names.length != relids.length) {
                    throw new MappingException("The number of column of foreign keys doesn't not match with what specified in manyKey");
                }
                if (joins != null && joins.length != classids.length) {
                    throw new MappingException("The number of column of foreign keys doesn't not match with what specified in manyKey");
                }
                switch (type) {
                    case 0: {
                        this.tableName = classTable;
                        this.jdoName = fieldDesc.getFieldName();
                        this.load = true;
                        this.store = !ext && !((JDOFieldDescriptor)fieldDesc).isReadonly();
                        this.multi = false;
                        this.joined = false;
                        this.dirtyCheck = ((JDOFieldDescriptor)fieldDesc).isDirtyCheck();
                        names = names != null ? names : relnames;
                        this.joinFields = classnames;
                        break;
                    }
                    case 1: {
                        this.tableName = ((JDOClassDescriptor)related).getTableName();
                        this.jdoName = fieldDesc.getFieldName();
                        this.load = true;
                        this.store = false;
                        this.multi = fieldDesc.isMultivalued();
                        this.joined = true;
                        this.dirtyCheck = fieldDesc instanceof JDOFieldDescriptor ? ((JDOFieldDescriptor)fieldDesc).isDirtyCheck() : true;
                        names = names != null ? names : relnames;
                        this.joinFields = joins != null ? joins : classnames;
                        break;
                    }
                    case 2: {
                        this.tableName = ((JDOFieldDescriptor)fieldDesc).getManyTable();
                        this.jdoName = fieldDesc.getFieldName();
                        this.load = true;
                        this.store = false;
                        this.multi = fieldDesc.isMultivalued();
                        this.joined = true;
                        this.dirtyCheck = ((JDOFieldDescriptor)fieldDesc).isDirtyCheck();
                        names = names != null ? names : relnames;
                        this.joinFields = joins != null ? joins : classnames;
                        break;
                    }
                    default: {
                        throw new MappingException("Never happen! But, it won't compile without the exception");
                    }
                }
                this.columns = new ColumnInfo[relids.length];
                int i3 = 0;
                while (i3 < relids.length) {
                    if (!(relids[i3] instanceof JDOFieldDescriptor)) {
                        throw new MappingException("Related class identities field does not contains sql information!");
                    }
                    JDOFieldDescriptor relId = (JDOFieldDescriptor)relids[i3];
                    FieldHandlerImpl fh = (FieldHandlerImpl)relId.getHandler();
                    this.columns[i3] = new ColumnInfo(names[i3], relId.getSQLType()[0], fh.getConvertTo(), fh.getConvertFrom(), fh.getConvertParam());
                    ++i3;
                }
            } else {
                this.tableName = classTable;
                this.jdoName = fieldDesc.getFieldName();
                this.load = true;
                this.store = !ext && !((JDOFieldDescriptor)fieldDesc).isReadonly();
                this.multi = false;
                this.joined = false;
                this.joinFields = null;
                this.dirtyCheck = ((JDOFieldDescriptor)fieldDesc).isDirtyCheck();
                FieldHandlerImpl fh = (FieldHandlerImpl)fieldDesc.getHandler();
                this.columns = new ColumnInfo[1];
                String[] sqlNameArray = ((JDOFieldDescriptor)fieldDesc).getSQLName();
                String sqlName = sqlNameArray == null ? fieldDesc.getFieldName() : sqlNameArray[0];
                this.columns[0] = new ColumnInfo(sqlName, ((JDOFieldDescriptor)fieldDesc).getSQLType()[0], fh.getConvertTo(), fh.getConvertFrom(), fh.getConvertParam());
            }
        }

        public boolean isComplex() {
            return true;
        }

        public boolean isPersisted() {
            return this.store;
        }

        public String getFieldName() {
            return this.jdoName;
        }

        public String toString() {
            return this.tableName + "." + this.jdoName;
        }
    }
}

