/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility.security;

import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.TreeSet;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import nz.co.k.tms.billing.ejb.NCBManager;
import nz.co.k.tms.billing.ejb.NCBManagerHome;
import nz.co.k.tms.billing.ejb.NCBManagerUtil;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.utility.DateHelper;
import nz.co.k.tms.utility.FormatHelper;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.MailHelper;
import nz.co.k.tms.utility.security.Encrypter;
import org.apache.log4j.Level;

public class SecurityHelper {
    public static String encrypt(String clearTextString) throws BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Encrypter encrypter = new Encrypter();
        return encrypter.encrypt(clearTextString);
    }

    public static String decrypt(String encryptedString) throws BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Encrypter encrypter = new Encrypter();
        return encrypter.decrypt(encryptedString);
    }

    public static String hashPassword(String username, String password) {
        String result = new String();
        if (username == null || username.equals("")) {
            return null;
        }
        if (password == null || password.equals("")) {
            return null;
        }
        result = SecurityHelper.generateMD5Hash(String.valueOf(username) + password);
        return result;
    }

    public static String generateMD5Hash(String stringToHash) {
        String result = new String();
        if (stringToHash == null || stringToHash.equals("")) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashArray = md.digest(stringToHash.getBytes());
            int hashArrayIndex = 0;
            while (hashArrayIndex < hashArray.length) {
                String tmpHash = Integer.toHexString(hashArray[hashArrayIndex] & 0xFF);
                while (tmpHash.length() < 2) {
                    tmpHash = "0" + tmpHash;
                }
                result = String.valueOf(result) + tmpHash;
                ++hashArrayIndex;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return result;
    }

    public static String generateRandomPassword() {
        String password = Integer.toHexString(SecurityHelper.generateRandomNumber());
        return password;
    }

    public static Integer generateRandomNumber() {
        Random random = new Random();
        return new Integer(random.nextInt(99999999));
    }

    public static String covertDbHashToLdapHash(String stringToConvert) throws TmsGeneralException {
        String result = new String();
        if (stringToConvert == null || stringToConvert.equals("")) {
            return null;
        }
        byte[] hashBackToRawResult = new byte[stringToConvert.length() / 2];
        int stringToConvertIndex = 0;
        while (stringToConvertIndex < stringToConvert.length()) {
            String tempRawHash = "" + stringToConvert.charAt(stringToConvertIndex) + stringToConvert.charAt(stringToConvertIndex + 1);
            int tempRawHashIntTemp = Integer.valueOf(tempRawHash, 16);
            int tempRawHashInt = tempRawHashIntTemp;
            if (tempRawHashInt > 127) {
                tempRawHashInt -= 256;
            }
            byte tempRawHashByte = new Byte("" + tempRawHashInt);
            hashBackToRawResult[stringToConvertIndex / 2] = new Byte("" + tempRawHashInt);
            stringToConvertIndex += 2;
        }
        result = SecurityHelper.generateLdapHash(hashBackToRawResult);
        return result;
    }

    private static String generateLdapHash(byte[] byteArrayToUse) throws TmsGeneralException {
        String PWDALG = "{MD5}";
        String result = null;
        String tempDigest = null;
        byte[] buf = new byte[byteArrayToUse.length];
        System.arraycopy(byteArrayToUse, 0, buf, 0, byteArrayToUse.length);
        tempDigest = FormatHelper.base64Encode(buf);
        buf = tempDigest.getBytes();
        byteArrayToUse = new byte[PWDALG.length() + buf.length];
        System.arraycopy(PWDALG.getBytes(), 0, byteArrayToUse, 0, PWDALG.length());
        System.arraycopy(buf, 0, byteArrayToUse, PWDALG.length(), buf.length);
        result = new String(byteArrayToUse);
        return result;
    }

    public static String generateLdapHash(String stringToHash) throws TmsGeneralException {
        byte[] bytesToHash = stringToHash.getBytes();
        String result = null;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(bytesToHash);
            byte[] digest = md.digest();
            result = SecurityHelper.generateLdapHash(digest);
        }
        catch (NoSuchAlgorithmException nae) {
            throw new TmsGeneralException("Required Crypto Algorithm not supported! ", nae);
        }
        return result;
    }

    public static String generateLoginName(String firstname, String lastname) throws TmsGeneralException {
        String result;
        block12: {
            result = new String();
            if (firstname == null || firstname.trim().equals("") || lastname == null || lastname.trim().equals("")) {
                return null;
            }
            int loginCounterLength = Integer.toString(999).length();
            result = firstname.toLowerCase().substring(0, 1);
            if (lastname.length() < 3) {
                lastname = FormatHelper.padString('x', 3 - lastname.length(), lastname);
            }
            result = String.valueOf(result) + lastname.toLowerCase().substring(0, 3);
            int nextLoginNumber = 1;
            try {
                String nextLoginNumberString = Integer.toString(nextLoginNumber);
                String tempResult = String.valueOf(result) + FormatHelper.padString('0', loginCounterLength - nextLoginNumberString.length(), nextLoginNumberString);
                NCBManagerHome ncbManagerHome = NCBManagerUtil.getHome();
                NCBManager ncbManager = ncbManagerHome.create();
                boolean loginUnique = ncbManager.checkNcbLoginUnique(tempResult);
                if (!loginUnique) {
                    TreeSet ncbLoginsFound = ncbManager.findNcbLoginsByFirstAndLastName(firstname, lastname, result);
                    if (ncbLoginsFound != null && ncbLoginsFound.size() > 0) {
                        String maxLoginName = (String)ncbLoginsFound.last();
                        String maxLoginNumberString = maxLoginName.substring(maxLoginName.length() - loginCounterLength, maxLoginName.length());
                        int maxLoginNumber = 1;
                        try {
                            maxLoginNumber = Integer.parseInt(maxLoginNumberString);
                        }
                        catch (NumberFormatException nfe) {
                            throw new TmsGeneralException("generateLoginName: NamingException : Details : " + nfe.getMessage(), nfe);
                        }
                        nextLoginNumber = maxLoginNumber + 1;
                        if (nextLoginNumber > 999) {
                            throw new TmsGeneralException("generateLoginName: Cannot create unique login for. First :" + firstname + ": Last :" + lastname + ": Maximum login number reached :" + 999 + ":");
                        }
                        nextLoginNumberString = Integer.toString(nextLoginNumber);
                        result = String.valueOf(result) + FormatHelper.padString('0', loginCounterLength - nextLoginNumberString.length(), nextLoginNumberString);
                        break block12;
                    }
                    LogHelper.getBillingLogger().log(Level.FATAL, (Object)("generateLoginName: FatalException : Details : The return for find NCBs with the same first and last name with a similar login failed. first :" + firstname + ": last :" + lastname + ": login : " + result + ":"));
                    MailHelper.sendEmailToQueue("generateLoginName: FatalException : Details : The return for find NCBs with the same first and last name with a similar login failed. first :" + firstname + ": last :" + lastname + ": login : " + result + ":");
                    throw new TmsGeneralException("generateLoginName: FatalException : Details : The return for find NCBs with the same first and last name with a similar login failed. first :" + firstname + ": last :" + lastname + ": login : " + result + ":");
                }
                result = tempResult;
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("generateLoginName: NamingException : Details : " + ne.getMessage(), ne);
            }
            catch (RemoteException re) {
                throw new TmsGeneralException("generateLoginName: RemoteException : Details : " + re.getMessage(), re);
            }
            catch (CreateException ce) {
                throw new TmsGeneralException("generateLoginName: CreateException : Details : " + ce.getMessage(), (Exception)((Object)ce));
            }
            catch (FinderException fe) {
                throw new TmsGeneralException("generateLoginName: FinderException : Details : " + fe.getMessage(), (Exception)((Object)fe));
            }
        }
        return result;
    }

    public static String generatePassword(String stringToConvert) throws TmsGeneralException {
        String result = new String();
        if (stringToConvert == null || stringToConvert.trim().equals("")) {
            return null;
        }
        int inputCounter = stringToConvert.length() - 1;
        while (inputCounter >= 0) {
            result = String.valueOf(result) + stringToConvert.charAt(inputCounter);
            --inputCounter;
        }
        Random randGenerator = new Random(DateHelper.getCurrentDate().getTime());
        result = String.valueOf(result) + (randGenerator.nextInt(999) + 1);
        result = "[" + result + "]";
        return result;
    }
}

