/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import nz.co.k.tms.billing.ejb.NCBAddressData;
import nz.co.k.tms.billing.ejb.NCBData;
import nz.co.k.tms.utility.DateHelper;
import nz.co.k.tms.utility.TmsConst;
import nz.co.k.tms.xml.MessageAuthBlk;
import nz.co.k.tms.xml.MessageResponseBlk;
import nz.co.k.tms.xml.MessageTypeChoice;
import nz.co.k.tms.xml.Ncb;
import nz.co.k.tms.xml.NcbAddress;
import nz.co.k.tms.xml.ResponseGeneral;
import nz.co.k.tms.xml.TmsMessage;
import nz.co.k.tms.xml.TmsNcbServiceAuth;
import nz.co.k.tms.xml.report.audit.TmsAuditReport;
import nz.co.k.tms.xml.report.billing.TmsBillingReport;
import nz.co.k.tms.xml.report.fraud.TmsFraudReport;
import nz.co.k.tms.xml.report.royalty.TmsRoyaltyReport;
import nz.co.k.tms.xml.report.settlement.TmsSettlementReport;
import nz.co.k.tms.xml.report.usage.TmsUsageReport;
import nz.co.k.tms.xml.server.GeneralAvailable;
import nz.co.k.tms.xml.server.GeneralUnavailable;
import nz.co.k.tms.xml.server.NcbServiceAuth;
import nz.co.k.tms.xml.server.ServerMessageGeneralBlk;
import nz.co.k.tms.xml.server.ServerMessageRatingBlk;
import nz.co.k.tms.xml.server.TmsServerMessage;
import nz.co.k.tms.xml.server.UpdateFull;
import nz.co.k.tms.xml.server.UpdateNcb;
import nz.co.k.tms.xml.server.UpdateRating;
import nz.co.k.tms.xml.server.UpdateRatingItem;
import nz.co.k.tms.xml.server.types.ComponentType;
import nz.co.k.tms.xml.types.NcbAddressTypeType;
import nz.co.k.tms.xml.types.NcbTypeType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class XmlHelper {
    public static String createUpdateFullServerMessage() {
        TmsServerMessage serverMessage = XmlHelper.createBasicTmsServerMessage(new Long(DateHelper.getCurrentDate().getTime()));
        ServerMessageRatingBlk serverMessageRatingBlk = new ServerMessageRatingBlk();
        UpdateFull updateFull = new UpdateFull();
        serverMessageRatingBlk.setUpdateFull(updateFull);
        serverMessage.setServerMessageRatingBlk(serverMessageRatingBlk);
        String result = null;
        try {
            result = XmlHelper.marshalTmsServerMessage(serverMessage);
        }
        catch (MarshalException marshalException) {
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return result;
    }

    public static String createUpdateNcbServerMessage(Integer ncbId, Integer ratingId) {
        TmsServerMessage serverMessage = XmlHelper.createBasicTmsServerMessage(new Long(DateHelper.getCurrentDate().getTime()));
        ServerMessageRatingBlk serverMessageRatingBlk = new ServerMessageRatingBlk();
        UpdateNcb updateNcb = new UpdateNcb();
        updateNcb.setNcbId(ncbId);
        updateNcb.setRatingId(ratingId);
        serverMessageRatingBlk.setUpdateNcb(updateNcb);
        serverMessage.setServerMessageRatingBlk(serverMessageRatingBlk);
        String result = null;
        try {
            result = XmlHelper.marshalTmsServerMessage(serverMessage);
        }
        catch (MarshalException marshalException) {
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return result;
    }

    public static String createUpdateRatingItemServerMessage(Integer itemId, Integer ratingId) {
        TmsServerMessage serverMessage = XmlHelper.createBasicTmsServerMessage(new Long(DateHelper.getCurrentDate().getTime()));
        ServerMessageRatingBlk serverMessageRatingBlk = new ServerMessageRatingBlk();
        UpdateRatingItem updateRatingItem = new UpdateRatingItem();
        updateRatingItem.setItemId(itemId);
        updateRatingItem.setRatingId(ratingId);
        serverMessageRatingBlk.setUpdateRatingItem(updateRatingItem);
        serverMessage.setServerMessageRatingBlk(serverMessageRatingBlk);
        String result = null;
        try {
            result = XmlHelper.marshalTmsServerMessage(serverMessage);
        }
        catch (MarshalException marshalException) {
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return result;
    }

    public static String createUpdateRatingServerMessage(Integer ratingId) {
        TmsServerMessage serverMessage = XmlHelper.createBasicTmsServerMessage(new Long(DateHelper.getCurrentDate().getTime()));
        ServerMessageRatingBlk serverMessageRatingBlk = new ServerMessageRatingBlk();
        UpdateRating updateRating = new UpdateRating();
        updateRating.setRatingId(ratingId);
        serverMessageRatingBlk.setUpdateRating(updateRating);
        serverMessage.setServerMessageRatingBlk(serverMessageRatingBlk);
        String result = null;
        try {
            result = XmlHelper.marshalTmsServerMessage(serverMessage);
        }
        catch (MarshalException marshalException) {
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return result;
    }

    public static String createAvailableServerMessage() {
        TmsServerMessage serverMessage = XmlHelper.createBasicTmsServerMessage(new Long(DateHelper.getCurrentDate().getTime()));
        GeneralAvailable generalAvailable = new GeneralAvailable();
        generalAvailable.setComponentAvailable(ComponentType.BILLING);
        ServerMessageGeneralBlk serverMessageGeneralBlk = new ServerMessageGeneralBlk();
        serverMessageGeneralBlk.setGeneralAvailable(generalAvailable);
        serverMessage.setServerMessageGeneralBlk(serverMessageGeneralBlk);
        String result = null;
        try {
            result = XmlHelper.marshalTmsServerMessage(serverMessage);
        }
        catch (MarshalException marshalException) {
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return result;
    }

    public static String generateUnavailableServerMessage() {
        TmsServerMessage serverMessage = XmlHelper.createBasicTmsServerMessage(new Long(DateHelper.getCurrentDate().getTime()));
        GeneralUnavailable generalUnavailable = new GeneralUnavailable();
        generalUnavailable.setComponentUnavailable(ComponentType.BILLING);
        ServerMessageGeneralBlk serverMessageGeneralBlk = new ServerMessageGeneralBlk();
        serverMessageGeneralBlk.setGeneralUnavailable(generalUnavailable);
        serverMessage.setServerMessageGeneralBlk(serverMessageGeneralBlk);
        String result = null;
        try {
            result = XmlHelper.marshalTmsServerMessage(serverMessage);
        }
        catch (MarshalException marshalException) {
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return result;
    }

    public static NcbAddress convertNcbAddressDataToNcbAddress(NCBAddressData ncbAddressData, NcbAddressTypeType ncbAddressType) {
        NcbAddress ncbAddress = new NcbAddress();
        ncbAddress.setSelectedAddressType(ncbAddressType);
        if (ncbAddressData.getCity() != null) {
            ncbAddress.setCity(ncbAddressData.getCity());
        }
        if (ncbAddressData.getCountryCode() != null) {
            ncbAddress.setCountyCode(ncbAddressData.getCountryCode());
        }
        if (ncbAddressData.getEmail() != null) {
            ncbAddress.setEmail(ncbAddressData.getEmail());
        }
        if (ncbAddressData.getFaxNumber() != null) {
            ncbAddress.setFaxNumber(ncbAddressData.getFaxNumber());
        }
        if (ncbAddressData.getPhoneNumber() != null) {
            ncbAddress.setPhoneNumber(ncbAddressData.getPhoneNumber());
        }
        if (ncbAddressData.getPostalCode() != null) {
            ncbAddress.setPostalCode(ncbAddressData.getPostalCode());
        }
        if (ncbAddressData.getStateProv() != null) {
            ncbAddress.setStateProv(ncbAddressData.getStateProv());
        }
        if (ncbAddressData.getStreetLine1() != null) {
            ncbAddress.setStreetLine1(ncbAddressData.getStreetLine1());
        }
        if (ncbAddressData.getStreetLine2() != null) {
            ncbAddress.setStreetLine2(ncbAddressData.getStreetLine2());
        }
        if (ncbAddressData.getStreetLine3() != null) {
            ncbAddress.setStreetLine3(ncbAddressData.getStreetLine3());
        }
        return ncbAddress;
    }

    public static NCBData convertNcbToNCBData(Ncb ncb) {
        NCBData newNcbData = new NCBData();
        if (ncb.getNcbId() != null) {
            newNcbData.setNcbId(ncb.getNcbId());
        }
        if (ncb.getParentNcbId() != null) {
            newNcbData.setParentNcbId(ncb.getParentNcbId());
        }
        if (ncb.getNcbType() != null) {
            newNcbData.setNcbTypeId(new Integer(ncb.getNcbType().getType()));
        } else {
            newNcbData.setNcbTypeId(new Integer(2));
        }
        newNcbData.setName(ncb.getName());
        newNcbData.setNameLast(ncb.getNameLast());
        newNcbData.setNamePrefix(ncb.getNamePrefix());
        newNcbData.setNameSuffix(ncb.getNameSuffix());
        newNcbData.setLoginName(ncb.getLogin());
        newNcbData.setPassword(ncb.getPassword());
        if (ncb.getCertificate() != null) {
            newNcbData.setCert(ncb.getCertificate().toString());
        }
        return newNcbData;
    }

    public static Ncb convertNcbDataToNCB(NCBData ncbData) {
        Ncb newNcb = new Ncb();
        newNcb.setLogin(ncbData.getLoginName());
        newNcb.setName(ncbData.getName());
        newNcb.setNameLast(ncbData.getNameLast());
        newNcb.setNamePrefix(ncbData.getNamePrefix());
        newNcb.setNameSuffix(ncbData.getNameSuffix());
        newNcb.setNcbId(ncbData.getNcbId());
        if (ncbData.getParentNcbId() != null) {
            newNcb.setParentNcbId(ncbData.getParentNcbId());
        }
        if (ncbData.getNcbTypeId() != null) {
            newNcb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbData.getNcbTypeId()]));
        } else {
            newNcb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]));
        }
        newNcb.setPassword(ncbData.getPassword());
        return newNcb;
    }

    public static nz.co.k.tms.xml.server.Ncb convertNcbToServerNcb(Ncb ncbToConvert) {
        nz.co.k.tms.xml.server.Ncb newNcb = new nz.co.k.tms.xml.server.Ncb();
        newNcb.setLogin(ncbToConvert.getLogin());
        newNcb.setName(ncbToConvert.getName());
        newNcb.setNameLast(ncbToConvert.getNameLast());
        newNcb.setNamePrefix(ncbToConvert.getNamePrefix());
        newNcb.setNameSuffix(ncbToConvert.getNameSuffix());
        newNcb.setNcbId(ncbToConvert.getNcbId());
        if (ncbToConvert.getParentNcbId() != null) {
            newNcb.setParentNcbId(ncbToConvert.getParentNcbId());
        }
        newNcb.setPassword(ncbToConvert.getPassword());
        return newNcb;
    }

    public static Ncb convertServerNcbToNcb(nz.co.k.tms.xml.server.Ncb ncbToConvert) {
        Ncb newNcb = new Ncb();
        newNcb.setLogin(ncbToConvert.getLogin());
        newNcb.setName(ncbToConvert.getName());
        newNcb.setNameLast(ncbToConvert.getNameLast());
        newNcb.setNamePrefix(ncbToConvert.getNamePrefix());
        newNcb.setNameSuffix(ncbToConvert.getNameSuffix());
        newNcb.setNcbId(ncbToConvert.getNcbId());
        if (ncbToConvert.getParentNcbId() != null) {
            newNcb.setParentNcbId(ncbToConvert.getParentNcbId());
        }
        newNcb.setPassword(ncbToConvert.getPassword());
        return newNcb;
    }

    public static NcbServiceAuth convertNcbServiceAuthToServerNcbServiceAuth(TmsNcbServiceAuth tmsNcbServiceAuthToConvert) {
        NcbServiceAuth newNcbServiceAuth = new NcbServiceAuth();
        newNcbServiceAuth.setNcbId(tmsNcbServiceAuthToConvert.getNcbId());
        newNcbServiceAuth.setNcbConnectionLimit(tmsNcbServiceAuthToConvert.getNcbConnectionLimit());
        newNcbServiceAuth.setNcbServiceAuthDateTime(tmsNcbServiceAuthToConvert.getNcbServiceAuthDateTime());
        newNcbServiceAuth.setNcbService(tmsNcbServiceAuthToConvert.getNcbService());
        return newNcbServiceAuth;
    }

    public static TmsNcbServiceAuth convertServerNcbServiceAuthToNcbServiceAuth(NcbServiceAuth ncbServiceAuthToConvert) {
        TmsNcbServiceAuth newTmsNcbServiceAuth = new TmsNcbServiceAuth();
        newTmsNcbServiceAuth.setNcbId(ncbServiceAuthToConvert.getNcbId());
        newTmsNcbServiceAuth.setNcbConnectionLimit(ncbServiceAuthToConvert.getNcbConnectionLimit());
        newTmsNcbServiceAuth.setNcbServiceAuthDateTime(ncbServiceAuthToConvert.getNcbServiceAuthDateTime());
        newTmsNcbServiceAuth.setNcbService(ncbServiceAuthToConvert.getNcbService());
        return newTmsNcbServiceAuth;
    }

    public static String marshalTmsServerMessage(TmsServerMessage tmsServerMessage) throws MarshalException, ValidationException {
        StringWriter ms = new StringWriter();
        Marshaller.marshal((Object)tmsServerMessage, (Writer)ms);
        return ms.toString();
    }

    public static String marshalTmsMessage(TmsMessage tmsMessage) throws MarshalException, ValidationException {
        StringWriter ms = new StringWriter();
        Marshaller.marshal((Object)tmsMessage, (Writer)ms);
        return ms.toString();
    }

    public static String marshalTmsBillingReportMessage(TmsBillingReport tmsBillingReport) throws MarshalException, ValidationException {
        StringWriter outputStringWriter = new StringWriter();
        Marshaller.marshal((Object)tmsBillingReport, (Writer)outputStringWriter);
        return outputStringWriter.toString();
    }

    public static String marshalTmsUsageReportMessage(TmsUsageReport tmsUsageReport) throws MarshalException, ValidationException {
        StringWriter outputStringWriter = new StringWriter();
        Marshaller.marshal((Object)tmsUsageReport, (Writer)outputStringWriter);
        return outputStringWriter.toString();
    }

    public static String marshalTmsFraudReportMessage(TmsFraudReport tmsFraudReport) throws MarshalException, ValidationException {
        StringWriter outputStringWriter = new StringWriter();
        Marshaller.marshal((Object)tmsFraudReport, (Writer)outputStringWriter);
        return outputStringWriter.toString();
    }

    public static String marshalTmsSettlementReportMessage(TmsSettlementReport tmsSettlementReport) throws MarshalException, ValidationException {
        StringWriter outputStringWriter = new StringWriter();
        Marshaller.marshal((Object)tmsSettlementReport, (Writer)outputStringWriter);
        return outputStringWriter.toString();
    }

    public static String marshalTmsRoyaltyReportMessage(TmsRoyaltyReport tmsRoyaltyReport) throws MarshalException, ValidationException {
        StringWriter outputStringWriter = new StringWriter();
        Marshaller.marshal((Object)tmsRoyaltyReport, (Writer)outputStringWriter);
        return outputStringWriter.toString();
    }

    public static String marshalTmsAuditReportMessage(TmsAuditReport tmsAuditReport) throws MarshalException, ValidationException {
        StringWriter outputStringWriter = new StringWriter();
        Marshaller.marshal((Object)tmsAuditReport, (Writer)outputStringWriter);
        return outputStringWriter.toString();
    }

    public static TmsServerMessage createBasicTmsServerMessage(Long messageId) {
        TmsServerMessage tmsServerMessage = new TmsServerMessage();
        tmsServerMessage.setServerMessageDateTime(DateHelper.getCurrentDate());
        if (messageId == null) {
            messageId = new Long(-1L);
        }
        tmsServerMessage.setServerMessageId(messageId);
        return tmsServerMessage;
    }

    public static TmsMessage createBasicTmsMessage(Long messageId, MessageAuthBlk authBlk) {
        Date currentDate = DateHelper.getCurrentDate();
        TmsMessage basicMessage = new TmsMessage();
        if (messageId == null) {
            messageId = new Long(-1L);
        }
        basicMessage.setMessageId(messageId);
        basicMessage.setMessageDateTime(currentDate);
        if (authBlk == null) {
            authBlk = new MessageAuthBlk();
            authBlk.setNcbId(new Integer(0));
        }
        basicMessage.setMessageAuthBlk(authBlk);
        return basicMessage;
    }

    public static MessageAuthBlk createTmsMessageAuthBlock(Integer ncbId) {
        MessageAuthBlk messageAuthBlk = new MessageAuthBlk();
        messageAuthBlk.setNcbId(ncbId);
        return messageAuthBlk;
    }

    public static String createGeneralResponseMessage(Long messageId, MessageAuthBlk auth, String actionString, int responseCode, String responseDescription, Integer responseMessageDaysValidFor) throws MarshalException, ValidationException {
        Date currentDate = DateHelper.getCurrentDate();
        TmsMessage createdMessage = XmlHelper.createBasicTmsMessage(messageId, auth);
        MessageResponseBlk responseBlk = new MessageResponseBlk();
        ResponseGeneral general = new ResponseGeneral();
        general.setCode(Integer.toString(responseCode));
        general.setActionString(actionString);
        String responseDescriptionDetail = "";
        if (responseCode != 0) {
            responseDescriptionDetail = responseDescription;
            try {
                responseDescriptionDetail = String.valueOf(responseDescriptionDetail) + " " + TmsConst.CODE_DESCRIPTION[responseCode];
            }
            catch (NumberFormatException nfe) {}
        } else {
            responseDescriptionDetail = responseDescription;
        }
        general.setDescription(responseDescriptionDetail);
        general.setResponseDateTime(currentDate);
        Date expiryDate = DateHelper.addDaysToDate(currentDate, responseMessageDaysValidFor);
        general.setResponseExpiryDateTime(expiryDate);
        responseBlk.addResponseGeneral(general);
        MessageTypeChoice messageTypeChoice = new MessageTypeChoice();
        messageTypeChoice.setMessageResponseBlk(responseBlk);
        createdMessage.setMessageTypeChoice(messageTypeChoice);
        return XmlHelper.marshalTmsMessage(createdMessage);
    }
}

