/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.io.FileInputStream;
import java.util.Properties;
import nz.co.k.tms.exception.TmsGeneralException;

public class TmsPropertyHelper {
    public static final String PropertyFile = "/config/application/tms.properties";
    public String SessionDBServerDriver;
    public String SessionDBServerProtocol;
    public String SessionDBServerAddress;
    public String SessionDBServerPort;
    public String SessionDBDatabase;
    public String SessionDBUser;
    public String SessionDBPassword;
    public int SessionDBLifeLimit;
    public int SessionDBInactivityLimit;
    public String LdapServerProtocol;
    public String LdapServerAddress;
    public int LdapServerPort;
    public String LdapServerAdminDn;
    public String LdapServerAdminPassword;
    public String RootOrganisation;
    public String XMLPacketAttribteName;
    public String MediationReceiveToQueueBase;
    public String MediationSendToRealTimeQueueBase;
    public String MediationSendToNonRealTimeQueueBase;
    public String MediationReceiveBackQueueBase;
    public String MediationSendBackQueueBase;
    public String MediationWaitingMessageQueueBase;
    public String RatingReceiveToRealTimeQueueBase;
    public String RatingReceiveToNonRealTimeQueueBase;
    public String RatingSendToRealTimeQueueBase;
    public String RatingSendToNonRealTimeQueueBase;
    public String RatingTempQueueBase;
    public String BillingReceiveToRealTimeQueueBase;
    public String BillingReceiveToNonRealTimeQueueBase;
    public String BillingSendToRealTimeQueueBase;
    public String BillingSendToNonRealTimeQueueBase;
    public String BillingTempQueueBase;
    public String BillingLdapQueueBase;
    public String MediationLocation;
    public String RatingLocation;
    public String BillingLocation;
    public String SmtpServerAddress;
    public String EmailQueueBase;
    public String EmailQueueCheckPeriod;
    public String AlertEmailSubject;
    public String AlertEmailSendFrom;
    public String AlertEmailSendTo;
    public String AlertEmailPriority;
    public int ConnectionTimeout;
    public int RatingRetryMaxTime;
    public String MediationScheduledTime;
    public String MediationScheduledPeriod;
    public String RatingScheduledTime;
    public String RatingScheduledPeriod;
    public String BillingScheduledTime;
    public String BillingScheduledPeriod;
    public String BillingSettlementTime;
    public String BillingSettlementPeriod;
    public String BillingLdapScheduledPeriod;
    public int ResponseExpiryDays;
    public int SettlementAuthMaxDays;
    public int SettlementDeactivateLeadDays;
    public String SettlementDefaultCurrencyCode;
    public int BillingPeriodIncrementType;
    public int BillingPeriodIncrementValue;
    public String BuyLineServerIP;
    public int BuyLineServerPort;
    public String BuyLineServerOpsId;
    public String BuyLineServerOpsPass;
    public String BuyLineVoidQueueBase;
    public String BuyLineVoidScheduledPeriod;
    public int BuyLineServerStatus;
    public int BuyLineConnectionTimeout;

    public void load() throws TmsGeneralException {
        TmsGeneralException tmsPropertiesGeneralException = new TmsGeneralException("Exception Occurred during load of TMS properties.");
        try {
            String ResponseExpiryDaysTemp;
            Properties properties = new Properties();
            FileInputStream propertiesFile = new FileInputStream(PropertyFile);
            properties.load(propertiesFile);
            propertiesFile.close();
            this.SessionDBServerDriver = properties.getProperty("SessionDBServerDriver", "");
            this.SessionDBServerProtocol = properties.getProperty("SessionDBServerProtocol", "");
            this.SessionDBServerAddress = properties.getProperty("SessionDBServerAddress", "");
            this.SessionDBServerPort = properties.getProperty("SessionDBServerPort", "");
            this.SessionDBDatabase = properties.getProperty("SessionDBDatabase", "");
            this.SessionDBUser = properties.getProperty("SessionDBUser", "");
            this.SessionDBPassword = properties.getProperty("SessionDBPassword", "");
            String SessionDBLifeLimitTemp = properties.getProperty("SessionDBLifeLimit", "");
            String SessionDBInactivityLimitTemp = properties.getProperty("SessionDBInactivityLimit", "");
            if (this.SessionDBServerDriver.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBServerDriver does not exist in Config file.");
            }
            if (this.SessionDBServerProtocol.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBServerProtocol does not exist in Config file.");
            }
            if (this.SessionDBServerAddress.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBServerAddress does not exist in Config file.");
            }
            if (this.SessionDBServerPort.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBServerPort does not exist in Config file.");
            }
            if (this.SessionDBDatabase.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBDatabase does not exist in Config file.");
            }
            if (this.SessionDBUser.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBUser does not exist in Config file.");
            }
            if (this.SessionDBPassword.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBPassword does not exist in Config file.");
            }
            if (SessionDBLifeLimitTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBLifeLimit does not exist in Config file.");
            }
            try {
                this.SessionDBLifeLimit = new Integer(SessionDBLifeLimitTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBLifeLimit in Config file NOT a number.");
            }
            if (SessionDBInactivityLimitTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBInactivityLimit does not exist in Config file.");
            }
            try {
                this.SessionDBInactivityLimit = new Integer(SessionDBInactivityLimitTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("SessionDBInactivityLimit in Config file NOT a number.");
            }
            this.LdapServerProtocol = properties.getProperty("LdapServerProtocol", "");
            this.LdapServerAddress = properties.getProperty("LdapServerAddress", "");
            String LdapServerPortTemp = properties.getProperty("LdapServerPort", "");
            this.LdapServerAdminDn = properties.getProperty("LdapServerAdminDn", "");
            this.LdapServerAdminPassword = properties.getProperty("LdapServerAdminPassword", "");
            this.RootOrganisation = properties.getProperty("RootOrganisation", "");
            this.XMLPacketAttribteName = properties.getProperty("XMLPacketAttribteName", "");
            if (this.LdapServerProtocol.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("LdapServerProtocol does not exist in Config file.");
            }
            if (this.LdapServerAddress.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("LdapServerAddress does not exist in Config file.");
            }
            if (LdapServerPortTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("LdapServerPort does not exist in Config file.");
            }
            try {
                this.LdapServerPort = new Integer(LdapServerPortTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("LdapServerPort in Config file NOT a number.");
            }
            if (this.LdapServerAdminDn.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("LdapServerAdminDn does not exist in Config file.");
            }
            if (this.LdapServerAdminPassword.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("LdapServerAdminPassword does not exist in Config file.");
            }
            if (this.RootOrganisation.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("RootOrganisation does not exist in Config file.");
            }
            if (this.XMLPacketAttribteName.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("XMLPacketAttribteName does not exist in Config file.");
            }
            this.MediationReceiveToQueueBase = properties.getProperty("MediationReceiveToQueueBase", "");
            this.MediationSendToRealTimeQueueBase = properties.getProperty("MediationSendToRealTimeQueueBase", "");
            this.MediationSendToNonRealTimeQueueBase = properties.getProperty("MediationSendToNonRealTimeQueueBase", "");
            this.MediationReceiveBackQueueBase = properties.getProperty("MediationReceiveBackQueueBase", "");
            this.MediationSendBackQueueBase = properties.getProperty("MediationSendBackQueueBase", "");
            this.MediationWaitingMessageQueueBase = properties.getProperty("MediationWaitingMessageQueueBase", "");
            if (this.MediationReceiveToQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation receive to queue does not exist in Config file.");
            }
            if (this.MediationSendToRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation send to real time queue does not exist in Config file.");
            }
            if (this.MediationSendToNonRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation send to non-real time queue does not exist in Config file.");
            }
            if (this.MediationReceiveBackQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation receive back queue does not exist in Config file.");
            }
            if (this.MediationSendBackQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation send back queue does not exist in Config file.");
            }
            if (this.MediationWaitingMessageQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation waiting message queue does not exist in Config file.");
            }
            this.RatingReceiveToRealTimeQueueBase = properties.getProperty("RatingReceiveToRealTimeQueueBase", "");
            this.RatingReceiveToNonRealTimeQueueBase = properties.getProperty("RatingReceiveToNonRealTimeQueueBase", "");
            this.RatingSendToRealTimeQueueBase = properties.getProperty("RatingSendToRealTimeQueueBase", "");
            this.RatingSendToNonRealTimeQueueBase = properties.getProperty("RatingSendToNonRealTimeQueueBase", "");
            this.RatingTempQueueBase = properties.getProperty("RatingTempQueueBase", "");
            if (this.RatingReceiveToRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating receive to real time queue does not exist in Config file.");
            }
            if (this.RatingReceiveToNonRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating receive to non-real time queue does not exist in Config file.");
            }
            if (this.RatingSendToRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating send to real time queue does not exist in Config file.");
            }
            if (this.RatingSendToNonRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating send to non-real time queue does not exist in Config file.");
            }
            if (this.RatingTempQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating temp queue does not exist in Config file.");
            }
            this.BillingReceiveToRealTimeQueueBase = properties.getProperty("BillingReceiveToRealTimeQueueBase", "");
            this.BillingReceiveToNonRealTimeQueueBase = properties.getProperty("BillingReceiveToNonRealTimeQueueBase", "");
            this.BillingSendToRealTimeQueueBase = properties.getProperty("BillingSendToRealTimeQueueBase", "");
            this.BillingSendToNonRealTimeQueueBase = properties.getProperty("BillingSendToNonRealTimeQueueBase", "");
            this.BillingTempQueueBase = properties.getProperty("BillingTempQueueBase", "");
            this.BillingLdapQueueBase = properties.getProperty("BillingLdapQueueBase", "");
            if (this.BillingReceiveToRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing receive to real time queue does not exist in Config file.");
            }
            if (this.BillingReceiveToNonRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing receive to non-real time queue does not exist in Config file.");
            }
            if (this.BillingSendToRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing send to real time queue does not exist in Config file.");
            }
            if (this.BillingSendToNonRealTimeQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing send to non-real time queue does not exist in Config file.");
            }
            if (this.BillingTempQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing temp queue does not exist in Config file.");
            }
            if (this.BillingLdapQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing LDAP queue does not exist in Config file.");
            }
            this.MediationLocation = properties.getProperty("MediationEngineLocation", "");
            this.RatingLocation = properties.getProperty("RatingEngineLocation", "");
            this.BillingLocation = properties.getProperty("BillingEngineLocation", "");
            if (this.MediationLocation.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation Engine location was not specified in Config file.");
            }
            if (this.RatingLocation.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating Engine location was not specified in Config file.");
            }
            if (this.BillingLocation.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing Engine location was not specified in Config file.");
            }
            this.SmtpServerAddress = properties.getProperty("SmtpServerAddress", "");
            this.EmailQueueBase = properties.getProperty("EmailQueueBase", "");
            this.EmailQueueCheckPeriod = properties.getProperty("EmailQueueCheckPeriod", "");
            this.AlertEmailSubject = properties.getProperty("AlertEmailSubject", "");
            this.AlertEmailSendFrom = properties.getProperty("AlertEmailSendFrom", "");
            this.AlertEmailSendTo = properties.getProperty("AlertEmailSendTo", "");
            this.AlertEmailPriority = properties.getProperty("AlertEmailPriority", "3");
            if (this.SmtpServerAddress.trim().equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Smtp Server Address was not specified in Config file.");
            }
            if (this.EmailQueueBase.trim().equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Email Queue Base was not specified in Config file.");
            }
            if (this.EmailQueueCheckPeriod.trim().equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Email Queue Check Period was not specified in Config file.");
            }
            if (this.AlertEmailSubject.trim().equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Alert Email Subject was not specified in Config file.");
            }
            if (this.AlertEmailSendFrom.trim().equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Alert Email Send From was not specified in Config file.");
            }
            if (this.AlertEmailSendTo.trim().equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Alert Email Send to was not specified in Config file.");
            }
            if (this.AlertEmailPriority.trim().equals("")) {
                this.AlertEmailPriority = "3";
            } else if (!(this.AlertEmailPriority.trim().equals("1") || this.AlertEmailPriority.trim().equals("2") || this.AlertEmailPriority.trim().equals("3") || this.AlertEmailPriority.trim().equals("4") || this.AlertEmailPriority.trim().equals("5"))) {
                this.AlertEmailPriority = "3";
            }
            String ConnectionTimeoutTemp = properties.getProperty("ConnectionTimeout", "");
            String RatingRetryMaxTimeTemp = properties.getProperty("RatingRetryMaxTime", "");
            if (ConnectionTimeoutTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("Connection Timeout does not exist in Config file.");
            }
            try {
                this.ConnectionTimeout = new Integer(ConnectionTimeoutTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("Connection Timeout in Config file NOT a number.");
            }
            if (RatingRetryMaxTimeTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating Retry Max Time does not exist in Config file.");
            }
            try {
                this.RatingRetryMaxTime = new Integer(RatingRetryMaxTimeTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("Rating Retry Max Time in Config file NOT a number.");
            }
            this.MediationScheduledTime = properties.getProperty("MediationScheduledTime", "");
            this.MediationScheduledPeriod = properties.getProperty("MediationScheduledPeriod", "");
            this.RatingScheduledTime = properties.getProperty("RatingScheduledTime", "");
            this.RatingScheduledPeriod = properties.getProperty("RatingScheduledPeriod", "");
            this.BillingScheduledTime = properties.getProperty("BillingScheduledTime", "");
            this.BillingScheduledPeriod = properties.getProperty("BillingScheduledPeriod", "");
            this.BillingSettlementTime = properties.getProperty("BillingSettlementTime", "");
            this.BillingSettlementPeriod = properties.getProperty("BillingSettlementPeriod", "");
            this.BillingLdapScheduledPeriod = properties.getProperty("BillingLdapScheduledPeriod", "");
            if (this.MediationScheduledTime.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation Scheduled Time was not specified in Config file.");
            }
            if (this.MediationScheduledPeriod.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Mediation Scheduled Period was not specified in Config file.");
            }
            if (this.RatingScheduledTime.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating Scheduled Time was not specified in Config file.");
            }
            if (this.RatingScheduledPeriod.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Rating Scheduled Period was not specified in Config file.");
            }
            if (this.BillingScheduledTime.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing Scheduled Time was not specified in Config file.");
            }
            if (this.BillingScheduledPeriod.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing Scheduled Period was not specified in Config file.");
            }
            if (this.BillingSettlementTime.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing Settlement Time was not specified in Config file.");
            }
            if (this.BillingSettlementPeriod.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing Settlement Period was not specified in Config file.");
            }
            if (this.BillingLdapScheduledPeriod.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("Billing LDAP Scheduled Period was not specified in Config file.");
            }
            if ((ResponseExpiryDaysTemp = properties.getProperty("ResponseExpiryDays")).trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("Response Expiry Days does not exist in Config file.");
            }
            try {
                this.ResponseExpiryDays = new Integer(ResponseExpiryDaysTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("Response Expiry Days in Config file NOT a number.");
            }
            String SettlementAuthMaxDaysTemp = properties.getProperty("SettlementAuthMaxDays", "");
            String SettlementDeactivateLeadDaysTemp = properties.getProperty("SettlementDeactivateLeadDays", "");
            this.SettlementDefaultCurrencyCode = properties.getProperty("SettlementDefaultCurrencyCode", "");
            if (SettlementAuthMaxDaysTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SettlementAuthMaxDays does not exist in Config file.");
            }
            try {
                this.SettlementAuthMaxDays = new Integer(SettlementAuthMaxDaysTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("SettlementAuthMaxDays in Config file NOT a number.");
            }
            if (SettlementDeactivateLeadDaysTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SettlementDeactivateLeadDays does not exist in Config file.");
            }
            try {
                this.SettlementDeactivateLeadDays = new Integer(SettlementDeactivateLeadDaysTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("SettlementDeactivateLeadDays in Config file NOT a number.");
            }
            if (this.SettlementDefaultCurrencyCode.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("SettlementDefaultCurrencyCode does not exist in Config file.");
            }
            String BillingPeriodIncrementTypeTemp = properties.getProperty("BillingPeriodIncrementType", "1");
            String BillingPeriodIncrementValueTemp = properties.getProperty("BillingPeriodIncrementValue", "1");
            if (BillingPeriodIncrementTypeTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("BillingPeriodIncrementType does not exist in Config file.");
            }
            try {
                this.BillingPeriodIncrementType = new Integer(BillingPeriodIncrementTypeTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("BillingPeriodIncrementType in Config file NOT a number.");
            }
            if (BillingPeriodIncrementValueTemp.trim().equalsIgnoreCase("")) {
                tmsPropertiesGeneralException.addApplicationException("BillingPeriodIncrementValue does not exist in Config file.");
            }
            try {
                this.BillingPeriodIncrementValue = new Integer(BillingPeriodIncrementValueTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("BillingPeriodIncrementValue in Config file NOT a number.");
            }
            this.BuyLineServerIP = properties.getProperty("BuyLineServerIP", "");
            String BuyLineServerPortTemp = properties.getProperty("BuyLineServerPort", "");
            this.BuyLineServerOpsId = properties.getProperty("BuyLineServerOpsId", "");
            this.BuyLineServerOpsPass = properties.getProperty("BuyLineServerOpsPass", "");
            this.BuyLineVoidQueueBase = properties.getProperty("BuyLineVoidQueueBase", "");
            this.BuyLineVoidScheduledPeriod = properties.getProperty("BuyLineVoidScheduledPeriod", "");
            String BuyLineServerStatusTemp = properties.getProperty("BuyLineServerStatus", "0");
            String BuyLineConnectionTimeoutTemp = properties.getProperty("BuyLineConnectionTimeout", "");
            if (this.BuyLineServerIP.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Server IP was not specified in Config file.");
            }
            if (BuyLineServerPortTemp.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Server Port was not specified in Config file.");
            }
            try {
                this.BuyLineServerPort = new Integer(BuyLineServerPortTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Server Port in Config file NOT a number.");
            }
            if (this.BuyLineServerOpsId.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Server Ops Id was not specified in Config file.");
            }
            if (this.BuyLineServerOpsPass.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Server Ops Password was not specified in Config file.");
            }
            if (this.BuyLineVoidQueueBase.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Void Queue base was not specified in Config file.");
            }
            if (this.BuyLineVoidScheduledPeriod.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Void Schedular Period was not specified in Config file.");
            }
            if (BuyLineServerStatusTemp.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Server Status was not specified in Config file.");
            }
            try {
                this.BuyLineServerStatus = new Integer(BuyLineServerStatusTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Server Status in Config file NOT a number.");
            }
            if (BuyLineConnectionTimeoutTemp.equals("")) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Connection Timeout was not specified in Config file.");
            }
            try {
                this.BuyLineConnectionTimeout = new Integer(BuyLineConnectionTimeoutTemp);
            }
            catch (NumberFormatException nfe) {
                tmsPropertiesGeneralException.addApplicationException("BuyLine Connection Timeout in Config file NOT a number.");
            }
            if (tmsPropertiesGeneralException.getExceptionItemCount() > 0) {
                throw tmsPropertiesGeneralException;
            }
        }
        catch (Exception err) {
            throw new TmsGeneralException("Exception Occurred during load of TMS properties.", err);
        }
    }
}

