/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.utility.FileQueue;
import nz.co.k.tms.utility.TmsPropertyHelper;

public class MessageSender {
    public static String sendMessage(String sendMessage, String toLocation) throws IOException, SocketTimeoutException, TmsGeneralException {
        TmsPropertyHelper tmsProperties = new TmsPropertyHelper();
        tmsProperties.load();
        String timeOut = "" + tmsProperties.ConnectionTimeout * 1000;
        System.getProperties().put("sun.net.client.defaultReadTimeout", timeOut);
        System.getProperties().put("sun.net.client.defaultConnectTimeout", timeOut);
        String receiveBackXml = MessageSender.sendMessageNoTimeout(sendMessage, toLocation);
        return receiveBackXml;
    }

    public static String sendMessageNoTimeout(String sendMessage, String toLocation) throws IOException, SocketTimeoutException {
        String inputLine;
        String receiveBackXml = null;
        URL url = new URL(toLocation);
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        String content = "j_username=" + URLEncoder.encode("username", "UTF-8") + "&j_password=" + URLEncoder.encode("password", "UTF-8") + "&TmsXmlData=" + URLEncoder.encode(sendMessage, "UTF-8");
        printout.writeBytes(content);
        printout.flush();
        printout.close();
        DataInputStream input = new DataInputStream(urlConn.getInputStream());
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        receiveBackXml = "";
        while ((inputLine = br.readLine()) != null) {
            receiveBackXml = String.valueOf(receiveBackXml) + inputLine + "\n";
        }
        input.close();
        return receiveBackXml;
    }

    public static void sendMessagesFromQueue(String queueBase, String nextParty) throws IOException, SocketTimeoutException, TmsGeneralException {
        TmsPropertyHelper tmsProperties = new TmsPropertyHelper();
        tmsProperties.load();
        String timeOut = "" + tmsProperties.ConnectionTimeout * 1000;
        System.getProperties().put("sun.net.client.defaultReadTimeout", timeOut);
        System.getProperties().put("sun.net.client.defaultConnectTimeout", timeOut);
        FileQueue queue = new FileQueue(queueBase);
        String[] fileNames = queue.getAllFileNames();
        if (fileNames == null) {
            return;
        }
        int i = 0;
        while (i < fileNames.length) {
            String fileContent = queue.getByName(fileNames[i]);
            String receiveBackXml = MessageSender.sendMessageNoTimeout(fileContent, nextParty);
            if (receiveBackXml.trim().indexOf("<title>Error Page</title>") != -1) {
                throw new IOException("404 error page, you requested a page that does not exist");
            }
            queue.removeByName(fileNames[i]);
            ++i;
        }
    }
}

