/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.utility.DateHelper;
import nz.co.k.tms.utility.FileQueue;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsPropertyHelper;
import nz.co.k.tms.xml.mailer.CksMailerMessage;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class MailHelper {
    private static Message prepareHeader(String smtpHost, String messageSentFrom, String messageSendTo, String messageSubject) throws IOException, AddressException, MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.host", smtpHost);
        Session session = Session.getDefaultInstance((Properties)props);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress messageSendToAddr = new InternetAddress(messageSendTo);
        msg.addRecipients(Message.RecipientType.TO, (Address[])new InternetAddress[]{messageSendToAddr});
        InternetAddress from_addr = new InternetAddress(messageSentFrom);
        msg.setFrom((Address)from_addr);
        msg.setSubject(messageSubject);
        return msg;
    }

    public static void sendMail(String messageSentFrom, String messageSendTo, String messageSubject, String messageBody) throws IOException, AddressException, MessagingException, TmsGeneralException {
        TmsPropertyHelper tmsProperties = new TmsPropertyHelper();
        try {
            tmsProperties.load();
            Message msg = MailHelper.prepareHeader(tmsProperties.SmtpServerAddress, messageSentFrom, messageSendTo, messageSubject);
            msg.addHeader("X-Priority", tmsProperties.AlertEmailPriority);
            msg.setContent((Object)messageBody, "text/plain");
            msg.setSentDate(DateHelper.getCurrentDate());
            Transport.send((Message)msg);
        }
        catch (IOException ioex) {
            throw new TmsGeneralException("IOException while sending email", ioex);
        }
        catch (AddressException aex) {
            throw new TmsGeneralException("AddressException while sending email", (Exception)((Object)aex));
        }
        catch (MessagingException mex) {
            throw new TmsGeneralException("MessagingException while sending email", (Exception)((Object)mex));
        }
    }

    public static void sendEmailToQueue(String messageToSend) throws TmsGeneralException {
        TmsPropertyHelper tmsProperties = new TmsPropertyHelper();
        tmsProperties.load();
        CksMailerMessage cksMailerMessage = new CksMailerMessage();
        cksMailerMessage.setMailerMessageTo(tmsProperties.AlertEmailSendTo);
        cksMailerMessage.setMailerMessageFrom(tmsProperties.AlertEmailSendFrom);
        cksMailerMessage.setMailerMessageSubject(tmsProperties.AlertEmailSubject);
        cksMailerMessage.setMailerMessageBody(messageToSend);
        String cksMailerMessageString = null;
        try {
            StringWriter ms = new StringWriter();
            Marshaller.marshal((Object)cksMailerMessage, (Writer)ms);
            cksMailerMessageString = ms.toString();
        }
        catch (MarshalException me) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)me.toString());
            cksMailerMessageString = null;
        }
        catch (ValidationException ve) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)ve.toString());
            cksMailerMessageString = null;
        }
        MailHelper.sendMessageToQueue(cksMailerMessageString);
    }

    private static void sendMessageToQueue(String message) {
        TmsPropertyHelper tmsProperties = new TmsPropertyHelper();
        try {
            tmsProperties.load();
            FileQueue mailerQueue = new FileQueue(tmsProperties.EmailQueueBase);
            String mailerMessageFileName = mailerQueue.put(message);
            LogHelper.getBillingLogger().log(Level.INFO, (Object)(">>>> The file :" + mailerMessageFileName + ": was placed on the Mailer queue."));
        }
        catch (IOException ioe) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("MailHelper:sendMessageToQueue: IOException. Details :" + ioe.toString()));
        }
        catch (TmsGeneralException tmsge) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("MailHelper:sendMessageToQueue: TmsGeneralException. Details :" + tmsge.toString()));
        }
    }
}

