/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Random;

public class Guid
implements Serializable {
    static final long serialVersionUID = -6798123864977760588L;
    protected static final String STRING_TEMPLATE = "00000000-0000-0000-0000-000000000000";
    private static Object lock;
    private long hi;
    private long lo;

    public Guid() {
        Random randomNumberGenerator = new Random();
        randomNumberGenerator.setSeed(new Date().getTime());
        this.lo = randomNumberGenerator.nextLong();
        this.hi = randomNumberGenerator.nextLong() + this.lo;
    }

    public Guid(String s) throws NumberFormatException {
        if (36 != s.length() || '-' != s.charAt(8) || '-' != s.charAt(13) || '-' != s.charAt(18) || '-' != s.charAt(23)) {
            throw new NumberFormatException("Invalid structure for string representation of GUID");
        }
        this.hi = Long.parseLong(s.substring(0, 8), 16) << 32 | Long.parseLong(s.substring(9, 13), 16) << 16 | Long.parseLong(s.substring(14, 18), 16);
        this.lo = Long.parseLong(s.substring(19, 23), 16) << 48 | Long.parseLong(s.substring(24, 36), 16);
    }

    public Guid(String s, char sep) throws NumberFormatException {
        if (36 != s.length() || sep != s.charAt(8) || sep != s.charAt(13) || sep != s.charAt(18) || sep != s.charAt(23)) {
            throw new NumberFormatException("Invalid structure for string representation of GUID");
        }
        this.hi = Long.parseLong(s.substring(0, 8), 16) << 32 | Long.parseLong(s.substring(9, 13), 16) << 16 | Long.parseLong(s.substring(14, 18), 16);
        this.lo = Long.parseLong(s.substring(19, 23), 16) << 48 | Long.parseLong(s.substring(24, 36), 16);
    }

    public Guid(byte[] bytes) {
        if (16 != bytes.length) {
            throw new IllegalArgumentException("Invalid byte array (length not 16)");
        }
        this.hi = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | ((long)bytes[7] & 0xFFL) << 0;
        this.lo = ((long)bytes[8] & 0xFFL) << 56 | ((long)bytes[9] & 0xFFL) << 48 | ((long)bytes[10] & 0xFFL) << 40 | ((long)bytes[11] & 0xFFL) << 32 | ((long)bytes[12] & 0xFFL) << 24 | ((long)bytes[13] & 0xFFL) << 16 | ((long)bytes[14] & 0xFFL) << 8 | ((long)bytes[15] & 0xFFL) << 0;
    }

    public Guid(long high, long low) {
        this.hi = high;
        this.lo = low;
    }

    public Guid(DataInput in) throws IOException {
        this.hi = in.readLong();
        this.lo = in.readLong();
    }

    public boolean equals(Object o) {
        if (o instanceof Guid) {
            Guid other = (Guid)o;
            return this.hi == other.hi && this.lo == other.lo;
        }
        return false;
    }

    public int hashCode() {
        long temp = this.hi ^ this.lo;
        return (int)temp ^ (int)(temp >> 32);
    }

    public void writeBytes(DataOutput out) throws IOException {
        out.writeLong(this.hi);
        out.writeLong(this.lo);
    }

    public long getHigh() {
        return this.hi;
    }

    public long getLow() {
        return this.lo;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.hi >>> 56), (byte)(this.hi >>> 48), (byte)(this.hi >>> 40), (byte)(this.hi >>> 32), (byte)(this.hi >>> 24), (byte)(this.hi >>> 16), (byte)(this.hi >>> 8), (byte)(this.hi >>> 0), (byte)(this.lo >>> 56), (byte)(this.lo >>> 48), (byte)(this.lo >>> 40), (byte)(this.lo >>> 32), (byte)(this.lo >>> 24), (byte)(this.lo >>> 16), (byte)(this.lo >>> 8), (byte)(this.lo >>> 0)};
        return bytes;
    }

    public String toString() {
        return this.fill(new StringBuffer(STRING_TEMPLATE));
    }

    public String toUnderscoredString() {
        return this.fill(new StringBuffer("00000000_0000_0000_0000_000000000000"));
    }

    public String toString(char sep) {
        return this.fill(new StringBuffer(STRING_TEMPLATE.replace('-', sep)));
    }

    protected String fill(StringBuffer buf) {
        String s = Integer.toHexString((int)(this.hi >> 32));
        buf.replace(8 - s.length(), 8, s);
        s = Integer.toHexString((int)(this.hi >> 16) & 0xFFFF);
        buf.replace(13 - s.length(), 13, s);
        s = Integer.toHexString((int)this.hi & 0xFFFF);
        buf.replace(18 - s.length(), 18, s);
        s = Integer.toHexString((int)(this.lo >> 48) & 0xFFFF);
        buf.replace(23 - s.length(), 23, s);
        s = Long.toHexString(this.lo & 0xFFFFFFFFFFFFL);
        buf.replace(36 - s.length(), 36, s);
        return buf.toString();
    }
}

