/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;

public class FileQueue {
    private File queueBaseDirectory = null;

    public FileQueue() {
    }

    public FileQueue(String queueBasePathName) {
        this.queueBaseDirectory = new File(queueBasePathName);
    }

    public int size() {
        String[] fileNames = this.queueBaseDirectory.list();
        return fileNames.length;
    }

    public String put(String fileContent) throws IOException {
        if (!this.queueBaseDirectory.exists()) {
            this.queueBaseDirectory.mkdirs();
        }
        String fileName = this.createFileName();
        String filePath = String.valueOf(this.queueBaseDirectory.getPath()) + File.separator + fileName + ".txt";
        File newFile = new File(filePath);
        if (newFile.exists()) {
            Random random = new Random();
            fileName = String.valueOf(fileName) + "-" + Math.abs(random.nextInt(99999));
            filePath = String.valueOf(this.queueBaseDirectory.getPath()) + File.separator + fileName + ".txt";
            newFile = new File(filePath);
        }
        FileOutputStream fos = new FileOutputStream(newFile);
        fos.flush();
        fos.write(fileContent.getBytes());
        fos.close();
        return String.valueOf(fileName) + ".txt";
    }

    public String getByName(String fileName) throws IOException {
        String thisLine;
        if (fileName == null) {
            return null;
        }
        String filePath = String.valueOf(this.queueBaseDirectory.getPath()) + File.separator + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        String fileContent = "";
        FileInputStream fin = new FileInputStream(file);
        BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
        while ((thisLine = myInput.readLine()) != null) {
            fileContent = String.valueOf(fileContent) + thisLine;
        }
        fin.close();
        return fileContent;
    }

    public boolean peekByName(String fileName) throws IOException {
        if (fileName == null) {
            return false;
        }
        String filePath = String.valueOf(this.queueBaseDirectory.getPath()) + File.separator + fileName;
        File file = new File(filePath);
        return file.exists();
    }

    public boolean removeByName(String fileName) {
        if (fileName == null) {
            return false;
        }
        String filePath = String.valueOf(this.queueBaseDirectory.getPath()) + File.separator + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        file.delete();
        return true;
    }

    public boolean removeQueue() {
        if (!this.queueBaseDirectory.exists()) {
            return false;
        }
        this.queueBaseDirectory.delete();
        return true;
    }

    private String createFileName() {
        return "" + System.currentTimeMillis();
    }

    public String[] getAllFileNames() {
        String[] fileNames = this.queueBaseDirectory.list();
        return fileNames;
    }

    public File getQueueBaseDirectory() {
        return this.queueBaseDirectory;
    }
}

