/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileHelper {
    public static boolean copyOneFile(String srcDir, String srcFile, String destDir, String destFile) throws IOException {
        File sourceFile = new File(srcDir, srcFile);
        if (sourceFile.exists()) {
            File destinationFile = new File(destDir, destFile);
            long len = sourceFile.length();
            FileInputStream fis = new FileInputStream(sourceFile);
            FileOutputStream fos = new FileOutputStream(destinationFile);
            byte[] bytes = new byte[4096];
            int count = fis.read(bytes);
            while (count > 0) {
                fos.write(bytes, 0, count);
                count = fis.read(bytes);
            }
            fis.close();
            fos.close();
            return true;
        }
        return false;
    }

    public static void moveWholeDirectory(String srcDir, String destDir) throws IOException {
        File srcDirFile = new File(srcDir);
        String[] fileNames = srcDirFile.list();
        if (fileNames == null) {
            return;
        }
        File destDirFile = new File(destDir);
        if (!destDirFile.exists()) {
            destDirFile.mkdir();
        }
        int i = 0;
        while (i < fileNames.length) {
            FileHelper.copyOneFile(srcDir, fileNames[i], destDir, fileNames[i]);
            File srcFile = new File(srcDir, fileNames[i]);
            srcFile.delete();
            ++i;
        }
    }

    public static void removeWholeDirectory(String dir) {
        File tmpQueue = new File(dir);
        if (tmpQueue.exists()) {
            File[] files = tmpQueue.listFiles();
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
            tmpQueue.delete();
        }
    }
}

