/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import nz.co.k.tms.exception.TmsParseException;
import nz.co.k.tms.utility.FormatHelper;
import nz.co.k.tms.utility.TmsConst;

public class DateHelper {
    public static Date parseDateTimeSting(String dateString) throws TmsParseException {
        String allowedFormats = "dd/mm/yyyy HH:mm:ss";
        String allowedInput = "Please enter only numbers and optionally slash's separating the day month year values or colons for seperating hours minutes and seconds. When entering date times.";
        boolean parseError = false;
        Date enteredDate = null;
        DateFormat df = DateFormat.getDateInstance();
        SimpleDateFormat simpleFormat = (SimpleDateFormat)df;
        if (dateString != null) {
            GregorianCalendar currentCal = new GregorianCalendar();
            currentCal.setTime(new Date());
            simpleFormat.applyPattern("dd/MM/yyyy HH:mm:ss");
            try {
                enteredDate = simpleFormat.parse(dateString);
            }
            catch (ParseException tpe) {
                throw new TmsParseException("parseDateTimeSting : Parse exception while formating date time " + tpe.getMessage());
            }
        }
        return enteredDate;
    }

    public static Date parseDate(String dateString) throws TmsParseException {
        String allowedFormats = "dd/mm/yyyy";
        String allowedInput = "Please enter only numbers and optionally slash's separating the day month year values. When entering dates.";
        boolean parseError = false;
        Date enteredDate = null;
        DateFormat df = DateFormat.getDateInstance();
        SimpleDateFormat simpleFormat = (SimpleDateFormat)df;
        if (dateString != null) {
            GregorianCalendar currentCal = new GregorianCalendar();
            currentCal.setTime(new Date());
            simpleFormat.applyPattern("dd/MM/yyyy");
            try {
                enteredDate = simpleFormat.parse(dateString);
            }
            catch (ParseException tpe) {
                throw new TmsParseException("parseDateTimeSting : Parse exception while formating date " + tpe.getMessage());
            }
        }
        return enteredDate;
    }

    public static Date parseExpiryDate(String dateString) throws TmsParseException {
        String allowedFormats = "YYMM or YYYYMM";
        String allowedInput = "Please enter only numbers. When entering expiry dates.";
        boolean parseError = false;
        Date enteredDate = null;
        DateFormat df = DateFormat.getDateInstance();
        SimpleDateFormat simpleFormat = (SimpleDateFormat)df;
        if (dateString != null) {
            if (dateString.length() == 4) {
                GregorianCalendar currentCal = new GregorianCalendar();
                currentCal.setTime(new Date());
                simpleFormat.applyPattern("yyMM");
                try {
                    enteredDate = simpleFormat.parse(dateString);
                }
                catch (ParseException tpe) {
                    throw new TmsParseException("parseExpiryDate : Parse exception while formating date " + tpe.getMessage());
                }
            }
            if (dateString.length() == 6) {
                GregorianCalendar currentCal = new GregorianCalendar();
                currentCal.setTime(new Date());
                simpleFormat.applyPattern("yyyyMM");
                try {
                    enteredDate = simpleFormat.parse(dateString);
                }
                catch (ParseException tpe) {
                    throw new TmsParseException("parseExpiryDate : Parse exception while formating date " + tpe.getMessage());
                }
            }
        }
        return enteredDate;
    }

    public static Date createDate(String yearValue, String monthValue, String dayValue, String hourValue, String minuteValue, String secondValue) throws TmsParseException {
        Date result = null;
        TmsParseException createDateTmsParseException = new TmsParseException("An exception has occured while creating a date");
        GregorianCalendar maxValueCal = new GregorianCalendar();
        int yearValueInt = -1;
        int monthValueInt = -1;
        int dayValueInt = -1;
        int hourValueInt = -1;
        int minuteValueInt = -1;
        int secondValueInt = -1;
        if (yearValue == null || yearValue.trim().equalsIgnoreCase("")) {
            createDateTmsParseException.addLogicException("The year value cannot be null or blank");
        } else if (yearValue.length() > 4) {
            createDateTmsParseException.addLogicException("The year value can not be more than 4 digits long");
        } else {
            try {
                yearValueInt = new Integer(yearValue);
                if (yearValueInt < maxValueCal.getMinimum(1)) {
                    createDateTmsParseException.addLogicException("You cannot enter a year less than " + maxValueCal.getMinimum(1));
                } else if (yearValueInt > maxValueCal.getMaximum(1)) {
                    createDateTmsParseException.addLogicException("You cannot enter a year greater than " + maxValueCal.getMaximum(1));
                }
            }
            catch (NumberFormatException nfe) {
                createDateTmsParseException.addLogicException("The year string nust be a number");
            }
        }
        if (monthValue == null || monthValue.trim().equalsIgnoreCase("")) {
            createDateTmsParseException.addLogicException("The month value cannot be null or blank");
        } else if (monthValue.length() > 2) {
            createDateTmsParseException.addLogicException("The month value can not be more than 2 digits long");
        } else {
            try {
                monthValueInt = new Integer(monthValue) - 1;
                if (monthValueInt < maxValueCal.getMinimum(2)) {
                    createDateTmsParseException.addLogicException("You cannot enter a month less than " + (maxValueCal.getMinimum(2) + 1));
                } else if (monthValueInt > maxValueCal.getMaximum(2)) {
                    createDateTmsParseException.addLogicException("You cannot enter a month greater than " + (maxValueCal.getMaximum(2) + 1));
                }
            }
            catch (NumberFormatException nfe) {
                createDateTmsParseException.addLogicException("The month string nust be a number");
            }
        }
        if (dayValue == null || dayValue.trim().equalsIgnoreCase("")) {
            createDateTmsParseException.addLogicException("The day value cannot be null or blank");
        } else if (dayValue.length() > 2) {
            createDateTmsParseException.addLogicException("The day value can not be more than 2 digits long");
        } else {
            try {
                dayValueInt = new Integer(dayValue);
                if (dayValueInt < maxValueCal.getMinimum(5)) {
                    createDateTmsParseException.addLogicException("You cannot enter a day less than " + maxValueCal.getMinimum(5));
                } else if (dayValueInt > maxValueCal.getMaximum(5)) {
                    createDateTmsParseException.addLogicException("You cannot enter a day greater than " + maxValueCal.getMaximum(5));
                }
            }
            catch (NumberFormatException nfe) {
                createDateTmsParseException.addLogicException("The day string nust be a number");
            }
        }
        if (hourValue == null || hourValue.trim().equalsIgnoreCase("")) {
            createDateTmsParseException.addLogicException("The hour value cannot be null or blank");
        } else if (hourValue.length() > 2) {
            createDateTmsParseException.addLogicException("The hour value can not be more than 2 digits long");
        } else {
            try {
                hourValueInt = new Integer(hourValue);
                if (hourValueInt < maxValueCal.getMinimum(11)) {
                    createDateTmsParseException.addLogicException("You cannot enter a hour less than " + maxValueCal.getMinimum(11));
                } else if (hourValueInt > maxValueCal.getMaximum(11)) {
                    createDateTmsParseException.addLogicException("You cannot enter a hour greater than " + maxValueCal.getMaximum(11));
                }
            }
            catch (NumberFormatException nfe) {
                createDateTmsParseException.addLogicException("The hour string nust be a number");
            }
        }
        if (minuteValue == null || minuteValue.trim().equalsIgnoreCase("")) {
            createDateTmsParseException.addLogicException("The minute value cannot be null or blank");
        } else if (minuteValue.length() > 2) {
            createDateTmsParseException.addLogicException("The minute value can not be more than 2 digits long");
        } else {
            try {
                minuteValueInt = new Integer(minuteValue);
                if (minuteValueInt < maxValueCal.getMinimum(12)) {
                    createDateTmsParseException.addLogicException("You cannot enter a minute less than " + maxValueCal.getMinimum(12));
                } else if (minuteValueInt > maxValueCal.getMaximum(12)) {
                    createDateTmsParseException.addLogicException("You cannot enter a minute greater than " + maxValueCal.getMaximum(12));
                }
            }
            catch (NumberFormatException nfe) {
                createDateTmsParseException.addLogicException("The minute string nust be a number");
            }
        }
        if (secondValue == null || secondValue.trim().equalsIgnoreCase("")) {
            createDateTmsParseException.addLogicException("The second value cannot be null or blank");
        } else if (secondValue.length() > 2) {
            createDateTmsParseException.addLogicException("The second value can not be more than 2 digits long");
        } else {
            try {
                secondValueInt = new Integer(secondValue);
                if (secondValueInt < maxValueCal.getMinimum(13)) {
                    createDateTmsParseException.addLogicException("You cannot enter a second less than " + maxValueCal.getMinimum(13));
                } else if (secondValueInt > maxValueCal.getMaximum(13)) {
                    createDateTmsParseException.addLogicException("You cannot enter a second greater than " + maxValueCal.getMaximum(13));
                }
            }
            catch (NumberFormatException nfe) {
                createDateTmsParseException.addLogicException("The second string nust be a number");
            }
        }
        if (createDateTmsParseException.getExceptionItemCount() <= 0) {
            try {
                DateHelper.checkDateInMonth(yearValueInt, monthValueInt, dayValueInt);
            }
            catch (TmsParseException tmspe) {
                createDateTmsParseException.addLogicException(tmspe.getMessage());
                throw createDateTmsParseException;
            }
        } else {
            throw createDateTmsParseException;
        }
        String dateString = FormatHelper.padString('0', 2 - dayValue.length(), dayValue);
        dateString = String.valueOf(dateString) + "/" + FormatHelper.padString('0', 2 - monthValue.length(), monthValue);
        dateString = String.valueOf(dateString) + "/" + FormatHelper.padString('0', 4 - yearValue.length(), yearValue);
        dateString = String.valueOf(dateString) + " " + FormatHelper.padString('0', 2 - hourValue.length(), hourValue);
        dateString = String.valueOf(dateString) + ":" + FormatHelper.padString('0', 2 - minuteValue.length(), minuteValue);
        dateString = String.valueOf(dateString) + ":" + FormatHelper.padString('0', 2 - secondValue.length(), secondValue);
        result = DateHelper.parseDateTimeSting(dateString);
        return result;
    }

    public static final String getCurrentDateString(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TmsConst.DEFAULT_TIME_ZONE);
        return df.format(DateHelper.getCurrentDate());
    }

    public static final Date getCurrentDate() {
        GregorianCalendar localDateCalendar = new GregorianCalendar(TmsConst.DEFAULT_TIME_ZONE, TmsConst.DEFAULT_LOCALE);
        Date currentDate = localDateCalendar.getTime();
        return currentDate;
    }

    public static final String formatDateTimeWithMilli(Date dateToFromat) {
        if (dateToFromat == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
        df.setTimeZone(TmsConst.DEFAULT_TIME_ZONE);
        return df.format(dateToFromat);
    }

    public static final String formatDateTime(Date dateToFromat) {
        if (dateToFromat == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        df.setTimeZone(TmsConst.DEFAULT_TIME_ZONE);
        return df.format(dateToFromat);
    }

    public static final String formatDate(Date dateToFromat) {
        if (dateToFromat == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        df.setTimeZone(TmsConst.DEFAULT_TIME_ZONE);
        return df.format(dateToFromat);
    }

    public static final String formatTime(Date dateToFromat) {
        if (dateToFromat == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        df.setTimeZone(TmsConst.DEFAULT_TIME_ZONE);
        return df.format(dateToFromat);
    }

    public static void checkDateInMonth(int yearToCheck, int monthToCheck, int dayToCheck) throws TmsParseException {
        int maxDayForMonth = DateHelper.getMaxDayInMonth(yearToCheck, monthToCheck);
        if (dayToCheck > maxDayForMonth) {
            String monthName = DateHelper.getMonthName(monthToCheck);
            throw new TmsParseException("\n The maximum day value for " + monthName + " is " + maxDayForMonth);
        }
    }

    public static int getMaxDayInMonth(int yearToCheck, int monthToCheck) throws TmsParseException {
        int result = -1;
        GregorianCalendar checkMaxDaysCal = new GregorianCalendar();
        checkMaxDaysCal.setTime(new Date());
        checkMaxDaysCal.set(1, yearToCheck);
        checkMaxDaysCal.set(2, monthToCheck);
        checkMaxDaysCal.set(5, 1);
        if (monthToCheck > checkMaxDaysCal.getMaximum(2)) {
            throw new TmsParseException("You cannot enter a month greater than " + (checkMaxDaysCal.getMaximum(2) + 1));
        }
        result = checkMaxDaysCal.getActualMaximum(5);
        return result;
    }

    public static String getMonthName(int monthToGetNameFor) throws TmsParseException {
        String result = null;
        GregorianCalendar monthNameCal = new GregorianCalendar();
        monthNameCal.setTime(new Date());
        monthNameCal.set(2, monthToGetNameFor);
        monthNameCal.set(5, 1);
        if (monthToGetNameFor > monthNameCal.getMaximum(2)) {
            throw new TmsParseException("You cannot enter a month greater than " + (monthNameCal.getMaximum(2) + 1));
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MMMM");
        result = dateFormatter.format(monthNameCal.getTime());
        return result;
    }

    public static Date getMondayDateBeforeDate(Date enteredDate) {
        Date result = null;
        GregorianCalendar enteredDateCalendar = new GregorianCalendar();
        enteredDateCalendar.setTime(enteredDate);
        int enteredDateDayOfTheWeek = enteredDateCalendar.get(7);
        switch (enteredDateDayOfTheWeek) {
            case 2: {
                result = enteredDate;
                break;
            }
            case 3: {
                enteredDateCalendar.add(5, -1);
                result = enteredDateCalendar.getTime();
                break;
            }
            case 4: {
                enteredDateCalendar.add(5, -2);
                result = enteredDateCalendar.getTime();
                break;
            }
            case 5: {
                enteredDateCalendar.add(5, -3);
                result = enteredDateCalendar.getTime();
                break;
            }
            case 6: {
                enteredDateCalendar.add(5, -4);
                result = enteredDateCalendar.getTime();
                break;
            }
            case 7: {
                enteredDateCalendar.add(5, -5);
                result = enteredDateCalendar.getTime();
                break;
            }
            case 1: {
                enteredDateCalendar.add(5, -6);
                result = enteredDateCalendar.getTime();
            }
        }
        return result;
    }

    public static Date getFirstDayOfMonth(Date enteredDate) {
        Date result = null;
        GregorianCalendar enteredDateCalendar = new GregorianCalendar();
        enteredDateCalendar.setTime(enteredDate);
        enteredDateCalendar.set(5, 1);
        result = enteredDateCalendar.getTime();
        return result;
    }

    public static Date getLastDayOfMonth(Date enteredDate) throws TmsParseException {
        Date result = null;
        GregorianCalendar enteredDateCalendar = new GregorianCalendar();
        enteredDateCalendar.setTime(enteredDate);
        int monthToCheck = enteredDateCalendar.get(2);
        int yearToCheck = enteredDateCalendar.get(1);
        int maxDayInMonth = DateHelper.getMaxDayInMonth(yearToCheck, monthToCheck);
        enteredDateCalendar.set(5, maxDayInMonth);
        result = enteredDateCalendar.getTime();
        return result;
    }

    public static Date setTimeForDate(Date date, String specificTime) throws TmsParseException {
        Date result = null;
        GregorianCalendar scheduledCalendar = new GregorianCalendar();
        scheduledCalendar.setTime(date);
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        GregorianCalendar calendar = new GregorianCalendar();
        Date specificDate = null;
        try {
            specificDate = sdf.parse(specificTime);
        }
        catch (ParseException tpe) {
            throw new TmsParseException("setTimeForDate : Parse exception while formating date " + tpe.getMessage());
        }
        if (specificDate != null) {
            calendar.setTime(specificDate);
            scheduledCalendar.set(11, calendar.get(11));
            scheduledCalendar.set(12, calendar.get(12));
            scheduledCalendar.set(13, calendar.get(13));
            result = scheduledCalendar.getTime();
        }
        return result;
    }

    public static Date setDateToCurrentYear(Date enteredDate) {
        Date result = null;
        GregorianCalendar enteredCalendar = new GregorianCalendar();
        enteredCalendar.setTime(enteredDate);
        GregorianCalendar currentCalendar = new GregorianCalendar();
        enteredCalendar.setTime(DateHelper.getCurrentDate());
        int yearForCurrentDate = currentCalendar.get(1);
        int monthForEnteredDate = enteredCalendar.get(2);
        int dayForEnteredDate = enteredCalendar.get(5);
        try {
            DateHelper.checkDateInMonth(yearForCurrentDate, monthForEnteredDate, dayForEnteredDate);
            enteredCalendar.set(1, yearForCurrentDate);
            result = enteredCalendar.getTime();
        }
        catch (TmsParseException tmspe) {
            DateHelper.addDaysToDate(enteredDate, 1);
            enteredCalendar = new GregorianCalendar();
            enteredCalendar.setTime(enteredDate);
            result = enteredCalendar.getTime();
        }
        return result;
    }

    public static Date addSecondsToDate(Date enteredDate, int numberOfSecondsToAdd) {
        Date result = null;
        GregorianCalendar enteredDateCalendar = new GregorianCalendar();
        enteredDateCalendar.setTime(enteredDate);
        enteredDateCalendar.add(13, numberOfSecondsToAdd);
        result = enteredDateCalendar.getTime();
        return result;
    }

    public static Date addDaysToDate(Date enteredDate, int numberOfDaysToAdd) {
        Date result = null;
        GregorianCalendar enteredDateCalendar = new GregorianCalendar();
        enteredDateCalendar.setTime(enteredDate);
        enteredDateCalendar.add(5, numberOfDaysToAdd);
        result = enteredDateCalendar.getTime();
        return result;
    }

    public static Date addMonthsToDate(Date enteredDate, int numberOfMonthsToAdd) {
        Date result = null;
        GregorianCalendar enteredDateCalendar = new GregorianCalendar();
        enteredDateCalendar.setTime(enteredDate);
        enteredDateCalendar.add(2, numberOfMonthsToAdd);
        result = enteredDateCalendar.getTime();
        return result;
    }

    public static Date addYearsToDate(Date enteredDate, int numberOfYearsToAdd) {
        Date result = null;
        GregorianCalendar enteredDateCalendar = new GregorianCalendar();
        enteredDateCalendar.setTime(enteredDate);
        enteredDateCalendar.add(1, numberOfYearsToAdd);
        result = enteredDateCalendar.getTime();
        return result;
    }

    public static boolean datesEqual(Date firstDate, Date secondDate) {
        boolean result = false;
        GregorianCalendar firstDateCalendar = new GregorianCalendar();
        firstDateCalendar.setTime(firstDate);
        GregorianCalendar secondDateCalendar = new GregorianCalendar();
        secondDateCalendar.setTime(secondDate);
        int firstDateDay = firstDateCalendar.get(5);
        int firstDateMonth = firstDateCalendar.get(2);
        int firstDateYear = firstDateCalendar.get(1);
        int secondDateDay = secondDateCalendar.get(5);
        int secondDateMonth = secondDateCalendar.get(2);
        int secondDateYear = secondDateCalendar.get(1);
        if (firstDateDay == secondDateDay & firstDateMonth == secondDateMonth & firstDateYear == secondDateYear) {
            result = true;
        }
        return result;
    }

    public static boolean dateLessThan(Date firstDate, Date secondDate) {
        boolean result = false;
        GregorianCalendar firstDateCalendar = new GregorianCalendar();
        firstDateCalendar.setTime(firstDate);
        GregorianCalendar secondDateCalendar = new GregorianCalendar();
        secondDateCalendar.setTime(secondDate);
        int firstDateDay = firstDateCalendar.get(5);
        int firstDateMonth = firstDateCalendar.get(2);
        int firstDateYear = firstDateCalendar.get(1);
        int secondDateDay = secondDateCalendar.get(5);
        int secondDateMonth = secondDateCalendar.get(2);
        int secondDateYear = secondDateCalendar.get(1);
        if (firstDateDay < secondDateDay && firstDateMonth == secondDateMonth && firstDateYear == secondDateYear) {
            result = true;
            return result;
        }
        if (firstDateDay < secondDateDay && firstDateMonth < secondDateMonth && firstDateYear == secondDateYear) {
            result = true;
            return result;
        }
        if (firstDateDay < secondDateDay && firstDateMonth < secondDateMonth && firstDateYear < secondDateYear) {
            result = true;
            return result;
        }
        if (firstDateMonth < secondDateMonth && firstDateYear < secondDateYear) {
            result = true;
            return result;
        }
        if (firstDateYear < secondDateYear) {
            result = true;
            return result;
        }
        return result;
    }

    public static boolean dateGreaterThan(Date firstDate, Date secondDate) {
        boolean result = false;
        GregorianCalendar firstDateCalendar = new GregorianCalendar();
        firstDateCalendar.setTime(firstDate);
        GregorianCalendar secondDateCalendar = new GregorianCalendar();
        secondDateCalendar.setTime(secondDate);
        int firstDateDay = firstDateCalendar.get(5);
        int firstDateMonth = firstDateCalendar.get(2);
        int firstDateYear = firstDateCalendar.get(1);
        int secondDateDay = secondDateCalendar.get(5);
        int secondDateMonth = secondDateCalendar.get(2);
        int secondDateYear = secondDateCalendar.get(1);
        if (firstDateDay > secondDateDay && firstDateMonth == secondDateMonth && firstDateYear == secondDateYear) {
            result = true;
            return result;
        }
        if (firstDateDay > secondDateDay && firstDateMonth > secondDateMonth && firstDateYear == secondDateYear) {
            result = true;
            return result;
        }
        if (firstDateDay > secondDateDay && firstDateMonth > secondDateMonth && firstDateYear > secondDateYear) {
            result = true;
            return result;
        }
        if (firstDateMonth > secondDateMonth && firstDateYear > secondDateYear) {
            result = true;
            return result;
        }
        if (firstDateYear > secondDateYear) {
            result = true;
            return result;
        }
        return result;
    }
}

