/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.utility;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.utility.LogHelper;
import org.apache.log4j.Level;

public class CodeMappingHelper {
    public static final String PROPERTY_FILE = "/config/application/tmscodemapping.properties";
    public static final String MAPPING_DELIMITER = "|";
    public static final String CODE_DELIMITER = ",";
    public ArrayList ExternalCodesArrayList = new ArrayList();
    public ArrayList TMSCodesArrayList = new ArrayList();
    public String AS2805Codes = null;
    public String BuyLineCodes = null;

    public void load() throws TmsGeneralException {
        TmsGeneralException tmsCodeMappingGeneralException = new TmsGeneralException("Exception Occurred during load of CodeMapping properties.");
        try {
            Properties properties = new Properties();
            FileInputStream propertiesFile = new FileInputStream(PROPERTY_FILE);
            properties.load(propertiesFile);
            propertiesFile.close();
            this.AS2805Codes = properties.getProperty("AS2805Codes", "");
            this.BuyLineCodes = properties.getProperty("BuyLineCodes", "");
            if (this.AS2805Codes.trim().equalsIgnoreCase("")) {
                tmsCodeMappingGeneralException.addApplicationException("AS2805Codes does not exist in CodeMapping Config file :/config/application/tmscodemapping.properties:");
            }
            if (this.BuyLineCodes.trim().equalsIgnoreCase("")) {
                tmsCodeMappingGeneralException.addApplicationException("BuyLineCodes does not exist in CodeMapping Config file :/config/application/tmscodemapping.properties:");
            }
            this.tokenizeMappingString(this.AS2805Codes);
            this.tokenizeMappingString(this.BuyLineCodes);
        }
        catch (Exception err) {
            throw new TmsGeneralException("Exception Occurred during load of CodeMapping properties.", err);
        }
    }

    public void tokenizeMappingString(String stringToTokenize) throws TmsGeneralException {
        try {
            StringTokenizer tokenizedExternalToTmsMapping;
            if (stringToTokenize != null && !stringToTokenize.trim().equals("") && (tokenizedExternalToTmsMapping = new StringTokenizer(stringToTokenize, MAPPING_DELIMITER)) != null) {
                while (tokenizedExternalToTmsMapping.hasMoreTokens()) {
                    String currentExternalToTmsMappingToken = tokenizedExternalToTmsMapping.nextToken();
                    StringTokenizer tokenizedExternalTmsCodes = new StringTokenizer(currentExternalToTmsMappingToken, CODE_DELIMITER);
                    if (tokenizedExternalTmsCodes == null) continue;
                    while (tokenizedExternalTmsCodes.hasMoreTokens()) {
                        String currentExternalCodeToken = tokenizedExternalTmsCodes.nextToken();
                        String currentTmsToken = tokenizedExternalTmsCodes.nextToken();
                        this.ExternalCodesArrayList.add(currentExternalCodeToken);
                        this.TMSCodesArrayList.add(currentTmsToken);
                    }
                }
            }
        }
        catch (Exception err) {
            throw new TmsGeneralException("Exception Occurred during load of CodeMapping ArrayLists.", err);
        }
    }

    public static String convertExternalResponseCode(String externalCode) {
        String result = null;
        if (externalCode != null && !externalCode.trim().equals("")) {
            try {
                CodeMappingHelper codeMappingProperty = new CodeMappingHelper();
                codeMappingProperty.load();
                int indexOfBuyLineCode = codeMappingProperty.ExternalCodesArrayList.indexOf(externalCode);
                if (indexOfBuyLineCode > -1) {
                    result = (String)codeMappingProperty.TMSCodesArrayList.get(indexOfBuyLineCode);
                }
            }
            catch (TmsGeneralException tmsgex) {
                LogHelper.getBillingLogger().log(Level.FATAL, (Object)("Exception while loading CodeMapping ArrayLists. Details :" + tmsgex.getMessage() + ":"));
            }
        }
        return result;
    }
}

