/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.ldap;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.ldap.NcbEntry;
import nz.co.k.tms.ldap.UserDetail;
import nz.co.k.tms.utility.TmsPropertyHelper;
import nz.co.k.tms.xml.Ncb;
import nz.co.k.tms.xml.TmsNcbServiceAuth;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class LdapHelper {
    private static TmsPropertyHelper tmsProperties = null;

    private static void setUp() {
        if (tmsProperties == null) {
            try {
                tmsProperties = new TmsPropertyHelper();
                tmsProperties.load();
            }
            catch (TmsGeneralException tmsgex) {
                tmsgex.printStackTrace();
            }
        }
    }

    public static UserDetail authentiacteUser(String username, String password) throws TmsGeneralException {
        UserDetail userDetailFromServer = null;
        Context ldapServerContext = null;
        if (tmsProperties == null) {
            LdapHelper.setUp();
        }
        try {
            try {
                if (username == null) {
                    throw new TmsGeneralException("Username cannnot be null");
                }
                if (username.trim().equalsIgnoreCase("")) {
                    throw new TmsGeneralException("Username cannnot be blank");
                }
                if (password == null) {
                    throw new TmsGeneralException("Password cannnot be null");
                }
                if (password.trim().equalsIgnoreCase("")) {
                    throw new TmsGeneralException("Password cannnot be blank");
                }
                ldapServerContext = new InitialDirContext(LdapHelper.createLdapEnvironment(username, password));
                String[] attributesToGet = new String[]{LdapHelper.tmsProperties.XMLPacketAttribteName};
                Attributes attributesFound = ldapServerContext.getAttributes(LdapHelper.getNcbDistinguishedName(username), attributesToGet);
                userDetailFromServer = LdapHelper.createUserDetail(attributesFound);
            }
            catch (AuthenticationException ae) {
                throw new TmsGeneralException("Username or password incorrect", ae);
            }
            catch (CommunicationException ce) {
                throw new TmsGeneralException("Error connecting to LDAP server", ce);
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Error finding user", ne);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (ldapServerContext != null) {
                    ldapServerContext.close();
                }
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Error closing connection to LDAP server", ne);
            }
            throw throwable;
        }
        Object var6_11 = null;
        try {
            if (ldapServerContext != null) {
                ldapServerContext.close();
            }
        }
        catch (NamingException ne) {
            throw new TmsGeneralException("Error closing connection to LDAP server", ne);
        }
        return userDetailFromServer;
    }

    protected static String getNcbDistinguishedName(String username) {
        String result = null;
        if (tmsProperties == null) {
            LdapHelper.setUp();
        }
        result = "cn=" + username;
        return result;
    }

    protected static Hashtable createLdapEnvironment(String username, String password) {
        if (tmsProperties == null) {
            LdapHelper.setUp();
        }
        String distinguishedName = String.valueOf(LdapHelper.getNcbDistinguishedName(username)) + "," + LdapHelper.tmsProperties.RootOrganisation;
        Hashtable ldapServerEnvironment = LdapHelper.createLdapEnvironmentFullDistinguishedName(distinguishedName, password);
        return ldapServerEnvironment;
    }

    protected static Hashtable createLdapEnvironmentFullDistinguishedName(String distinguishedName, String password) {
        if (tmsProperties == null) {
            LdapHelper.setUp();
        }
        String connectionUrl = String.valueOf(LdapHelper.tmsProperties.LdapServerProtocol) + LdapHelper.tmsProperties.LdapServerAddress + ":" + LdapHelper.tmsProperties.LdapServerPort + "/" + LdapHelper.tmsProperties.RootOrganisation;
        Hashtable<String, String> ldapServerEnvironment = new Hashtable<String, String>();
        ldapServerEnvironment.put("java.naming.provider.url", connectionUrl);
        ldapServerEnvironment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapServerEnvironment.put("java.naming.security.authentication", "simple");
        ldapServerEnvironment.put("java.naming.security.principal", distinguishedName);
        ldapServerEnvironment.put("java.naming.security.credentials", password);
        return ldapServerEnvironment;
    }

    private static UserDetail createUserDetail(Attributes attributesFound) throws TmsGeneralException {
        UserDetail userDetailFound = null;
        if (attributesFound == null) {
            throw new TmsGeneralException("No attributes for user");
        }
        String userXmlPacket = null;
        try {
            NamingEnumeration<? extends Attribute> attributesFoundEnumeration = attributesFound.getAll();
            while (attributesFoundEnumeration.hasMore()) {
                Attribute attr = attributesFoundEnumeration.next();
                if (!attr.getID().equalsIgnoreCase(LdapHelper.tmsProperties.XMLPacketAttribteName)) continue;
                userXmlPacket = (String)LdapHelper.getAttributeValue(attr.getAll());
            }
            userDetailFound = new UserDetail(userXmlPacket);
        }
        catch (NamingException ne) {
            throw new TmsGeneralException("Error finding user attributes", ne);
        }
        return userDetailFound;
    }

    private static Object getAttributeValue(NamingEnumeration attributeValues) throws NamingException {
        Object result = null;
        if (attributeValues.hasMore()) {
            result = attributeValues.next();
        }
        return result;
    }

    public static NcbEntry generateNcbEntry(Ncb ncbToUse, TmsNcbServiceAuth tmsNcbServiceAuth) throws TmsGeneralException {
        NcbEntry result = null;
        if (ncbToUse != null) {
            try {
                TmsPropertyHelper tmsProperty = new TmsPropertyHelper();
                tmsProperty.load();
                String username = null;
                if (ncbToUse.getLogin() == null) {
                    throw new TmsGeneralException("generateNcbEntry : NCB Login cannot be blank");
                }
                username = ncbToUse.getLogin();
                String passwordToUse = null;
                if (ncbToUse.getPassword() == null) {
                    throw new TmsGeneralException("generateNcbEntry : NCB Password cannot be blank");
                }
                passwordToUse = ncbToUse.getPassword();
                BasicAttribute objclassSet = new BasicAttribute("objectclass");
                objclassSet.add("top");
                objclassSet.add("person");
                objclassSet.add("organizationalPerson");
                objclassSet.add("inetOrgPerson");
                BasicAttribute commonName = new BasicAttribute("cn");
                commonName.add(username);
                if (ncbToUse.getName() != null) {
                    commonName.add(ncbToUse.getName());
                }
                BasicAttributes attrs = new BasicAttributes();
                attrs.put(objclassSet);
                attrs.put(commonName);
                if (ncbToUse.getNameLast() != null) {
                    attrs.put("sn", ncbToUse.getNameLast());
                }
                attrs.put("userPassword", passwordToUse);
                if (tmsNcbServiceAuth != null) {
                    StringWriter writer = new StringWriter();
                    Marshaller marshaller = new Marshaller((Writer)writer);
                    Marshaller.marshal((Object)tmsNcbServiceAuth, (Writer)writer);
                    String encodedNcbServiceAuth = writer.toString();
                    attrs.put(tmsProperty.XMLPacketAttribteName, encodedNcbServiceAuth);
                }
                result = new NcbEntry(LdapHelper.getNcbDistinguishedName(username), attrs);
            }
            catch (IOException ioex) {
                throw new TmsGeneralException("generateNcbEntry : IOException", ioex);
            }
            catch (MarshalException mex) {
                throw new TmsGeneralException("generateNcbEntry : MarshalException", (Exception)((Object)mex));
            }
            catch (ValidationException vex) {
                throw new TmsGeneralException("generateNcbEntry : ValidationException", (Exception)((Object)vex));
            }
        }
        return result;
    }
}

