/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.ldap;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchResult;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.ldap.LdapHelper;
import nz.co.k.tms.ldap.NcbEntry;
import nz.co.k.tms.utility.FileQueue;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsPropertyHelper;
import nz.co.k.tms.utility.XmlHelper;
import nz.co.k.tms.utility.security.SecurityHelper;
import nz.co.k.tms.xml.Ncb;
import nz.co.k.tms.xml.TmsNcbServiceAuth;
import nz.co.k.tms.xml.server.LdapAdd;
import nz.co.k.tms.xml.server.LdapDelete;
import nz.co.k.tms.xml.server.LdapUpdateLoginName;
import nz.co.k.tms.xml.server.LdapUpdatePassword;
import nz.co.k.tms.xml.server.LdapUpdateXml;
import nz.co.k.tms.xml.server.NcbServiceAuth;
import nz.co.k.tms.xml.server.ServerMessageLdapBlk;
import nz.co.k.tms.xml.server.TmsServerMessage;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class LdapAdmin {
    public static void add(Ncb ncbToAdd, TmsNcbServiceAuth ncbServiceAuthToAdd, String username, String password) throws TmsGeneralException {
        LdapAdmin.add(ncbToAdd, ncbServiceAuthToAdd, username, password, true);
    }

    public static void add(Ncb ncbToAdd, TmsNcbServiceAuth ncbServiceAuthToAdd, String username, String password, boolean hashPassword) throws TmsGeneralException {
        if (ncbToAdd != null) {
            TmsServerMessage tmsServerMessage = XmlHelper.createBasicTmsServerMessage(null);
            LdapAdd ldapAdd = new LdapAdd();
            nz.co.k.tms.xml.server.Ncb serverNcb = XmlHelper.convertNcbToServerNcb(ncbToAdd);
            if (hashPassword) {
                serverNcb.setPassword(SecurityHelper.generateLdapHash(serverNcb.getPassword()));
            }
            ldapAdd.setNcb(serverNcb);
            if (ncbServiceAuthToAdd != null) {
                NcbServiceAuth serverNcbServiceAuthToAdd = XmlHelper.convertNcbServiceAuthToServerNcbServiceAuth(ncbServiceAuthToAdd);
                ldapAdd.setNcbServiceAuth(serverNcbServiceAuthToAdd);
            }
            ServerMessageLdapBlk serverMessageLdapBlk = new ServerMessageLdapBlk();
            serverMessageLdapBlk.setLdapAdd(ldapAdd);
            tmsServerMessage.setServerMessageLdapBlk(serverMessageLdapBlk);
            String ldapMessageXml = null;
            try {
                ldapMessageXml = XmlHelper.marshalTmsServerMessage(tmsServerMessage);
            }
            catch (MarshalException me) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:add: MarshalException Details :" + me.toString()));
                ldapMessageXml = null;
            }
            catch (ValidationException ve) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:add: ValidationException Details :" + ve.toString()));
                ldapMessageXml = null;
            }
            LdapAdmin.sendMessageToQueue(ldapMessageXml);
        }
    }

    public static void updateXml(String ncbLoginName, TmsNcbServiceAuth ncbServiceAuthToUpdate, String managerUsername, String managerPassword) throws TmsGeneralException {
        if (ncbLoginName != null && ncbServiceAuthToUpdate != null) {
            TmsServerMessage tmsServerMessage = XmlHelper.createBasicTmsServerMessage(null);
            LdapUpdateXml ldapUpdateXml = new LdapUpdateXml();
            ldapUpdateXml.setNcbLoginName(ncbLoginName);
            NcbServiceAuth serverNcbServiceAuthToAdd = XmlHelper.convertNcbServiceAuthToServerNcbServiceAuth(ncbServiceAuthToUpdate);
            ldapUpdateXml.setNcbServiceAuth(serverNcbServiceAuthToAdd);
            ServerMessageLdapBlk serverMessageLdapBlk = new ServerMessageLdapBlk();
            serverMessageLdapBlk.setLdapUpdateXml(ldapUpdateXml);
            tmsServerMessage.setServerMessageLdapBlk(serverMessageLdapBlk);
            String ldapMessageXml = null;
            try {
                ldapMessageXml = XmlHelper.marshalTmsServerMessage(tmsServerMessage);
            }
            catch (MarshalException me) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:updateXml: MarshalException Details :" + me.toString()));
                ldapMessageXml = null;
            }
            catch (ValidationException ve) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:updateXml: ValidationException Details :" + ve.toString()));
                ldapMessageXml = null;
            }
            LdapAdmin.sendMessageToQueue(ldapMessageXml);
        }
    }

    public static void updatePassword(String ncbLoginName, String ncbPassword, String managerUsername, String managerPassword) throws TmsGeneralException {
        if (ncbLoginName != null && ncbPassword != null) {
            TmsServerMessage tmsServerMessage = XmlHelper.createBasicTmsServerMessage(null);
            LdapUpdatePassword ldapUpdatePassword = new LdapUpdatePassword();
            ldapUpdatePassword.setNcbLoginName(ncbLoginName);
            ldapUpdatePassword.setNcbPassword(SecurityHelper.generateLdapHash(ncbPassword));
            ServerMessageLdapBlk serverMessageLdapBlk = new ServerMessageLdapBlk();
            serverMessageLdapBlk.setLdapUpdatePassword(ldapUpdatePassword);
            tmsServerMessage.setServerMessageLdapBlk(serverMessageLdapBlk);
            String ldapMessageXml = null;
            try {
                ldapMessageXml = XmlHelper.marshalTmsServerMessage(tmsServerMessage);
            }
            catch (MarshalException me) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:updatePassword: MarshalException Details :" + me.toString()));
                ldapMessageXml = null;
            }
            catch (ValidationException ve) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:updatePassword: ValidationException Details :" + ve.toString()));
                ldapMessageXml = null;
            }
            LdapAdmin.sendMessageToQueue(ldapMessageXml);
        }
    }

    public static void updateLoginName(String ncbLoginNameOld, String ncbLoginNameNew, String managerUsername, String managerPassword) throws TmsGeneralException {
        if (ncbLoginNameOld != null && ncbLoginNameNew != null) {
            TmsServerMessage tmsServerMessage = XmlHelper.createBasicTmsServerMessage(null);
            LdapUpdateLoginName ldapUpdateLoginName = new LdapUpdateLoginName();
            ldapUpdateLoginName.setLdapLoginNameOld(ncbLoginNameOld);
            ldapUpdateLoginName.setLdapLoginNameNew(ncbLoginNameNew);
            ServerMessageLdapBlk serverMessageLdapBlk = new ServerMessageLdapBlk();
            serverMessageLdapBlk.setLdapUpdateLoginName(ldapUpdateLoginName);
            tmsServerMessage.setServerMessageLdapBlk(serverMessageLdapBlk);
            String ldapMessageXml = null;
            try {
                ldapMessageXml = XmlHelper.marshalTmsServerMessage(tmsServerMessage);
            }
            catch (MarshalException me) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:updateLoginName: MarshalException Details :" + me.toString()));
                ldapMessageXml = null;
            }
            catch (ValidationException ve) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:updateLoginName: ValidationException Details :" + ve.toString()));
                ldapMessageXml = null;
            }
            LdapAdmin.sendMessageToQueue(ldapMessageXml);
        }
    }

    public static void delete(String ncbLoginName, String managerUsername, String managerPassword) throws TmsGeneralException {
        if (ncbLoginName != null) {
            TmsServerMessage tmsServerMessage = XmlHelper.createBasicTmsServerMessage(null);
            LdapDelete ldapDelete = new LdapDelete();
            ldapDelete.setNcbLoginName(ncbLoginName);
            ServerMessageLdapBlk serverMessageLdapBlk = new ServerMessageLdapBlk();
            serverMessageLdapBlk.setLdapDelete(ldapDelete);
            tmsServerMessage.setServerMessageLdapBlk(serverMessageLdapBlk);
            String ldapMessageXml = null;
            try {
                ldapMessageXml = XmlHelper.marshalTmsServerMessage(tmsServerMessage);
            }
            catch (MarshalException me) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:delete: MarshalException Details :" + me.toString()));
                ldapMessageXml = null;
            }
            catch (ValidationException ve) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:delete: ValidationException Details :" + ve.toString()));
                ldapMessageXml = null;
            }
            LdapAdmin.sendMessageToQueue(ldapMessageXml);
        }
    }

    private static void sendMessageToQueue(String message) {
        if (message != null) {
            TmsPropertyHelper tmsProperties = new TmsPropertyHelper();
            try {
                tmsProperties.load();
                FileQueue ldapQueue = new FileQueue(tmsProperties.BillingLdapQueueBase);
                String ldapMessageFileName = ldapQueue.put(message);
                LogHelper.getBillingLogger().log(Level.INFO, (Object)(">>>> The file :" + ldapMessageFileName + ": was placed on the LDAP queue."));
            }
            catch (IOException ioe) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:sendMessageToQueue: IOException Details :" + ioe.toString()));
            }
            catch (TmsGeneralException tmsge) {
                LogHelper.getBillingLogger().log(Level.ERROR, (Object)("LdapAdmin:sendMessageToQueue: TmsGeneralException Details :" + tmsge.toString()));
            }
        } else {
            LogHelper.getBillingLogger().log(Level.WARN, (Object)"LdapAdmin:sendMessageToQueue: A null message cannot be sent to the queue.");
        }
    }

    public static void addRealTime(Ncb ncbToAdd, TmsNcbServiceAuth ncbServiceAuthToAdd, String username, String password) throws TmsGeneralException {
        NcbEntry ncbEntry = null;
        Context directoryContext = null;
        try {
            try {
                ncbEntry = LdapHelper.generateNcbEntry(ncbToAdd, ncbServiceAuthToAdd);
                directoryContext = new InitialDirContext(LdapHelper.createLdapEnvironmentFullDistinguishedName(username, password));
                BasicAttributes newEntryAttributes = ncbEntry.getAttributes();
                directoryContext.createSubcontext(ncbEntry.getDN(), newEntryAttributes);
            }
            catch (SchemaViolationException sve) {
                String ncbEntryString = "";
                if (ncbEntry != null) {
                    ncbEntryString = ncbEntry.toString();
                }
                throw new TmsGeneralException("Add Ldap Entry: Schema Violation:" + ncbEntryString + ":", sve);
            }
            catch (InvalidAttributesException iae) {
                String ncbEntryString = "";
                if (ncbEntry != null) {
                    ncbEntryString = ncbEntry.toString();
                }
                throw new TmsGeneralException("Add Ldap Entry: Invalid Attributes:" + ncbEntryString + ":", iae);
            }
            catch (NameAlreadyBoundException nabe) {
                String ncbEntryString = "";
                if (ncbEntry != null) {
                    ncbEntryString = ncbEntry.toString();
                }
                throw new TmsGeneralException("Add Ldap Entry: Entry Already Exists:" + ncbEntryString + ":", nabe);
            }
            catch (NoPermissionException npe) {
                throw new TmsGeneralException("Add Ldap Entry: Access Denied to Add", npe);
            }
            catch (CommunicationException ce) {
                throw new TmsGeneralException("Add Ldap Entry: Error communicating with the server", ce);
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Add Ldap Entry: NamingException", ne);
            }
        }
        catch (Throwable throwable) {
            Object var8_17 = null;
            if (directoryContext != null) {
                try {
                    directoryContext.close();
                }
                catch (NamingException ne) {
                    throw new TmsGeneralException("Add Ldap Entry: NamingException during closing of Directory Context", ne);
                }
            }
            throw throwable;
        }
        Object var8_18 = null;
        if (directoryContext != null) {
            try {
                directoryContext.close();
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Add Ldap Entry: NamingException during closing of Directory Context", ne);
            }
        }
    }

    public static void updateXmlRealTime(String ncbLoginName, TmsNcbServiceAuth ncbServiceAuthToUpdate, String managerUsername, String managerPassword) throws TmsGeneralException {
        Context directoryContext = null;
        try {
            try {
                TmsPropertyHelper tmsProperty = new TmsPropertyHelper();
                tmsProperty.load();
                directoryContext = new InitialDirContext(LdapHelper.createLdapEnvironmentFullDistinguishedName(managerUsername, managerPassword));
                ModificationItem[] attributesToModify = new ModificationItem[1];
                StringWriter writer = new StringWriter();
                Marshaller marshaller = new Marshaller((Writer)writer);
                Marshaller.marshal((Object)ncbServiceAuthToUpdate, (Writer)writer);
                String encodedNcbServiceAuth = writer.toString();
                BasicAttribute currentLdapAttribute = new BasicAttribute(tmsProperty.XMLPacketAttribteName, encodedNcbServiceAuth);
                attributesToModify[0] = new ModificationItem(2, currentLdapAttribute);
                String ncbDistinguishedName = LdapHelper.getNcbDistinguishedName(ncbLoginName);
                directoryContext.modifyAttributes(ncbDistinguishedName, attributesToModify);
            }
            catch (SchemaViolationException sve) {
                throw new TmsGeneralException("Update XML Ldap Entry: Schema Violation:" + ncbLoginName + ":", sve);
            }
            catch (InvalidAttributesException iae) {
                throw new TmsGeneralException("Update XML Ldap Entry: Invalid Attributes:" + ncbLoginName + ":", iae);
            }
            catch (NameAlreadyBoundException nabe) {
                throw new TmsGeneralException("Update XML Ldap Entry: Entry Already Exists:" + ncbLoginName + ":", nabe);
            }
            catch (NoPermissionException npe) {
                throw new TmsGeneralException("Update XML Ldap Entry: Access Denied to Add", npe);
            }
            catch (CommunicationException ce) {
                throw new TmsGeneralException("Update XML Ldap Entry: Error communicating with the server", ce);
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Update XML Ldap Entry: NamingException", ne);
            }
            catch (IOException ioe) {
                throw new TmsGeneralException("Update XML Ldap Entry: IOException", ioe);
            }
            catch (MarshalException me) {
                throw new TmsGeneralException("Update XML Ldap Entry: MarshalException", (Exception)((Object)me));
            }
            catch (ValidationException ve) {
                throw new TmsGeneralException("Update XML Ldap Entry: ValidationException", (Exception)((Object)ve));
            }
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            if (directoryContext != null) {
                try {
                    directoryContext.close();
                }
                catch (NamingException ne) {
                    throw new TmsGeneralException("Update XML Ldap Entry: NamingException during closing of Directory Context", ne);
                }
            }
            throw throwable;
        }
        Object var12_23 = null;
        if (directoryContext != null) {
            try {
                directoryContext.close();
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Update XML Ldap Entry: NamingException during closing of Directory Context", ne);
            }
        }
    }

    public static void updatePasswordRealTime(String ncbLoginName, String ncbPassword, String managerUsername, String managerPassword) throws TmsGeneralException {
        Context directoryContext = null;
        try {
            try {
                TmsPropertyHelper tmsProperty = new TmsPropertyHelper();
                tmsProperty.load();
                directoryContext = new InitialDirContext(LdapHelper.createLdapEnvironmentFullDistinguishedName(managerUsername, managerPassword));
                ModificationItem[] attributesToModify = new ModificationItem[1];
                BasicAttribute currentLdapAttribute = new BasicAttribute("userPassword", ncbPassword);
                attributesToModify[0] = new ModificationItem(2, currentLdapAttribute);
                String ncbDistinguishedName = LdapHelper.getNcbDistinguishedName(ncbLoginName);
                directoryContext.modifyAttributes(ncbDistinguishedName, attributesToModify);
            }
            catch (SchemaViolationException sve) {
                throw new TmsGeneralException("Update Password Ldap Entry: Schema Violation:" + ncbLoginName + ":", sve);
            }
            catch (InvalidAttributesException iae) {
                throw new TmsGeneralException("Update Password Ldap Entry: Invalid Attributes:" + ncbLoginName + ":", iae);
            }
            catch (NameAlreadyBoundException nabe) {
                throw new TmsGeneralException("Update Password Ldap Entry: Entry Already Exists:" + ncbLoginName + ":", nabe);
            }
            catch (NoPermissionException npe) {
                throw new TmsGeneralException("Update Password Ldap Entry: Access Denied to Add", npe);
            }
            catch (CommunicationException ce) {
                throw new TmsGeneralException("Update Password Ldap Entry: Error communicating with the server", ce);
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Update Password Ldap Entry: NamingException", ne);
            }
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (directoryContext != null) {
                try {
                    directoryContext.close();
                }
                catch (NamingException ne) {
                    throw new TmsGeneralException("Update Password Ldap Entry: NamingException during closing of Directory Context", ne);
                }
            }
            throw throwable;
        }
        Object var9_17 = null;
        if (directoryContext != null) {
            try {
                directoryContext.close();
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Update Password Ldap Entry: NamingException during closing of Directory Context", ne);
            }
        }
    }

    public static void updateLoginNameRealTime(String ncbLoginNameOld, String ncbLoginNameNew, String managerUsername, String managerPassword) throws TmsGeneralException {
        Context directoryContext = null;
        try {
            try {
                TmsPropertyHelper tmsProperty = new TmsPropertyHelper();
                tmsProperty.load();
                directoryContext = new InitialDirContext(LdapHelper.createLdapEnvironmentFullDistinguishedName(managerUsername, managerPassword));
                directoryContext.rename(LdapHelper.getNcbDistinguishedName(ncbLoginNameOld), LdapHelper.getNcbDistinguishedName(ncbLoginNameNew));
            }
            catch (SchemaViolationException sve) {
                throw new TmsGeneralException("Update Login Name Ldap Entry: Schema Violation: OLD :" + ncbLoginNameOld + ": NEW :" + ncbLoginNameNew + ":", sve);
            }
            catch (InvalidAttributesException iae) {
                throw new TmsGeneralException("Update Login Name Ldap Entry: Invalid Attributes:OLD :" + ncbLoginNameOld + ": NEW :" + ncbLoginNameNew + ":", iae);
            }
            catch (NameAlreadyBoundException nabe) {
                throw new TmsGeneralException("Update Login Name Ldap Entry: Entry Already Exists:OLD :" + ncbLoginNameOld + ": NEW :" + ncbLoginNameNew + ":", nabe);
            }
            catch (NoPermissionException npe) {
                throw new TmsGeneralException("Update Login Name Ldap Entry: Access Denied to Add", npe);
            }
            catch (CommunicationException ce) {
                throw new TmsGeneralException("Update Login Name Ldap Entry: Error communicating with the server", ce);
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Update Login Name Ldap Entry: NamingException", ne);
            }
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            if (directoryContext != null) {
                try {
                    directoryContext.close();
                }
                catch (NamingException ne) {
                    throw new TmsGeneralException("Update Login Name Ldap Entry: NamingException during closing of Directory Context", ne);
                }
            }
            throw throwable;
        }
        Object var6_14 = null;
        if (directoryContext != null) {
            try {
                directoryContext.close();
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Update Login Name Ldap Entry: NamingException during closing of Directory Context", ne);
            }
        }
    }

    public static void deleteRealTime(String ncbLoginName, String managerUsername, String managerPassword) throws TmsGeneralException {
        LdapAdmin.deleteRealTime(ncbLoginName, managerUsername, managerPassword, true);
    }

    public static void deleteRealTime(String nameToDelete, String managerUsername, String managerPassword, boolean convertNameToDn) throws TmsGeneralException {
        InitialDirContext directoryContext = null;
        try {
            try {
                directoryContext = new InitialDirContext(LdapHelper.createLdapEnvironmentFullDistinguishedName(managerUsername, managerPassword));
                if (convertNameToDn) {
                    nameToDelete = LdapHelper.getNcbDistinguishedName(nameToDelete);
                }
                directoryContext.destroySubcontext(nameToDelete);
            }
            catch (NoPermissionException npe) {
                throw new TmsGeneralException("Delete Ldap Entry: Access Denied to Add", npe);
            }
            catch (CommunicationException ce) {
                throw new TmsGeneralException("Delete Ldap Entry: Error communicating with the server", ce);
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Delete Ldap Entry: NamingException", ne);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (directoryContext != null) {
                try {
                    directoryContext.close();
                }
                catch (NamingException ne) {
                    throw new TmsGeneralException("Delete Ldap Entry: NamingException during closing of Directory Context", ne);
                }
            }
            throw throwable;
        }
        Object var6_10 = null;
        if (directoryContext != null) {
            try {
                directoryContext.close();
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("Delete Ldap Entry: NamingException during closing of Directory Context", ne);
            }
        }
    }

    public static boolean deleteAll() throws TmsGeneralException {
        TmsPropertyHelper tmsProperties = new TmsPropertyHelper();
        Context directoryContext = null;
        try {
            try {
                tmsProperties.load();
                directoryContext = new InitialDirContext(LdapHelper.createLdapEnvironmentFullDistinguishedName(tmsProperties.LdapServerAdminDn, tmsProperties.LdapServerAdminPassword));
                BasicAttributes matchAttrs = new BasicAttributes(true);
                matchAttrs.put(new BasicAttribute("objectclass", "inetOrgPerson"));
                NamingEnumeration<SearchResult> searchResults = directoryContext.search("", matchAttrs);
                if (searchResults != null) {
                    while (searchResults.hasMore()) {
                        SearchResult currentSearchResult = searchResults.next();
                        LdapAdmin.deleteRealTime(currentSearchResult.getName(), tmsProperties.LdapServerAdminDn, tmsProperties.LdapServerAdminPassword, false);
                    }
                }
            }
            catch (NoPermissionException npe) {
                throw new TmsGeneralException("deleteAll: Access Denied to Add", npe);
            }
            catch (CommunicationException ce) {
                throw new TmsGeneralException("deleteAll: Error communicating with the server", ce);
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("deleteAll: NamingException", ne);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (directoryContext != null) {
                try {
                    directoryContext.close();
                }
                catch (NamingException ne) {
                    throw new TmsGeneralException("deleteAll: NamingException during closing of Directory Context", ne);
                }
            }
            throw throwable;
        }
        Object var5_10 = null;
        if (directoryContext != null) {
            try {
                directoryContext.close();
            }
            catch (NamingException ne) {
                throw new TmsGeneralException("deleteAll: NamingException during closing of Directory Context", ne);
            }
        }
        return true;
    }
}

